<?php

require_once "conexion.php";

class ModeloProductos{
	/*=============================================
	MOSTRAR CONSULTA
	=============================================*/

	static public function mdlMostrarConsulta($tabla,$consulta){
		$stmt = Conexion::conectar()->prepare("SELECT 
			tra.tra_cm_correlativo,
			tra.tra_cm_procedencia,
			tra.tra_cm_aseguradora,
			tra.tra_cm_primer_consulta,
			tra.tra_cm_lugar_atencion,
			tra.tra_cm_tipo_consulta,
			tra.tra_cm_usr_correl,
			tra.tra_cm_fecha_inicio_consulta,
			tra.tra_cm_fecha_fin_consulta,
			tra.tra_cm_cli_correlativo,
			suc.suc_nombre,
			cli.cli_nombre,
			cli.cli_fecha_nacimiento,
			cli.cli_dpi,
			cli.cli_telefono1,
			cli.cli_fecha_nacimiento,
			cli.cli_direccion,
			cat.cat_nombre,
			cli.cli_religion,
			cli.cli_escolaridad,
			cli.cli_ocupacion,
			tfm.tra_fm_app,
			tfm.tra_fm_apf,
			tfm.tra_fm_alcohol,
			tfm.tra_fm_cafe,
			tfm.tra_fm_tabaco,
			tfm.tra_fm_otros,
			cli.cli_grupo_sanguineo,
			tfm.tra_fm_g,
			tfm.tra_fm_p,
			tfm.tra_fm_a,
			tfm.tra_fm_hv,
			tfm.tra_fm_hm,
			tfm.tra_fm_fur,
			ciclo.cat_nombre as tipo_ciclo,
			tfm.tra_fm_eg,
			tfm.tra_fm_fpp,
			tfm.tra_fm_motivo_consulta,
			tfm.tra_fm_resumen_hea,
			tfm.tra_fm_peso_kg,
			tfm.tra_fm_talla_mts,
			tfm.tra_fm_valor_imc,
			tfm.tra_fm_estado_nutricional,
			tfm.tra_fm_valor_fc,
			tfm.tra_fm_valor_fr,
			tfm.tra_fm_valor_ta,
			tfm.tra_fm_valor_temperatura,
			tfm.tra_fm_impresion_diagnostico,
			tfm.tra_fm_tratamiento,
			tra.tra_cm_responsable_parentesco  
			 FROM $tabla tra
		LEFT JOIN cfg_sucursal suc on(suc.suc_correlativo = tra.tra_cm_lugar_atencion) 
		LEFT JOIN cfg_cliente cli on(cli.cli_correlativo = tra.tra_cm_cli_correlativo)
		LEFT JOIN cfg_catalogo cat on(cat.cat_valor = cli.cli_estado_civil and cat.cat_tipo = 'ESTADO_CIVIL') 	
		LEFT JOIN tra_ficha_medica tfm on(tfm.tra_fm_tra_cm_correlativo = tra.tra_cm_correlativo)
		LEFT JOIN cfg_catalogo ciclo on(ciclo.cat_valor = tfm.tra_fm_ciclos and ciclo.cat_tipo = 'TIPO_CICLO') 
		WHERE 1=1 AND tra.tra_cm_correlativo = :$consulta");
			$stmt -> bindParam(":".$consulta, $consulta, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetch();
		$stmt -> close();
		$stmt = null;
	}
	
	/*=============================================
	MOSTRAR RECETAS
	=============================================*/

	static public function mdlMostrarLaboratorios($tabla, $filtro){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE 1=1 AND cat_tipo = :$filtro ORDER BY cat_nombre ASC");
		$stmt -> bindParam(":".$filtro, $filtro, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR RECETAS
	=============================================*/

	static public function mdlMostrarExamenFisico($tabla, $noExamen){
		$stmt = Conexion::conectar()->prepare("SELECT 
			*,
			cat.cat_nombre as nombre_examen 
		 FROM $tabla 
		 INNER join cfg_catalogo cat on (cat.cat_valor = tra_ef_cat_valor and cat.cat_tipo = 'EXAMEN_FISICO_FM' and cat.cat_estado = 'A')
		 WHERE 1=1 
		 AND tra_ef_tra_fm_correlativo = :$noExamen 
		 ORDER BY tra_ef_cat_valor ASC");
		$stmt -> bindParam(":".$noExamen, $noExamen, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}
	/*=============================================
	MOSTRAR EXAMENES
	=============================================*/
	static public function mdlMostrarExamenes($tabla, $filtro,$consulta,$tipoFicha,$noExamen){
		$stmt = Conexion::conectar()->prepare("SELECT 
			*,
			exc.tra_ecom_pro_correl 
			FROM $tabla 
			left join examenes_complementarios exc on (exc.tra_ecom_tra_cm_correlativo = :$consulta AND exc.tra_ecom_tipo_ficha = :$tipoFicha AND exc.tra_ecom_no_examen = :$noExamen AND exc.tra_ecom_pro_correl = pro_correl) 
		WHERE 1=1 AND pro_tipo_laboratorio = :$filtro AND pro_clasificacion = 1 ORDER BY pro_nombre DESC");
		$stmt -> bindParam(":".$filtro, $filtro, PDO::PARAM_STR);
		$stmt -> bindParam(":".$consulta, $consulta, PDO::PARAM_STR);
		$stmt -> bindParam(":".$tipoFicha, $tipoFicha, PDO::PARAM_INT);
		$stmt -> bindParam(":".$noExamen, $noExamen, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR CLIENTES
	=============================================*/

	static public function mdlMostrarPaciente($tabla,$paciente){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE 1=1 AND cli_correlativo = :$paciente");
			$stmt -> bindParam(":".$paciente, $paciente, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

}