<?php

require_once "conexion.php";

class ModeloProductos{

	/*=============================================
	MOSTRAR RECETAS
	=============================================*/

	static public function mdlMostrarDatos($tabla, $noConsulta){
		$stmt = Conexion::conectar()->prepare("SELECT 
			*,
			suc.suc_nombre,
			ficha.tra_fm_app,
			ficha.tra_fm_apf,
			ficha.tra_fm_alcohol,
			ficha.tra_fm_cafe,
			ficha.tra_fm_tabaco,
			ficha.tra_fm_otros,
			ficha.tra_fm_motivo_consulta,
			ficha.tra_fm_valor_fc,
			ficha.tra_fm_valor_ta,
			ficha.tra_fm_valor_fr,
			ficha.tra_fm_valor_temperatura,
			ficha.tra_fm_impresion_diagnostico,
			ficha.tra_fm_tratamiento   
			FROM $tabla 
			INNER JOIN cfg_sucursal suc on(suc.suc_correlativo = tra_cm_lugar_atencion)
			INNER JOIN tra_ficha_medica ficha on(ficha.tra_fm_tra_cm_correlativo = :$noConsulta)
			WHERE 1=1 
			AND tra_cm_correlativo = :$noConsulta");
		$stmt -> bindParam(":".$noConsulta, $noConsulta, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR EXAMENES
	=============================================*/

	static public function mdlMostrarExamenes($tabla, $filtro){
		$consult= 4;
		$tipoFicha = 0;
		$noExamen = 1; 
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla 
		WHERE 1=1 AND pro_tipo_laboratorio = :$filtro AND pro_clasificacion = 1 ORDER BY pro_nombre DESC");
		$stmt -> bindParam(":".$filtro, $filtro, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}
	static public function mdlMostrarExamenesCheck($tabla, $consulta, $producto,$tipoFicha,$noExamen){
		//$consult= 4;
		//$tipoFicha = 0;
		$noExamen = 1; 
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE 1=1 AND tra_ecom_tra_cm_correlativo = :$consulta AND tra_ecom_tipo_ficha = :$tipoFicha AND tra_ecom_no_examen = :$noExamen AND tra_ecom_pro_correl = :$producto");
		$stmt -> bindParam(":".$consulta, $consulta, PDO::PARAM_STR);
		$stmt -> bindParam(":".$tipoFicha, $tipoFicha, PDO::PARAM_INT);
		$stmt -> bindParam(":".$noExamen, $noExamen, PDO::PARAM_INT);
		$stmt -> bindParam(":".$producto, $producto, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}
	/*=============================================
	MOSTRAR CLIENTES
	=============================================*/

	static public function mdlMostrarPaciente($tabla,$paciente){
		$stmt = Conexion::conectar()->prepare("SELECT 
			*,
			fm.tra_fm_app,
			fm.tra_fm_apf,
			fm.tra_fm_alcohol,
			fm.tra_fm_cafe,
			fm.tra_fm_tabaco,
			fm.tra_fm_otros,
			fm.tra_fm_motivo_consulta,
			fm.tra_fm_examen_fisico,
			fm.tra_fm_valor_fc,
			fm.tra_fm_valor_ta,
			fm.tra_fm_valor_fr,
			fm.tra_fm_valor_temperatura,
			fm.tra_fm_impresion_diagnostico,
			fm.tra_fm_tratamiento 
			FROM $tabla 
			left outer join tra_ficha_medica fm on (fm.tra_fm_tra_cm_correlativo = 4)
			WHERE 1=1 AND cli_correlativo = :$paciente");
			$stmt -> bindParam(":".$paciente, $paciente, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

}