<?php

require_once "conexion.php";

class ModeloProductos{

	/*=============================================
	MOSTRAR LABORATORIOS
	=============================================*/

	static public function mdlMostrarLaboratorios($tabla, $filtro, $consulta, $noExamen){
		$stmt = Conexion::conectar()->prepare("SELECT 
			* 
			FROM $tabla
			INNER JOIN cfg_catalogo cat on(cat.cat_tipo = :$filtro and cat.cat_valor = tra_ecom_pro_tipo_laboratorio and cat.cat_estado = 'A' and tra_ecom_tra_cm_correlativo = :$consulta and tra_ecom_no_examen = :$noExamen)
			WHERE 1=1 
			AND tra_ecom_estado = 'A'
			GROUP BY tra_ecom_pro_tipo_laboratorio 
			ORDER BY cat.cat_nombre ASC");
		$stmt -> bindParam(":".$filtro, $filtro, PDO::PARAM_STR);
		$stmt -> bindParam(":".$consulta, $consulta, PDO::PARAM_INT);
		$stmt -> bindParam(":".$noExamen, $noExamen, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlMostrarExamenes($tabla, $filtro,$consulta,$noExamen){
		$stmt = Conexion::conectar()->prepare("SELECT 
			*,
			exc.tra_ecom_pro_correl 
			FROM $tabla 
			INNER join examenes_complementarios exc on (exc.tra_ecom_tra_cm_correlativo = :$consulta AND exc.tra_ecom_no_examen = :$noExamen AND exc.tra_ecom_pro_correl = pro_correl AND exc.tra_ecom_estado = 'A') 
		WHERE 1=1 AND pro_tipo_laboratorio = :$filtro AND pro_clasificacion = 1 ORDER BY pro_nombre DESC");//AND exc.tra_ecom_tipo_ficha = :$tipoFicha 
		$stmt -> bindParam(":".$filtro, $filtro, PDO::PARAM_STR);
		$stmt -> bindParam(":".$consulta, $consulta, PDO::PARAM_STR);
		//$stmt -> bindParam(":".$tipoFicha, $tipoFicha, PDO::PARAM_INT);
		$stmt -> bindParam(":".$noExamen, $noExamen, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}
	
	/*=============================================
	MOSTRAR PACIENTES
	=============================================*/

	static public function mdlMostrarPaciente($tabla,$paciente){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE 1=1 AND cli_correlativo = :$paciente");
			$stmt -> bindParam(":".$paciente, $paciente, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}
	/*=============================================
	MOSTRAR MEDICO
	=============================================*/

	static public function mdlMostrarMedico($tabla,$consulta){
		$stmt = Conexion::conectar()->prepare("SELECT 
			tra_cm_correlativo,
			CONCAT(usr.usr_nombres,' ',usr.usr_apellidos) as nombre,
			usr.usr_colegiado,
			 pro.pro_nombre 
			 FROM $tabla 
			 INNER JOIN cfg_usuario usr on(usr.usr_correl = tra_cm_usr_correl)
			 INNER JOIN cfg_producto pro on(pro.pro_correl = tra_cm_tipo_consulta)
			 WHERE 1=1 AND tra_cm_correlativo = :$consulta");
		$stmt -> bindParam(":".$consulta, $consulta, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

}