<?php

require_once "conexion.php";

class ModeloProductos{
	/*=============================================
	MOSTRAR CONSULTA
	=============================================*/

	static public function mdlMostrarConsulta($tabla,$consulta){
		$stmt = Conexion::conectar()->prepare("SELECT 
			tra.tra_cm_correlativo,
			tra.tra_cm_procedencia,
			tra.tra_cm_aseguradora,
			tra.tra_cm_primer_consulta,
			tra.tra_cm_lugar_atencion,
			tra.tra_cm_tipo_consulta,
			tra.tra_cm_usr_correl,
			tra.tra_cm_fecha_inicio_consulta,
			tra.tra_cm_fecha_fin_consulta,
			tra.tra_cm_cli_correlativo,
			suc.suc_nombre,
			cli.cli_nombre,
			cli.cli_fecha_nacimiento,
			cli.cli_dpi,
			cli.cli_telefono1,
			cli.cli_fecha_nacimiento,
			cm.tra_cm_responsable_parentesco,
			cli.cli_estado_civil,
			cli.cli_direccion,
			cat.cat_nombre,
			cli.cli_religion,
			cli.cli_escolaridad,
			cli.cli_ocupacion,
			fn.tra_fichamn_antecedentes_medicos,
			fn.tra_fichamn_alergias,
			fn.tra_fichamn_alcohol,
			fn.tra_fichamn_cafe,
			fn.tra_fichamn_tabaco,
			fn.tra_fichamn_ht_otros,
			fn.tra_fichamn_glucosa_pre,
			fn.tra_fichamn_acido_urico,
			fn.tra_fichamn_colesterol,
			fn.tra_fichamn_trigliceridos,
			fn.tra_fichamn_otros,
			fn.tra_fichamn_presion_arterial,
			fn.tra_fichamn_bebidas_azucaradas,
			fn.tra_fichamn_comida_chatarra,
			fn.tra_fichamn_harinas_refinadas,
			fn.tra_fichamn_talla,
			fn.tra_fichamn_peso_anterior,
			fn.tra_fichamn_peso_actual,
			fn.tra_fichamn_imc_anterior,
			fn.tra_fichamn_imc_actual,
			fn.tra_fichamn_cirabdominal_anterior,
			fn.tra_fichamn_cirabdominal_actual,
			fn.tra_fichamn_grasa,
			fn.tra_fichamn_musculo,
			fn.tra_fichamn_actividad_fnombre,
			fn.tra_fichamn_actividad_fduracion,
			fn.tra_fichamn_activiad_fporsemana,
			fn.tra_fichamn_edad_metabolica,
			fn.tra_fichamn_alimentos_noconsume,
			fn.tra_fichamn_suplementos_medicamenots_consume,
			fn.tra_fichamn_cirbiceps_anterior,
			fn.tra_fichamn_cirbiceps_actual,
			fn.tra_fichamn_cirpantorrilla_anterior,
			fn.tra_fichamn_cirpantorrilla_actual,
			fn.tra_fichamn_cirpecho_anterior,
			fn.tra_fichamn_cirpecho_actual,
			fn.tra_fichamn_cirmuslo_anterior,
			fn.tra_fichamn_cirmuslo_actual,
			fn.tra_fichamn_impresion_diagnostica,
			fn.tra_fichamn_tratamiento,
			fn.tra_fichamn_datos_interes 
			 FROM $tabla tra
		LEFT JOIN cfg_sucursal suc on(suc.suc_correlativo = tra.tra_cm_lugar_atencion) 
		LEFT JOIN cfg_cliente cli on(cli.cli_correlativo = tra.tra_cm_cli_correlativo)
		LEFT JOIN cfg_catalogo cat on(cat.cat_valor = cli.cli_estado_civil and cat.cat_tipo = 'ESTADO_CIVIL') 	
		LEFT JOIN tra_ficha_nutricional fn on(fn.tra_fichamn_tra_cm_correlativo = tra.tra_cm_correlativo)
		LEFT JOIN tra_consulta_medica cm on(cm.tra_cm_correlativo = tra_fichamn_tra_cm_correlativo)
		WHERE 1=1 AND tra.tra_cm_correlativo = :$consulta");
			$stmt -> bindParam(":".$consulta, $consulta, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR RECETAS
	=============================================*/

	static public function mdlMostrarLaboratorios($tabla, $filtro){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE 1=1 AND cat_tipo = :$filtro ORDER BY cat_nombre ASC");
		$stmt -> bindParam(":".$filtro, $filtro, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	MOSTRAR EXAMENES
	=============================================*/
	static public function mdlMostrarExamenes($tabla, $filtro,$consulta,$tipoFicha,$noExamen){
		$stmt = Conexion::conectar()->prepare("SELECT 
			*,
			exc.tra_ecom_pro_correl 
			FROM $tabla 
			left join examenes_complementarios exc on (exc.tra_ecom_tra_cm_correlativo = :$consulta AND exc.tra_ecom_tipo_ficha = :$tipoFicha AND exc.tra_ecom_no_examen = :$noExamen AND exc.tra_ecom_pro_correl = pro_correl) 
		WHERE 1=1 AND pro_tipo_laboratorio = :$filtro AND pro_clasificacion = 1 ORDER BY pro_nombre DESC");
		$stmt -> bindParam(":".$filtro, $filtro, PDO::PARAM_STR);
		$stmt -> bindParam(":".$consulta, $consulta, PDO::PARAM_STR);
		$stmt -> bindParam(":".$tipoFicha, $tipoFicha, PDO::PARAM_INT);
		$stmt -> bindParam(":".$noExamen, $noExamen, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

	static public function mdlMostrarPaciente($tabla,$paciente){
		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE 1=1 AND cli_correlativo = :$paciente");
			$stmt -> bindParam(":".$paciente, $paciente, PDO::PARAM_INT);
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;
	}

}