<?php

use Slim\App;

$app->group('/security',function(App $group){
    $group->post('/login','App\Controllers\LoginController:login');
    $group->post('/menu','App\Controllers\FunctionsController:userMenu');
    $group->post('/objectaccess','App\Controllers\FunctionsController:objectAccess');
    
});

$app->group('/utilities',function(App $group){
    $group->post('/cmbcatalogo','App\Controllers\FunctionsController:cmbCatalogo');
    $group->post('/upload','App\Controllers\FunctionsController:uploadFile');
});


$app->group('/cfg_usuario',function(App $group){
    $group->post('/select','App\Controllers\CfgUsuarioController:select');
    $group->post('/insert','App\Controllers\CfgUsuarioController:insert');
    $group->post('/update','App\Controllers\CfgUsuarioController:update');
    $group->post('/delete','App\Controllers\CfgUsuarioController:delete');
    $group->post('/profile','App\Controllers\CfgUsuarioController:userProfile');
    $group->post('/updateprofile','App\Controllers\CfgUsuarioController:updateProfile');
    
});

$app->group('/cfg_usuario_rol',function(App $group){
    $group->post('/select','App\Controllers\CfgUsuarioRolController:select');
    $group->post('/insert','App\Controllers\CfgUsuarioRolController:insert');
    $group->post('/delete','App\Controllers\CfgUsuarioRolController:delete');
});

$app->group('/cfg_usuario_config',function(App $group){
    $group->post('/select','App\Controllers\CfgUsuarioConfigController:select');
    $group->post('/insert','App\Controllers\CfgUsuarioConfigController:insert');
    $group->post('/delete','App\Controllers\CfgUsuarioConfigController:delete');
});

$app->group('/cfg_funcionalidad',function(App $group){
    $group->post('/select','App\Controllers\CfgFuncionalidadController:select');
    $group->post('/insert','App\Controllers\CfgFuncionalidadController:insert');
    $group->post('/update','App\Controllers\CfgFuncionalidadController:update');
    $group->post('/delete','App\Controllers\CfgFuncionalidadController:delete'); 
    $group->post('/cmbFuncionalidadDispRol','App\Controllers\CfgFuncionalidadController:cmbFuncionalidadDispRol');
});

$app->group('/cfg_rol',function(App $group){
    $group->post('/select','App\Controllers\CfgRolController:select');
    $group->post('/insert','App\Controllers\CfgRolController:insert');
    $group->post('/update','App\Controllers\CfgRolController:update');
    $group->post('/delete','App\Controllers\CfgRolController:delete');
    $group->post('/cmbroldispusr','App\Controllers\CfgRolController:cmbRolDispUsr');
    
});

$app->group('/cfg_rol_funcionalidad',function(App $group){
    $group->post('/select','App\Controllers\CfgRolFuncionalidadController:select');
    $group->post('/insert','App\Controllers\CfgRolFuncionalidadController:insert');
    $group->post('/update','App\Controllers\CfgRolFuncionalidadController:update');
    $group->post('/delete','App\Controllers\CfgRolFuncionalidadController:delete');
});

$app->group('/cfg_organizacion',function(App $group){
    $group->post('/select','App\Controllers\CfgOrganizacionController:select');
    $group->post('/insert','App\Controllers\CfgOrganizacionController:insert');
    $group->post('/update','App\Controllers\CfgOrganizacionController:update');
    $group->post('/delete','App\Controllers\CfgOrganizacionController:delete');
    $group->post('/cmborgdispusr','App\Controllers\CfgOrganizacionController:cmbOrgDispUsr');
    
});

$app->group('/cfg_catalogo',function(App $group){
    $group->post('/select','App\Controllers\CfgCatalogoController:select');
    $group->post('/insert','App\Controllers\CfgCatalogoController:insert');
    $group->post('/update','App\Controllers\CfgCatalogoController:update');
    $group->post('/delete','App\Controllers\CfgCatalogoController:delete');
});


$app->group('/tra_attachment',function(App $group){
    $group->post('/select','App\Controllers\TraAttachmentController:select');
    $group->post('/insert','App\Controllers\TraAttachmentController:insert');
    $group->post('/delete','App\Controllers\TraAttachmentController:delete');
});


$app->group('/cfg_persona',function(App $group){
    $group->post('/select','App\Controllers\CfgPersonaController:select');
    $group->post('/insert','App\Controllers\CfgPersonaController:insert');
    $group->post('/update','App\Controllers\CfgPersonaController:update');
    $group->post('/delete','App\Controllers\CfgPersonaController:delete');
});

$app->group('/cfg_sucursal',function(App $group){
    $group->post('/select','App\Controllers\CfgSucursalController:select');
    $group->post('/selectuser','App\Controllers\CfgSucursalController:selectUser');
    $group->post('/cmbservicios','App\Controllers\CfgSucursalController:cmbServicios');
    $group->post('/insert','App\Controllers\CfgSucursalController:insert');
    $group->post('/insertbloqueoagenda','App\Controllers\CfgSucursalController:insertBloqueoAgenda');
    $group->post('/update','App\Controllers\CfgSucursalController:update');
    $group->post('/delete','App\Controllers\CfgSucursalController:delete');
    $group->post('/cmblistuser','App\Controllers\CfgSucursalController:cmbListUser');
    $group->post('/selectbloqueoagendacentro','App\Controllers\CfgSucursalController:selectBloqueoAgendaCentro');
});

$app->group('/cfg_usuario_sucursal',function(App $group){
    $group->post('/select','App\Controllers\CfgUsuarioSucursalController:select');
    $group->post('/selectcentrosusuariocmenagenda','App\Controllers\CfgUsuarioSucursalController:selectCentrosUsuarioCmenAgenda');
    $group->post('/selectcentrosusuariotabla','App\Controllers\CfgUsuarioSucursalController:selectCentrosUsuarioTabla');
    $group->post('/selectcentrosasignadosausuario','App\Controllers\CfgUsuarioSucursalController:selectCentrosAsignadosAUsuario');
    $group->post('/selectcentros','App\Controllers\CfgUsuarioSucursalController:selectCentros');
    $group->post('/delete','App\Controllers\CfgUsuarioSucursalController:delete');
    $group->post('/insert','App\Controllers\CfgUsuarioSucursalController:insert');
    $group->post('/cmbsucursales','App\Controllers\CfgUsuarioSucursalController:cmbSucursales');
});


$app->group('/cfg_cliente',function(App $group){
    $group->post('/select','App\Controllers\CfgClienteController:select');
    $group->post('/insert','App\Controllers\CfgClienteController:insert');
    $group->post('/update','App\Controllers\CfgClienteController:update');
    $group->post('/delete','App\Controllers\CfgClienteController:delete');
    $group->post('/getsign','App\Controllers\CfgClienteController:getSign');
});

$app->group('/cfg_producto',function(App $group){
    $group->post('/select','App\Controllers\CfgProductoController:select');
    $group->post('/selectespecialidad','App\Controllers\CfgProductoController:selectEspecialidad');
    $group->post('/insert','App\Controllers\CfgProductoController:insert');
    $group->post('/update','App\Controllers\CfgProductoController:update');
    $group->post('/delete','App\Controllers\CfgProductoController:delete');
});


$app->group('/cfg_aseguradora',function(App $group){
    $group->post('/select','App\Controllers\CfgAseguradoraController:select');
    $group->post('/insert','App\Controllers\CfgAseguradoraController:insert');
    $group->post('/update','App\Controllers\CfgAseguradoraController:update');
    $group->post('/delete','App\Controllers\CfgAseguradoraController:delete');
});

$app->group('/cfg_producto_plan',function(App $group){
    $group->post('/select','App\Controllers\CfgProductoPlanController:select');
    $group->post('/selectcosto','App\Controllers\CfgProductoPlanController:selectCosto');
    $group->post('/insert','App\Controllers\CfgProductoPlanController:insert');
    $group->post('/insertcosto','App\Controllers\CfgProductoPlanController:insertCosto');
    $group->post('/update','App\Controllers\CfgProductoPlanController:update');
    $group->post('/delete','App\Controllers\CfgProductoPlanController:delete');
    $group->post('/deletecosto','App\Controllers\CfgProductoPlanController:deleteCosto');
    $group->post('/selectproducts','App\Controllers\CfgProductoPlanController:selectProducts');
    $group->post('/selectaseguradora','App\Controllers\CfgProductoPlanController:selectAseguradora');
    $group->post('/selectcentroatencion','App\Controllers\CfgProductoPlanController:selectCentroAtencion');
});

$app->group('/cfg_objeto_config',function(App $group){
    $group->post('/select','App\Controllers\CfgObjetoConfigController:select');
    $group->post('/selectservicioregistrados','App\Controllers\CfgObjetoConfigController:selectServicioRegistrados');
    $group->post('/insert','App\Controllers\CfgObjetoConfigController:insert');
    $group->post('/insertservicio','App\Controllers\CfgObjetoConfigController:insertServicio');
    $group->post('/update','App\Controllers\CfgObjetoConfigController:update');
    $group->post('/delete','App\Controllers\CfgObjetoConfigController:delete');
});

$app->group('/cfg_agenda',function(App $group){
    $group->post('/select','App\Controllers\CfgAgendaController:select');
    $group->post('/selectespecialidadescentro','App\Controllers\CfgAgendaController:selectEspecialidadesCentro');
    $group->post('/selectagenda','App\Controllers\CfgAgendaController:selectAgenda');
    $group->post('/insertagenda','App\Controllers\CfgAgendaController:insertAgenda');
    $group->post('/insertcita','App\Controllers\CfgAgendaController:insertCita');
    $group->post('/updateagenda','App\Controllers\CfgAgendaController:updateAgenda');
    $group->post('/delete','App\Controllers\CfgAgendaController:delete');
});

$app->group('/tra_call_center',function(App $group){
    $group->post('/selectespecialidad','App\Controllers\TraCitaMedicaController:selectEspecialidades');
    //$group->post('/selectagenda','App\Controllers\TraCitaMedicaController:selectAgenda');//no borrar
    $group->post('/selectagendacallcenter','App\Controllers\TraCitaMedicaController:selectAgendaCallCenter');
    $group->post('/selectordendetrabajo','App\Controllers\TraCitaMedicaController:selectOrdenDeTrabajo');
    $group->post('/selectnoordendetrabajo','App\Controllers\TraCitaMedicaController:selectNoOrdenDeTrabajo');
    $group->post('/selectbloqueoagenda','App\Controllers\TraCitaMedicaController:selectBloqueoAgenda');
    $group->post('/selectdatapaciente','App\Controllers\TraCitaMedicaController:selectDataPaciente');
    $group->post('/cmbserviciosgeneral','App\Controllers\TraCitaMedicaController:cmbServiciosGeneral');
    $group->post('/selectservicioespecialidad','App\Controllers\TraCitaMedicaController:selectServicioEspecialidad');
    $group->post('/selectaseguradoras','App\Controllers\TraCitaMedicaController:selectAseguradoras');
    $group->post('/selectcentrosatencion','App\Controllers\TraCitaMedicaController:selectCentrosAtencion');
    $group->post('/selectcitamedico','App\Controllers\TraCitaMedicaController:selectCitaMedico');
    $group->post('/selectinfomedico','App\Controllers\TraCitaMedicaController:selectInfoMedico');

    $group->post('/insertconsultamedica','App\Controllers\TraCitaMedicaController:insertConsultaMedica');
    $group->post('/updateconsultamedica','App\Controllers\TraCitaMedicaController:updateConsultaMedica');

    
    $group->post('/insertitemreceta','App\Controllers\TraCitaMedicaController:insertItemReceta');
    
    $group->post('/insertitemexameneslaboratorio','App\Controllers\TraCitaMedicaController:insertItemExamenesLaboratorio');
    
    $group->post('/deleteitemexamen','App\Controllers\TraCitaMedicaController:deleteItemExamen');
    
    $group->post('/confirmacionproximaconsulta','App\Controllers\TraCitaMedicaController:confirmacionProximaConsulta');
    $group->post('/cancelarProximaConsulta','App\Controllers\TraCitaMedicaController:cancelarProximaConsulta');
    $group->post('/cancelarconsulta','App\Controllers\TraCitaMedicaController:cancelarConsulta');
    
    $group->post('/confirmarconsulta','App\Controllers\TraCitaMedicaController:confirmarConsulta');
    $group->post('/recalendarizarconsulta','App\Controllers\TraCitaMedicaController:recalendarizarConsulta');
    
    $group->post('/selectproximaconsulta','App\Controllers\TraCitaMedicaController:selectProximaConsulta');
    
    $group->post('/selectrecetafichamedica','App\Controllers\TraCitaMedicaController:selectRecetaFichamedica');

    $group->post('/selectsucursal','App\Controllers\TraCitaMedicaController:selectSucursal');
    $group->post('/selectcitasucursal','App\Controllers\TraCitaMedicaController:selectCitaSucursal');
    $group->post('/deleteordentrabajo','App\Controllers\TraCitaMedicaController:deleteOrdenTrabajo');
    
});
$app->group('/tra_ficha_medica',function(App $group){
    $group->post('/selectpaciente','App\Controllers\TraFichaMedicaController:selectPaciente');
    $group->post('/selectconsultapaciente','App\Controllers\TraFichaMedicaController:selectConsultaPaciente');
    $group->post('/selectimcpaciente','App\Controllers\TraFichaMedicaController:selectImcPaciente');
    $group->post('/selectconsultamedica','App\Controllers\TraFichaMedicaController:selectConsultaMedica');
    $group->post('/selectultimasconsultasmedicas','App\Controllers\TraFichaMedicaController:selectUltimasConsultasMedicas');
    $group->post('/selectexamenfisico','App\Controllers\TraFichaMedicaController:selectExamenFisico');
    $group->post('/selectfichamedica','App\Controllers\TraFichaMedicaController:selectFichaMedica');
    $group->post('/selectfichaocupacional','App\Controllers\TraFichaMedicaController:selectFichaOcupacional');
    $group->post('/selectultimafichanutricional','App\Controllers\TraFichaMedicaController:selectUltimaFichaNutricional');
    $group->post('/selectfichanutricional','App\Controllers\TraFichaMedicaController:selectFichaNutricional');
    $group->post('/selectconsultamedicapaciente','App\Controllers\TraFichaMedicaController:selectConsultaMedicaPaciente');
    $group->post('/selectconsultareceta','App\Controllers\TraFichaMedicaController:selectConsultaReceta');
    $group->post('/selectconsultarecetaexamencomplementario','App\Controllers\TraFichaMedicaController:selectConsultaRecetaExamenComplementario');
    $group->post('/selectexamenlaboratorio','App\Controllers\TraFichaMedicaController:selectExamenLaboratorio');
    $group->post('/selectultimaconsulta','App\Controllers\TraFichaMedicaController:selectUltimaConsulta');
    $group->post('/selectconsultaexamen','App\Controllers\TraFichaMedicaController:selectConsultaExamen');
    $group->post('/selectexamenlab','App\Controllers\TraFichaMedicaController:selectExamenLab');
    $group->post('/selectreceta','App\Controllers\TraFichaMedicaController:selectReceta');
    $group->post('/selectrecetaexamencomplementario','App\Controllers\TraFichaMedicaController:selectRecetaExamenComplementario');
    $group->post('/selectpesofichapaciente','App\Controllers\TraFichaMedicaController:selectPesoFichaPaciente');

    $group->post('/insertfichamedica','App\Controllers\TraFichaMedicaController:insertFichaMedica');
    $group->post('/insertchecklist','App\Controllers\TraFichaMedicaController:insertChecklist');
    $group->post('/insertreceta','App\Controllers\TraFichaMedicaController:insertReceta');
    $group->post('/insertrecetaexamen','App\Controllers\TraFichaMedicaController:insertRecetaExamen');
    $group->post('/insertexamenlaboratorio','App\Controllers\TraFichaMedicaController:insertExamenLaboratorio');
    $group->post('/insertfichaocupacional','App\Controllers\TraFichaMedicaController:insertFichaOcupacional');
    $group->post('/insertitemexamenlaboratorio','App\Controllers\TraFichaMedicaController:insertItemExamenLaboratorio');
    $group->post('/insertitemrecetaexamencomplementario','App\Controllers\TraFichaMedicaController:insertItemRecetaExamenComplementario');
    $group->post('/insertfichanutricional','App\Controllers\TraFichaMedicaController:insertFichaNutricional');
    $group->post('/insertitemreceta','App\Controllers\TraFichaMedicaController:insertItemReceta');
    $group->post('/insertitemexameneslaboratorio','App\Controllers\TraFichaMedicaController:insertItemExamenesLaboratorio');

    $group->post('/updatefichamedica','App\Controllers\TraFichaMedicaController:updateFichaMedica');
    $group->post('/updatefichaocupacional','App\Controllers\TraFichaMedicaController:updateFichaOcupacional');
    $group->post('/updateproximacita','App\Controllers\TraFichaMedicaController:updateProximaCita');
    $group->post('/updateallreceta','App\Controllers\TraFichaMedicaController:updateAllReceta');
    $group->post('/updateitemreceta','App\Controllers\TraFichaMedicaController:updateItemReceta');
    $group->post('/updateitemrecetaexamencomplementario','App\Controllers\TraFichaMedicaController:updateItemRecetaExamenComplementario');
    $group->post('/updateallrecetaexacomplementario','App\Controllers\TraFichaMedicaController:updateAllRecetaExaComplementario');
    $group->post('/updateallrecetaexamencomplementario','App\Controllers\TraFichaMedicaController:updateAllRecetaExamenComplementario');
    $group->post('/updatefichanutricional','App\Controllers\TraFichaMedicaController:updateFichaNutricional');
    //$group->post('/cancelarProximaConsulta','App\Controllers\TraFichaMedicaController:cancelarProximaConsulta');

    $group->post('/deletereceta','App\Controllers\TraFichaMedicaController:deleteReceta');
    $group->post('/deleterecetaexamencomplementario','App\Controllers\TraFichaMedicaController:deleteRecetaExamenComplementario');
    $group->post('/deleteexamenlaboratorio','App\Controllers\TraFichaMedicaController:deleteExamenLaboratorio');
    $group->post('/deleteitemreceta','App\Controllers\TraFichaMedicaController:deleteItemReceta');
    $group->post('/deletelaboratorio','App\Controllers\TraFichaMedicaController:deleteLaboratorio');
    $group->post('/deleteitemexamen','App\Controllers\TraFichaMedicaController:deleteItemExamen');

});




$app->group('/agenda_medico',function(App $group){
    $group->post('/selectSucursalAsignada','App\Controllers\TraAgendaMedicoController:selectSucursalAsignada');
    $group->post('/selectConsultaSucursal','App\Controllers\TraAgendaMedicoController:selectConsultaSucursal');
    $group->post('/selectbloqueoagenda','App\Controllers\TraAgendaMedicoController:selectBloqueoAgenda');
    $group->post('/selectAseguradora','App\Controllers\TraAgendaMedicoController:selectAseguradora');
    $group->post('/selectAgendaCallCenter','App\Controllers\TraAgendaMedicoController:selectAgendaCallCenter');
    $group->post('/selectDataPaciente','App\Controllers\TraAgendaMedicoController:selectDataPaciente');

    $group->post('/updateConsultaMedica','App\Controllers\TraAgendaMedicoController:updateConsultaMedica');
});

$app->group('/tra_recepcion_paciente',function(App $group){
    $group->post('/selectconsulta','App\Controllers\TraRecepcionPacienteController:selectConsulta');
    $group->post('/selectitemordentrabajo','App\Controllers\TraRecepcionPacienteController:selectItemOrdenTrabajo');
    $group->post('/selectfacturapaciente','App\Controllers\TraRecepcionPacienteController:selectFacturaPaciente');
    $group->post('/selectformapago','App\Controllers\TraRecepcionPacienteController:selectFormaPago');
    $group->post('/selectaseguradora','App\Controllers\TraRecepcionPacienteController:selectAseguradora');
    $group->post('/selectplan','App\Controllers\TraRecepcionPacienteController:selectPlan');
    $group->post('/calcularMontoOrdenTrabajo','App\Controllers\TraRecepcionPacienteController:calcularMontoOrdenTrabajo');
    $group->post('/selectservicio','App\Controllers\TraRecepcionPacienteController:selectServicio');
    $group->post('/selectprecio','App\Controllers\TraRecepcionPacienteController:selectPrecio');
    $group->post('/selectexamen','App\Controllers\TraRecepcionPacienteController:selectExamen');
    $group->post('/selectmedico','App\Controllers\TraRecepcionPacienteController:selectMedico');
    $group->post('/selectpaciente','App\Controllers\TraRecepcionPacienteController:selectPaciente');
    $group->post('/selectusuariocortesia','App\Controllers\TraRecepcionPacienteController:selectUsuarioCortesia');
    $group->post('/insertservicio','App\Controllers\TraRecepcionPacienteController:insertServicio');
    $group->post('/insertservicioordentrabajo','App\Controllers\TraRecepcionPacienteController:insertServicioOrdenTrabajo');
    $group->post('/updateotroscobros','App\Controllers\TraRecepcionPacienteController:updateOtrosCobros');
    $group->post('/insertpagoefectivo','App\Controllers\TraRecepcionPacienteController:insertPagoEfectivo');
    $group->post('/insertpagocortesia','App\Controllers\TraRecepcionPacienteController:insertPagoCortesia');
    $group->post('/insertpagodepositotransferencia','App\Controllers\TraRecepcionPacienteController:insertPagoDepositoTransferencia');
    $group->post('/insertpagocupon','App\Controllers\TraRecepcionPacienteController:insertPagoCupon');
    $group->post('/insertpagotarjeta','App\Controllers\TraRecepcionPacienteController:insertPagoTarjeta');
    $group->post('/insertpagocredito','App\Controllers\TraRecepcionPacienteController:insertPagoCredito');
    $group->post('/insertfacturapaciente','App\Controllers\TraRecepcionPacienteController:insertFacturaPaciente');
    $group->post('/insertdatopaciente','App\Controllers\TraRecepcionPacienteController:insertDatoPaciente');
    $group->post('/deleteitemservicioordentrabajo','App\Controllers\TraRecepcionPacienteController:deleteItemServicioOrdenTrabajo');
    $group->post('/deletefacturapaciente','App\Controllers\TraRecepcionPacienteController:deleteFacturaPaciente');
    $group->post('/deleteitemformapago','App\Controllers\TraRecepcionPacienteController:deleteItemFormaPago');
    /*$group->post('/insert','App\Controllers\TraRecepcionPacienteController:insert');
    $group->post('/update','App\Controllers\TraRecepcionPacienteController:update');
    $group->post('/delete','App\Controllers\TraRecepcionPacienteController:delete');
    $group->post('/getsign','App\Controllers\TraRecepcionPacienteController:getSign');*/
    
});

$app->group('/cfg_cupon',function(App $group){
    $group->post('/select','App\Controllers\CfgCuponController:select');
    $group->post('/insert','App\Controllers\CfgCuponController:insert');
    $group->post('/update','App\Controllers\CfgCuponController:update');
    $group->post('/delete','App\Controllers\CfgCuponController:delete');
});

$app->group('/tra_facturacion',function(App $group){
    $group->post('/select','App\Controllers\TraFacturacionPeriodicaController:select');
    $group->post('/insert','App\Controllers\TraFacturacionPeriodicaController:insert');
    //$group->post('/insertfacturacliente','App\Controllers\TraFacturacionPeriodicaController:insertFacturaCliente');
    $group->post('/insertfacturacliente','App\Controllers\TraFacturacionPeriodicaController:insertFacturaCliente');
    $group->post('/update','App\Controllers\TraFacturacionPeriodicaController:update');
    $group->post('/delete','App\Controllers\TraFacturacionPeriodicaController:delete');
    $group->post('/getsign','App\Controllers\TraFacturacionPeriodicaController:getSign');
});