<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgAgendaController {
	
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $pro_clasificacion = $parameter['pro_clasificacion'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $pro_estado = $parameter['pro_estado'] ?? 'A';

					
                    $sql = " 
                    select 
                    a.pro_correl, 
                    a.pro_codigo,  
                    a.pro_empresa,  
                    a.pro_nombre,  
                    a.pro_nombre_corto,  
                    a.pro_codigo_ext,  
                    a.pro_clasificacion,  
                    a.pro_cod_padre,  
                    d.cat_nombre cat_estado_nombre,  
                    a.pro_estado,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as pro_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as pro_usuariom,  
                    date_format(a.pro_fechai, '%d/%m/%y %T') as pro_fechai,  
                    date_format(a.pro_fecham, '%d/%m/%y %T') as pro_fecham,  
                    a.pro_ambiente  
                    from cfg_producto a
                    left outer join cfg_catalogo d on(a.pro_estado= d.cat_valor and d.cat_tipo = 'ESTADO_PRODUCTO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.pro_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.pro_usuariom)
                    where 
                    1=1
                    and a.pro_clasificacion = :pro_clasificacion
                    and a.pro_empresa = :emp_codigo 
                    and a.pro_ambiente = :pro_ambiente 
                    and ((a.pro_nombre like concat('%',:filter,'%') or a.pro_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and a.pro_estado =:pro_estado
                    and (a.pro_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.pro_fechai <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900')
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo' => $emp_codigo,
                        'pro_ambiente' => $amb_codigo,
                        'pro_clasificacion' => $pro_clasificacion,
                        'pro_estado' => $pro_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter,
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una especialidad'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_producto a
                            left outer join cfg_catalogo d on(a.pro_estado= d.cat_valor and d.cat_tipo = 'ESTADO_PRODUCTO' and d.cat_empresa = :emp_codigo and a.pro_ambiente = :pro_ambiente)
                            left outer join cfg_usuario b on (b.usr_correl = a.pro_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.pro_usuariom)
                            ", " and a.pro_clasificacion = :pro_clasificacion
                            and a.pro_empresa = :emp_codigo 
                            and ((a.pro_nombre like concat('%',:filter,'%') or a.pro_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                            and a.pro_estado =:pro_estado
                            and (a.pro_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                            and (a.pro_fechai <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'pro_ambiente' => $amb_codigo,
                            'pro_clasificacion' => $pro_clasificacion,
                            'pro_estado' => $pro_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter' => $filter,
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'No existen especialidades'));
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectEspecialidadesCentro($request, $response, $args) {//selectEspecialidades
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $ocf_objeto_permiso = 'Cfg_sucursal';//$parameter['ocf_objeto_permiso'] ?? 'no_object';//corregir
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, $ocf_objeto_permiso, 'lectura');
                if($userFuncionality == 'OK'){
                    $ocf_objeto = $parameter['ocf_objeto'] ?? 'no_object';
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $ocf_estado = 'A';//$parameter['ocf_estado'] ?? 'A';
                    $ocf_objeto_codigo = $parameter['ocf_objeto_codigo'] ?? 0;
                    $type = $parameter['type'] ?? 'qry';

                    $sql = " 
                    select 
                    a.ocf_correlativo, 
                    a.ocf_codigo,  
                    a.ocf_cod_cat,  
                    a.ocf_empresa,  
                    a.ocf_objeto,  
                    a.ocf_objeto_codigo,  
                    a.ocf_orden,  
                    a.ocf_param_nombre,  
                    a.ocf_param_tipo,  
                    a.ocf_param_catalogo,  
                    a.ocf_param_valor,  
                    d.cat_nombre cat_estado_nombre,  
                    pro.pro_nombre nombre_especialidad,
                    pro.pro_color color,
                    a.ocf_hora_inicio_lav as hora_inicio_lav, 
                    a.ocf_hora_fin_lav as hora_fin_lav, 
                    a.ocf_hora_inicio_sabado as hora_inicio_sabado, 
                    a.ocf_hora_fin_sabado as hora_fin_sabado, 
                    a.ocf_hora_inicio_domingo as hora_inicio_domingo, 
                    a.ocf_hora_fin_domingo as hora_fin_domingo,   
                    a.ocf_estado,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as ocf_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as ocf_usuariom,  
                    a.ocf_fechai,  
                    a.ocf_fecham  
                    from cfg_objeto_config a
                    left outer join cfg_catalogo d on(a.ocf_estado= d.cat_valor and d.cat_tipo = 'COLOCA_CATALOGO_AQUI' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.ocf_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.ocf_usuariom)
                    left outer join cfg_producto pro on (pro.pro_correl = a.ocf_param_tipo and pro.pro_clasificacion=2 and pro.pro_estado='A') 
                    where 
                    1=1
                    and a.ocf_empresa = :emp_codigo 
                    and a.ocf_estado =:ocf_estado
                    and a.ocf_objeto = :ocf_objeto
                    and a.ocf_objeto_codigo = :ocf_objeto_codigo
                    and (a.ocf_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.ocf_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 

                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                    'ocf_estado' => $ocf_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'ocf_objeto'=>$ocf_objeto,
                    'ocf_objeto_codigo'=>$ocf_objeto_codigo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($result)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_objeto_config a
                        left outer join cfg_catalogo d on(a.ocf_estado= d.cat_valor and d.cat_tipo = 'COLOCA_CATALOGO_AQUI' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.ocf_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.ocf_usuariom)
                        left outer join cfg_producto pro on (pro.pro_correl = a.ocf_param_tipo and pro.pro_clasificacion=2 and pro.pro_estado='A')
                        ", "   and a.ocf_empresa = :emp_codigo 
                        and a.ocf_estado =:ocf_estado
                        and a.ocf_objeto = :ocf_objeto
                        and a.ocf_objeto_codigo = :ocf_objeto_codigo
                        and (a.ocf_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                        and (a.ocf_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                        ", 
                        ['emp_codigo' => $emp_codigo,
                        'ocf_estado' => $ocf_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'ocf_objeto'=>$ocf_objeto,
                        'ocf_objeto_codigo'=>$ocf_objeto_codigo
                        ]);
                        
                        array_unshift($result,array("ocf_correlativo"=>'','nombre_especialidad'=>'Seleccione una opción'));

                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                            array_unshift($result,array("ocf_correlativo"=>'','nombre_especialidad'=>'No existen datos'));
                        
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectAgenda($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');//SE DEBE CAMBIAR EL NOMBRE DEL OBJETO
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $age_usr_correl = $parameter['age_usr_correl'] ?? 0;
                    $age_estado = $parameter['age_estado'] ?? 'A';
                    ////09/01/2021 - 09/10/2021
                    
                    $sql = " 
                    select 
                    a.age_correlativo as id, 
                    a.age_usr_correl as idmedico,  
                    concat(med.usr_nombres,' ', med.usr_apellidos) as medico,
                    a.age_pro_correl as idespecialidad,
                    a.age_suc_correlativo,  
                    suc.suc_nombre as nombre_centro, 
                    pro.pro_nombre as title, 
                    pro.pro_color as backgroundColor,
                    a.age_fecha_inicio as start,
                    a.age_fecha_fin as end,
                    concat(date_format(a.age_fecha_inicio, '%m/%d/%Y'),' - ',date_format(a.age_fecha_fin, '%m/%d/%Y')) as age_fechaInicioFin,
                    concat(date_format(a.age_fecha_inicio, '%H:%i')) as age_hora_inicio,
                    concat(date_format(a.age_fecha_fin, '%H:%i')) as age_hora_fin,
                    a.age_text_color as textColor,
                    a.age_comentario as comment, 
                    a.age_estado,  
                    d.cat_nombre cat_estado_nombre,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                    date_format(a.age_fechai, '%d/%m/%y %T') as age_fechai,  
                    date_format(a.age_fecham, '%d/%m/%y %T') as age_fecham 
                    from cfg_agenda a
                    left outer join cfg_catalogo d on(a.age_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_producto pro on(a.age_pro_correl= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.age_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.age_usuariom)
                    left outer join cfg_usuario med on (a.age_usr_correl = med.usr_correl)
                    left outer join cfg_sucursal suc on (suc.suc_correlativo  = a.age_suc_correlativo)
                    where 
                    1=1
                    and ((a.age_comentario like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and a.age_estado =:age_estado
                    and a.age_usr_correl =:age_usr_correl 
                    and (a.age_usuarioi >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.age_fecham <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900')
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                        'age_usr_correl' => $age_usr_correl,
                        'age_estado' => $age_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter,
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_agenda a
                            left outer join cfg_catalogo d on(a.age_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)
                            left outer join cfg_producto pro on(a.age_pro_correl= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                            left outer join cfg_usuario b on (b.usr_correl = a.age_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.age_usuariom)
                            left outer join cfg_sucursal suc on (suc.suc_correlativo  = a.age_suc_correlativo)
                            ", " 
                            and ((a.age_comentario like concat('%',:filter,'%')) or (:filter = 'undefined'))
                            and a.age_estado =:age_estado
                            and a.age_usr_correl =:age_usr_correl 
                            and (a.age_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                            and (a.age_fecham <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'age_usr_correl' => $age_usr_correl,
                            'age_estado' => $age_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter' => $filter,
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }

    public function insertAgenda($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'nuevo');//CAMBIAR EL NOMBRE DEL OBJETO
                if($userFuncionality == 'OK'){
                    $existeHorario = [];
                    $existesHorarioAgenda = [];
                    $registrar = false;
                    $registrarAgenda = false;
                    $mensaje = "";
                    $age_allDay = (int)$parameter['age_allDay'] ?? 0;
                    $age_usr_correl=(int)$parameter['age_usr_correl'] ?? 0;
                    $age_pro_correl=(int)$parameter['age_pro_correl'] ?? 0;
                    $age_suc_correlativo=(int)$parameter['age_suc_correlativo'] ?? 0;
                    $age_fecha_inicio=$parameter['age_fecha_inicio'] ?? date("Y-m-d");
                    $age_fecha_fin=$parameter['age_fecha_fin'] ?? date("Y-m-d");

                    $age_hora_inicio=$parameter['age_hora_inicio'] ?? date("H:i");
                    $age_hora_fin=$parameter['age_hora_fin'] ?? date("H:i");

                    /*$age_fecha_inicio = $age_fecha_inicio."T".$age_hora_inicio;
                    $age_fecha_fin = $age_fecha_fin."T".$age_hora_fin;*/

                    $age_comentario=$parameter['age_comentario'] ?? 'null';
                    $age_color = '#A3F2ED';//$parameter['age_color'] ?? '#A3F2ED';
                    $age_text_color = '#000000';//$parameter['age_text_color'] ?? '#000000';

                    $age_comentario = $utility->validarLongitudString($age_comentario, 0, 500);
                    
                    $age_estado=$parameter['age_estado'] ?? 'A';
                    //$reemplazar = $age_fecha_hora_inicio;
                    //$age_correlativo = $utility->CorrelAutomatico($PDO, "cfg_agenda", "age_correlativo ", "");
                    $age_fecha_inicio_n = "";
                    $age_fecha_fin_n = "";
                    $fechaInicio = "";
                    $fechaFin = "";
                    $age_fecha_inicio_n = date("d-m-Y",strtotime($age_fecha_inicio));
                    $age_fecha_fin_n = date("d-m-Y",strtotime($age_fecha_fin));
                    $fechaInicio=strtotime($age_fecha_inicio_n);
                    $fechaFin=strtotime($age_fecha_fin_n);
                    //$fechaInicio2=strtotime($age_fecha_inicio_n);
                    //$fechaFin2=strtotime($age_fecha_fin_n);
                    $i = "";
                    //$horarioCentroValido = 1;
                    for($i=$fechaInicio; $i<=$fechaFin; $i+=86400){
                        //echo "(".date("Y-m-d", $i)." ".$age_hora_inicio." - ".date("Y-m-d", $i)." ".$age_hora_fin.")<br>";
                        $horarioCentroValido = $utility->validarHorarioSucursal($PDO, "cfg_sucursal", "suc_correlativo",date("Y-m-d", $i)." ".$age_hora_inicio,date("Y-m-d", $i)." ".$age_hora_fin,"$age_suc_correlativo"," and suc_empresa = $emp_codigo and suc_ambiente = $amb_codigo");
                        if($horarioCentroValido == 0){
                            $horarioCentroValido = 0;
                            break;
                        }
                    }

                    //$horarioServicioValido = 1;
                    
                    $age_correlativo = $utility->ultimoRegistro($PDO, "cfg_agenda", "age_correlativo ", "order by age_correlativo desc limit 1");
                    //$especialidadRegistrada = 0;
                    $especialidadRegistrada = $utility->validarAgendaMedico($PDO, "cfg_agenda", "age_correlativo ","$age_usr_correl","$age_suc_correlativo","$age_pro_correl", "$age_fecha_inicio.' '.$age_hora_inicio", "$age_fecha_fin.' '.$age_hora_fin", "");

                    

                   



                    //date_format(a.age_fechai, '%d/%m/%y %T') as age_fechai
                    /*$especialidad = $utility->buscarRegistro($PDO, "cfg_producto", "pro_correl,pro_nombre dato", " and pro_correl=:valorCampo1 and pro_estado != 'E' and pro_clasificacion = 2",$age_pro_correl,"");*/

                    /***********************************INICIO HORA Y ESPECIALIDAD*********************************************/
                    /*$existesHorarioAgenda = $utility->buscarRegistroObj($PDO, "cfg_agenda", "age_correlativo,age_usr_correl,age_pro_correl,age_fecha,age_hora_inicio,age_hora_fin", " and age_estado != 'E' and age_usr_correl = $age_usr_correl and age_fecha=:valorCampo1 AND (age_hora_inicio between '$age_hora_inicio' and '$age_hora_fin') and (age_hora_fin between '$age_hora_inicio' and '$age_hora_fin' )",$age_fecha,"");*///and age_pro_correl = $age_pro_correl

                    /*if(count($existesHorarioAgenda) > 0){
                        $nombreEspecialidad = $utility->buscarRegistroObj($PDO, "cfg_producto", "pro_correl,pro_nombre", " and pro_correl=:valorCampo1 and pro_estado != 'E' and pro_clasificacion = 2",$existesHorarioAgenda[0]->age_pro_correl,"");
                    }*/
                    /***********************************FIN*********************************************/
                    $sql = "
                        SET @row_number = :age_correlativo;
                        insert into cfg_agenda (age_correlativo, age_usr_correl, age_pro_correl,age_suc_correlativo,age_fecha_inicio,age_fecha_fin,age_comentario,age_allDay,age_estado,age_usuarioi,age_usuariom, age_fechai, age_fecham)
                        select 
                        (@row_number:=@row_number + 1) AS num,
                        :age_usr_correl,
                        :age_pro_correl,
                        :age_suc_correlativo,
                        concat(selected_date,'T',:age_hora_inicio),
                        concat(selected_date,'T',:age_hora_fin),
                        :age_comentario,
                        :age_allDay,
                        'A',
                        :id_usuario,
                        :id_usuario,
                        now(),
                        now()

                        from 
                        (select concat(adddate('1970-01-01',t4.i*10000 + t3.i*1000 + t2.i*100 + t1.i*10 + t0.i)) selected_date from
                         (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t0,
                         (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t1,
                         (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t2,
                         (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t3,
                         (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t4) v
                        where selected_date between :age_fecha_inicio and :age_fecha_fin";
                        
                   
                    if($horarioCentroValido > 0){
                        if($especialidadRegistrada  > 0){
                            $registrarAgenda = false;
                            $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar este horario en la agenda del Therapeuta, actualmente la fecha y hora ya está reservada', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }else{
                            $registrarAgenda = true;
                        }
                        
                    }else{
                        $registrarAgenda = false;
                        //$registrarCita = false;
                        $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar este horario en la agenda del Therapeuta, el horario seleccionado está fuera del horario del centro, por favor revise el horario del centro de atención', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    } 
                    if($registrarAgenda == true){ 
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'age_correlativo' => $age_correlativo,
                            'age_allDay' => $age_allDay,//4
                            'age_usr_correl'=>$age_usr_correl,//1
                            'age_pro_correl' => $age_pro_correl,//2
                            'age_suc_correlativo' => $age_suc_correlativo,
                            'age_fecha_inicio' => $age_fecha_inicio,//6
                            'age_fecha_fin' => $age_fecha_fin,//7
                            'age_comentario' => $age_comentario,//3
                            'id_usuario' => $id_usuario,//5
                            'age_hora_inicio' => $age_hora_inicio,
                            'age_hora_fin' => $age_hora_fin
                            ]);
                            
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$age_correlativo);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function updateAgenda($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'modificar');//CAMBIAR EL NOMBRE DEL OBJETO
                if($userFuncionality == 'OK'){
                    $existeHorario = [];
                    $existeHorarioEspecialidad = [];
                    $actualizarRegistro = false;
                    $age_correlativo = (int)$parameter['age_correlativo'] ?? 0;
                    $age_suc_correlativo = (int)$parameter['age_suc_correlativo'] ?? 0;
                    $age_allDay = (int)$parameter['age_allDay'] ?? 0;
                    $age_usr_correl=(int)$parameter['age_usr_correl'] ?? 0;
                    $age_pro_correl=(int)$parameter['age_pro_correl'] ?? 0;
                    $age_fecha_inicio=$parameter['age_fecha_inicio'] ?? date("Y-m-d");
                    $age_fecha_fin=$parameter['age_fecha_fin'] ?? date("Y-m-d");
                    $age_hora_inicio=$parameter['age_hora_inicio'] ?? date("H:i");
                    $age_hora_fin=$parameter['age_hora_fin'] ?? date("H:i");
                    $age_comentario=$parameter['age_comentario'] ?? 'null';
                    $age_color = $parameter['age_color'] ?? '#A3F2ED';
                    $age_text_color = $parameter['age_text_color'] ?? '#000000';

                    $age_comentario = $utility->validarLongitudString($age_comentario, 0, 500);
                    
                    $age_estado=$parameter['age_estado'] ?? 'A';
                    $age_fecha_hora_inicio = date("Y-m-d H:i");
                    $age_fecha_hora_fin = date("Y-m-d H:i");

                    if(($age_fecha_inicio !="" && $age_hora_inicio !="") && ($age_fecha_fin !="" && $age_hora_fin !="")){
                        $age_fecha_hora_inicio = $age_fecha_inicio." ".$age_hora_inicio;
                        $age_fecha_hora_fin = $age_fecha_fin." ".$age_hora_fin;
                    }else{
                        $age_fecha_hora_inicio = date("Y-m-d H:i");
                        $age_fecha_hora_fin = date("Y-m-d H:i");
                    }

                    //date_format(a.age_fechai, '%d/%m/%y %T') as age_fechai

                    //$especialidad = $utility->buscarRegistro($PDO, "cfg_producto", "pro_correl,pro_nombre dato", " and pro_correl=:valorCampo1 and pro_estado != 'E' and pro_clasificacion = 2",$age_pro_correl,"");
                    $horarioCentroValido = $utility->validarHorarioSucursal($PDO, "cfg_sucursal", "suc_correlativo",$age_fecha_hora_inicio,$age_fecha_hora_fin,"$age_suc_correlativo"," and suc_empresa = $emp_codigo and suc_ambiente = $amb_codigo");

                    /***********************************INICIO HORA Y ESPECIALIDAD*********************************************/
                    /*$existesHorarioAgenda = $utility->buscarRegistroObj($PDO, "cfg_agenda", "age_correlativo,age_usr_correl,age_pro_correl,age_fecha,age_hora_inicio,age_hora_fin", " and age_estado != 'E' and age_usr_correl = $age_usr_correl and age_fecha=:valorCampo1 AND (age_hora_inicio between '$age_hora_inicio' and '$age_hora_fin') and (age_hora_fin between '$age_hora_inicio' and '$age_hora_fin' )",$age_fecha,"");//and age_pro_correl = $age_pro_correl

                    if(count($existesHorarioAgenda) > 0){
                        $nombreEspecialidad = $utility->buscarRegistroObj($PDO, "cfg_producto", "pro_correl,pro_nombre", " and pro_correl=:valorCampo1 and pro_estado != 'E' and pro_clasificacion = 2",$existesHorarioAgenda[0]->age_pro_correl,"");
                    }*/
                    /***********************************FIN*********************************************/


                    $sql = " update cfg_agenda set
                            age_fecha_inicio = :age_fecha_hora_inicio,  
                            age_fecha_fin = :age_fecha_hora_fin,  
                            age_comentario = :age_comentario,  
                            age_usuariom = :id_usuario,
                            age_fecham = now() 
                            where 
                            age_correlativo = :age_correlativo";
                                    

                    if($horarioCentroValido > 0){//HORARIO VALIDO DEL CENTRO
                        $actualizarRegistro = true;
                    }else{//ACTUALIZAR HORARIO
                        $actualizarRegistro = false;
                        $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible actualizar el horario del Therapeuta, el horario seleccionado está fuera del horario del centro, por favor revise el horario del centro de atención', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                    }
                    

                    if($actualizarRegistro == true){
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'age_correlativo' => $age_correlativo,
                            'age_fecha_hora_inicio' => $age_fecha_hora_inicio,
                            'age_fecha_hora_fin' => $age_fecha_hora_fin,
                            'age_comentario' => $age_comentario,
                            'id_usuario' => $id_usuario
                            ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Horario actualizado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'El horario no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }

                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertCita($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'nuevo');
                if($userFuncionality == 'OK'){
                    $tra_lugar_atencion  = (int)$parameter['tra_lugar_atencion '] ?? 0;
                    $tra_tipo_consulta=(int)$parameter['tra_tipo_consulta'] ?? 0;
                    $tra_fecha_consulta=$parameter['tra_fecha_consulta'] ?? date("Y-m-d H:i");
                    $tra_nombre_paciente=$parameter['tra_nombre_paciente'] ?? 'null';
                    $tra_fecha_nacimiento=$parameter['tra_fecha_nacimiento'] ?? date("Y-m-d");
                    $tra_dpi= $parameter['tra_dpi'] ?? 'null';
                    $tra_telefono= $parameter['tra_telefono'] ?? 'null';
                    $tra_menor  = (int)$parameter['tra_menor '] ?? 0;
                    $tra_responsable_menor=$parameter['tra_responsable_menor'] ?? 'null';
                    $tra_direccion=$parameter['tra_direccion'] ?? 'null';
                    $tra_etapa  = 1;
                    $tra_estado='A';//$parameter['tra_estado'] ?? 'A';

                    

                    //$age_comentario = $utility->validarLongitudString($age_comentario, 0, 500);
                    
                    
                    
                    $tra_correlativo = $utility->CorrelAutomatico($PDO, "tra_consulta_medica", "tra_correlativo ", "");
                    
                     $sql = " insert into tra_consulta_medica (
                                            tra_correlativo, 
                                            tra_codigo, 
                                            tra_empresa, 
                                            tra_ambiente,
                                            tra_lugar_atencion,
                                            tra_tipo_consulta, 
                                            tra_fecha_consulta, 
                                            tra_nombre_paciente, 
                                            tra_fecha_nacimiento,
                                            tra_telefono,
                                            tra_menor,
                                            tra_responsable_menor, 
                                            tra_direccion, 
                                            tra_etapa,
                                            tra_estado,
                                            tra_usuarioi,
                                            tra_usuariom,
                                            tra_fechai,
                                            tra_fecham
                                            ) values(
                                            :tra_correlativo, 
                                            :tra_codigo, 
                                            :tra_empresa, 
                                            :tra_ambiente,
                                            :tra_lugar_atencion,
                                            :tra_tipo_consulta, 
                                            :tra_fecha_consulta, 
                                            :tra_nombre_paciente, 
                                            :tra_fecha_nacimiento,
                                            :tra_telefono,
                                            :tra_menor,
                                            :tra_responsable_menor, 
                                            :tra_direccion, 
                                            :tra_etapa,
                                            :tra_estado,
                                            :id_usuario, 
                                            :id_usuario, 
                                            now(), 
                                            now()
                                            )";
                        
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'tra_correlativo' => $tra_correlativo, 
                            'tra_codigo' => $tra_correlativo, 
                            'tra_empresa' => $emp_codigo, 
                            'tra_ambiente' => $amb_codigo,
                            'tra_lugar_atencion' => $tra_lugar_atencion,
                            'tra_tipo_consulta' => $tra_tipo_consulta, 
                            'tra_fecha_consulta' => $tra_fecha_consulta, 
                            'tra_nombre_paciente' => $tra_nombre_paciente, 
                            'tra_fecha_nacimiento' => $tra_fecha_nacimiento,
                            'tra_telefono' => $tra_telefono,
                            'tra_menor' => $tra_menor,
                            'tra_responsable_menor' => $tra_responsable_menor, 
                            'tra_direccion' => $tra_direccion, 
                            'tra_etapa' => $tra_etapa,
                            'tra_estado' => $tra_estado,
                            'id_usuario' => $id_usuario, 
                            'id_usuario' => $id_usuario
                            ]);
                            
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>$age_fecha_inicio.' '.$age_fecha_fin, 'status'=>200,'token'=>$token,'key'=>$age_correlativo);//'Registro ingresado exitosamente'
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>$age_fecha_inicio.' '.$age_fecha_fin, 'status'=>403,'token'=>$token);//'Registro no pudo ser ingresado'
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $age_correlativo = (int)$parameter['age_correlativo'] ?? 0;
                    
                    $sql = " update cfg_agenda set age_estado ='E' where age_correlativo = :age_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'age_correlativo' => $age_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
}
