<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgAseguradoraController {
	
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_aseguradora', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $ase_estado = $parameter['ase_estado'] ?? 'A';

					
                    $sql = " 
                    select 
                    a.ase_correlativo, 
                    a.ase_nombre,  
                    a.ase_numero,  
                    a.ase_correo,  
                    a.ase_nit,
                    a.ase_direccion,
                    a.ase_comentarios,  
                    d.cat_nombre cat_estado_nombre,  
                    a.ase_estado,  
                    a.ase_fechai,  
                    a.ase_fecham,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as ase_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as ase_usuariom  
                    from cfg_aseguradora a
                    left outer join cfg_catalogo d on(a.ase_estado= d.cat_valor and d.cat_tipo = 'ESTADO_ASEGURADORA' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.ase_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.ase_usuariom)
                    where 
                    1=1
					and a.ase_estado =:ase_estado
                    and (a.ase_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.ase_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                    and ((a.ase_nombre like concat('%',:filter,'%') or a.ase_numero like concat('%',:filter,'%') or a.ase_correo like concat('%',:filter,'%')) or (:filter = 'undefined'))
					limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['ase_estado' => $ase_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'filter' => $filter,
                    'emp_codigo' => $emp_codigo,
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_aseguradora a
                        left outer join cfg_catalogo d on(a.ase_estado= d.cat_valor and d.cat_tipo = 'ESTADO_ASEGURADORA' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.ase_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.ase_usuariom)
                        ", "   and a.ase_estado =:ase_estado
                        and (a.ase_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                        and (a.ase_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                        and ((a.ase_nombre like concat('%',:filter,'%') or a.ase_numero like concat('%',:filter,'%') or a.ase_correo like concat('%',:filter,'%')) or (:filter = 'undefined'))
                        ", 
                        ['ase_estado' => $ase_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter,
                        'emp_codigo' => $emp_codigo,
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_aseguradora', 'nuevo');
                if($userFuncionality == 'OK'){
                    $ase_nombre=$parameter['ase_nombre'] ?? '';
                    $ase_numero=$parameter['ase_numero'] ?? '';
                    $ase_nit=$parameter['ase_nit'] ?? '';
                    $ase_direccion=$parameter['ase_direccion'] ?? '';
                    $ase_correo=$parameter['ase_correo'] ?? '';
                    $ase_comentarios=$parameter['ase_comentarios'] ?? '';
                    $ase_estado=$parameter['ase_estado'] ?? 'A';

                    $ase_nombre = $utility->validarLongitudString($ase_nombre, 0, 100);
                    $ase_numero = $utility->validarLongitudString($ase_numero, 0, 9);
                    $ase_nit = $utility->validarLongitudString($ase_nit, 0, 50);
                    $ase_direccion = $utility->validarLongitudString($ase_direccion, 0, 100);
                    $ase_correo = $utility->validarLongitudString($ase_correo, 0, 100);
                    $ase_comentarios = $utility->validarLongitudString($ase_comentarios, 0, 1000);


                    $ase_correlativo = $utility->CorrelAutomatico($PDO, "cfg_aseguradora", "ase_correlativo", "");
                    
                    $sql = " insert into cfg_aseguradora (
					
                            ase_correlativo, 
                            ase_empresa,
                            ase_ambiente,
                            ase_nombre, 
                            ase_numero, 
                            ase_correo, 
                            ase_nit,
                            ase_direccion,
                            ase_comentarios, 
                            ase_estado, 
                            ase_fechai, 
                            ase_fecham, 
                            ase_usuarioi, 
                            ase_usuariom 
                            ) values(
                            :ase_correlativo, 
                            :emp_codigo,
                            :amb_codigo,
                            :ase_nombre, 
                            :ase_numero, 
                            :ase_correo, 
                            :ase_nit,
                            :ase_direccion,
                            :ase_comentarios, 
                            :ase_estado, 
                            now(), 
                            now(), 
                            :id_usuario, 
                            :id_usuario 
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['ase_correlativo' => $ase_correlativo,
                    'ase_nombre' => $ase_nombre,
                    'ase_numero' => $ase_numero,
                    'ase_correo' => $ase_correo,
                    'ase_nit' => $ase_nit,
                    'ase_direccion' => $ase_direccion,
                    'ase_comentarios' => $ase_comentarios,
                    'ase_estado' => $ase_estado,
                    'id_usuario' => $id_usuario,
                    'emp_codigo' => $emp_codigo,
                    'amb_codigo' => $amb_codigo,
                    ]);
                    
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$ase_correlativo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_aseguradora', 'modificar');
                if($userFuncionality == 'OK'){
                   $ase_correlativo=(int)$parameter['ase_correlativo'] ?? 0;
                    $ase_nombre=$parameter['ase_nombre'] ?? '';
                    $ase_numero=$parameter['ase_numero'] ?? '';
                    $ase_correo=$parameter['ase_correo'] ?? '';
                    $ase_nit=$parameter['ase_nit'] ?? '';
                    $ase_direccion=$parameter['ase_direccion'] ?? '';
                    $ase_comentarios=$parameter['ase_comentarios'] ?? '';
                    $ase_estado=$parameter['ase_estado'] ?? 'A';

                    $ase_nombre = $utility->validarLongitudString($ase_nombre, 0, 100);
                    $ase_numero = $utility->validarLongitudString($ase_numero, 0, 9);
                    $ase_nit = $utility->validarLongitudString($ase_nit, 0, 50);
                    $ase_direccion = $utility->validarLongitudString($ase_direccion, 0, 100);
                    $ase_correo = $utility->validarLongitudString($ase_correo, 0, 100);
                    $ase_comentarios = $utility->validarLongitudString($ase_comentarios, 0, 1000);

                    $sql = " update cfg_aseguradora set
                            ase_nombre = :ase_nombre,  
                            ase_numero = :ase_numero,  
                            ase_correo = :ase_correo, 
                            ase_nit = :ase_nit, 
                            ase_direccion = :ase_direccion,  
                            ase_comentarios = :ase_comentarios,  
                            ase_estado = :ase_estado,  
                            ase_fecham=now(),  
                            ase_usuariom = :id_usuario
                            where
                            ase_correlativo=:ase_correlativo
                    ";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['ase_correlativo' => $ase_correlativo,
                    'ase_nombre' => $ase_nombre,
                    'ase_numero' => $ase_numero,
                    'ase_correo' => $ase_correo,
                    'ase_nit' => $ase_nit,
                    'ase_direccion' => $ase_direccion,
                    'ase_comentarios' => $ase_comentarios,
                    'ase_estado' => $ase_estado,
                    'id_usuario' => $id_usuario,
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_aseguradora', 'eliminar');
                if($userFuncionality == 'OK'){
                    $ase_correlativo= (int)$parameter['ase_correlativo'] ?? 0;
                    
                    
                    $sql = " update cfg_aseguradora set ase_estado = 'E ' where ase_correlativo = :ase_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'ase_correlativo' => $ase_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Catalogo no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
}
