<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgCatalogoController {
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_catalogo', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $cat_estado= $parameter['cat_estado'] ?? 'A';
                    $fecha_inicio = $parameter['fecha_inicio'] ?? "null";
                    $fecha_fin = $parameter['fecha_fin'] ?? "null";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $sql = " select 
                    cat.cat_correl,
                    cat.cat_codigo,
                    cat.cat_empresa,
                    cat.cat_tipo,
                    cat.cat_codigo_ext,
                    cat.cat_valor,
                    cat.cat_nombre,
                    cat.cat_nombre_corto,
                    cat.cat_padre,
                    cat.cat_nivel,
                    cat.cat_arbol,
                    cat.cat_estado,
                    est.cat_nombre cat_estado_nombre,
                    concat(u1.usr_nombres,' ',u1.usr_apellidos)as cat_usuarioi,
                    concat(u2.usr_nombres,' ',u2.usr_apellidos)as cat_usuariom,
                    date_format(cat.cat_fechai, '%d/%m/%y %T') as cat_fechai,
                    date_format(cat.cat_fecham, '%d/%m/%y %T') as cat_fecham,
                    cat.cat_ambiente,
                    cat.cat_version
                    from cfg_catalogo cat
                    left outer join cfg_usuario u1 on (u1.usr_correl = cat_usuarioi)  
                    left outer join cfg_usuario u2 on (u2.usr_correl = cat_usuariom) 
                    left outer join cfg_catalogo est on(cat.cat_estado = est.cat_valor and est.cat_tipo = 'CAT_ESTADO' and est.cat_empresa = :emp_codigo)
                    where 
                    1=1
                    and cat.cat_estado = :cat_estado
                    and ((cat.cat_nombre like concat('%',:filter,'%') or cat.cat_tipo like concat('%',:filter,'%') or cat.cat_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and (cat.cat_fechai >= STR_TO_DATE(:fecha_inicio,'%d/%m/%y %T') OR :fecha_inicio ='null' )
                    and (cat.cat_fechai <= STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin = 'null' ) 
                    and cat.cat_empresa = :emp_codigo
                    order by cat.cat_tipo
                    limit $pag_inicio, $tamanio 
                    ";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'cat_estado' => $cat_estado,
                        'emp_codigo' => $emp_codigo,
                        'fecha_inicio'=>$fecha_inicio,
                        'fecha_fin'=>$fecha_fin,
                        'filter'=>$filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if ($stmt->rowCount() > 0) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_catalogo cat", "  and cat.cat_estado = :cat_estado
                        and ((cat.cat_nombre like concat('%',:filter,'%') or cat.cat_tipo like concat('%',:filter,'%') or cat.cat_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                        and (cat.cat_fechai >= STR_TO_DATE(:fecha_inicio,'%d/%m/%y %T') OR :fecha_inicio ='null' )
                        and (cat.cat_fechai <= STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin = 'null' ) 
                        and cat.cat_empresa = :emp_codigo", 
                        [
                            'cat_estado' => $cat_estado,
                            'emp_codigo' => $emp_codigo,
                            'fecha_inicio'=>$fecha_inicio,
                            'fecha_fin'=>$fecha_fin,
                            'filter'=>$filter
                        ]);
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_catalogo', 'nuevo');
                if($userFuncionality == 'OK'){
                    $cat_correl = $utility->CorrelAutomatico($PDO, "cfg_catalogo", "cat_correl", "");
                    $cat_tipo= $parameter['cat_tipo'] ?? 'null';
                    $cat_codigo_ext= $parameter['cat_codigo_ext'] ?? 'null';
                    $cat_valor= $parameter['cat_valor'] ?? 'null';
                    $cat_nombre= $parameter['cat_nombre'] ?? 'null';
                    $cat_nombre_corto= $parameter['cat_nombre_corto'] ?? 'null';
                    $cat_padre= $parameter['cat_padre'] ?? 'null';
                    $cat_nivel= $parameter['cat_nivel'] ?? 'null';
                    $cat_arbol= $parameter['cat_arbol'] ?? 'null';
                    $cat_estado= $parameter['cat_estado'] ?? 'A';
                    
                    
                    $sql = " insert into cfg_catalogo (
                        cat_correl,
                        cat_codigo,
                        cat_empresa,
                        cat_tipo,
                        cat_codigo_ext,
                        cat_valor,
                        cat_nombre,
                        cat_nombre_corto,
                        cat_padre,
                        cat_nivel,
                        cat_arbol,
                        cat_estado,
                        cat_usuarioi,
                        cat_usuariom,
                        cat_fechai,
                        cat_fecham,
                        cat_ambiente,
                        cat_version
                        ) values(
                            :cat_correl,
                            :cat_correl,
                            :cat_empresa,
                            :cat_tipo,
                            :cat_codigo_ext,
                            :cat_valor,
                            :cat_nombre,
                            :cat_nombre_corto,
                            :cat_padre,
                            :cat_nivel,
                            :cat_arbol,
                            :cat_estado,
                            :cat_usuarioi,
                            :cat_usuarioi,
                            now(),
                            now(),
                            :cat_ambiente,
                            1
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'cat_correl' => $cat_correl,
                        'cat_empresa' => $emp_codigo,
                        'cat_tipo' => $cat_tipo,
                        'cat_codigo_ext' => $cat_codigo_ext,
                        'cat_valor' => $cat_valor,
                        'cat_nombre' => $cat_nombre,
                        'cat_nombre_corto' => $cat_nombre_corto,
                        'cat_padre' => $cat_padre,
                        'cat_nivel' => $cat_nivel,
                        'cat_arbol' => $cat_arbol,
                        'cat_estado' => $cat_estado,
                        'cat_usuarioi' => $id_usuario,
                        'cat_ambiente' => $amb_codigo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Catalogo registrado exitosamente', 'status'=>200,'token'=>$token,'key'=>$cat_correl);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Catalogo no pudo ser registrado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_catalogo', 'modificar');
                if($userFuncionality == 'OK'){
                    $cat_correl= $parameter['cat_correl'] ?? '0';
                    $cat_tipo= $parameter['cat_tipo'] ?? 'null';
                    $cat_codigo_ext= $parameter['cat_codigo_ext'] ?? 'null';
                    $cat_nombre= $parameter['cat_nombre'] ?? 'null';
                    $cat_nombre_corto= $parameter['cat_nombre_corto'] ?? 'null';
                    $cat_padre= $parameter['cat_padre'] ?? 'null';
                    $cat_nivel= $parameter['cat_nivel'] ?? 'null';
                    $cat_arbol= $parameter['cat_arbol'] ?? 'null';
                    $cat_estado= $parameter['cat_estado'] ?? 'A';
                    $sql = " update cfg_catalogo set
                        cat_tipo=:cat_tipo,
                        cat_codigo_ext=:cat_codigo_ext,
                        cat_nombre=:cat_nombre,
                        cat_nombre_corto=:cat_nombre_corto,
                        cat_padre=:cat_padre,
                        cat_nivel=:cat_nivel,
                        cat_arbol=:cat_arbol,
                        cat_estado=:cat_estado,
                        cat_usuariom=:cat_usuariom,
                        cat_fecham=now()
                        where
                        cat_correl=:cat_correl
                    ";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'cat_correl' => $cat_correl,
                        'cat_tipo' => $cat_tipo,
                        'cat_codigo_ext' => $cat_codigo_ext,
                        'cat_nombre' => $cat_nombre,
                        'cat_nombre_corto' => $cat_nombre_corto,
                        'cat_padre' => $cat_padre,
                        'cat_nivel' => $cat_nivel,
                        'cat_arbol' => $cat_arbol,
                        'cat_estado' => $cat_estado,
                        'cat_usuariom' => $id_usuario
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Catalogo actualizado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Catalogo no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_catalogo', 'eliminar');
                if($userFuncionality == 'OK'){
                    $cat_correl= $parameter['cat_correl'] ?? '0';
                    
                    
                    $sql = " update cfg_catalogo set
                        cat_estado = 'E',
                        cat_usuariom = :cat_usuariom,
                        cat_fecham = now()
                        where cat_correl=:cat_correl
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'cat_correl' => $cat_correl,
                        'cat_usuariom' => $id_usuario,
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Catalogo eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Catalogo no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
}