<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;


class CfgClienteController {
	
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";

                    $filter1 = $parameter['filter1'] ?? "undefined";
                    if(empty($filter1)) $filter1 = "undefined";

                    $filter2 = $parameter['filter2'] ?? "undefined";
                    if(empty($filter2)) $filter2 = "undefined";


                    $cli_estado = $parameter['cli_estado'] ?? 'A';

					
                    $sql = " 
                  
                    select 
                    a.cli_correlativo, 
                    a.cli_nombre,  
                    a.cli_email,  
                    a.cli_facturar,  
                    a.cli_nit,  
                    a.cli_telefono1,  
                    a.cli_telefono2,  
                    a.cli_direccion,  
                    d.cat_nombre cat_estado_nombre,  
                    a.cli_estado,  
                    concat(b.usr_nombres,' ',b.usr_apellidos) as cli_usuarioi,  
                    concat(c.usr_nombres,' ',c.usr_apellidos) as cli_usuariom,  
                    a.cli_fechai,  
                    a.cli_fecham  

                    from cfg_cliente a
                    left outer join cfg_catalogo d on(a.cli_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.cli_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.cli_usuariom)

					
                    where 
                    1=1
                    and a.cli_estado =:cli_estado
                    and ((a.cli_nombre like concat('%',:filter,'%') or a.cli_email like concat('%',:filter,'%') or a.cli_nit like concat('%',:filter,'%')) or (:filter = 'undefined'))

                     and (a.cli_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                     and (a.cli_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 

                     limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'cli_estado' => $cli_estado,
                    'emp_codigo' => $emp_codigo,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'cli_estado' => $cli_estado,
                    'filter' => $filter,
                    'filter1' => $filter1,
                    'filter2' => $filter2
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_cliente a
                        left outer join cfg_catalogo d on(a.cli_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.cli_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.cli_usuariom)
                        ", "   and a.cli_estado =:cli_estado 
                         and ((a.cli_nombre like concat('%',:filter,'%') or a.cli_email like concat('%',:filter,'%') or a.cli_nit like concat('%',:filter,'%')) or (:filter = 'undefined'))
                         and (a.cli_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                         and (a.cli_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                        ", 
                        [
                        'cli_estado' => $cli_estado,
                        'emp_codigo' => $emp_codigo,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'cli_estado' => $cli_estado,
                        'filter' => $filter
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'nuevo');
                if($userFuncionality == 'OK'){
                    $cli_nombre=$parameter['cli_nombre'] ?? 'null';
                    $cli_email=$parameter['cli_email'] ?? 'null';
                    $cli_facturar=$parameter['cli_facturar'] ?? 'NA';
                    $cli_nit=$parameter['cli_nit'] ?? 'cf';
                    $cli_telefono1=$parameter['cli_telefono1'] ?? 'null';
                    $cli_telefono2=$parameter['cli_telefono2'] ?? 'null';
                    $cli_direccion=$parameter['cli_direccion'] ?? 'null';
                    $cli_estado=$parameter['cli_estado'] ?? 'A';

                    $cli_correlativo = $utility->CorrelAutomatico($PDO, "cfg_cliente", "cli_correlativo", "");
                    
                    $existeCorreo = 0;$existeNit = 0;
					$existeCorreo = $utility->buscarRegistro($PDO, "cfg_cliente", "cli_correlativo dato,cli_email", " and UPPER(cli_email)=UPPER(:valorCampo1) and cli_estado = 'A'",$cli_email);
                    
                    
                    if($cli_nit == "CF" || $cli_nit == "cf"){
                        $existeNit = 0;
                    }else{
                        $existeNit = $utility->buscarRegistro($PDO, "cfg_cliente", "cli_correlativo dato,cli_nit", " and UPPER(cli_nit)=UPPER(:valorCampo1) and cli_estado = 'A'",$cli_nit);
                    }
                    
                    
                    $sql = " insert into cfg_cliente (
                        					cli_correlativo, 
											cli_nombre, 
											cli_email, 
											cli_facturar, 
											cli_nit, 
											cli_telefono1, 
											cli_telefono2, 
											cli_direccion, 
											cli_estado, 
											cli_usuarioi, 
											cli_usuariom, 
											cli_fechai, 
											cli_fecham 

                                ) values(
                            				:cli_correlativo, 
											:cli_nombre, 
											:cli_email, 
											:cli_facturar, 
											:cli_nit, 
											:cli_telefono1, 
											:cli_telefono2, 
											:cli_direccion, 
											:cli_estado, 
											:id_usuario, 
											:id_usuario, 
											now(), 
											now() 

                        )
                    ";
                    $datosRegistrado = "";
                    if($existeCorreo > 0){
                        $datosRegistrado .= "Corre: ".$cli_email." ";
                    }
                    if($existeNit > 0){
                        $datosRegistrado .= "Nit: ".$cli_nit;
                    }

                    if($existeCorreo > 0 || $existeNit > 0){
                        $data = array('estado'=>'ERROR', 'mensaje'=>$datosRegistrado, 'status'=>400,'token'=>$token);//'Registro duplicado'
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(400);
                    }else{
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre' => $cli_nombre,
                        'cli_email' => $cli_email,
                        'cli_facturar' => $cli_facturar,
                        'cli_nit' => $cli_nit,
                        'cli_telefono1' => $cli_telefono1,
                        'cli_telefono2' => $cli_telefono2,
                        'cli_direccion' => $cli_direccion,
                        'cli_estado' => $cli_estado,
                        'id_usuario' => $id_usuario
                        ]);
                        
                        
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro registrado exitosamente', 'status'=>200,'token'=>$token,'key'=>$cli_correlativo);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser registrado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'modificar');
                if($userFuncionality == 'OK'){
                    $cli_correlativo=(int)$parameter['cli_correlativo'] ?? 0;
                    $cli_nombre=$parameter['cli_nombre'] ?? 'null';
                    $cli_email=$parameter['cli_email'] ?? 'null';
                    $cli_facturar=$parameter['cli_facturar'] ?? 'null';
                    $cli_nit=$parameter['cli_nit'] ?? 'null';
                    $cli_telefono1=$parameter['cli_telefono1'] ?? 'null';
                    $cli_telefono2=$parameter['cli_telefono2'] ?? 'null';
                    $cli_direccion=$parameter['cli_direccion'] ?? 'null';
                    $cli_estado=$parameter['cli_estado'] ?? 'A';


                    $existeCorreo = $utility->buscarRegistro($PDO, "cfg_cliente", "cli_correlativo dato,cli_email", " and UPPER(cli_email)=UPPER(:valorCampo1) and cli_estado = 'A'",$cli_email);

                    if($cli_nit == "CF" || $cli_nit == "cf"){
                        $existeNit = 0;
                    }else{
                        $existeNit = $utility->buscarRegistro($PDO, "cfg_cliente", "cli_correlativo dato,cli_nit", " and UPPER(cli_nit)=UPPER(:valorCampo1) and cli_estado = 'A'",$cli_nit);
                    }
                    

                    $sql = " update cfg_cliente set
                        					cli_nombre = :cli_nombre,  
											cli_email = :cli_email,  
											cli_facturar = :cli_facturar,  
											cli_nit = :cli_nit,  
											cli_telefono1 = :cli_telefono1,  
											cli_telefono2 = :cli_telefono2,  
											cli_direccion = :cli_direccion,  
											cli_estado = :cli_estado,  
											cli_usuariom = :id_usuario,
											cli_fecham=now()  

                        where cli_correlativo=:cli_correlativo";
                    $datosRegistrado = "";
                    if($existeCorreo > 0){//&& $cli_correlativo <> $existeCorreo
                        $datosRegistrado .= "Corre: ".$cli_email." ";
                    }
                    if($existeNit > 0){//&& $cli_correlativo <> $existeNit
                        $datosRegistrado .= "Nit: ".$cli_nit;
                    }
                    if($cli_correlativo == $existeCorreo && $cli_correlativo == $existeNit){//
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre' => $cli_nombre,
                        'cli_email' => $cli_email,
                        'cli_facturar' => $cli_facturar,
                        'cli_nit' => $cli_nit,
                        'cli_telefono1' => $cli_telefono1,
                        'cli_telefono2' => $cli_telefono2,
                        'cli_direccion' => $cli_direccion,
                        'cli_estado' => $cli_estado,
                        'id_usuario' => $id_usuario
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente'.$cli_correlativo.' '.$existeNit, 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        if(($existeCorreo > 0 && $cli_correlativo <> $existeCorreo) && ($existeNit > 0 && $cli_correlativo == $existeNit)){//|| $existeNit > 0
                            $data = array('estado'=>'ERROR', 'mensaje'=>$datosRegistrado, 'status'=>400,'token'=>$token);//'Registro duplicado'
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(400);
                        }else{//Registro no existe
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'cli_correlativo' => $cli_correlativo,
                                'cli_nombre' => $cli_nombre,
                                'cli_email' => $cli_email,
                                'cli_facturar' => $cli_facturar,
                                'cli_nit' => $cli_nit,
                                'cli_telefono1' => $cli_telefono1,
                                'cli_telefono2' => $cli_telefono2,
                                'cli_direccion' => $cli_direccion,
                                'cli_estado' => $cli_estado,
                                'id_usuario' => $id_usuario
                            ]);
                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente'.$cli_correlativo.' '.$existeNit, 'status'=>200,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }
                        /*$data = array('estado'=>'ERROR', 'mensaje'=>'Registro duplicado', 'status'=>400,'token'=>$token);//'Registro duplicado'
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(400);*/
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'eliminar');
                if($userFuncionality == 'OK'){
                    $cli_correlativo= (int)$parameter['cli_correlativo'] ?? 0;
                    
                    
                    $sql = " delete from cfg_cliente where cli_correlativo = :cli_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'cli_correlativo' => $cli_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Catalogo no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function getSign($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_recepcion', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $att_objeto_codigo = $parameter['att_objeto_codigo'] ?? 0;
                    $att_objeto = $parameter['att_objeto'] ?? 'no_object';
                    
                    $download_dir = DOWNLOAD_DIR_FIRMA;                    

					
                    $sql = "select concat('$download_dir', to_char(att_fechai,'YYYY'),'/',to_char(att_fechai,'MM'),att_archivo) as firma from tra_attachment
                    where 
                    att_objeto_codigo = :att_objeto_codigo and att_objeto = :att_objeto and att_estado = 'A'
                    ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['att_objeto' => $att_objeto,
                    'att_objeto_codigo' => $att_objeto_codigo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($result)) {
                        
                        $path = $result[0]->firma;
                        $type = pathinfo($path, PATHINFO_EXTENSION);
                        $data = file_get_contents($path);
                        $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
                        
                        
                        $data = array('estado'=>'OK', 'data'=>$base64, 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
   
    
}
