<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgCuponController {
	
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cupon', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $cup_estado = $parameter['cup_estado'] ?? 'A';

					
                    $sql = " 
                    select 
                    a.cup_correlativo, 
                    a.cup_empresa,  
                    a.cup_ambiente,  
                    a.cup_serie,  
                    a.cup_numero_inicio,  
                    a.cup_numero_fin,
                    a.cup_monto, 
                    a.cup_tipo, 
                    IF(a.cup_tipo = 1,'Therapycash','Cortesía') as tipo,
                    a.cup_estado,  
                    a.cup_fechai,  
                    a.cup_fecham,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as ase_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as ase_usuariom  
                    from cfg_cupon a
                    left outer join cfg_usuario b on (b.usr_correl = a.cup_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.cup_usuariom)
                    where 
                    1=1
					and a.cup_estado =:cup_estado
                    and a.cup_empresa =:emp_codigo
                    and a.cup_ambiente =:amb_codigo
                    and (a.cup_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.cup_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                    and ((a.cup_serie like concat('%',:filter,'%') or a.cup_numero_inicio like concat('%',:filter,'%') or a.cup_numero_fin like concat('%',:filter,'%') or a.cup_monto like concat('%',:filter,'%')) or (:filter = 'undefined'))
					limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'cup_estado' => $cup_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'filter' => $filter,
                    'emp_codigo' => $emp_codigo,
                    'amb_codigo' => $amb_codigo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_cupon a
                        left outer join cfg_usuario b on (b.usr_correl = a.cup_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.cup_usuariom)
                        ", "  
                            and a.cup_estado =:cup_estado
                            and a.cup_empresa =:emp_codigo
                            and a.cup_ambiente =:amb_codigo
                            and (a.cup_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                            and (a.cup_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                            and ((a.cup_serie like concat('%',:filter,'%') or a.cup_numero_inicio like concat('%',:filter,'%') or a.cup_monto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                        ", 
                        [
                            'cup_estado' => $cup_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter' => $filter,
                            'emp_codigo' => $emp_codigo,
                            'amb_codigo' => $amb_codigo
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cupon', 'nuevo');
                if($userFuncionality == 'OK'){
                    $cup_serie=$parameter['cup_serie'] ?? '';
                    $cup_numero_inicio=$parameter['cup_numero_inicio'] ?? 0;
                    $cup_numero_fin=$parameter['cup_numero_fin'] ?? 0;
                    $cup_monto=$parameter['cup_monto'] ?? 0.00;
                    $cup_tipo=$parameter['cup_tipo'] ?? 0;
                    $cup_estado=$parameter['cup_estado'] ?? 'A';

                    $cup_serie = $utility->validarLongitudString($cup_serie, 0, 5);
                    $cup_numero_inicio = $utility->validarLongitudString($cup_numero_inicio, 0, 18);
                    $cup_numero_fin = $utility->validarLongitudString($cup_numero_fin, 0, 18);
                    $cup_monto = $utility->validarLongitudString($cup_monto, 0, 18);
                    $cup_tipo = $utility->validarLongitudString($cup_tipo, 0, 1);

                    $cup_correlativo = $utility->CorrelAutomatico($PDO, "cfg_cupon", "cup_correlativo", "");
                    
                    $sql = " insert into cfg_cupon (
                            cup_correlativo, 
                            cup_empresa,
                            cup_ambiente,
                            cup_serie, 
                            cup_numero_inicio, 
                            cup_numero_fin, 
                            cup_monto, 
                            cup_tipo,
                            cup_estado, 
                            cup_fechai, 
                            cup_fecham, 
                            cup_usuarioi, 
                            cup_usuariom 
                            ) values(
                            :cup_correlativo, 
                            :cup_empresa,
                            :cup_ambiente,
                            UPPER(:cup_serie), 
                            :cup_numero_inicio, 
                            :cup_numero_fin, 
                            :cup_monto, 
                            :cup_tipo,
                            :cup_estado, 
                            now(), 
                            now(), 
                            :id_usuario, 
                            :id_usuario 
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['cup_correlativo' => $cup_correlativo,
                    'cup_serie' => $cup_serie,
                    'cup_numero_inicio' => $cup_numero_inicio,
                    'cup_numero_fin' => $cup_numero_fin,
                    'cup_monto' => $cup_monto,
                    'cup_tipo' => $cup_tipo,
                    'cup_estado' => $cup_estado,
                    'id_usuario' => $id_usuario,
                    'cup_empresa' => $emp_codigo,
                    'cup_ambiente' => $amb_codigo,
                    ]);
                    
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$cup_correlativo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cupon', 'modificar');
                if($userFuncionality == 'OK'){
                    $cup_correlativo=(int)$parameter['cup_correlativo'] ?? 0;
                    $cup_serie=$parameter['cup_serie'] ?? '';
                    $cup_numero_inicio=$parameter['cup_numero_inicio'] ?? 0;
                    $cup_numero_fin=$parameter['cup_numero_fin'] ?? 0;
                    $cup_monto=$parameter['cup_monto'] ?? 0.00;
                    $cup_tipo=$parameter['cup_tipo'] ?? 0;
                    $cup_estado=$parameter['cup_estado'] ?? 'A';

                    $cup_serie = $utility->validarLongitudString($cup_serie, 0, 5);
                    $cup_numero_inicio = $utility->validarLongitudString($cup_numero_inicio, 0, 18);
                    $cup_numero_fin = $utility->validarLongitudString($cup_numero_fin, 0, 18);
                    $cup_monto = $utility->validarLongitudString($cup_monto, 0, 18);
                    $cup_tipo = $utility->validarLongitudString($cup_tipo, 0, 1);

                    $sql = " update cfg_cupon set
                            cup_serie = :cup_serie,  
                            cup_numero_inicio = :cup_numero_inicio,  
                            cup_numero_fin = :cup_numero_fin,  
                            cup_monto = :cup_monto,  
                            cup_tipo = :cup_tipo,
                            cup_estado = :cup_estado,  
                            cup_fecham=now(),  
                            cup_usuariom = :id_usuario
                            where
                            cup_correlativo=:cup_correlativo
                    ";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['cup_correlativo' => $cup_correlativo,
                    'cup_serie' => $cup_serie,
                    'cup_numero_inicio' => $cup_numero_inicio,
                    'cup_numero_fin' => $cup_numero_fin,
                    'cup_monto' => $cup_monto,
                    'cup_tipo' => $cup_tipo,
                    'cup_estado' => $cup_estado,
                    'id_usuario' => $id_usuario,
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cupon', 'eliminar');
                if($userFuncionality == 'OK'){
                    $cup_correlativo= (int)$parameter['cup_correlativo'] ?? 0;
                    
                    
                    $sql = "update cfg_cupon set cup_estado = 'E ' where cup_correlativo = :cup_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'cup_correlativo' => $cup_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Catalogo no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
}
