<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgFuncionalidadController{
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fun_nombre = $parameter['fun_nombre'] ?? "null";
                    $fun_estado = $parameter['fun_estado'] ?? "A";
                    $fun_tipo = $parameter['fun_tipo'] ?? "null";
                    $fun_fechai_ini = $parameter['fun_fechai_ini'] ?? "null";
                    $fun_fechai_fin = $parameter['fun_fechai_fin'] ?? "null";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $sql = " select 
                    fun_codigo, 
                    fun_empresa,  
                    fun_tipo,  
                    fun_codigo_ext,  
                    fun_nombre,  
                    fun_nombre_corto,  
                    fun_objeto, 
                    tip.cat_nombre fun_objeto_nombre, 
                    fun_url,  
                    fun_icono,  
                    fun_padre,  
                    fun_nivel,  
                    fun_arbol,  
                    fun_estado, 
                    est.cat_nombre fun_estado_nombre, 
                    concat(u1.usr_nombres,' ',u1.usr_apellidos)as rol_usuarioi,
                    date_format(fun_fechai, '%d/%m/%y %T') as fun_fechai,			
                    concat(u2.usr_nombres,' ',u2.usr_apellidos)as rol_usuariom,
                    date_format(fun_fecham, '%d/%m/%y %T') as fun_fecham, 			 
                    fun_correlativo 
                    from cfg_funcionalidad 
                    left outer join cfg_catalogo tip on(fun_tipo = tip.cat_valor and tip.cat_tipo = 'TIPO_OBJ' and tip.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario u1 on (u1.usr_codigo = fun_usuarioi) 
                    left outer join cfg_usuario u2 on (u2.usr_codigo = fun_usuariom) 
                    left outer join cfg_catalogo est on(fun_estado = est.cat_valor and est.cat_tipo = 'FUN_ESTADO' and est.cat_empresa = :emp_codigo)
                    where 1=1 
                    and fun_estado = :fun_estado
                    and ((fun_nombre like concat('%',:filter,'%') or fun_url like concat('%',:filter,'%') or fun_objeto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and fun_empresa = :emp_codigo
                    
                    
                    limit $pag_inicio, $tamanio 
                    ";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['fun_nombre' => $fun_nombre,'fun_fecha_ini'=>$fun_fechai_ini,'fun_fecha_fin'=>$fun_fechai_fin,
                    'emp_codigo'=>$emp_codigo,"filter"=>$filter,"fun_estado"=>$fun_estado]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if ($stmt->rowCount() > 0) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_funcionalidad", " and fun_empresa = :emp_codigo
                        and fun_estado = :fun_estado
                        and ((fun_nombre like concat('%',:filter,'%') or fun_url like concat('%',:filter,'%') or fun_objeto like concat('%',:filter,'%')) or (:filter = 'undefined'))", ['emp_codigo'=>$emp_codigo,'filter'=>$filter,"fun_estado"=>$fun_estado]);
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'OK', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'nuevo');
                if($userFuncionality == 'OK'){
                    $fun_correlativo = $utility->CorrelAutomatico($PDO, "cfg_funcionalidad", "fun_correlativo", "");
                    $fun_nombre = $parameter['fun_nombre'] ?? "";
                    $fun_objeto = $parameter['fun_objeto'] ?? "";
                    $fun_tipo = $parameter['fun_tipo'] ?? "";
                    $fun_url = $parameter['fun_url'] ?? "";
                    $fun_icono = $parameter['fun_icono'] ?? "";
                    $fun_padre = $parameter['fun_padre'] ?? "";
                    $fun_nivel = $parameter['fun_nivel'] ?? "";
                    $fun_arbol = $parameter['fun_arbol'] ?? "";
                    $fun_estado = $parameter['fun_estado'] ?? "A";
                    $fun_codigo_ext = $parameter['fun_codigo_ext'] ?? "";
                    $fun_nombre_corto = $parameter['fun_nombre_corto'] ?? "";
                    
                    $sql = " insert into cfg_funcionalidad (
                        fun_correlativo,
                        fun_codigo,
                        fun_empresa,
                        fun_tipo,
                        fun_codigo_ext,
                        fun_nombre,
                        fun_nombre_corto,
                        fun_objeto,
                        fun_url,
                        fun_icono,
                        fun_padre,
                        fun_nivel,
                        fun_arbol,
                        fun_estado,
                        fun_usuarioi,
                        fun_usuariom,
                        fun_fechai,
                        fun_fecham
                        ) values(
                            :fun_correlativo,
                            :fun_correlativo,
                            :fun_empresa,
                            :fun_tipo,
                            :fun_codigo_ext,
                            :fun_nombre,
                            :fun_nombre_corto,
                            :fun_objeto,
                            :fun_url,
                            :fun_icono,
                            :fun_padre,
                            :fun_nivel,
                            :fun_arbol,
                            :fun_estado,
                            :fun_usuarioi,
                            :fun_usuarioi,
                            now(),
                            now()
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'fun_correlativo'=>$fun_correlativo,
                        'fun_empresa'=>$emp_codigo,
                        'fun_tipo'=>$fun_tipo,
                        'fun_codigo_ext'=>$fun_codigo_ext,
                        'fun_nombre'=>$fun_nombre,
                        'fun_nombre_corto'=>$fun_nombre_corto,
                        'fun_objeto'=>$fun_objeto,
                        'fun_url'=>$fun_url,
                        'fun_icono'=>$fun_icono,
                        'fun_padre'=>$fun_padre,
                        'fun_nivel'=>$fun_nivel,
                        'fun_arbol'=>$fun_arbol,
                        'fun_estado'=>$fun_estado,
                        'fun_usuarioi'=>$id_usuario,
                    ]);
                    if ($result == true) {
                        //insertamos funcionalidad para el ambiente
                        $utility->insertFuncionalidadAmbiente($PDO,$fun_correlativo,$amb_codigo, $fun_nombre, $id_usuario);
                        $data = array('estado'=>'OK', 'mensaje'=>'Funcionalidad registrada exitosamente', 'status'=>200,'token'=>$token,'key'=>$fun_correlativo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Funcionalidad no pudo ser registrada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'modificar');
                if($userFuncionality == 'OK'){
                    $fun_correlativo = $parameter['fun_correlativo'] ?? "0";
                    $fun_nombre = $parameter['fun_nombre'] ?? "NULL";
                    $fun_objeto = $parameter['fun_objeto'] ?? "NULL";
                    $fun_tipo = $parameter['fun_tipo'] ?? "NULL";
                    $fun_url = $parameter['fun_url'] ?? "NULL";
                    $fun_icono = $parameter['fun_icono'] ?? "NULL";
                    $fun_padre = $parameter['fun_padre'] ?? "0";
                    $fun_nivel = $parameter['fun_nivel'] ?? "0";
                    $fun_arbol = $parameter['fun_arbol'] ?? "";
                    $fun_estado = $parameter['fun_estado'] ?? "";
                    $fun_codigo_ext = $parameter['fun_codigo_ext'] ?? "";
                    $fun_nombre_corto = $parameter['fun_nombre_corto'] ?? "";
                    
                    $sql = " update cfg_funcionalidad set
                        fun_codigo_ext = :fun_codigo_ext,
                        fun_nombre_corto = :fun_nombre_corto,
                        fun_nombre = :fun_nombre,
                        fun_objeto = :fun_objeto,
                        fun_tipo = :fun_tipo,
                        fun_url = :fun_url,
                        fun_icono = :fun_icono,
                        fun_padre = :fun_padre,
                        fun_nivel = :fun_nivel,
                        fun_arbol = :fun_arbol,
                        fun_estado = :fun_estado,
                        fun_usuariom = :fun_usuariom,
                        fun_fecham = now()
                        where
                        fun_correlativo = :fun_correlativo
                        
                    ";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['fun_correlativo' => $fun_correlativo,'fun_nombre'=>$fun_nombre,'fun_objeto'=>$fun_objeto,
                    'fun_tipo'=>$fun_tipo,'fun_url'=>$fun_url,'fun_icono'=>$fun_icono,'fun_padre'=>$fun_padre,'fun_nivel'=>$fun_nivel,
                    'fun_arbol'=>$fun_arbol,'fun_estado'=>$fun_estado,'fun_usuariom'=>$id_usuario,
                    'fun_codigo_ext'=>$fun_codigo_ext,'fun_nombre_corto'=>$fun_nombre_corto]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Funcionalidad actualizada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Funcionalidad no pudo ser actualizada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'eliminar');
                if($userFuncionality == 'OK'){
                    $fun_correlativo = $parameter['fun_correlativo'] ?? "0";
                    
                    
                    $sql = " update cfg_funcionalidad set
                        fun_estado = 'A',
                        fun_usuariom = :fun_usuariom,
                        fun_fecham = now()
                        where fun_correlativo = :fun_correlativo
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['fun_correlativo' => $fun_correlativo,'fun_usuariom'=>$id_usuario]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Funcionalidad eliminada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Funcionalidad no pudo ser eliminada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function cmbFuncionalidadDispRol($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $rof_rol = $parameter['rof_rol'] ?? "0";
                    $cmb_tipo = $parameter['cmb_tipo'] ?? "options";
                        
                    $sql = " select   
                    fun_correlativo,   
                    concat(c1.cat_nombre , ' - ' , fun_nombre ) as fun_nombre   
                    from cfg_funcionalidad   
                    left outer join cfg_catalogo c1 on (c1.cat_valor = fun_tipo and cat_tipo = 'TIPO_OBJ' and cat_empresa = :emp_codigo)   
                    where 1 = 1   
                    and fun_empresa =   :emp_codigo     
                    and fun_estado = 'A'   
                    and fun_correlativo not in (   
                    select   
                    rof_funcionalidad   
                    from cfg_rol_funcionalidad   
                    where 1 = 1   
                    and rof_empresa = :emp_codigo
                    and rof_estado = 'A'   
                    and rof_rol =   :rol
                    )   
                    order by fun_nombre asc 
                    ";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'rol'=>$rof_rol,
                        'emp_codigo'=>$emp_codigo    
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if ($stmt->rowCount() > 0) {
                        if($cmb_tipo == 'options'){
                            array_unshift($result,array("fun_correlativo"=>'','fun_nombre'=>'Seleccione una opción'));
                        };
                        $totalRegistros =$stmt->rowCount();
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
}