<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgObjetoConfigController {
	
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $ocf_objeto_permiso = $parameter['ocf_objeto_permiso'] ?? 'no_object';
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, $ocf_objeto_permiso, 'lectura');
                if($userFuncionality == 'OK'){
                    $ocf_objeto = $parameter['ocf_objeto'] ?? 'no_object';
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $ocf_estado = $parameter['ocf_estado'] ?? 'A';
                    $ocf_objeto_codigo = $parameter['ocf_objeto_codigo'] ?? 0;
					$type = $parameter['type'] ?? 'qry';

                    $sql = " 
                    select 
                    a.ocf_correlativo, 
                    a.ocf_codigo,  
                    a.ocf_cod_cat,  
                    a.ocf_empresa,  
                    a.ocf_objeto,  
                    a.ocf_objeto_codigo,  
                    a.ocf_orden,  
                    a.ocf_param_nombre,  
                    a.ocf_param_tipo,  
                    a.ocf_param_catalogo,  
                    a.ocf_param_valor, 
                    a.ocf_porcentaje_uno,
                    a.ocf_porcentaje_dos, 
                    d.cat_nombre cat_estado_nombre, 
                    pro.pro_nombre nombre_especialidad,  
                    a.ocf_estado,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as ocf_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as ocf_usuariom,  
                    a.ocf_fechai,  
                    a.ocf_fecham  
                    from cfg_objeto_config a
                    left outer join cfg_catalogo d on(a.ocf_estado= d.cat_valor and d.cat_tipo = 'COLOCA_CATALOGO_AQUI' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.ocf_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.ocf_usuariom)
                    left outer join cfg_producto pro on (pro.pro_correl = a.ocf_param_tipo and pro.pro_clasificacion=2 and pro.pro_estado='A')
                    where 
                    1=1
					and a.ocf_empresa = :emp_codigo 
                    and a.ocf_estado =:ocf_estado
                    and a.ocf_objeto = :ocf_objeto
                    and a.ocf_objeto_codigo = :ocf_objeto_codigo
                    and (a.ocf_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.ocf_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                    order by ocf_correlativo desc 
					limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                    'ocf_estado' => $ocf_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'ocf_objeto'=>$ocf_objeto,
                    'ocf_objeto_codigo'=>$ocf_objeto_codigo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($result)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_objeto_config a
                        left outer join cfg_catalogo d on(a.ocf_estado= d.cat_valor and d.cat_tipo = 'COLOCA_CATALOGO_AQUI' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.ocf_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.ocf_usuariom)
                        ", "   and a.ocf_empresa = :emp_codigo 
                        and a.ocf_estado =:ocf_estado
                        and a.ocf_objeto = :ocf_objeto
                        and a.ocf_objeto_codigo = :ocf_objeto_codigo
                        and (a.ocf_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                        and (a.ocf_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                        ", 
                        ['emp_codigo' => $emp_codigo,
                        'ocf_estado' => $ocf_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'ocf_objeto'=>$ocf_objeto,
                        'ocf_objeto_codigo'=>$ocf_objeto_codigo
                        ]);
                        
                        if($type == 'cmb'){
                            array_unshift($result,array("ocf_correlativo"=>'','ocf_param_valor'=>'Seleccione una opción'));
                        }

                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{

                        if($type == 'cmb'){
                            array_unshift($result,array("ocf_correlativo"=>'','ocf_param_valor'=>'No Existen Planes Definidos...'));
                        }
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }

    public function selectServicioRegistrados($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $ocf_objeto_permiso = $parameter['ocf_objeto_permiso'] ?? 'no_object';
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, $ocf_objeto_permiso, 'lectura');
                if($userFuncionality == 'OK'){
                    $ocf_objeto = $parameter['ocf_objeto'] ?? 'no_object';
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $ocf_estado = $parameter['ocf_estado'] ?? 'A';
                    $ocf_objeto_codigo = $parameter['ocf_objeto_codigo'] ?? 0;
                    $type = $parameter['type'] ?? 'qry';

                    $sql = " 
                    select 
                    a.ocf_correlativo, 
                    a.ocf_codigo,  
                    a.ocf_cod_cat,  
                    a.ocf_empresa,  
                    a.ocf_objeto,  
                    a.ocf_objeto_codigo,  
                    a.ocf_orden,  
                    a.ocf_param_nombre,  
                    a.ocf_param_tipo,  
                    a.ocf_param_catalogo,  
                    a.ocf_param_valor,  
                    d.cat_nombre cat_estado_nombre, 
                    pro.pro_nombre nombre_especialidad,  
                    a.ocf_estado,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as ocf_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as ocf_usuariom,  
                    a.ocf_fechai,  
                    a.ocf_fecham,
                    CONCAT(suc.suc_horario_lunes_a_viernes_inicio,' a ',suc.suc_horario_lunes_a_viernes_fin) as horario_lav,
                    CONCAT(suc.suc_horario_sabado_inicio,' a ',suc.suc_horario_sabado_fin) as horario_sabado,
                    CONCAT(suc.suc_horario_domingo_inicio,' a ',suc.suc_horario_domingo_fin) as horario_domingo 
                    from cfg_objeto_config a
                    left outer join cfg_catalogo d on(a.ocf_estado= d.cat_valor and d.cat_tipo = 'COLOCA_CATALOGO_AQUI' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.ocf_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.ocf_usuariom)
                    left outer join cfg_producto pro on (pro.pro_correl = a.ocf_param_tipo and pro.pro_clasificacion=2 and pro.pro_estado='A')
                    left outer join cfg_sucursal suc on (suc.suc_correlativo = :ocf_objeto_codigo and suc.suc_estado = 'A' and suc.suc_empresa = :emp_codigo and suc.suc_ambiente = :amb_codigo)  
                    where 
                    1=1
                    and a.ocf_empresa = :emp_codigo 
                    and a.ocf_estado =:ocf_estado
                    and a.ocf_objeto = :ocf_objeto
                    and a.ocf_objeto_codigo = :ocf_objeto_codigo
                    and (a.ocf_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.ocf_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                    order by ocf_correlativo desc 
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                    'amb_codigo' => $amb_codigo,
                    'ocf_estado' => $ocf_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'ocf_objeto'=>$ocf_objeto,
                    'ocf_objeto_codigo'=>$ocf_objeto_codigo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($result)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_objeto_config a
                        left outer join cfg_catalogo d on(a.ocf_estado= d.cat_valor and d.cat_tipo = 'COLOCA_CATALOGO_AQUI' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.ocf_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.ocf_usuariom) 
                        left outer join cfg_sucursal suc on (suc.suc_correlativo = :ocf_objeto_codigo and suc.suc_estado = 'A' and suc.suc_empresa = :emp_codigo and suc.suc_ambiente = :amb_codigo)  
                        ", "   and a.ocf_empresa = :emp_codigo 
                        and a.ocf_estado =:ocf_estado
                        and a.ocf_objeto = :ocf_objeto
                        and a.ocf_objeto_codigo = :ocf_objeto_codigo
                        and (a.ocf_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                        and (a.ocf_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                        ", 
                        ['emp_codigo' => $emp_codigo,
                        'amb_codigo' => $amb_codigo,
                        'ocf_estado' => $ocf_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'ocf_objeto'=>$ocf_objeto,
                        'ocf_objeto_codigo'=>$ocf_objeto_codigo
                        ]);
                        
                        if($type == 'cmb'){
                            array_unshift($result,array("ocf_correlativo"=>'','ocf_param_valor'=>'Seleccione una opción'));
                        }

                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{

                        if($type == 'cmb'){
                            array_unshift($result,array("ocf_correlativo"=>'','ocf_param_valor'=>'No Existen Planes Definidos...'));
                        }
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }

    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $ocf_objeto_permiso=$parameter['ocf_objeto_permiso'] ?? 'no_object';
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, $ocf_objeto_permiso, 'nuevo');
                if($userFuncionality == 'OK'){
                    $ocf_cod_cat=(int)$parameter['ocf_cod_cat'] ?? 0;
                    $ocf_objeto=$parameter['ocf_objeto'] ?? 'no_object';
                    $ocf_objeto_codigo=(int)$parameter['ocf_objeto_codigo'] ?? 0;
                    $ocf_porcentaje_uno=(double)$parameter['ocf_porcentaje_uno'] ?? 0;
                    $ocf_porcentaje_dos=(double)$parameter['ocf_porcentaje_dos'] ?? 0;
                    $ocf_orden=(int)$parameter['ocf_orden'] ?? 0;
                    $ocf_param_nombre=$parameter['ocf_param_nombre'] ?? 'null';
                    $ocf_param_tipo=(int)$parameter['ocf_param_tipo'] ?? 0;
                    $ocf_param_catalogo=$parameter['ocf_param_catalogo'] ?? 'null';
                    $ocf_param_valor=$parameter['ocf_param_valor'] ?? 'null';
                    $ocf_estado=$parameter['ocf_estado'] ?? 'A';
                    
                    
                    $ocf_porcentaje_uno = $utility->validarLongitudString($ocf_porcentaje_uno, 0, 6);
                    $ocf_porcentaje_dos = $utility->validarLongitudString($ocf_porcentaje_dos, 0, 6);
                    $ocf_param_valor = $utility->validarLongitudString($ocf_param_valor, 0, 2000);

                    $ocf_correlativo = $utility->CorrelAutomatico($PDO, "cfg_objeto_config", "ocf_correlativo", "");
					$ocf_codigo = $utility->CorrelAutomatico($PDO, "cfg_objeto_config", "ocf_codigo", " and ocf_empresa = $emp_codigo 
");
                    
                    $sql = " insert into cfg_objeto_config (
					
                            ocf_correlativo, 
                            ocf_codigo, 
                            ocf_cod_cat,
                            ocf_empresa, 
                            ocf_objeto, 
                            ocf_objeto_codigo,
                            ocf_orden,
                            ocf_param_nombre, 
                            ocf_param_tipo,
                            ocf_param_catalogo, 
                            ocf_param_valor, 
                            ocf_porcentaje_uno,
                            ocf_porcentaje_dos,
                            ocf_estado, 
                            ocf_usuarioi, 
                            ocf_usuariom, 
                            ocf_fechai, 
                            ocf_fecham 

                        ) values(
                            :ocf_correlativo, 
                            :ocf_codigo, 
                            :ocf_cod_cat,
                            :ocf_empresa, 
                            :ocf_objeto, 
                            :ocf_objeto_codigo,
                            :ocf_orden,
                            :ocf_param_nombre, 
                            :ocf_param_tipo,
                            :ocf_param_catalogo, 
                            :ocf_param_valor, 
                            :ocf_porcentaje_uno,
                            :ocf_porcentaje_dos,
                            :ocf_estado, 
                            :id_usuario, 
                            :id_usuario, 
                            now(), 
                            now() 

                        )";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['ocf_correlativo' => $ocf_correlativo,
                    'ocf_codigo'=>$ocf_codigo,
                    'ocf_cod_cat' => $ocf_cod_cat,
                    'ocf_empresa' => $emp_codigo,
                    'ocf_objeto' => $ocf_objeto,
                    'ocf_objeto_codigo' => $ocf_objeto_codigo,
                    'ocf_orden' => $ocf_orden,
                    'ocf_param_nombre' => $ocf_param_nombre,
                    'ocf_param_tipo' => $ocf_param_tipo,
                    'ocf_param_catalogo' => $ocf_param_catalogo,
                    'ocf_param_valor' => $ocf_param_valor,
                    'ocf_porcentaje_uno' => $ocf_porcentaje_uno,
                    'ocf_porcentaje_dos' => $ocf_porcentaje_dos,
                    'ocf_estado' => $ocf_estado,
                    'id_usuario' => $id_usuario,
                    ]);
                    
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$ocf_correlativo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertServicio($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $ocf_objeto_permiso=$parameter['ocf_objeto_permiso'] ?? 'no_object';
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, $ocf_objeto_permiso, 'nuevo');
                if($userFuncionality == 'OK'){
                    $registrarServicio = false;
                    $ocf_cod_cat=(int)$parameter['ocf_cod_cat'] ?? 0;
                    $ocf_objeto=$parameter['ocf_objeto'] ?? 'no_object';
                    $ocf_objeto_codigo=(int)$parameter['ocf_objeto_codigo'] ?? 0;
                    $ocf_orden=(int)$parameter['ocf_orden'] ?? 0;
                    $ocf_param_nombre=$parameter['ocf_param_nombre'] ?? 'null';
                    $ocf_param_tipo=(int)$parameter['ocf_param_tipo'] ?? 0;
                    $ocf_param_catalogo=$parameter['ocf_param_catalogo'] ?? 'null';
                    $ocf_param_valor=$parameter['ocf_param_valor'] ?? 'null';

                    $ocf_hora_inicio_lav=$parameter['ocf_hora_inicio_lav'] ?? 'null';
                    $ocf_hora_fin_lav=$parameter['ocf_hora_fin_lav'] ?? 'null';
                    $ocf_hora_inicio_sabado=$parameter['ocf_hora_inicio_sabado'] ?? 'null';
                    $ocf_hora_fin_sabado=$parameter['ocf_hora_fin_sabado'] ?? 'null';
                    $ocf_hora_inicio_domingo=$parameter['ocf_hora_inicio_domingo'] ?? 'null';
                    $ocf_hora_fin_domingo=$parameter['ocf_hora_fin_domingo'] ?? 'null';

                    $ocf_estado=$parameter['ocf_estado'] ?? 'A';
                    
                    $ocf_param_valor = $utility->validarLongitudString($ocf_param_valor, 0, 2000);

                    $ocf_correlativo = $utility->CorrelAutomatico($PDO, "cfg_objeto_config", "ocf_correlativo", "");
                    $ocf_codigo = $utility->CorrelAutomatico($PDO, "cfg_objeto_config", "ocf_codigo", " and ocf_empresa = $emp_codigo 
");
                    $validaHorarioLunesAViernes = $utility->validarHorariosServicio($PDO, "cfg_sucursal", "suc_correlativo",2,6,$ocf_hora_inicio_lav,$ocf_hora_fin_lav,"$ocf_objeto_codigo"," and suc_empresa = $emp_codigo and suc_ambiente = $amb_codigo");
                    $validaHorarioDomingo = $utility->validarHorariosServicio($PDO, "cfg_sucursal", "suc_correlativo",1,0,$ocf_hora_inicio_domingo,$ocf_hora_fin_domingo,"$ocf_objeto_codigo"," and suc_empresa = $emp_codigo and suc_ambiente = $amb_codigo");
                    $validaHorarioSabado = $utility->validarHorariosServicio($PDO, "cfg_sucursal", "suc_correlativo",7,0,$ocf_hora_inicio_sabado,$ocf_hora_fin_sabado,"$ocf_objeto_codigo"," and suc_empresa = $emp_codigo and suc_ambiente = $amb_codigo");
                    
                    $sql = " insert into cfg_objeto_config (
                    
                            ocf_correlativo, 
                            ocf_codigo, 
                            ocf_cod_cat,
                            ocf_empresa, 
                            ocf_objeto, 
                            ocf_objeto_codigo,
                            ocf_orden,
                            ocf_param_nombre, 
                            ocf_param_tipo,
                            ocf_param_catalogo, 
                            ocf_param_valor, 
                            ocf_hora_inicio_lav,
                            ocf_hora_fin_lav,
                            ocf_hora_inicio_sabado,
                            ocf_hora_fin_sabado,
                            ocf_hora_inicio_domingo,
                            ocf_hora_fin_domingo,
                            ocf_estado, 
                            ocf_usuarioi, 
                            ocf_usuariom, 
                            ocf_fechai, 
                            ocf_fecham 

                        ) values(
                            :ocf_correlativo, 
                            :ocf_codigo, 
                            :ocf_cod_cat,
                            :ocf_empresa, 
                            :ocf_objeto, 
                            :ocf_objeto_codigo,
                            :ocf_orden,
                            :ocf_param_nombre, 
                            :ocf_param_tipo,
                            :ocf_param_catalogo, 
                            :ocf_param_valor, 
                            :ocf_hora_inicio_lav,
                            :ocf_hora_fin_lav,
                            :ocf_hora_inicio_sabado,
                            :ocf_hora_fin_sabado,
                            :ocf_hora_inicio_domingo,
                            :ocf_hora_fin_domingo,
                            :ocf_estado, 
                            :id_usuario, 
                            :id_usuario, 
                            now(), 
                            now() 

                        )";
                    if($validaHorarioLunesAViernes > 0){//se valida el horario de lunes a viernes de la sucursal
                        if($validaHorarioDomingo > 0){//se valida el horario domingo de la sucursal
                            if($validaHorarioSabado > 0){//se valida el horario del día sábado de la sucursal
                                $registrarServicio = true;
                            }else{
                                $registrarServicio = false;
                                $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar este servicio, el horario seleccionado esta fuera del horario permitido por el centro, por favor revise el horario del día (sábado)', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                            
                        }else{
                            $registrarServicio = false;
                            $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar este servicio, el horario seleccionado esta fuera del horario permitido por el centro, por favor revise el horario del día (domingo)', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{//no se registra el servicio
                        $registrarServicio = false;
                        $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar este servicio, el horario seleccionado esta fuera del horario permitido por el centro, por favor revise el horario de (lunes a viernes)', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }

                    if($registrarServicio == true){
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute(['ocf_correlativo' => $ocf_correlativo,
                        'ocf_codigo'=>$ocf_codigo,
                        'ocf_cod_cat' => $ocf_cod_cat,
                        'ocf_empresa' => $emp_codigo,
                        'ocf_objeto' => $ocf_objeto,
                        'ocf_objeto_codigo' => $ocf_objeto_codigo,
                        'ocf_orden' => $ocf_orden,
                        'ocf_param_nombre' => $ocf_param_nombre,
                        'ocf_param_tipo' => $ocf_param_tipo,
                        'ocf_param_catalogo' => $ocf_param_catalogo,
                        'ocf_param_valor' => $ocf_param_valor,
                        'ocf_estado' => $ocf_estado,
                        'id_usuario' => $id_usuario,
                        'ocf_hora_inicio_lav' => $ocf_hora_inicio_lav,
                        'ocf_hora_fin_lav' => $ocf_hora_fin_lav,
                        'ocf_hora_inicio_sabado' => $ocf_hora_inicio_sabado,
                        'ocf_hora_fin_sabado' => $ocf_hora_fin_sabado,
                        'ocf_hora_inicio_domingo' => $ocf_hora_inicio_domingo,
                        'ocf_hora_fin_domingo' => $ocf_hora_fin_domingo
                        ]);
                        
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$ocf_correlativo);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $ocf_objeto_permiso=$parameter['ocf_objeto_permiso'] ?? 'no_object';
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, $ocf_objeto_permiso, 'eliminar');
                if($userFuncionality == 'OK'){
                    $ocf_correlativo= (int)$parameter['ocf_correlativo'] ?? 0;
                    
                    
                    $sql = " update cfg_objeto_config set ocf_estado = 'E' where ocf_correlativo = :ocf_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'ocf_correlativo' => $ocf_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
    
}
