<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgOrganizacionController{
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_organizacion', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $org_estado= $parameter['org_estado'] ?? 'A';
                    $fecha_inicio = $parameter['fecha_inicio'] ?? "null";
                    $fecha_fin = $parameter['fecha_fin'] ?? "null";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $sql = " select 
                    org_correlativo,
                    org_nombre,
                    org_pais,
                    org_coordinador,
                    org_estado,
                    est.cat_nombre as org_estado_nombre,
                    pa.cat_nombre as org_pais_nombre,
                    concat(u1.usr_nombres,' ',u1.usr_apellidos)as org_usuarioi,
                    concat(u2.usr_nombres,' ',u2.usr_apellidos)as org_usuariom,
                    date_format(org_fechai, '%d/%m/%y %T') as org_fechai,
                    date_format(org_fecham, '%d/%m/%y %T') as org_fecham 			
                    from cfg_organizacion 
                    left outer join cfg_usuario u1 on (u1.usr_correl = org_usuarioi)  
                    left outer join cfg_usuario u2 on (u2.usr_correl = org_usuariom) 
                    left outer join cfg_catalogo est on(org_estado = est.cat_valor and est.cat_tipo = 'ORG_ESTADO' and est.cat_empresa = :emp_codigo)
                    left outer join cfg_catalogo pa on(org_pais = pa.cat_valor and pa.cat_tipo = 'PAIS' and pa.cat_empresa = :emp_codigo)
                    where 1=1 
                    and org_estado = :org_estado
                    and ((org_nombre like concat('%',:filter,'%') or org_coordinador like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and (org_fechai >= STR_TO_DATE(:fecha_inicio,'%d/%m/%y %T') OR :fecha_inicio ='null' )
                    and (org_fechai <= STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin = 'null' ) 
                    and org_empresa = :emp_codigo
                    
                    
                    limit $pag_inicio, $tamanio 
                    ";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'org_estado' => $org_estado,
                        'emp_codigo' => $emp_codigo,
                        'fecha_inicio'=>$fecha_inicio,
                        'fecha_fin'=>$fecha_fin,
                        'filter'=>$filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if ($stmt->rowCount() > 0) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_organizacion", "  and org_estado = :org_estado
                        and ((org_nombre like concat('%',:filter,'%') or org_coordinador like concat('%',:filter,'%')) or (:filter = 'undefined'))
                        and (org_fechai >= STR_TO_DATE(:fecha_inicio,'%d/%m/%y %T') OR :fecha_inicio ='null' )
                        and (org_fechai <= STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin = 'null' ) 
                        and org_empresa = :emp_codigo", 
                        [
                            'org_estado' => $org_estado,
                            'emp_codigo' => $emp_codigo,
                            'fecha_inicio'=>$fecha_inicio,
                            'fecha_fin'=>$fecha_fin,
                            'filter'=>$filter
                        ]);
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_organizacion', 'nuevo');
                if($userFuncionality == 'OK'){
                    $org_correlativo = $utility->CorrelAutomatico($PDO, "cfg_organizacion", "org_correlativo", "");
                    $org_nombre= $parameter['org_nombre'] ?? 'null';
                    $org_pais= $parameter['org_pais'] ?? 'null';
                    $org_coordinador= $parameter['org_coordinador'] ?? 'null';
                    $org_estado= $parameter['org_estado'] ?? 'A';
                    
                    
                    $sql = " insert into cfg_organizacion (
                        org_correlativo,
                        org_empresa,
                        org_nombre,
                        org_pais,
                        org_coordinador,
                        org_estado,
                        org_usuarioi,
                        org_usuariom,
                        org_fechai,
                        org_fecham
                        ) values(
                            :org_correlativo,
                            :org_empresa,
                            :org_nombre,
                            :org_pais,
                            :org_coordinador,
                            :org_estado,
                            :org_usuarioi,
                            :org_usuarioi,
                            now(),
                            now()
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'org_correlativo' => $org_correlativo,
                        'org_empresa' => $emp_codigo,
                        'org_nombre' => $org_nombre,
                        'org_pais' => $org_pais,
                        'org_coordinador' => $org_coordinador,
                        'org_estado' => $org_estado,
                        'org_usuarioi' => $id_usuario,
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Organización registrada exitosamente', 'status'=>200,'token'=>$token,'key'=>$org_correlativo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Organización no pudo ser registrada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_organizacion', 'modificar');
                if($userFuncionality == 'OK'){
                    $org_correlativo= $parameter['org_correlativo'] ?? '0';
                    $org_nombre= $parameter['org_nombre'] ?? 'null';
                    $org_pais= $parameter['org_pais'] ?? 'null';
                    $org_coordinador= $parameter['org_coordinador'] ?? 'null';
                    $org_estado= $parameter['org_estado'] ?? 'A';
                    
                    
                    $sql = " update cfg_organizacion set
                        org_nombre=:org_nombre,
                        org_pais=:org_pais,
                        org_coordinador=:org_coordinador,
                        org_estado=:org_estado,
                        org_usuariom=:org_usuariom,
                        org_fecham=now() 
                        where
                        org_correlativo = :org_correlativo
                    ";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'org_nombre' => $org_nombre,
                        'org_pais' => $org_pais,
                        'org_coordinador' => $org_coordinador,
                        'org_estado' => $org_estado,
                        'org_usuariom' => $id_usuario,
                        'org_correlativo' => $org_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Organización actualizada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Organización no pudo ser actualizada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'eliminar');
                if($userFuncionality == 'OK'){
                    $org_correlativo = $parameter['org_correlativo'] ?? "0";
                    
                    
                    $sql = " update cfg_organizacion set
                        org_estado = 'E',
                        org_usuariom = :org_usuariom,
                        org_fecham = now()
                        where org_correlativo = :org_correlativo
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'org_correlativo' => $org_correlativo,
                        'org_usuariom' => $id_usuario,
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Organización eliminada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Organización no pudo ser eliminada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function cmbOrgDispUsr($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $ucf_usuario = $parameter['ucf_usuario'] ?? "0";
                    $cmb_tipo = $parameter['cmb_tipo'] ?? "options";
                        
                    $sql = "select 
                    org_correlativo,org_nombre 
                    from cfg_organizacion
                    where
                    org_estado = 'A'
                    and org_correlativo not in(
                        select ucf_objeto_codigo from cfg_usuario_config 
                        where ucf_empresa = :emp_codigo
                        and ucf_usuario = :ucf_usuario
                        and ucf_objeto = 'Organizacion'
                    )
                    and org_empresa = :emp_codigo
                    ";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo'=>$emp_codigo,
                        'ucf_usuario'=>$ucf_usuario
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if ($stmt->rowCount() > 0) {
                        if($cmb_tipo == 'options'){
                            array_unshift($result,array("org_correlativo"=>'','org_nombre'=>'Seleccione una opción'));
                        };
                        $totalRegistros =$stmt->rowCount();
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
                }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
}