<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgProductoController {
	
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $pro_estado = $parameter['pro_estado'] ?? 'A';

					
                    $sql = " 
                    select 
                    a.pro_correl, 
                    a.pro_codigo,  
                    a.pro_empresa,  
                    a.pro_nombre,  
                    a.pro_nombre_corto,  
                    a.pro_codigo_ext,  
                    a.pro_clasificacion,  
                    IF(a.pro_clasificacion = 1, 'Producto','Servicio médico') as servicio,
                    a.pro_tipo_laboratorio,
                    pro_tipo_ficha,
                    a.pro_cod_padre,  
                    a.pro_color, 
                    d.cat_nombre cat_estado_nombre,  
                    a.pro_estado,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as pro_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as pro_usuariom,  
                    date_format(a.pro_fechai, '%d/%m/%y %T') as pro_fechai,  
                    date_format(a.pro_fecham, '%d/%m/%y %T') as pro_fecham,  
                    a.pro_ambiente  
                    from cfg_producto a
                    left outer join cfg_catalogo d on(a.pro_estado= d.cat_valor and d.cat_tipo = 'ESTADO_PRODUCTO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.pro_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.pro_usuariom)
                    where 
                    1=1
                    and ((a.pro_nombre like concat('%',:filter,'%') or a.pro_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
					and a.pro_empresa = :emp_codigo 
                    and a.pro_estado =:pro_estado
                    and (a.pro_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.pro_fechai <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900')
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                        'pro_estado' => $pro_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter,
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_producto a
                            left outer join cfg_catalogo d on(a.pro_estado= d.cat_valor and d.cat_tipo = 'ESTADO_PRODUCTO' and d.cat_empresa = :emp_codigo)
                            left outer join cfg_usuario b on (b.usr_correl = a.pro_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.pro_usuariom)
                            ", "   and a.pro_empresa = :emp_codigo 
                            and ((a.pro_nombre like concat('%',:filter,'%') or a.pro_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                            and a.pro_estado =:pro_estado
                            and (a.pro_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                            and (a.pro_fechai <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'pro_estado' => $pro_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter' => $filter,
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }

    public function selectEspecialidad($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $pro_estado = $parameter['pro_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.pro_correl, 
                    a.pro_codigo,  
                    a.pro_empresa,  
                    a.pro_nombre,  
                    a.pro_nombre_corto,  
                    a.pro_codigo_ext,  
                    a.pro_clasificacion,  
                    a.pro_cod_padre,  
                    d.cat_nombre cat_estado_nombre,  
                    a.pro_estado,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as pro_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as pro_usuariom,  
                    date_format(a.pro_fechai, '%d/%m/%y %T') as pro_fechai,  
                    date_format(a.pro_fecham, '%d/%m/%y %T') as pro_fecham,  
                    a.pro_ambiente  
                    from cfg_producto a
                    left outer join cfg_catalogo d on(a.pro_estado= d.cat_valor and d.cat_tipo = 'ESTADO_PRODUCTO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.pro_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.pro_usuariom)
                    where 
                    1=1
                    and ((a.pro_nombre like concat('%',:filter,'%') or a.pro_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and a.pro_empresa = :emp_codigo 
                    and a.pro_estado = 'A'
                    and a.pro_clasificacion = 2

                    and (a.pro_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.pro_fechai <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900')
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo' => $emp_codigo,
                        'pro_estado' => $pro_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter,
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_producto a
                            left outer join cfg_catalogo d on(a.pro_estado= d.cat_valor and d.cat_tipo = 'ESTADO_PRODUCTO' and d.cat_empresa = :emp_codigo)
                            left outer join cfg_usuario b on (b.usr_correl = a.pro_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.pro_usuariom)
                            ", "   and a.pro_empresa = :emp_codigo 
                            and ((a.pro_nombre like concat('%',:filter,'%') or a.pro_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                            and a.pro_estado =:pro_estado
                            and (a.pro_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                            and (a.pro_fechai <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'pro_estado' => $pro_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter' => $filter,
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }

    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'nuevo');
                if($userFuncionality == 'OK'){
                    $pro_nombre=$parameter['pro_nombre'] ?? 'null';
                    $pro_nombre_corto=$parameter['pro_nombre_corto'] ?? 'null';
                    $pro_codigo_ext=$parameter['pro_codigo_ext'] ?? 'null';
                    $pro_clasificacion=(int)$parameter['pro_clasificacion'] ?? 0;
                    $pro_tipo_laboratorio=(int)$parameter['pro_tipo_laboratorio'] ?? 0;
                    $pro_cod_padre=(int)$parameter['pro_cod_padre'] ?? 0;
                    $pro_color=$parameter['pro_color'] ?? "#0CB7F2";
                    $pro_estado=$parameter['pro_estado'] ?? 'A';
                    $pro_tipo_ficha=$parameter['pro_tipo_ficha'] ?? 0;

                    $pro_correl = $utility->CorrelAutomatico($PDO, "cfg_producto", "pro_correl", "");
					$pro_codigo = $utility->CorrelAutomatico($PDO, "cfg_producto", "pro_codigo", " and pro_empresa = $emp_codigo");


                    $pro_nombre = $utility->validarLongitudString($pro_nombre, 0, 255);
                    $pro_nombre_corto = $utility->validarLongitudString($pro_nombre_corto, 0, 50);
                    $pro_color = $utility->validarLongitudString($pro_color, 0, 100);
                    
                    
                    $sql = " insert into cfg_producto (
                                            pro_correl, 
											pro_codigo, 
											pro_empresa, 
											pro_nombre, 
											pro_nombre_corto, 
											pro_codigo_ext, 
											pro_clasificacion,
                                            pro_tipo_laboratorio,
                                            pro_tipo_ficha,
											pro_cod_padre,
                                            pro_color,
											pro_estado, 
											pro_usuarioi, 
											pro_usuariom, 
											pro_fechai, 
											pro_fecham, 
											pro_ambiente
                                            ) values(
                                            :pro_correl, 
											:pro_codigo, 
											:pro_empresa, 
											:pro_nombre, 
											:pro_nombre_corto, 
											:pro_codigo_ext, 
											:pro_clasificacion,
                                            :pro_tipo_laboratorio,
                                            :pro_tipo_ficha,
											:pro_cod_padre,
                                            :pro_color,
											:pro_estado, 
											:id_usuario, 
											:id_usuario, 
											now(), 
											now(), 
											:pro_ambiente
                                            )";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['pro_correl' => $pro_correl,
                        'pro_codigo'=>$pro_codigo,
                        'pro_empresa' => $emp_codigo,
                        'pro_nombre' => $pro_nombre,
                        'pro_nombre_corto' => $pro_nombre_corto,
                        'pro_codigo_ext' => $pro_codigo_ext,
                        'pro_clasificacion' => $pro_clasificacion,
                        'pro_tipo_laboratorio' => $pro_tipo_laboratorio,
                        'pro_tipo_ficha' => $pro_tipo_ficha,
                        'pro_cod_padre' => $pro_cod_padre,
                        'pro_color' => $pro_color,
                        'pro_estado' => $pro_estado,
                        'id_usuario' => $id_usuario,
                        'pro_ambiente' => $amb_codigo,
                        ]);
                    
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$pro_correl);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'modificar');
                if($userFuncionality == 'OK'){
                   $pro_correl=(int)$parameter['pro_correl'] ?? 0;
                    $pro_nombre=$parameter['pro_nombre'] ?? 'null';
                    $pro_nombre_corto=$parameter['pro_nombre_corto'] ?? 'null';
                    $pro_codigo_ext=$parameter['pro_codigo_ext'] ?? 'null';
                    $pro_clasificacion=(int)$parameter['pro_clasificacion'] ?? 0;
                    $pro_tipo_laboratorio=(int)$parameter['pro_tipo_laboratorio'] ?? 0;
                    $pro_cod_padre=(int)$parameter['pro_cod_padre'] ?? 0;
                    $pro_color=$parameter['pro_color'] ?? "#0CB7F2";
                    $pro_estado=$parameter['pro_estado'] ?? 'A';
                    $pro_tipo_ficha=$parameter['pro_tipo_ficha'] ?? 0;

                    if($pro_tipo_ficha == 'undefined'){$pro_tipo_ficha = 0;}
                    if($pro_tipo_laboratorio == 'undefined'){$pro_tipo_laboratorio = 0;}

                    $pro_nombre = $utility->validarLongitudString($pro_nombre, 0, 255);
                    $pro_nombre_corto = $utility->validarLongitudString($pro_nombre_corto, 0, 50);
                    $pro_color = $utility->validarLongitudString($pro_color, 0, 100);

                    $sql = " update cfg_producto set
                            pro_empresa = :pro_empresa,
                            pro_nombre = :pro_nombre,  
                            pro_nombre_corto = :pro_nombre_corto,  
                            pro_codigo_ext = :pro_codigo_ext,  
                            pro_clasificacion = :pro_clasificacion,
                            pro_tipo_laboratorio = :pro_tipo_laboratorio,
                            pro_tipo_ficha = :pro_tipo_ficha,
                            pro_cod_padre = :pro_cod_padre,
                            pro_color = :pro_color,
                            pro_estado = :pro_estado,  
                            pro_usuariom = :id_usuario,
                            pro_fecham=now(),  
                            pro_ambiente = :pro_ambiente
                            where
                            pro_correl=:pro_correl";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['pro_correl' => $pro_correl,
                        'pro_empresa' => $emp_codigo,
                        'pro_nombre' => $pro_nombre,
                        'pro_nombre_corto' => $pro_nombre_corto,
                        'pro_codigo_ext' => $pro_codigo_ext,
                        'pro_clasificacion' => $pro_clasificacion,
                        'pro_tipo_laboratorio' => $pro_tipo_laboratorio,
                        'pro_tipo_ficha' => $pro_tipo_ficha,
                        'pro_cod_padre' => $pro_cod_padre,
                        'pro_color' => $pro_color,
                        'pro_estado' => $pro_estado,
                        'id_usuario' => $id_usuario,
                        'pro_ambiente' => $amb_codigo,
                        ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $pro_correl= (int)$parameter['pro_correl'] ?? 0;
                    
                    
                    $sql = " update cfg_producto set pro_estado ='E' where pro_correl = :pro_correl";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'pro_correl' => $pro_correl
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Catalogo no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
}
