<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgProductoPlanController {
	
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $prp_estado = $parameter['prp_estado'] ?? 'A';
                    $prp_cod_prod = $parameter['prp_cod_prod'] ?? 0;

					
                    $sql = " 
                    select 
                    a.prp_correlativo, 
                    a.prp_empresa,  
                    a.prp_ambiente,  
                    a.prp_cod_aseg,  
                    e.ase_nombre,
                    a.prp_cod_prod,  
                    f.pro_nombre,
                    f.pro_codigo_ext,
                    g.cat_nombre prod_clasif,
                    a.prp_precio, 
                    h.ocf_param_valor prp_plan, 
                    d.cat_nombre cat_estado_nombre,  
                    a.prp_estado,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as prp_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as prp_usuariom,  
                    a.prp_fechai,  
                    a.prp_fecham  
                    from cfg_producto_plan a
                    left outer join cfg_catalogo d on(a.prp_estado= d.cat_valor and d.cat_tipo = 'PROD_PLAN_ESTADO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.prp_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.prp_usuariom)
                    left outer join cfg_aseguradora e on(a.prp_cod_aseg = e.ase_correlativo)
                    left outer join cfg_producto f on(a.prp_cod_prod = f.pro_correl)
                    left outer join cfg_catalogo g on(f.pro_clasificacion = g.cat_valor and g.cat_tipo = 'PRODUCTO_CLASIF')
                    left outer join cfg_objeto_config h on(h.ocf_correlativo = a.prp_plan and h.ocf_objeto = 'Cfg_aseguradora_plan')
                    where 
                    1=1
					and a.prp_empresa = :emp_codigo 
                    and a.prp_ambiente = :amb_codigo 
                    and a.prp_estado =:prp_estado
                    and a.prp_cod_prod = :prp_cod_prod
                    and (a.prp_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.prp_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 

					limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                    'amb_codigo' => $amb_codigo,
                    'prp_estado' => $prp_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'prp_cod_prod'=>$prp_cod_prod
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_producto_plan a
                        left outer join cfg_catalogo d on(a.prp_estado= d.cat_valor and d.cat_tipo = 'PROD_PLAN_ESTADO' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.prp_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.prp_usuariom)
                        left outer join cfg_aseguradora e on(a.prp_cod_aseg = e.ase_correlativo)
                        left outer join cfg_producto f on(a.prp_cod_prod = f.pro_correl)
                        left outer join cfg_catalogo g on(f.pro_clasificacion = g.cat_valor and g.cat_tipo = 'PRODUCTO_CLASIF')
                        left outer join cfg_objeto_config h on(h.ocf_correlativo = a.prp_plan and h.ocf_objeto = 'Cfg_aseguradora_plan')
                        ", "   and a.prp_empresa = :emp_codigo 
                        and a.prp_ambiente = :amb_codigo 
                        and a.prp_estado =:prp_estado
                        and a.prp_cod_prod = :prp_cod_prod
                        and (a.prp_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                        and (a.prp_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                        ", 
                        ['emp_codigo' => $emp_codigo,
                        'amb_codigo' => $amb_codigo,
                        'prp_estado' => $prp_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'prp_cod_prod'=>$prp_cod_prod
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectCosto($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $cpro_estado = 'A';//$parameter['cpro_estado'] ?? 'A';
                    $cpro_cod_producto = $parameter['cpro_cod_producto'] ?? 0;

                    
                    $sql = " 
                    select 
                    a.cpro_correlativo, 
                    a.cpro_empresa, 
                    a.cpro_ambiente, 
                    a.cpro_cod_producto,  
                    a.cpro_cod_centro,  
                    a.cpro_costo,  
                    a.cpro_estado,
                    IF(a.cpro_estado = 'A','Activo','Inactivo') as estado,
                    a.cpro_usuarioi,  
                    a.cpro_usuariom,
                    a.cpro_fechai,
                    a.cpro_fecham,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as prp_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as prp_usuariom,
                    pro.pro_nombre,
                    suc.suc_nombre 
                    from cfg_producto_costo a 
                    left outer join cfg_usuario b on (b.usr_correl = a.cpro_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.cpro_usuariom)
                    left outer join cfg_producto pro on (pro.pro_correl = a.cpro_cod_producto)
                    left outer join cfg_sucursal suc on (suc.suc_correlativo = a.cpro_cod_centro)
                    where 
                    1=1
                    and a.cpro_empresa = :emp_codigo 
                    and a.cpro_ambiente = :amb_codigo 
                    and a.cpro_estado =:cpro_estado
                    and a.cpro_cod_producto = :cpro_cod_producto
                    and (a.cpro_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.cpro_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                    'amb_codigo' => $amb_codigo,
                    'cpro_estado' => $cpro_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'cpro_cod_producto'=>$cpro_cod_producto
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_producto_costo a
                        left outer join cfg_usuario b on (b.usr_correl = a.cpro_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.cpro_usuariom)
                        left outer join cfg_producto pro on (pro.pro_correl = a.cpro_cod_producto)
                        ", "   and a.cpro_empresa = :emp_codigo 
                        and a.cpro_ambiente = :amb_codigo 
                        and a.cpro_estado =:cpro_estado
                        and a.cpro_cod_producto = :cpro_cod_producto 
                        and (a.cpro_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                        and (a.cpro_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                        ", 
                        ['emp_codigo' => $emp_codigo,
                        'amb_codigo' => $amb_codigo,
                        'cpro_estado' => $cpro_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'cpro_cod_producto'=> $cpro_cod_producto
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectCentroAtencion($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $age_estado = 'A';//$parameter['ucf_estado'] ?? "A";

                    
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 200;//$parameter['tamanio'] ?? 10;
                    $usr_tipo = 2;//$parameter['usr_tipo'] ?? 10;
                    //$age_suc_correlativo = $parameter['age_suc_correlativo'] ?? 0;
                    $parametro = "";
                    $filtro = "";
                    
                    //$filter = $parameter['filter'] ?? "undefined";
                    
                    $sql = " select 
                            suc_correlativo,
                            suc_nombre 
                            FROM cfg_sucursal 
                            where 1=1 
                            and suc_empresa = :suc_empresa 
                            and suc_ambiente = :suc_ambiente 
                            limit $pag_inicio, $tamanio";

                    //echo $sql;
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'suc_empresa'=>$emp_codigo,
                        'suc_ambiente'=>$amb_codigo
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'Seleccione una opción'));
                        }else{
                            array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'No existen ninguna opción'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'nuevo');
                if($userFuncionality == 'OK'){
                    $prp_cod_aseg=(int)$parameter['prp_cod_aseg'] ?? 0;
                    $prp_cod_prod=(int)$parameter['prp_cod_prod'] ?? 0;
                    //$prp_plan=(int)$parameter['prp_plan'] ?? 0;
                    $prp_precio=(double)$parameter['prp_precio'] ?? 0;
                    $prp_estado=$parameter['prp_estado'] ?? 'A';

                    $prp_correlativo = $utility->CorrelAutomatico($PDO, "Cfg_producto_plan", "prp_correlativo", "");
					
                    
                    $sql = " insert into Cfg_producto_plan (
                                prp_correlativo, 
                                prp_empresa, 
                                prp_ambiente,
                                prp_cod_aseg,
                                prp_cod_prod,
                                prp_plan,
                                prp_precio,
                                prp_estado, 
                                prp_usuarioi, 
                                prp_usuariom, 
                                prp_fechai, 
                                prp_fecham 

                        ) values(
                            :prp_correlativo, 
                            :prp_empresa, 
                            :prp_ambiente,
                            :prp_cod_aseg,
                            :prp_cod_prod,
                            0,
                            :prp_precio,
                            :prp_estado, 
                            :id_usuario, 
                            :id_usuario, 
                            now(), 
                            now() 
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['prp_correlativo' => $prp_correlativo,
                    'prp_empresa' => $emp_codigo,
                    'prp_ambiente' => $amb_codigo,
                    'prp_cod_aseg' => $prp_cod_aseg,
                    'prp_cod_prod' => $prp_cod_prod,
                    //'prp_plan' => $prp_plan,
                    'prp_precio' => $prp_precio,
                    'prp_estado' => $prp_estado,
                    'id_usuario' => $id_usuario,
                    ]);
                    
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$prp_correlativo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertCosto($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'nuevo');
                if($userFuncionality == 'OK'){
                    $cpro_cod_producto=(int)$parameter['pro_correl'] ?? 0;
                    $cpro_cod_centro=(int)$parameter['cpro_cod_centro'] ?? 0;
                    //$prp_plan=(int)$parameter['prp_plan'] ?? 0;
                    $cpro_costo=(double)$parameter['cpro_costo'] ?? 0;
                    $cpro_estado=$parameter['cpro_estado'] ?? 'A';

                    $cpro_costo = $utility->validarLongitudString($cpro_costo, 0, 18);
                    $cpro_correlativo = $utility->CorrelAutomatico($PDO, "cfg_producto_costo", "cpro_correlativo", "");
                    
                    
                    $sql = " insert into cfg_producto_costo (
                                cpro_correlativo, 
                                cpro_empresa,
                                cpro_ambiente,
                                cpro_cod_producto, 
                                cpro_cod_centro,
                                cpro_costo,
                                cpro_estado,
                                cpro_usuarioi, 
                                cpro_usuariom, 
                                cpro_fechai, 
                                cpro_fecham 

                        ) values(
                            :cpro_correlativo, 
                            :cpro_empresa,
                            :cpro_ambiente,
                            :cpro_cod_producto, 
                            :cpro_cod_centro,
                            :cpro_costo,
                            :cpro_estado,
                            :id_usuario, 
                            :id_usuario, 
                            now(), 
                            now() 
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                    'cpro_correlativo' => $cpro_correlativo,
                    'cpro_empresa' => $emp_codigo,
                    'cpro_ambiente' => $amb_codigo,
                    'cpro_cod_producto' => $cpro_cod_producto,
                    'cpro_cod_centro' => $cpro_cod_centro,
                    'cpro_costo' => $cpro_costo,
                    'cpro_estado' => $cpro_estado,
                    'id_usuario' => $id_usuario
                    ]);
                    
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$prp_correlativo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'modificar');
                if($userFuncionality == 'OK'){
                   $prp_correlativo=(int)$parameter['prp_correlativo'] ?? 0;
                    $prp_cod_aseg=(int)$parameter['prp_cod_aseg'] ?? 0;
                    $prp_cod_prod=(int)$parameter['prp_cod_prod'] ?? 0;
                    $prp_precio=(int)$parameter['prp_precio'] ?? 0;
                    $prp_estado=$parameter['prp_estado'] ?? 'A';

                    $sql = " update Cfg_producto_plan set
                                prp_cod_aseg = :prp_cod_aseg,
                                prp_cod_prod = :prp_cod_prod,
                                prp_precio = :prp_precio,
                                prp_usuariom = :id_usuario,
                                prp_fecham=now()  
                        where
                        prp_correlativo=:prp_correlativo
                    ";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['prp_correlativo' => $prp_correlativo,
                    'prp_cod_aseg' => $prp_cod_aseg,
                    'prp_cod_prod' => $prp_cod_prod,
                    'prp_precio' => $prp_precio,
                    'id_usuario' => $id_usuario,
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $prp_correlativo= (int)$parameter['prp_correlativo'] ?? 0;
                    
                    
                    $sql = " update Cfg_producto_plan set prp_estado = 'E' where prp_correlativo = :prp_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'prp_correlativo' => $prp_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Catalogo no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function deleteCosto($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $cpro_correlativo= (int)$parameter['cpro_correlativo'] ?? 0;
                    
                    
                    $sql = " update cfg_producto_costo set cpro_estado = 'E' where cpro_correlativo = :cpro_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'cpro_correlativo' => $cpro_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Catalogo no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
   


    public function selectAseguradora($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $ase_estado = $parameter['ase_estado'] ?? 'A';
                    $cod_producto = $parameter['cod_producto'] ?? 'A';

					
                    $sql = " 
                    select 
                    a.ase_correlativo, 
                    a.ase_nombre,  
                    a.ase_numero,  
                    a.ase_correo,  
                    a.ase_comentarios,  
                    d.cat_nombre cat_estado_nombre,  
                    a.ase_estado,  
                    a.ase_fechai,  
                    a.ase_fecham,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as ase_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as ase_usuariom  
                    from cfg_aseguradora a
                    left outer join cfg_catalogo d on(a.ase_estado= d.cat_valor and d.cat_tipo = 'ESTADO_ASEGURADORA' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.ase_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.ase_usuariom)
                    where 
                    1=1
					and a.ase_estado =:ase_estado
                    and (a.ase_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.ase_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                    and ((a.ase_nombre like concat('%',:filter,'%') or a.ase_numero like concat('%',:filter,'%') or a.ase_correo like concat('%',:filter,'%')) or (:filter = 'undefined'))
					limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['ase_estado' => $ase_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'filter' => $filter,
                    'emp_codigo' => $emp_codigo,
                    'cod_producto' => $cod_producto,
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =sizeOf($result);
                        array_unshift($result,array("ase_correlativo"=>'','ase_nombre'=>'Seleccione una opción'));
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    
}
