<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgRolController{
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $rol_estado= $parameter['rol_estado'] ?? 'A';
                
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $sql = " select 
                    rol_codigo,
                    rol_empresa,
                    rol_codigo_ext,
                    rol_nombre,
                    rol_nombre_corto,
                    rol_descripcion,
                    rol_estado,
                    est.cat_nombre rol_estado_nombre,
                    concat(u1.usr_nombres,' ',u1.usr_apellidos)as rol_usuarioi,
                    concat(u2.usr_nombres,' ',u2.usr_apellidos)as rol_usuariom,
                    date_format(rol_fechai, '%d/%m/%y %T')  rol_fechai, 			 
                    date_format(rol_fecham, '%d/%m/%y %T')  rol_fecham,
                    rol_ambiente
                    from cfg_rol 
                    left outer join cfg_catalogo est on(rol_estado = est.cat_valor and est.cat_tipo = 'ROL_ESTADO' and est.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario u1 on (u1.usr_codigo = rol_usuarioi) 
                    left outer join cfg_usuario u2 on (u2.usr_codigo = rol_usuariom) 
                    where 1=1 
                    and rol_estado = :rol_estado
                    and rol_empresa = :emp_codigo
                    and rol_ambiente = :amb_codigo
                    and ((rol_nombre like concat('%',:filter,'%') or rol_descripcion like concat('%',:filter,'%') or rol_codigo_ext like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    
                    limit $pag_inicio, $tamanio 
                    ";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo,
                        'rol_estado'=>$rol_estado,
                        'filter'=>$filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if ($stmt->rowCount() > 0) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_rol", " and rol_estado = :rol_estado
                        and rol_empresa = :emp_codigo
                        and rol_ambiente = :amb_codigo
                        and ((rol_nombre like concat('%',:filter,'%') or rol_descripcion like concat('%',:filter,'%') or rol_codigo_ext like concat('%',:filter,'%')) or (:filter = 'undefined'))",
                        [
                            'emp_codigo'=>$emp_codigo,
                            'amb_codigo'=>$amb_codigo,
                            'rol_estado'=>$rol_estado,
                            'filter'=>$filter
                        ]);
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>0);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'nuevo');
                if($userFuncionality == 'OK'){
                    $rol_codigo = $utility->CorrelAutomatico($PDO, "cfg_rol", "rol_codigo", "");
                    $rol_codigo_ext= $parameter['rol_codigo_ext'] ?? '';
                    $rol_nombre= $parameter['rol_nombre'] ?? '';
                    $rol_nombre_corto= $parameter['rol_nombre_corto'] ?? '';
                    $rol_descripcion= $parameter['rol_descripcion'] ?? '';
                    $rol_estado= $parameter['rol_estado'] ?? 'A';
                    
                    $sql = " insert into cfg_rol (
                        rol_codigo,
                        rol_empresa,
                        rol_codigo_ext,
                        rol_nombre,
                        rol_nombre_corto,
                        rol_descripcion,
                        rol_estado,
                        rol_usuarioi,
                        rol_usuariom,
                        rol_fechai,
                        rol_fecham,
                        rol_ambiente
                        ) values(
                            :rol_codigo,
                            :rol_empresa,
                            :rol_codigo_ext,
                            :rol_nombre,
                            :rol_nombre_corto,
                            :rol_descripcion,
                            :rol_estado,
                            :rol_usuarioi,
                            :rol_usuarioi,
                            now(),
                            now(),
                            :rol_ambiente
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'rol_codigo' => $rol_codigo,
                        'rol_empresa' => $emp_codigo,
                        'rol_codigo_ext' => $rol_codigo_ext,
                        'rol_nombre' => $rol_nombre,
                        'rol_nombre_corto' => $rol_nombre_corto,
                        'rol_descripcion' => $rol_descripcion,
                        'rol_estado' => $rol_estado,
                        'rol_usuarioi' => $id_usuario,
                        'rol_ambiente' => $amb_codigo,
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Rol registrado exitosamente', 'status'=>200,'token'=>$token,'key'=>$rol_codigo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Rol no pudo ser registrado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'modificar');
                if($userFuncionality == 'OK'){
                    $rol_codigo= $parameter['rol_codigo'] ?? 0;
                    
                    $rol_codigo_ext= $parameter['rol_codigo_ext'] ?? '';
                    $rol_nombre= $parameter['rol_nombre'] ?? '';
                    $rol_nombre_corto= $parameter['rol_nombre_corto'] ?? '';
                    $rol_descripcion= $parameter['rol_descripcion'] ?? '';
                    $rol_estado= $parameter['rol_estado'] ?? 'A';
                    
                    $sql = " update cfg_rol set
                            rol_codigo_ext=:rol_codigo_ext,
                            rol_nombre=:rol_nombre,
                            rol_nombre_corto=:rol_nombre_corto,
                            rol_descripcion=:rol_descripcion,
                            rol_estado=:rol_estado,
                            rol_usuariom=:rol_usuariom,
                            rol_fecham=now()
                        where
                        rol_codigo = :rol_codigo
                        
                    ";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'rol_codigo' => $rol_codigo,
                        'rol_codigo_ext' => $rol_codigo_ext,
                        'rol_nombre' => $rol_nombre,
                        'rol_nombre_corto' => $rol_nombre_corto,
                        'rol_descripcion' => $rol_descripcion,
                        'rol_estado' => $rol_estado,
                        'rol_usuariom' => $id_usuario
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Rol actualizado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Rol no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'eliminar');
                if($userFuncionality == 'OK'){
                    $rol_codigo = $parameter['rol_codigo'] ?? "0";
                    
                    
                    $sql = " update cfg_rol set
                        rol_estado = 'E',
                        rol_usuariom = :rol_usuariom,
                        rol_fecham = now()
                        where rol_codigo = :rol_codigo
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['rol_codigo' => $rol_codigo,'rol_usuariom'=>$id_usuario]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Rol eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Rol no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function cmbRolDispUsr($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $uro_usuario = $parameter['uro_usuario'] ?? "0";
                    $cmb_tipo = $parameter['cmb_tipo'] ?? "options";
                        
                    $sql = " select   
                    rol_codigo,   
                    rol_nombre   
                    from cfg_rol   
                    where 1 = 1   
                    and rol_codigo not in (   
                    select   
                    uro_rol   
                    from cfg_usuario_rol   
                    where 1 = 1   
                    and uro_usuario =:uro_usuario     
                    )   
                    and rol_empresa =:emp_codigo
                    and rol_ambiente =:amb_codigo
                    and rol_estado = 'A'   
                    order by rol_nombre asc 
                    ";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'uro_usuario'=>$uro_usuario,
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo    
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if ($stmt->rowCount() > 0) {
                        if($cmb_tipo == 'options'){
                            array_unshift($result,array("rol_codigo"=>'','rol_nombre'=>'Seleccione una opción'));
                        };
                        $totalRegistros =$stmt->rowCount();
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
}