<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgRolFuncionalidadController{
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $rof_rol = $parameter['rof_rol'] ?? 0;
                    
                    $sql = " select 
                    rof_codigo,  
                    CONCAT_WS('-',c1.cat_nombre,fun_nombre ) as fun_nombre,  
                    rof_lectura,  
                    (case rof_lectura when 1 then 'si' when 0 then 'no' else 'indefinido' end) as nom_rof_lectura,  
                    (case rof_lectura when 1 then 'badge bg-blue' when 0 then 'badge bg-red' else 'badge bg-gray' end) as col_rof_lectura,  
                    rof_nuevo,  
                    (case rof_nuevo when 1 then 'si' when 0 then 'no' else 'indefinido' end) as nom_rof_nuevo,  
                    (case rof_nuevo when 1 then 'badge bg-blue' when 0 then 'badge bg-red' else 'badge bg-gray' end) as col_rof_nuevo,  
                    rof_modificar,  
                    (case rof_modificar when 1 then 'si' when 0 then 'no' else 'indefinido' end) as nom_rof_modificar,  
                    (case rof_modificar when 1 then 'badge bg-blue' when 0 then 'badge bg-red' else 'badge bg-gray' end) as col_rof_modificar,  
                    rof_eliminar,  
                    (case rof_eliminar when 1 then 'si' when 0 then 'no' else 'indefinido' end) as nom_rof_eliminar,  
                    (case rof_eliminar when 1 then 'badge bg-blue' when 0 then 'badge bg-red' else 'badge bg-gray' end) as col_rof_eliminar,  
                    concat(u1.usr_nombres,' ',u1.usr_apellidos)as rof_usuarioi,  
                    date_format(rof_fechaI, '%d/%m/%y %T')  rof_fechai,
                    concat(u2.usr_nombres,' ',u2.usr_apellidos)as rof_usuariom,  
                    date_format(rof_fecham, '%d/%m/%y %T')  rof_fecham
                    from cfg_rol_funcionalidad  
                    left outer join cfg_funcionalidad f1 on (f1.fun_correlativo = rof_funcionalidad and f1.fun_empresa = :emp_codigo  )  
                    left outer join cfg_catalogo c1 on (c1.cat_valor = fun_tipo and c1.cat_tipo = 'TIPO_OBJ' and c1.cat_empresa = :emp_codigo)  
                    left outer join cfg_usuario u1 on (u1.usr_codigo = rof_usuarioi)  
                    left outer join cfg_usuario u2 on (u2.usr_codigo = rof_usuariom)  
                    where 1 = 1                 
                    and rof_estado = 'A'
                    and rof_rol = :rof_rol
                    limit $pag_inicio, $tamanio 
                    ";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(["rof_rol"=>$rof_rol,"emp_codigo"=>$emp_codigo]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if ($stmt->rowCount() > 0) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_rol_funcionalidad", " and rof_estado = 'A' and rof_rol = :rof_rol",
                        ["rof_rol"=>$rof_rol]);
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>0);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'nuevo');
                if($userFuncionality == 'OK'){
                    $rof_codigo = $utility->CorrelAutomatico($PDO, "cfg_rol_funcionalidad", "rof_codigo", "");
                    $rof_rol= $parameter['rof_rol'] ?? 'null';
                    $rof_funcionalidad= $parameter['rof_funcionalidad'] ?? 'null';
                    $rof_lectura= $parameter['rof_lectura'] ?? '0';
                    $rof_nuevo= $parameter['rof_nuevo'] ?? '0';
                    $rof_modificar= $parameter['rof_modificar'] ?? '0';
                    $rof_eliminar= $parameter['rof_eliminar'] ?? '0';
                    
                    
                    $sql = " insert into cfg_rol_funcionalidad (
                        rof_codigo,
                        rof_empresa,
                        rof_rol,
                        rof_funcionalidad,
                        rof_lectura,
                        rof_nuevo,
                        rof_modificar,
                        rof_eliminar,
                        rof_estado,
                        rof_usuarioi,
                        rof_usuariom,
                        rof_fechai,
                        rof_fecham
                        ) values(
                            :rof_codigo,
                            :rof_empresa,
                            :rof_rol,
                            :rof_funcionalidad,
                            :rof_lectura,
                            :rof_nuevo,
                            :rof_modificar,
                            :rof_eliminar,
                            'A',
                            :rof_usuarioi,
                            :rof_usuarioi,
                            now(),
                            now()
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'rof_codigo' => $rof_codigo,
                        'rof_empresa' => $emp_codigo,
                        'rof_rol' => $rof_rol,
                        'rof_funcionalidad' => $rof_funcionalidad,
                        'rof_lectura' => $rof_lectura,
                        'rof_nuevo' => $rof_nuevo,
                        'rof_modificar' => $rof_modificar,
                        'rof_eliminar' => $rof_eliminar,
                        'rof_usuarioi' => $id_usuario
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Funcionalidad registrada exitosamente', 'status'=>200,'token'=>$token,'key'=>$rof_codigo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Funcionalidad no pudo ser registrada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'eliminar');
                if($userFuncionality == 'OK'){
                    $rof_codigo= $parameter['rof_codigo'] ?? '0';
                    
                    
                    $sql = " delete from  cfg_rol_funcionalidad 
                        where rof_codigo = :rof_codigo
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['rof_codigo' => $rof_codigo]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Funcionalidad eliminada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Funcionalidad no pudo ser eliminada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
}