<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgSucursalController {
	
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'lectura');

                

                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $suc_estado = $parameter['suc_estado'] ?? 'A';
                    
					//$codUsuario = $utility->codigoUsuario($PDO, "cfg_usuario", "usr_correl", "AND usr_correl= '1'");
                    //echo $codUsuario;
                    $sql = " 
                    select 
                    a.suc_correlativo, 
                    a.suc_codigo,  
                    a.suc_nombre,  
                    a.suc_direccion,  
                    a.suc_responsable, 
                    a.suc_horario_lunes_a_viernes_inicio,
                    a.suc_horario_lunes_a_viernes_fin,
                    a.suc_horario_sabado_inicio,
                    a.suc_horario_sabado_fin,
                    a.suc_horario_domingo_inicio,
                    a.suc_horario_domingo_fin,
                    concat(e.usr_nombres,' ', e.usr_apellidos) as suc_nombre_responsable,  
                    d.cat_nombre cat_estado_nombre,  
                    a.suc_estado,  
                    a.suc_empresa,  
                    a.suc_ambiente,  
                    a.suc_fechai,  
                    a.suc_fecham,  
                    b.usr_nombres,
                    b.usr_apellidos,
                    concat(b.usr_nombres,' ',b.usr_apellidos) as suc_usuarioi,  
                    concat(c.usr_nombres,' ',c.usr_apellidos) as suc_usuariom  

                    from cfg_sucursal a
                    left outer join cfg_catalogo d on(a.suc_estado= d.cat_valor and d.cat_tipo = 'SUCURSAL_ESTADO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.suc_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.suc_usuariom)
                    left outer join cfg_usuario e on (e.usr_correl = a.suc_responsable)

					
                    where 
                    1=1
					 and a.suc_empresa = :emp_codigo 
                     and a.suc_ambiente =:amb_codigo
                     and a.suc_estado =:suc_estado
                     and ((a.suc_nombre like concat('%',:filter,'%') or a.suc_direccion like concat('%',:filter,'%')) or (:filter = 'undefined'))
                     and (a.suc_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                     and (a.suc_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 

                     limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'emp_codigo' => $emp_codigo,
                    'amb_codigo' => $amb_codigo,
                    'suc_estado' => $suc_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'filter'=>$filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_sucursal a 
                            left outer join cfg_catalogo d on(a.suc_estado= d.cat_valor and d.cat_tipo = 'SUCURSAL_ESTADO' and d.cat_empresa = :emp_codigo)
                            left outer join cfg_usuario b on (b.usr_correl = a.suc_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.suc_usuariom)
                            ", "   and a.suc_empresa = :emp_codigo 
                             and a.suc_estado =:suc_estado 
                             and ((a.suc_nombre like concat('%',:filter,'%') or a.suc_direccion like concat('%',:filter,'%')) or (:filter = 'undefined'))
                             and (a.suc_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                             and (a.suc_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'suc_estado' => $suc_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter'=>$filter
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }

    public function selectUser($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'nuevo');
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'modificar');

                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $usr_estado = $parameter['usr_estado'] ?? 'A';
                    $filtro = "";

                    if($id_usuario == 1){
                        $filtro = "";
                    }else{
                        $filtro = " AND a.usr_correl > 1 ";
                    }
                    
                    $sql = " 
                    select 
                    a.usr_correl, 
                    a.usr_codigo,  
                    a.usr_empresa, 
                    a.usr_nombres,  
                    concat(a.usr_nombres,' ', a.usr_apellidos) as usr_nombres_apellidos,
                    a.usr_apellidos,  
                    a.usr_estado, 
                    a.usr_email, 
                    a.usr_telefono, 
                    a.usr_celular, 
                    d.cat_nombre cat_estado_nombre,   
                    a.usr_fechai,  
                    a.usr_fecham,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as suc_usuarioi,  
                    concat(c.usr_nombres ,' ',c.usr_apellidos) as suc_usuariom  

                    from cfg_usuario a
                    left outer join cfg_catalogo d on(a.usr_estado= d.cat_valor and d.cat_tipo = 'usr_estado' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.usr_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.usr_usuariom)

                    
                    where 
                    1=1
                    $filtro
                     and a.usr_empresa = :emp_codigo 
                     and a.usr_estado =:usr_estado
                     and ((a.usr_nombres like concat('%',:filter,'%') or a.usr_apellidos like concat('%',:filter,'%') or a.usr_email like concat('%',:filter,'%')) or (:filter = 'undefined'))
                     and (a.usr_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                     and (a.usr_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                     limit $pag_inicio, $tamanio ";
                    //echo $sql;
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'emp_codigo' => $emp_codigo,
                    'usr_estado' => $usr_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'filter'=>$filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        array_unshift($result,array("usr_correl"=>'','usr_nombres_apellidos'=>'Seleccione una opción'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_usuario a 
                            left outer join cfg_catalogo d on(a.usr_estado= d.cat_valor and d.cat_tipo = 'SUCURSAL_ESTADO' and d.cat_empresa = :emp_codigo)
                            left outer join cfg_usuario b on (b.usr_correl = a.usr_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.usr_usuariom)
                            ", "   and a.usr_empresa = :emp_codigo 
                             and a.usr_estado =:usr_estado 

                             and ((a.usr_nombres like concat('%',:filter,'%') or a.usr_apellidos like concat('%',:filter,'%') or a.usr_email like concat('%',:filter,'%')) or (:filter = 'undefined'))

                             and (a.usr_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                             and (a.usr_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'usr_estado' => $usr_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter'=>$filter
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectBloqueoAgendaCentro($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    //$filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $tra_ba_estado = 'A';//$parameter['age_estado'] ?? 'A';
                    $tra_ba_suc_correlativo = $parameter['tra_ba_suc_correlativo'] ?? 0;
                    
                    $sql = " 
                    select 
                    a.tra_ba_correlativo as id, 
                    a.tra_ba_suc_correlativo,
                    a.tra_ba_etiqueta,
                    a.tra_ba_observaciones,
                    a.tra_ba_color as color,
                    a.tra_ba_rendering_background as rendering,
                    a.tra_ba_fecha_inicio as start,
                    a.tra_ba_fecha_fin as end,
                    a.tra_ba_observaciones as comment, 
                    a.tra_ba_age_allDay as allDay,
                    a.tra_ba_estado,  
                    a.tra_ba_usuarioi,
                    a.tra_ba_usuariom,
                    a.tra_ba_fechai,
                    a.tra_ba_fecham,
                    concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                    date_format(a.tra_ba_fechai, '%d/%m/%y %T') as age_fechai,  
                    date_format(a.tra_ba_fecham, '%d/%m/%y %T') as age_fecham 
                    from tra_bloqueo_agenda a 
                    left outer join cfg_usuario b on (b.usr_correl = a.tra_ba_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.tra_ba_usuariom) 
                    where 
                    1=1 
                    and a.tra_ba_estado =:tra_ba_estado 
                    and a.tra_ba_suc_correlativo =:tra_ba_suc_correlativo 
                    and (a.tra_ba_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.tra_ba_fecham <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900')
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_ba_suc_correlativo' => $tra_ba_suc_correlativo,
                        'tra_ba_estado' => $tra_ba_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin
                        //'filter' => $filter
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_bloqueo_agenda a
                            left outer join cfg_usuario b on (b.usr_correl = a.tra_ba_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.tra_ba_usuariom) 
                            ", " 
                            and a.tra_ba_estado =:tra_ba_estado 
                            and a.tra_ba_suc_correlativo =:suc_correlativo 
                            and (a.tra_ba_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                            and (a.tra_ba_fecham <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900')
                            ", 
                            [
                                'suc_correlativo' => $suc_correlativo,
                                'tra_ba_estado' => $tra_ba_estado,
                                'fecha_ini' => $fecha_ini,
                                'fecha_fin' => $fecha_fin
                                //'filter' => $filter
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'nuevo');
                if($userFuncionality == 'OK'){
                    $suc_nombre=$parameter['suc_nombre'] ?? 'null';
                    $suc_direccion=$parameter['suc_direccion'] ?? 'null';
                    $suc_responsable=(int)$parameter['suc_responsable'] ?? 0;

                    $suc_horario_lunes_a_viernes_inicio = $parameter['suc_horario_lunes_a_viernes_inicio'] ?? date("H:i");
                    $suc_horario_lunes_a_viernes_fin = $parameter['suc_horario_lunes_a_viernes_fin'] ?? date("H:i");
                    $suc_horario_sabado_inicio = $parameter['suc_horario_sabado_inicio'] ?? date("H:i");
                    $suc_horario_sabado_fin = $parameter['suc_horario_sabado_fin'] ?? date("H:i");
                    $suc_horario_domingo_inicio = $parameter['suc_horario_domingo_inicio'] ?? date("H:i");
                    $suc_horario_domingo_fin = $parameter['suc_horario_domingo_fin'] ?? date("H:i");

                    $suc_nombre = $utility->validarLongitudString($suc_nombre, 0, 100);
                    $suc_direccion = $utility->validarLongitudString($suc_direccion, 0, 200);
                    //$suc_responsable = $utility->validarLongitudNumero($suc_responsable, 0, 11);
                    $suc_horario_lunes_a_viernes_inicio = $utility->validarLongitudString($suc_horario_lunes_a_viernes_inicio, 0, 9);
                    $suc_horario_lunes_a_viernes_fin = $utility->validarLongitudString($suc_horario_lunes_a_viernes_fin, 0, 9);
                    $suc_horario_sabado_inicio = $utility->validarLongitudString($suc_horario_sabado_inicio, 0, 9);
                    $suc_horario_sabado_fin = $utility->validarLongitudString($suc_horario_sabado_fin, 0, 9);
                    $suc_horario_domingo_inicio = $utility->validarLongitudString($suc_horario_domingo_inicio, 0, 9);
                    $suc_horario_domingo_fin = $utility->validarLongitudString($suc_horario_domingo_fin, 0, 9);

                    $suc_estado=$parameter['suc_estado'] ?? 'A';
                    $existeSucursal = 0;

                    $suc_correlativo = $utility->CorrelAutomatico($PDO, "cfg_sucursal", "suc_correlativo", "");
					$suc_codigo = $utility->CorrelAutomatico($PDO, "cfg_sucursal", "suc_codigo", " and suc_empresa = $emp_codigo 
");
                    
                    $sql = "insert into cfg_sucursal (
                        					suc_correlativo, 
											suc_codigo, 
											suc_nombre, 
											suc_direccion, 
											suc_responsable,
                                            suc_horario_lunes_a_viernes_inicio,
                                            suc_horario_lunes_a_viernes_fin,
                                            suc_horario_sabado_inicio,
                                            suc_horario_sabado_fin,
                                            suc_horario_domingo_inicio,
                                            suc_horario_domingo_fin,
											suc_estado, 
											suc_empresa, 
											suc_ambiente,
											suc_fechai, 
											suc_fecham, 
											suc_usuarioi, 
											suc_usuariom 

                        ) values(
                            				:suc_correlativo, 
											:suc_codigo, 
											:suc_nombre, 
											:suc_direccion, 
											:suc_responsable,
                                            :suc_horario_lunes_a_viernes_inicio,
                                            :suc_horario_lunes_a_viernes_fin,
                                            :suc_horario_sabado_inicio,
                                            :suc_horario_sabado_fin,
                                            :suc_horario_domingo_inicio,
                                            :suc_horario_domingo_fin,
											:suc_estado, 
											:suc_empresa, 
											:suc_ambiente,
											now(), 
											now(), 
											:id_usuario, 
											:id_usuario 

                        )
                    ";
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                        'suc_correlativo' => $suc_correlativo,
                        'suc_codigo' => $suc_codigo,
                        'suc_nombre' => $suc_nombre,
                        'suc_direccion' => $suc_direccion,
                        'suc_responsable' => $suc_responsable,
                        'suc_horario_lunes_a_viernes_inicio' => $suc_horario_lunes_a_viernes_inicio,
                        'suc_horario_lunes_a_viernes_fin' => $suc_horario_lunes_a_viernes_fin,
                        'suc_horario_sabado_inicio' => $suc_horario_sabado_inicio,
                        'suc_horario_sabado_fin' => $suc_horario_sabado_fin,
                        'suc_horario_domingo_inicio' => $suc_horario_domingo_inicio,
                        'suc_horario_domingo_fin' => $suc_horario_domingo_fin,
                        'suc_estado' => $suc_estado,
                        'suc_empresa' => $emp_codigo,
                        'suc_ambiente' => $amb_codigo,
                        'id_usuario' => $id_usuario
                        ]);
                        
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro registrado exitosamente', 'status'=>200,'token'=>$token,'key'=>$suc_correlativo);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser registrado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function insertBloqueoAgenda($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'nuevo');//CAMBIAR EL NOMBRE DEL OBJETO
                if($userFuncionality == 'OK'){
                    $existeHorario = [];
                    $existesHorarioAgenda = [];
                    $registrar = false;
                    $registrarAgenda = false;
                    $mensaje = "";
                    $age_allDay = 0;
                    $tra_ba_suc_correlativo=(int)$parameter['tra_ba_suc_correlativo'] ?? 0;
                    $tra_ba_fecha_inicio=$parameter['tra_ba_fecha_inicio'] ?? date("Y-m-d");
                    $tra_ba_fecha_fin=$parameter['tra_ba_fecha_fin'] ?? date("Y-m-d");

                    /*$age_hora_inicio=$parameter['age_hora_inicio'] ?? date("H:i");
                    $age_hora_fin=$parameter['age_hora_fin'] ?? date("H:i");*/

                    $tra_ba_etiqueta=$parameter['tra_ba_etiqueta'] ?? 'null';
                    $tra_ba_observaciones= NULL;//$parameter['tra_ba_observaciones'] ?? 'null';
                    $tra_ba_color=$parameter['tra_ba_color'] ?? '#F3DCE3';
                    $tra_ba_rendering_background = "background";

                    /*$age_color = '#A3F2ED';//$parameter['age_color'] ?? '#A3F2ED';
                    $age_text_color = '#000000';//$parameter['age_text_color'] ?? '#000000';*/

                    $tra_ba_etiqueta = $utility->validarLongitudString($tra_ba_etiqueta, 0, 50);
                    $tra_ba_observaciones = $utility->validarLongitudString($tra_ba_observaciones, 0, 1000);
                    
                    $tra_ba_estado=$parameter['tra_ba_estado'] ?? 'A';
                    

                    $horarioCentroValido = 1;
                    
                    $tra_ba_correlativo = $utility->ultimoRegistro($PDO, "tra_bloqueo_agenda", "tra_ba_correlativo ", "order by tra_ba_correlativo desc limit 1");
                    $especialidadRegistrada = 0;
                    /*$especialidadRegistrada = $utility->validarAgendaMedico($PDO, "cfg_agenda", "age_correlativo ","$age_usr_correl","$age_suc_correlativo","$age_pro_correl", "$age_fecha_inicio.' '.$age_hora_inicio", "$age_fecha_fin.' '.$age_hora_fin", "");*/

                    $sql = "
                        SET @row_number = :tra_ba_correlativo;
                        insert into tra_bloqueo_agenda (tra_ba_correlativo, tra_ba_suc_correlativo,tra_ba_fecha_inicio,tra_ba_fecha_fin,tra_ba_etiqueta,tra_ba_observaciones,tra_ba_color,tra_ba_rendering_background,tra_ba_estado,tra_ba_usuarioi,tra_ba_usuariom, tra_ba_fechai, tra_ba_fecham)
                        select 
                        (@row_number:=@row_number + 1) AS num,
                        :tra_ba_suc_correlativo,
                        selected_date,
                        selected_date,
                        :tra_ba_etiqueta,
                        :tra_ba_observaciones,
                        :tra_ba_color,
                        :tra_ba_rendering_background,
                        'A',
                        :id_usuario,
                        :id_usuario,
                        now(),
                        now()

                        from 
                        (select concat(adddate('1970-01-01',t4.i*10000 + t3.i*1000 + t2.i*100 + t1.i*10 + t0.i)) selected_date from
                         (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t0,
                         (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t1,
                         (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t2,
                         (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t3,
                         (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t4) v
                        where selected_date between :tra_ba_fecha_inicio and :tra_ba_fecha_fin";
                    
                    
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'tra_ba_correlativo' => $tra_ba_correlativo,
                            'tra_ba_color' => $tra_ba_color,
                            'tra_ba_suc_correlativo'=>$tra_ba_suc_correlativo,
                            'tra_ba_fecha_inicio' => $tra_ba_fecha_inicio,
                            'tra_ba_fecha_fin' => $tra_ba_fecha_fin,
                            'tra_ba_etiqueta' => $tra_ba_etiqueta,
                            'tra_ba_observaciones' => $tra_ba_observaciones,
                            'id_usuario' => $id_usuario,
                            'tra_ba_rendering_background' => $tra_ba_rendering_background
                            ]);
                            
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Bloqueo de agenda ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_ba_correlativo);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Bloqueo de agenda no pudo ser ingresado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'modificar');
                if($userFuncionality == 'OK'){
                    $existeSucursal = 0;
                    $suc_correlativo=(int)$parameter['suc_correlativo'] ?? 0;
                    $suc_nombre=$parameter['suc_nombre'] ?? 'null';
                    $suc_direccion=$parameter['suc_direccion'] ?? 'null';
                    $suc_responsable=(int)$parameter['suc_responsable'] ?? 0;
                    $suc_estado=$parameter['suc_estado'] ?? 'A';

                    $suc_horario_lunes_a_viernes_inicio = $parameter['suc_horario_lunes_a_viernes_inicio'] ?? date("H:i");
                    $suc_horario_lunes_a_viernes_fin = $parameter['suc_horario_lunes_a_viernes_fin'] ?? date("H:i");
                    $suc_horario_sabado_inicio = $parameter['suc_horario_sabado_inicio'] ?? date("H:i");
                    $suc_horario_sabado_fin = $parameter['suc_horario_sabado_fin'] ?? date("H:i");
                    $suc_horario_domingo_inicio = $parameter['suc_horario_domingo_inicio'] ?? date("H:i");
                    $suc_horario_domingo_fin = $parameter['suc_horario_domingo_fin'] ?? date("H:i");

                    $suc_nombre = $utility->validarLongitudString($suc_nombre, 0, 100);
                    $suc_direccion = $utility->validarLongitudString($suc_direccion, 0, 200);
                    $suc_responsable = $utility->validarLongitudNumero($suc_responsable, 0, 11);
                    $suc_horario_lunes_a_viernes_inicio = $utility->validarLongitudString($suc_horario_lunes_a_viernes_inicio, 0, 9);
                    $suc_horario_lunes_a_viernes_fin = $utility->validarLongitudString($suc_horario_lunes_a_viernes_fin, 0, 9);
                    $suc_horario_sabado_inicio = $utility->validarLongitudString($suc_horario_sabado_inicio, 0, 9);
                    $suc_horario_sabado_fin = $utility->validarLongitudString($suc_horario_sabado_fin, 0, 9);
                    $suc_horario_domingo_inicio = $utility->validarLongitudString($suc_horario_domingo_inicio, 0, 9);
                    $suc_horario_domingo_fin = $utility->validarLongitudString($suc_horario_domingo_fin, 0, 9);


                    $sql = " update cfg_sucursal set
                        					suc_nombre = :suc_nombre,  
											suc_direccion = :suc_direccion,  
											suc_responsable = :suc_responsable,
                                            suc_horario_lunes_a_viernes_inicio = :suc_horario_lunes_a_viernes_inicio,
                                            suc_horario_lunes_a_viernes_fin = :suc_horario_lunes_a_viernes_fin,
                                            suc_horario_sabado_inicio = :suc_horario_sabado_inicio,
                                            suc_horario_sabado_fin = :suc_horario_sabado_fin,
                                            suc_horario_domingo_inicio = :suc_horario_domingo_inicio,
                                            suc_horario_domingo_fin = :suc_horario_domingo_fin,
											suc_estado = :suc_estado,  
											suc_empresa = :suc_empresa,
											suc_ambiente = :suc_ambiente,
											suc_fecham=now(),  
											suc_usuariom = :id_usuario

                        where
                        suc_correlativo=:suc_correlativo
                    ";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'suc_correlativo' => $suc_correlativo,
                        'suc_nombre' => $suc_nombre,
                        'suc_direccion' => $suc_direccion,
                        'suc_responsable' => $suc_responsable,
                        'suc_horario_lunes_a_viernes_inicio' => $suc_horario_lunes_a_viernes_inicio,
                        'suc_horario_lunes_a_viernes_fin' => $suc_horario_lunes_a_viernes_fin,
                        'suc_horario_sabado_inicio' => $suc_horario_sabado_inicio,
                        'suc_horario_sabado_fin' => $suc_horario_sabado_fin,
                        'suc_horario_domingo_inicio' => $suc_horario_domingo_inicio,
                        'suc_horario_domingo_fin' => $suc_horario_domingo_fin,
                        'suc_estado' => $suc_estado,
                        'suc_empresa' => $emp_codigo,
                        'suc_ambiente' => $amb_codigo,
                        'id_usuario' => $id_usuario
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'eliminar');
                if($userFuncionality == 'OK'){
                    $suc_correlativo= (int)$parameter['suc_correlativo'] ?? 0;
                    
                    
                    $sql = " update cfg_sucursal set suc_estado='E' where suc_correlativo = :suc_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'suc_correlativo' => $suc_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function cmbServicios($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $suc_correlativo = (int)$parameter['suc_correlativo'] ?? 0;
                    $cmb_tipo = $parameter['cmb_tipo'] ?? "options";
                        
                    $sql = " select   
                    pro_correl,   
                    pro_nombre,
                    suc.suc_horario_lunes_a_viernes_inicio as hora_inicio_lav,
                    suc.suc_horario_lunes_a_viernes_fin as hora_fin_lav,
                    suc.suc_horario_sabado_inicio as hora_inicio_sabado,
                    suc.suc_horario_sabado_fin as hora_fin_sabado,
                    suc.suc_horario_domingo_inicio as hora_inicio_domingo,
                    suc.suc_horario_domingo_fin as hora_fin_domingo   
                    from cfg_producto 
                    left outer join cfg_sucursal suc on (suc.suc_correlativo = :suc_correlativo and suc.suc_estado = 'A' and suc.suc_empresa = :emp_codigo and suc.suc_ambiente = :amb_codigo)  
                    where 1 = 1   
                        and pro_correl not in (   
                        select   
                        ocf_param_tipo   
                        from cfg_objeto_config   
                        where 1 = 1   
                        and ocf_objeto = 'Cfg_centro_servicio' 
                        and ocf_objeto_codigo = :suc_correlativo 
                        and ocf_estado = 'A'     
                    ) 
                    and pro_empresa =:emp_codigo
                    and pro_ambiente =:amb_codigo
                    and pro_estado = 'A'
                    and pro_clasificacion = 2   
                    order by pro_nombre asc";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'suc_correlativo'=>$suc_correlativo,
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo    
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        //if($cmb_tipo == 'options'){
                            array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una opción'));
                        //};
                        $totalRegistros =$stmt->rowCount();
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
}
