<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgUsuarioConfigController{
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $ucf_objeto = $parameter['ucf_objeto'] ?? "null";
                    $ucf_usuario = $parameter['ucf_usuario'] ?? "0";
                    $columnaConfig = "";
                    $tablaConfig = "";
                    if ($ucf_objeto =="Empresa") { $tablaConfig = "left outer join cfg_empresa on (emp_codigo = ucf_objeto_codigo and emp_estado = 'A') "; $columnaConfig = "emp_nombre as nombre, "; }
                    if ($ucf_objeto =="Agencia") {  $tablaConfig = "left outer join cfg_estructura_org on (est_correl = ucf_objeto_codigo and est_estado = 'A') "; $columnaConfig = "est_nombre as nombre, "; }
                    if ($ucf_objeto =="Ambiente") {  $tablaConfig = "left outer join cfg_empresa on (emp_codigo = ucf_empresa and emp_estado = 'A') left outer join cfg_ambiente on (amb_correl = ucf_objeto_codigo and amb_empresa = :emp_codigo and amb_estado = 'A') "; $columnaConfig = "amb_nombre as nombre, emp_codigo, emp_nombre, "; }
                    if ($ucf_objeto =="Organizacion") {  $tablaConfig = "left outer join cfg_organizacion on (org_empresa = ucf_empresa and org_estado = 'A' and ucf_objeto_codigo = org_correlativo) "; $columnaConfig = "org_nombre as nombre, org_correlativo, date_format(org_fechai, '%d/%m/%y %T')  org_fechai, "; }
                    
                    $sql = " select  
                    ucf_codigo,   
                    $columnaConfig  
                    (case ucf_objeto_default when 'S' then 'Si' when 'N' then 'No' else 'indefinido' end) as nom_objeto_default,   
                    (case ucf_objeto_default when 'S' then 'badge bg-blue' when 'N' then 'badge bg-red' else 'badge bg-gray' end) as col_objeto_default,   
                    concat(u1.usr_nombres || ' ' || u1.usr_apellidos) as usr_ing,   
                    date_format(ucf_fechai, '%d/%m/%y %T') as ucf_fechai,   
                    concat(u2.usr_nombres || ' ' || u2.usr_apellidos) as usr_mod,   
                    date_format(ucf_fecham, '%d/%m/%y %T') as ucf_fecham   
                    from cfg_usuario_config   
                    $tablaConfig
                    left outer join cfg_usuario u1 on (u1.usr_correl = ucf_usuarioi)   
                    left outer join cfg_usuario u2 on (u2.usr_correl = ucf_usuariom)   
                    where 1 = 1  
                    and ucf_objeto = :ucf_objeto
                    and ucf_usuario = :ucf_usuario
                    limit $pag_inicio, $tamanio 
                    ";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(["ucf_objeto"=>$ucf_objeto,"ucf_usuario"=>$ucf_usuario]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if ($stmt->rowCount() > 0) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_usuario_config", " and ucf_objeto = :ucf_objeto and ucf_usuario = :ucf_usuario",
                        ["ucf_objeto"=>$ucf_objeto,"ucf_usuario"=>$ucf_usuario]);
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>0);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'nuevo');
                if($userFuncionality == 'OK'){
                    $ucf_codigo = $utility->CorrelAutomatico($PDO, "cfg_usuario_config", "ucf_codigo", "");
                    $ucf_objeto= $parameter['ucf_objeto'] ?? 'null';
                    $ucf_objeto_codigo= $parameter['ucf_objeto_codigo'] ?? 'null';
                    $ucf_objeto_default= $parameter['ucf_objeto_default'] ?? 'N';
                    $ucf_usuario= $parameter['ucf_usuario'] ?? 'null';
                    $ucf_tipo_asignacion= $parameter['ucf_tipo_asignacion'] ?? '0';
                    
                    
                    
                    $sql = " insert into cfg_usuario_config (
                        ucf_codigo,
                        ucf_empresa,
                        ucf_objeto,
                        ucf_objeto_codigo,
                        ucf_objeto_default,
                        ucf_usuario,
                        ucf_tipo_asignacion,
                        ucf_estado,
                        ucf_usuarioi,
                        ucf_usuariom,
                        ucf_fechai,
                        ucf_fecham
                        ) values(
                            :ucf_codigo,
                            :emp_codigo,
                            :ucf_objeto,
                            :ucf_objeto_codigo,
                            :ucf_objeto_default,
                            :ucf_usuario,
                            :ucf_tipo_asignacion,
                            'A',
                            :ucf_usuarioi,
                            :ucf_usuarioi,
                            now(),
                            now()
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'ucf_codigo' => $ucf_codigo,
                        'emp_codigo' => $emp_codigo,
                        'ucf_objeto' => $ucf_objeto,
                        'ucf_objeto_codigo' => $ucf_objeto_codigo,
                        'ucf_objeto_default' => $ucf_objeto_default,
                        'ucf_usuario' => $ucf_usuario,
                        'ucf_tipo_asignacion' => $ucf_tipo_asignacion,
                        'ucf_usuarioi' => $id_usuario
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Configuración registrada exitosamente', 'status'=>200,'token'=>$token,'key'=>$ucf_codigo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Configuración no pudo ser registrada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_funcionalidad', 'eliminar');
                if($userFuncionality == 'OK'){
                    $ucf_codigo= $parameter['ucf_codigo'] ?? '0';
                    
                    
                    $sql = " delete from  cfg_usuario_config 
                        where ucf_codigo = :ucf_codigo
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['ucf_codigo' => $ucf_codigo]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Configuración eliminada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Configuración no pudo ser eliminada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
}