<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgUsuarioController{
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $usr_estado = $parameter['usr_estado'] ?? "A";
                    $fecha_inicio = $parameter['fecha_inicio'] ?? "null";
                    $fecha_fin = $parameter['fecha_fin'] ?? "null";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    $filtro = "";

                    if($id_usuario == 1){
                        $filtro = "";
                    }else{
                        $filtro = " AND u0.usr_correl > 1 ";
                    }
                    
                    $sql = "select  
                    u0.usr_correl, 
                    u0.usr_codigo,  
                    u0.usr_nombres,
                    u0.usr_apellidos,
                    u0.usr_password, 
                    u0.usr_estado,  
                    u0.usr_telefono,
                    u0.usr_celular,
                    (case u0.usr_estado when 'A' then 'activo' when 'I' then 'inactivo' else 'indefinido' end) as nom_usr_estado,  
                    (case u0.usr_estado when 'A' then 'badge bg-green' when 'I' then 'badge bg-red' else 'badge bg-gray' end) as col_usr_estado, 
                    u0.usr_email, 
                    u0.usr_tipo,
                    d.cat_nombre as name_usr_tipo,
                    u0.usr_url_home,
                    e.cat_nombre as url_home,
                    u0.usr_colegiado,
                    concat(u1.usr_nombres,' ',u1.usr_apellidos)as usr_usuarioi,  
                    date_format(u0.usr_fechai, '%d/%m/%y %T') as usr_fechai,     
                    concat(u2.usr_nombres,' ',u2.usr_apellidos)as usr_usuariom,  
                    date_format(u0.usr_fecham, '%d/%m/%y %T') as usr_fecham 			
                    from cfg_usuario u0 
                    left outer join cfg_usuario u1 on (u1.usr_correl = u0.usr_usuarioi)  
                    left outer join cfg_usuario u2 on (u2.usr_correl = u0.usr_usuariom)
                    left outer join cfg_catalogo d on(u0.usr_tipo= d.cat_valor and d.cat_tipo = 'USR_TIPO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_catalogo e on(u0.usr_url_home= e.cat_valor and e.cat_tipo = 'URL_MODULOS' and e.cat_empresa = :emp_codigo)
                    where 1 = 1 
                    $filtro
                    and ((u0.usr_nombres like concat('%',:filter,'%') or u0.usr_apellidos like concat('%',:filter,'%') or u0.usr_email like concat ('%',:filter,'%')) or (:filter = 'undefined'))
                    and u0.usr_empresa = :emp_codigo
                    and u0.usr_estado = :usr_estado
                    and (u0.usr_fechai >= STR_TO_DATE(:fecha_inicio,'%d/%m/%y %T') OR :fecha_inicio ='null' )
                    and (u0.usr_fechai <= STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin = 'null' ) 
                    order by u0.usr_correl 
                    limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,'usr_estado'=>$usr_estado,'fecha_inicio'=>$fecha_inicio,'fecha_fin'=>$fecha_fin,
                    'filter'=>$filter]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if ($stmt->rowCount() > 0) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_usuario", " and ((usr_nombres like concat('%',:filter,'%') or usr_apellidos like concat('%',:filter,'%') or usr_email like concat ('%',:filter,'%')) or (:filter = 'undefined'))
                        and usr_empresa = :emp_codigo
                        and usr_estado = :usr_estado
                        and (usr_fechai >= STR_TO_DATE(:fecha_inicio,'%d/%m/%y %T') OR :fecha_inicio ='null' )
                        and (usr_fechai <= STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin = 'null' ) ", 
                        ['emp_codigo' => $emp_codigo,'usr_estado'=>$usr_estado,'fecha_inicio'=>$fecha_inicio,'fecha_fin'=>$fecha_fin,
                    'filter'=>$filter]);
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'totalRegistros'=>0,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'nuevo');
                if($userFuncionality == 'OK'){
                    $credencialesValidas = false;
                    $usr_correl = $utility->CorrelAutomatico($PDO, "cfg_usuario", "usr_correl", "");
                    $usr_nombres= $parameter['usr_nombres'] ?? 'null';
                    $usr_apellidos= $parameter['usr_apellidos'] ?? 'null';
                    $usr_password= $parameter['usr_password'] ?? 'null';
                    $usr_estado= $parameter['usr_estado'] ?? 'A';
                    $usr_tipo= $parameter['usr_tipo'] ?? '1';
                    $usr_url_home= $parameter['usr_url_home'] ?? NULL;
                    $usr_email= $parameter['usr_email'] ?? 'null';
                    $usr_telefono= $parameter['usr_telefono'] ?? 'null';
                    $usr_celular= $parameter['usr_celular'] ?? 'null';
                    $usr_colegiado= $parameter['usr_colegiado'] ?? NULL;
                    
                    $encriptacion = crypt($usr_password, '$2a$07$asxx54ahjppf45sd87a5a4dDDGsystemdev$');
                    
                    $sql = "insert into 
                    cfg_usuario ( 
                        usr_correl,
                        usr_codigo,
                        usr_empresa,
                        usr_nombres,
                        usr_apellidos,
                        usr_password,
                        usr_estado,
                        usr_tipo,
                        usr_url_home,
                        usr_colegiado,
                        usr_email,
                        usr_telefono,
                        usr_celular,
                        usr_usuarioi,
                        usr_usuariom,
                        usr_fechai,
                        usr_fecham
                    ) values ( 
                        :usr_correl,
                        :usr_correl,
                        :usr_empresa,
                        :usr_nombres,
                        :usr_apellidos,
                        :usr_password,
                        :usr_estado,
                        :usr_tipo,
                        :usr_url_home,
                        :usr_colegiado,
                        :usr_email,
                        :usr_telefono,
                        :usr_celular,
                        :usr_usuarioi,
                        :usr_usuarioi,
                        now(),
                        now()
                    )";
                    
                if(preg_match('/^[^0-9][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/', $usr_email) && preg_match('/^[a-zA-Z0-9#*]+$/', $usr_password)){
                    $credencialesValidas = true;
                }else{
                    $credencialesValidas = false;
                } 

                if($credencialesValidas == true){               
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'usr_correl' => $usr_correl,
                        'usr_codigo' => $usr_correl,
                        'usr_empresa' => $emp_codigo,
                        'usr_nombres' => $usr_nombres,
                        'usr_apellidos' => $usr_apellidos,
                        'usr_password' => $encriptacion,
                        'usr_estado' => $usr_estado,
                        'usr_tipo' => $usr_tipo,
                        'usr_url_home' => $usr_url_home,
                        'usr_email' => $usr_email,
                        'usr_telefono' => $usr_telefono,
                        'usr_celular' => $usr_celular,
                        'usr_usuarioi' => $id_usuario,
                        'usr_colegiado' => $usr_colegiado
                    ]);
                    if ($result == true) {						
                        $utility->insertUsuarioConfig($PDO,$emp_codigo,"empresa",1,"S",$usr_correl,$id_usuario);						$utility->insertUsuarioConfig($PDO,$emp_codigo,"ambiente",1,"S",$usr_correl,$id_usuario);
                        $data = array('estado'=>'OK', 'mensaje'=>'Usuario registrado exitosamente', 'status'=>200,'token'=>$token,'key'=>$usr_correl);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Usuario no pudo ser registrado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>'Usuario no pudo ser registrado, por favor revise el correo y contraseña', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'modificar');
                if($userFuncionality == 'OK'){
                    $credencialesValidas = false;
                    $usr_correl= $parameter['usr_correl'] ?? '0';
                    $usr_nombres= $parameter['usr_nombres'] ?? 'null';
                    $usr_apellidos= $parameter['usr_apellidos'] ?? 'null';
                    $usr_password= $parameter['usr_password'] ?? 'null';
                    $usr_estado= $parameter['usr_estado'] ?? 'A';
                    $usr_tipo= $parameter['usr_tipo'] ?? '1';
                    $usr_url_home= $parameter['usr_url_home'] ?? NULL;
                    $usr_email= $parameter['usr_email'] ?? 'null';
                    $usr_telefono= $parameter['usr_telefono'] ?? 'null';
                    $usr_celular= $parameter['usr_celular'] ?? 'null';
                    $usr_colegiado= $parameter['usr_colegiado'] ?? NULL;
                    
                    $encriptacion = crypt($usr_password, '$2a$07$asxx54ahjppf45sd87a5a4dDDGsystemdev$');
                    
                    $sql = "update cfg_usuario set 
                    usr_nombres=:usr_nombres,
                    usr_apellidos=:usr_apellidos,
                    usr_password=:usr_password,
                    usr_estado=:usr_estado,
                    usr_tipo=:usr_tipo,
                    usr_url_home=:usr_url_home,
                    usr_colegiado=:usr_colegiado,
                    usr_email=:usr_email,
                    usr_telefono=:usr_telefono,
                    usr_celular=:usr_celular,
                    usr_usuariom=:usr_usuariom,
                    usr_fecham=now()
                    where
                    usr_correl=:usr_correl";

                if(preg_match('/^[^0-9][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/', $usr_email) && preg_match('/^[a-zA-Z0-9#*]+$/', $usr_password)){
                    $credencialesValidas = true;
                }else{
                    $credencialesValidas = false;
                }

                if($credencialesValidas == true){
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'usr_correl' => $usr_correl,
                        'usr_nombres' => $usr_nombres,
                        'usr_apellidos' => $usr_apellidos,
                        'usr_password' => $encriptacion,
                        'usr_estado' => $usr_estado,
                        'usr_tipo' => $usr_tipo,
                        'usr_url_home' => $usr_url_home,
                        'usr_email' => $usr_email,
                        'usr_telefono' => $usr_telefono,
                        'usr_celular' => $usr_celular,
                        'usr_usuariom' => $id_usuario,
                        'usr_colegiado' => $usr_colegiado
        
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Usuario actualizado exitosamente', 'status'=>200,'token'=>$token,'usr_correl'=>$usr_correl);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Usuario no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>'Usuario no pudo ser registrado, por favor revise el correo y contraseña', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'eliminar');
                if($userFuncionality == 'OK'){
                    $usr_correl = $parameter['usr_correl'] ?? "0";
                    
                    
                    $sql = " update cfg_usuario set
                        usr_estado = 'E',
                        usr_usuariom = :usr_usuariom,
                        usr_fecham = now()
                        where usr_correl = :usr_correl
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute(['usr_correl' => $usr_correl,'usr_usuariom'=>$id_usuario]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Usuario eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Usuario no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function userProfile($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $utility = new UtilityDB();

                $userFuncionality = "OK";//$utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');
                if($userFuncionality == 'OK'){
                    
                    
                    
                    $sql = "select  
                    u0.usr_correl, 
                    u0.usr_codigo,  
                    u0.usr_nombres,
                    u0.usr_apellidos,
                    u0.usr_estado,  
                    u0.usr_telefono,
                    u0.usr_celular,
                    u0.usr_titulo,
                    (case u0.usr_estado when 'A' then 'activo' when 'I' then 'inactivo' else 'indefinido' end) as nom_usr_estado,  
                    (case u0.usr_estado when 'A' then 'badge bg-green' when 'I' then 'badge bg-red' else 'badge bg-gray' end) as col_usr_estado, 
                    u0.usr_email, 
                    concat(u1.usr_nombres,' ',u1.usr_apellidos)as usr_usuarioi,  
                    date_format(u0.usr_fechai, '%d/%m/%y %T') as usr_fechai,     
                    concat(u2.usr_nombres,' ',u2.usr_apellidos)as usr_usuariom,  
                    date_format(u0.usr_fecham, '%d/%m/%y %T') as usr_fecham 			
                    from cfg_usuario u0 
                    left outer join cfg_usuario u1 on (u1.usr_correl = u0.usr_usuarioi)  
                    left outer join cfg_usuario u2 on (u2.usr_correl = u0.usr_usuariom) 
                    where 1 = 1 
                    and u0.usr_empresa = :emp_codigo
                    and u0.usr_estado = 'A'
                    and u0.usr_correl = :usr_correl
                    limit 1
                    ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                    'usr_correl'=>$id_usuario]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if ($stmt->rowCount() > 0) {
                        $totalRegistros = 1;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'totalRegistros'=>0,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function updateProfile($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $login = $request->getAttribute('login');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $validateUser = 0;
                $userFuncionality ="OK";
                if($userFuncionality == 'OK'){
                    
                    $usr_nombres= $parameter['usr_nombres'] ?? 'null';
                    $usr_apellidos= $parameter['usr_apellidos'] ?? 'null';
                    $usr_password= $parameter['usr_password'] ?? 'null';
                    $usr_pass_nuevo= $parameter['usr_pass_nuevo'] ?? 'undefined';
                    $usr_titulo= $parameter['usr_titulo'] ?? '';
                    $usr_email= $parameter['usr_email'] ?? 'null';
                    $usr_telefono= $parameter['usr_telefono'] ?? 'null';
                    $usr_celular= $parameter['usr_celular'] ?? 'null';
                    
                    if($usr_pass_nuevo != 'undefined' && $usr_pass_nuevo != ''){
                        $validateUser = $utility->validateUser($PDO,$login,$usr_password);
                    }else{
                        $validateUser = 1;
                    }

                    if($usr_pass_nuevo != 'undefined' && $usr_pass_nuevo != ''){
                        $usr_password = $usr_pass_nuevo;
                    }else{
                        $usr_password = 'undefined';
                    }
                    
                    if($validateUser > 0){
                        $sql = "update cfg_usuario set 
                        usr_nombres=:usr_nombres,
                        usr_apellidos=:usr_apellidos,
                        usr_password= (case when :usr_password = 'undefined' then usr_password else :usr_password end),
                        usr_email=:usr_email,
                        usr_titulo=:usr_titulo,
                        usr_telefono=:usr_telefono,
                        usr_celular=:usr_celular,
                        usr_usuariom=:usr_usuariom,
                        usr_fecham=now()
                        where
                        usr_correl=:usr_correl";
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'usr_correl' => $id_usuario,
                            'usr_nombres' => $usr_nombres,
                            'usr_apellidos' => $usr_apellidos,
                            'usr_password' => $usr_password,
                            'usr_email' => $usr_email,
                            'usr_telefono' => $usr_telefono,
                            'usr_celular' => $usr_celular,
                            'usr_usuariom' => $id_usuario,
                            'usr_titulo'=>$usr_titulo
            
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Usuario actualizado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Usuario no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Contraseña incorrecta, intente nuevamente', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }

                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
}