<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class CfgUsuarioSucursalController {
	
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $uro_usuario = $parameter['uro_usuario'] ?? "0";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $ucf_objeto = $parameter['ucf_objeto'] ?? 'sucursal';
                    
                    $sql = "
                    select                    
                    ucf_codigo,   
                    ucf_empresa,   
                    ucf_objeto,
                    ucf_objeto_codigo,
                    ucf_objeto_default,
                    ucf_usuario,
                    ucf_tipo_asignacion,
                    ucf_estado,
                    ucf_usuarioi,
                    ucf_usuariom,
                    ucf_fechai,
                    ucf_fecham,
                    suc.suc_nombre as suc_nombre, 
                    u1.usr_nombres || ' ' || u1.usr_apellidos as usr_ing,  
                    DATE_FORMAT(ucf_fechai, '%T %d/%m/%Y') as uro_fechai,   
                    u2.usr_nombres || ' ' || u2.usr_apellidos as usr_mod,   
                    DATE_FORMAT(ucf_fecham, 'DD/MM/YYYY HH24:MI:SS a.m.') as uro_fecham   
                    from cfg_usuario_config   
                    left outer join cfg_sucursal suc on (suc.suc_correlativo = ucf_objeto_codigo and suc.suc_empresa =:emp_codigo  and suc.suc_estado = 'A') 
                    left outer join cfg_usuario u1 on (u1.usr_correl = ucf_usuarioi)   
                    left outer join cfg_usuario u2 on (u2.usr_correl = ucf_usuariom)   
                    where 1 = 1   
                    and ucf_usuario = :uro_usuario 
                    and ucf_empresa = :emp_codigo 
                    and ucf_objeto = :ucf_objeto
                    limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(["uro_usuario"=>$uro_usuario,"emp_codigo"=>$emp_codigo,"ucf_objeto"=>$ucf_objeto]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_usuario_config", "and ucf_usuario = :uro_usuario and ucf_empresa = :emp_codigo and ucf_objeto = :ucf_objeto",
                        ["uro_usuario"=>$uro_usuario,"emp_codigo"=>$emp_codigo,"ucf_objeto"=>$ucf_objeto]);

                        //array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'Seleccione una opción'));
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>0);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function selectCentrosAsignadosAUsuario($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $uro_usuario = $parameter['uro_usuario'] ?? "0";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $ucf_objeto = $parameter['ucf_objeto'] ?? 'sucursal';
                    
                    $sql = "
                    select                    
                    ucf_codigo,   
                    ucf_empresa,   
                    ucf_objeto,
                    ucf_objeto_codigo,
                    ucf_objeto_default,
                    ucf_usuario,
                    ucf_tipo_asignacion,
                    ucf_estado,
                    ucf_usuarioi,
                    ucf_usuariom,
                    ucf_fechai,
                    ucf_fecham,
                    suc.suc_nombre as suc_nombre, 
                    u1.usr_nombres || ' ' || u1.usr_apellidos as usr_ing,  
                    DATE_FORMAT(ucf_fechai, '%T %d/%m/%Y') as uro_fechai,   
                    u2.usr_nombres || ' ' || u2.usr_apellidos as usr_mod,   
                    DATE_FORMAT(ucf_fecham, 'DD/MM/YYYY HH24:MI:SS a.m.') as uro_fecham   
                    from cfg_usuario_config   
                    left outer join cfg_sucursal suc on (suc.suc_correlativo = ucf_objeto_codigo and suc.suc_empresa =:emp_codigo  and suc.suc_estado = 'A') 
                    left outer join cfg_usuario u1 on (u1.usr_correl = ucf_usuarioi)   
                    left outer join cfg_usuario u2 on (u2.usr_correl = ucf_usuariom)   
                    where 1 = 1   
                    and ucf_usuario = :uro_usuario 
                    and ucf_empresa = :emp_codigo 
                    and ucf_objeto = :ucf_objeto
                    limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(["uro_usuario"=>$uro_usuario,"emp_codigo"=>$emp_codigo,"ucf_objeto"=>$ucf_objeto]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_usuario_config", "and ucf_usuario = :uro_usuario and ucf_empresa = :emp_codigo and ucf_objeto = :ucf_objeto",
                        ["uro_usuario"=>$uro_usuario,"emp_codigo"=>$emp_codigo,"ucf_objeto"=>$ucf_objeto]);

                        array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'Seleccione una opción'));
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>0);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function selectCentrosUsuarioCmenAgenda($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $uro_usuario = $parameter['uro_usuario'] ?? "0";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $ucf_objeto = $parameter['ucf_objeto'] ?? 'sucursal';
                    
                    $sql = "
                    select                    
                    ucf_codigo,   
                    ucf_empresa,   
                    ucf_objeto,
                    ucf_objeto_codigo,
                    ucf_objeto_default,
                    ucf_usuario,
                    ucf_tipo_asignacion,
                    ucf_estado,
                    ucf_usuarioi,
                    ucf_usuariom,
                    ucf_fechai,
                    ucf_fecham,
                    suc.suc_nombre as suc_nombre, 
                    suc.suc_horario_lunes_a_viernes_inicio as hora_inicio_lav, 
                    suc.suc_horario_lunes_a_viernes_fin as hora_fin_lav, 
                    suc.suc_horario_sabado_inicio as hora_inicio_sabado, 
                    suc.suc_horario_sabado_fin as hora_fin_sabado, 
                    suc.suc_horario_domingo_inicio as hora_inicio_domingo, 
                    suc.suc_horario_domingo_fin as hora_fin_domingo, 
                    u1.usr_nombres || ' ' || u1.usr_apellidos as usr_ing,  
                    DATE_FORMAT(ucf_fechai, '%T %d/%m/%Y') as uro_fechai,   
                    u2.usr_nombres || ' ' || u2.usr_apellidos as usr_mod,   
                    DATE_FORMAT(ucf_fecham, 'DD/MM/YYYY HH24:MI:SS a.m.') as uro_fecham   
                    from cfg_usuario_config   
                    left outer join cfg_sucursal suc on (suc.suc_correlativo = ucf_objeto_codigo and suc.suc_empresa =:emp_codigo  and suc.suc_estado = 'A') 
                    left outer join cfg_usuario u1 on (u1.usr_correl = ucf_usuarioi)   
                    left outer join cfg_usuario u2 on (u2.usr_correl = ucf_usuariom)   
                    where 1 = 1   
                    and ucf_usuario = :uro_usuario 
                    and ucf_empresa = :emp_codigo 
                    and ucf_objeto = :ucf_objeto
                    limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(["uro_usuario"=>$uro_usuario,"emp_codigo"=>$emp_codigo,"ucf_objeto"=>$ucf_objeto]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_usuario_config", "and ucf_usuario = :uro_usuario and ucf_empresa = :emp_codigo and ucf_objeto = :ucf_objeto",
                        ["uro_usuario"=>$uro_usuario,"emp_codigo"=>$emp_codigo,"ucf_objeto"=>$ucf_objeto]);

                        array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'Seleccione una opción'));
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>0);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function selectCentrosUsuarioTabla($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $uro_usuario = $parameter['uro_usuario'] ?? "0";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $ucf_objeto = $parameter['ucf_objeto'] ?? 'sucursal';
                    
                    $sql = "
                    select                    
                    ucf_codigo,   
                    ucf_empresa,   
                    ucf_objeto,
                    ucf_objeto_codigo,
                    ucf_objeto_default,
                    ucf_usuario,
                    ucf_tipo_asignacion,
                    ucf_estado,
                    ucf_usuarioi,
                    ucf_usuariom,
                    ucf_fechai,
                    ucf_fecham,
                    suc.suc_nombre as suc_nombre, 
                    u1.usr_nombres || ' ' || u1.usr_apellidos as usr_ing,  
                    DATE_FORMAT(ucf_fechai, '%T %d/%m/%Y') as uro_fechai,   
                    u2.usr_nombres || ' ' || u2.usr_apellidos as usr_mod,   
                    DATE_FORMAT(ucf_fecham, 'DD/MM/YYYY HH24:MI:SS a.m.') as uro_fecham   
                    from cfg_usuario_config   
                    left outer join cfg_sucursal suc on (suc.suc_correlativo = ucf_objeto_codigo and suc.suc_empresa =:emp_codigo  and suc.suc_estado = 'A') 
                    left outer join cfg_usuario u1 on (u1.usr_correl = ucf_usuarioi)   
                    left outer join cfg_usuario u2 on (u2.usr_correl = ucf_usuariom)   
                    where 1 = 1   
                    and ucf_usuario = :uro_usuario 
                    and ucf_empresa = :emp_codigo 
                    and ucf_objeto = :ucf_objeto
                    and ucf_estado = 'A' 
                    limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(["uro_usuario"=>$uro_usuario,"emp_codigo"=>$emp_codigo,"ucf_objeto"=>$ucf_objeto]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_usuario_config", "and ucf_usuario = :uro_usuario and ucf_empresa = :emp_codigo and ucf_objeto = :ucf_objeto",
                        ["uro_usuario"=>$uro_usuario,"emp_codigo"=>$emp_codigo,"ucf_objeto"=>$ucf_objeto]);

                        //array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'Seleccione una opción'));
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>0);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function selectCentros($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $uro_usuario = $parameter['uro_usuario'] ?? "0";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $ucf_objeto = $parameter['ucf_objeto'] ?? 'sucursal';
                    
                    $sql = "
                    select                    
                    ucf_codigo,   
                    ucf_empresa,   
                    ucf_objeto,
                    ucf_objeto_codigo,
                    ucf_objeto_default,
                    ucf_usuario,
                    ucf_tipo_asignacion,
                    ucf_estado,
                    ucf_usuarioi,
                    ucf_usuariom,
                    ucf_fechai,
                    ucf_fecham,
                    suc.suc_nombre as suc_nombre, 
                    u1.usr_nombres || ' ' || u1.usr_apellidos as usr_ing,  
                    DATE_FORMAT(ucf_fechai, '%T %d/%m/%Y') as uro_fechai,   
                    u2.usr_nombres || ' ' || u2.usr_apellidos as usr_mod,   
                    DATE_FORMAT(ucf_fecham, 'DD/MM/YYYY HH24:MI:SS a.m.') as uro_fecham   
                    from cfg_usuario_config   
                    left outer join cfg_sucursal suc on (suc.suc_correlativo = ucf_objeto_codigo and suc.suc_empresa =:emp_codigo  and suc.suc_estado = 'A') 
                    left outer join cfg_usuario u1 on (u1.usr_correl = ucf_usuarioi)   
                    left outer join cfg_usuario u2 on (u2.usr_correl = ucf_usuariom)   
                    where 1 = 1   
                    and ucf_usuario = :uro_usuario 
                    and ucf_empresa = :emp_codigo 
                    and ucf_objeto = :ucf_objeto
                    limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(["uro_usuario"=>$uro_usuario,"emp_codigo"=>$emp_codigo,"ucf_objeto"=>$ucf_objeto]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_usuario_config", "and ucf_usuario = :uro_usuario and ucf_empresa = :emp_codigo and ucf_objeto = :ucf_objeto",
                        ["uro_usuario"=>$uro_usuario,"emp_codigo"=>$emp_codigo,"ucf_objeto"=>$ucf_objeto]);

                        array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'Seleccione una opción'));
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>0);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function selectUser($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'nuevo');
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'modificar');

                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $usr_estado = $parameter['usr_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.usr_correl, 
                    a.usr_codigo,  
                    a.usr_empresa, 
                    a.usr_nombres,  
                    (a.usr_nombres ||' '|| a.usr_apellidos) as usr_nombres_apellidos,
                    a.usr_apellidos,  
                    a.usr_estado, 
                    a.usr_email, 
                    a.usr_telefono, 
                    a.usr_celular, 
                    d.cat_nombre cat_estado_nombre,   
                    a.usr_fechai,  
                    a.usr_fecham,  
                     b.usr_nombres ||' '|| b.usr_apellidos as suc_usuarioi,  
                     c.usr_nombres ||' '|| c.usr_apellidos as suc_usuariom  

                    from cfg_usuario a
                    left outer join cfg_catalogo d on(a.usr_estado= d.cat_valor and d.cat_tipo = 'usr_estado' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.usr_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.usr_usuariom)

                    
                    where 
                    1=1
                     and a.usr_empresa = :emp_codigo 
                     and a.usr_estado =:usr_estado
                     and ((a.usr_nombres like '%'||:filter||'%' or a.usr_apellidos like '%'||:filter||'%' or a.usr_email like '%'||:filter||'%') or (:filter = 'undefined'))
                     and (a.usr_fechai >=to_date(:fecha_ini|| '00:00', 'dd/mm/yyyy hh24:mi') OR :fecha_ini='01/01/1900') 
                     and (a.usr_fechai <=to_date(:fecha_fin|| '23:59', 'dd/mm/yyyy hh24:mi') OR :fecha_fin='01/01/1900') 

                    )
                    limit $pag_inicio, $tamanio ";
                    //echo $sql;
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'emp_codigo' => $emp_codigo,
                    'usr_estado' => $usr_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'filter'=>$filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_usuario a 
                            left outer join cfg_catalogo d on(a.usr_estado= d.cat_valor and d.cat_tipo = 'SUCURSAL_ESTADO' and d.cat_empresa = :emp_codigo)
                            left outer join cfg_usuario b on (b.usr_correl = a.usr_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.usr_usuariom)
                            ", "   and a.usr_empresa = :emp_codigo 
                             and a.usr_estado =:usr_estado 

                             and ((a.usr_nombres like '%'||:filter||'%' or a.usr_apellidos like '%'||:filter||'%' or a.usr_email like '%'||:filter||'%') or (:filter = 'undefined')) 

                             and (a.usr_fechai >=to_date(:fecha_ini|| '00:00', 'dd/mm/yyyy hh24:mi') OR :fecha_ini='01/01/1900') 
                             and (a.usr_fechai <=to_date(:fecha_fin|| '23:59', 'dd/mm/yyyy hh24:mi') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'usr_estado' => $usr_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter'=>$filter
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }

    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'nuevo');
                if($userFuncionality == 'OK'){
                    $uro_codigo = $utility->CorrelAutomatico($PDO, "cfg_usuario_config", "ucf_codigo", "");
                    $uro_usuario= (int)$parameter['uro_usuario'] ?? 0;
                    $suc_correlativo= (int)$parameter['suc_correlativo'] ?? 0;
                    
                    
                    $sql = " insert into cfg_usuario_config (
                        ucf_codigo,
                        ucf_empresa,
                        ucf_objeto,
                        ucf_objeto_codigo,
                        ucf_objeto_default,
                        ucf_usuario,
                        ucf_tipo_asignacion,
                        ucf_estado,
                        ucf_usuarioi,
                        ucf_usuariom,
                        ucf_fechai,
                        ucf_fecham
                        ) values(
                            :uro_codigo,
                            :emp_codigo,
                            'sucursal',
                            :suc_correlativo,
                            'S',
                            :uro_usuario,
                            0,
                            'A',
                            :uro_usuarioi,
                            :uro_usuarioi,
                            now(),
                            now()
                        )
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'uro_codigo' => $uro_codigo,
                        'emp_codigo' => $emp_codigo,
                        'uro_usuario' => $uro_usuario,
                        'suc_correlativo' => $suc_correlativo,
                        'uro_usuarioi' => $id_usuario
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Sucursal registrado exitosamente', 'status'=>200,'token'=>$token,'key'=>$uro_codigo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Sucursal no pudo ser registrado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');

                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_usuario', 'eliminar');
                if($userFuncionality == 'OK'){
                    $uro_codigo= (int)$parameter['uro_codigo'] ?? 0;
                    $ucf_codigo= (int)$parameter['ucf_codigo'] ?? 0;
                    
                    
                    $sql = "delete from  cfg_usuario_config 
                        where 1=1 and ucf_codigo = :ucf_codigo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'ucf_codigo' => $ucf_codigo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Sucursal eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Sucursal no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function cmbSucursales($request, $response, $args) {//CARGA TODOS LOS CENTROS DISPONIBLES EN EL COMBO
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $uro_usuario = (int)$parameter['uro_usuario'] ?? 0;
                    $cmb_tipo = $parameter['cmb_tipo'] ?? "options";
                        
                    $sql = " select   
                    suc_correlativo,   
                    suc_nombre   
                    from cfg_sucursal   
                    where 1 = 1   
                        and suc_correlativo not in (   
                        select   
                        ucf_objeto_codigo   
                        from cfg_usuario_config   
                        where 1 = 1   
                        and ucf_objeto = 'sucursal' 
                        and ucf_objeto_codigo = suc_correlativo
                        and ucf_usuario =:uro_usuario 
                        and ucf_estado = 'A'     
                    ) 
                    and suc_empresa =:emp_codigo
                    and suc_ambiente =:amb_codigo
                    and suc_estado = 'A'   
                    order by suc_nombre asc";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'uro_usuario'=>$uro_usuario,
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo    
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        if($cmb_tipo == 'options'){
                            array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'Seleccione una opción'));
                        };
                        $totalRegistros =$stmt->rowCount();
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    
}
