<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use Exception;
use PDOException;
use Slim\Http\UploadedFile;
use Slim\Psr7\UploadedFile as Psr7UploadedFile;
class FunctionsController{
    public function userMenu($request,$response,$args){
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $login = $request->getAttribute('login');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                
                $sql =" select distinct
                fun_correlativo,fun_codigo,fua_titulo,fun_url,fun_padre,fun_nivel,
                fun_arbol,fun_icono
                from
                cfg_usuario,
                cfg_usuario_rol,
                cfg_rol,
                cfg_rol_funcionalidad,
                cfg_funcionalidad,
                cfg_funcionalidad_ambiente
                where
                usr_codigo = :id
                and usr_estado='A'
                and rol_empresa=:emp_codigo
                and rol_ambiente=:amb_codigo
                and uro_usuario = usr_codigo
                and rol_codigo = uro_rol
                and rol_estado = 'A'
                and fun_empresa = :emp_codigo
                and rof_rol = rol_codigo
                and fun_correlativo= rof_funcionalidad
                and fua_funcionalidad = fun_correlativo
                and fun_tipo = 'P'
                and fun_estado ='A'
                and rof_estado ='A'
                and fua_ambiente = :amb_codigo
                and fua_estado='A'
                and rof_lectura = 1
                order by fun_nivel,fun_arbol";
        
                $stmt = $PDO->prepare($sql);
                $stmt->execute(['id' => $id_usuario,'emp_codigo'=>$emp_codigo,'amb_codigo'=>$amb_codigo]);
                $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                if ($stmt->rowCount() > 0) {
                    
                    $data = array(
                        'estado'=>'OK', 
                        'data'=>$result,
                        'status'=>200,
                        'token'=>$token
                    );
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(200);
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>'El usuario no posee funcionalidades asociadas','data'=>array(), 'status'=>400);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(400);
                }
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(), 'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function objectAccess($request,$response,$args){
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $parameter = $request->getParsedBody();
                $objeto = $parameter['objeto'] ?? "no_object";
                //var_dump($objeto);
                $sql =" select 
                rof_lectura,rof_nuevo,rof_modificar,rof_eliminar,fua_titulo,fun_url,fun_icono
                from
                cfg_usuario,
                cfg_usuario_rol,
                cfg_rol,
                cfg_rol_funcionalidad,
                cfg_funcionalidad,
                cfg_funcionalidad_ambiente
                where
                usr_codigo = :id
                and usr_estado='A'
                and rol_empresa=:emp_codigo
                and rol_ambiente=:amb_codigo
                and uro_usuario = usr_codigo
                and rol_codigo = uro_rol
                and rol_estado = 'A'
                and fun_empresa = :emp_codigo
                and fun_estado = 'A'
                and rof_rol = rol_codigo
                and rof_estado = 'A'
                and fun_correlativo= rof_funcionalidad
                and fua_funcionalidad = fun_correlativo
                and fua_ambiente = :amb_codigo
                and fun_objeto = :objeto
                order by rof_lectura,rof_nuevo,rof_modificar,rof_eliminar desc
                limit 1";
        
                $stmt = $PDO->prepare($sql);
                $stmt->execute(['id' => $id_usuario,'emp_codigo'=>$emp_codigo,'amb_codigo'=>$amb_codigo,'objeto'=>$objeto]);								
                $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                if ($stmt->rowCount() > 0) {
                    
                    $data = array(
                        'estado'=>'OK', 
                        'data'=>$result,
                        'status'=>200,
                        'token'=>$token
                    );
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(200);
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>'El usuario no tiene acceso al recurso solicitado', 'token'=>$token,'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(), 'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function cmbCatalogo($request,$response,$args){
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $parameter = $request->getParsedBody();
                $cat_tipo = $parameter['cat_tipo'] ?? "no_object";
                $cmb_tipo = $parameter['cmb_tipo'] ?? "no_options";
                $cat_padre = $parameter['cat_padre'] ?? "undefined";
                
                $sql ="select
                cat_valor, 
                cat_nombre
                from cfg_catalogo
                where  
                upper(cat_tipo) = upper(:cat_tipo)
                and cat_estado = 'A' 
                and (cat_empresa=:emp_codigo or cat_empresa = -1)
                and (cat_ambiente=:amb_codigo or cat_ambiente=-1)
                and (cat_padre = :cat_padre or :cat_padre = 'undefined')
                order by cat_nombre,cat_arbol";
        
                $stmt = $PDO->prepare($sql);
                $stmt->execute(['cat_tipo' => $cat_tipo,'emp_codigo'=>$emp_codigo,'amb_codigo'=>$amb_codigo,'cat_padre'=>$cat_padre]);
                $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                if ($stmt->rowCount() > 0) {
                    if($cmb_tipo == 'options'){
                        array_unshift($result,array("cat_valor"=>'','cat_nombre'=>'Seleccione una opción'));
                    };
                    
                    $data = array(
                        'estado'=>'OK', 
                        'data'=>$result,
                        'status'=>200,
                        'token'=>$token
                    );
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(200);
                }else{
                    $data = array('estado'=>'NODATA', 'mensaje'=>'No existen valores para este objeto', 'status'=>200,'token'=>$token);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(200);
                }
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(), 'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
}