<?php
namespace App\Controllers;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use App\Controllers\BaseController;
use App\DB\DBConnection;
use PDOException;
use App\Security\Token;
use App\Utility\Word;
class LoginController{
    public function login($request,$response,$args){
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $parameter = $request->getParsedBody();
                $usrLogin = $parameter['usr_login'] ?? "";
                $usrPass = $parameter['usr_password'] ?? "";
                $encriptacion = crypt($usrPass, '$2a$07$asxx54ahjppf45sd87a5a4dDDGsystemdev$');
                
                $sql =" select 
                us.usr_codigo,
                concat(usr_nombres,' ',usr_apellidos)usr_nombre,
                ifnull(emp.emp_tema,'skin-blue-light')emp_tema,
                ifnull(emp.emp_codigo,0)emp_codigo,
                ifnull(amb.amb_correl,0)amb_codigo,
                ifnull(emp.emp_nombre,'')emp_nombre,
                ifnull(amb.amb_nombre,'')amb_nombre,
                us.usr_tipo,
                cat.cat_nombre as usr_url_home 
                from
                cfg_usuario us
                left outer join cfg_usuario_config us_emp on(us_emp.ucf_usuario = us.usr_codigo
                and us_emp.ucf_objeto = 'empresa' 
                and us_emp.ucf_objeto_default = 'S'
                and us_emp.ucf_estado = 'A'
                )
                left outer join cfg_usuario_config us_amb on(us_amb.ucf_usuario = us.usr_codigo
                and us_amb.ucf_objeto = 'ambiente'
                and us_amb.ucf_objeto_default = 'S'
                and us_amb.ucf_estado = 'A'
                )
                left outer join cfg_empresa emp on(emp.emp_codigo = us_emp.ucf_objeto_codigo)
                left outer join cfg_ambiente amb on(amb.amb_correl = us_amb.ucf_objeto_codigo)
                left outer join cfg_catalogo cat on(cat.cat_valor = us.usr_url_home and cat.cat_tipo = 'URL_MODULOS' and cat.cat_empresa = us_emp.ucf_objeto_codigo) 
                where
                1=1
                and us.usr_email = :usr_login
                and us.usr_password = :usr_password";
                $stmt = $PDO->prepare($sql);
                $stmt->execute(['usr_login' => $usrLogin,'usr_password'=>$encriptacion]);
                
                $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                if ($stmt->rowCount() > 0) {
                    $usr_codigo = $result[0]->usr_codigo;
                    $usr_nombre = $result[0]->usr_nombre;
                    $emp_tema = $result[0]->emp_tema;
                    $emp_codigo = $result[0]->emp_codigo;
                    $amb_codigo = $result[0]->amb_codigo;
                    $emp_nombre = $result[0]->emp_nombre;
                    $amb_nombre = $result[0]->amb_nombre;
                    $usr_perfil = $result[0]->usr_tipo;
                    $usr_url_home = $result[0]->usr_url_home;
                    $tokenCTL = new Token();
                    $token = strval ($tokenCTL->createToken($usr_codigo,$usrLogin,$emp_codigo,$amb_codigo)); 
                    $data = array(
                        'estado'=>'OK', 
                        'usr_nombre'=>$usr_nombre,
                        'mensaje'=>'Bienvenido: '.$usr_nombre, 
                        'emp_tema'=>$emp_tema,
                        'emp_nombre'=>$emp_nombre,
                        'amb_nombre'=>$amb_nombre,
                        'usr_perfil'=>$usr_perfil,
                        'usr_url_home'=>$usr_url_home,
                        'status'=>200,
                        'token'=>$token
                    );
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(200);
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>'El usuario o la contraseña son incorrectos.', 'status'=>200);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(200);
                }
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(), 'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
}