<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class TraAgendaMedicoController {

    public function selectSucursalAsignada($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraAgendaMedico', 'lectura');//Cfg_usuario //cfg_usuario_config
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();

                    
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 200;//$parameter['tamanio'] ?? 10;
                    $usr_tipo = 2;//$parameter['usr_tipo'] ?? 10;
                    $suc_estado = 'A';//$parameter['ucf_estado'] ?? "A";
                    //$age_suc_correlativo = $parameter['age_suc_correlativo'] ?? 0;
                    $parametro = "";
                    $filtro = "";
                   
                    $array_parametros = array(
                        'id_usuario'=>$id_usuario,
                        'ucf_objeto'=> 'sucursal'
                    );
                    
                    //$filter = $parameter['filter'] ?? "undefined";
                    
                    $sql = " select 
                            obj.ucf_objeto_codigo as suc_correlativo,
                            suc.suc_nombre as suc_nombre 
                            FROM cfg_usuario_config obj
                            INNER JOIN cfg_sucursal suc on(suc.suc_correlativo = obj.ucf_objeto_codigo and obj.ucf_estado !='E')
                            where 1=1 
                            and ucf_usuario = :id_usuario 
                            and ucf_objeto = :ucf_objeto order by obj.ucf_codigo asc 
                            limit $pag_inicio, $tamanio";

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute($array_parametros);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'Seleccione un centro'));
                        }else{
                            array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'No existen centros disponibles'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function selectConsultaSucursal($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraAgendaMedico', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    
                    $age_suc_correlativo = $parameter['age_suc_correlativo'] ?? 0;

                    //$filtro = "";

                    $tra_cm_estado = 'A';
                    $tra_etapa = 1;

                    //INICIO CONSULTA BLOQUEO AGENDA
                    $tra_ba_estado = 'A';
                    $pagInicio = 0;
                    $registros = 366;
                    $sqlBloqueoAgenda = " 
                    select 
                      date_format(tra_ba_fecha_inicio, '%Y-%m-%d 00:00') as tra_ba_fecha_inicio,
                      tra_ba_textcolor as textColor,
                      tra_ba_color as color,
                      tra_ba_rendering_background as rendering,
                      tra_ba_fecha_inicio as start,
                      tra_ba_etiqueta as title,
                      tra_ba_age_allDay as allDay 
                      from tra_bloqueo_agenda 
                      where 1=1
                      and tra_ba_suc_correlativo = :tra_ba_suc_correlativo 
                      and tra_ba_estado = :tra_ba_estado 
                      limit $pagInicio, $registros";

                    $stmt2 = $PDO->prepare($sqlBloqueoAgenda);
                    $stmt2->execute([
                        'tra_ba_estado' => $tra_ba_estado,
                        'tra_ba_suc_correlativo' => $age_suc_correlativo
                        ]);
                    $result1 = $stmt2->fetchAll($PDO::FETCH_ASSOC);
                    
                    $sql = " 
                    select 
                      tra.tra_cm_correlativo,
                      tra.tra_cm_correlativo as id,
                      tra.tra_cm_codigo,
                      tra.tra_cm_empresa,
                      tra.tra_cm_ambiente,
                      tra.tra_cm_procedencia,
                      tra.tra_cm_aseguradora,
                      ase.ase_nombre as tra_cm_nombre_aseguradora,
                      tra.tra_cm_primer_consulta,
                      if(tra.tra_cm_primer_consulta = 1,'Primera Consulta','Reconsulta') as tra_cm_descripcion_consulta,
                      tra.tra_cm_lugar_atencion,
                      tra.tra_cm_tipo_consulta,
                      tra.tra_cm_usr_correl,
                      cli.cli_correlativo,
                      cli.cli_nombre,
                      cli.cli_telefono1,
                      date_format(cli.cli_fecha_nacimiento, '%d/%m/%y') as cli_fecha_nacimiento,
                      cli.cli_email,
                      cli.cli_fecha_nacimiento as fecha_nacimiento,
                      date_format(tra.tra_cm_fecha_inicio_consulta, '%d/%m/%y %H:%i') as tra_cm_fecha_inicio_consulta, 
                      tra.tra_cm_fecha_inicio_consulta as fecha_inicio_consulta, 
                      tra.tra_cm_fecha_fin_consulta,
                      tra.tra_cm_fecha_inicio_consulta as start,
                      tra.tra_cm_fecha_fin_consulta as end,
                      date_format(tra.tra_cm_fecha_inicio_consulta, '%H:%i') as tra_cm_hora_inicio,
                      date_format(tra.tra_cm_fecha_fin_consulta, 'a %H:%i') as tra_cm_hora_fin,
                      concat(date_format(tra.tra_cm_fecha_inicio_consulta, '%H:%i'),'-',date_format(tra.tra_cm_fecha_fin_consulta, '%H:%i')) as duracionConsulta,
                      tra.tra_cm_nombre_paciente,
                      IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'MEDICO NO ASIGNADO') as tra_cm_nombre_medico,
                      pro.pro_nombre as tra_cm_nombre_especialidad,
                      pro.pro_color as tra_cm_color_etiqueta,

                      concat(date_format(tra.tra_cm_fecha_fin_consulta, '%H:%i'),'\n',(cli.cli_nombre),'\n',pro.pro_nombre) as title,
                      
                      pro.pro_color as backgroundColor,
                      pro.pro_color_texto as textColor,
                      pro.pro_tipo_ficha as tra_cm_tipo_ficha,
                      lug.suc_nombre as tra_cm_nombre_lugar_atencion,
                      concat(TIMESTAMPDIFF(MINUTE,tra.tra_cm_fecha_inicio_consulta,tra.tra_cm_fecha_fin_consulta),' ','Minutos') as tra_cm_duracion_minutos,
                      tra.tra_cm_fecha_nacimiento,
                      tra.tra_cm_telefono,
                      tra.tra_cm_direccion,
                      tra.tra_cm_etapa,
                      tra.tra_cm_paciente_intercalado,
                      if(tra.tra_cm_etapa = 1,'No Confirmado','Confirmado') as tra_cm_estado_consulta,
                      tra.tra_cm_fecha_confirmacion,
                      tra.tra_cm_cita_reprogramada_inicio,
                      tra.tra_cm_cita_reprogramada_fin,
                      IF(tra.tra_cm_observaciones = 'undefined', '',tra.tra_cm_observaciones) as tra_cm_observaciones,
                      tra.tra_cm_estado,
                      tra.tra_cm_usuarioi,
                      tra.tra_cm_usuariom,
                      tra.tra_cm_fechai,
                      tra.tra_cm_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra.tra_cm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra.tra_cm_fecham, '%d/%m/%y %T') as age_fecham,
                      cat.cat_nombre as tra_cm_nombre_procedencia 
                      from tra_consulta_medica tra 
                          left outer join cfg_usuario b on (b.usr_correl = tra.tra_cm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra.tra_cm_usuariom) 
                          left outer join cfg_producto pro on(tra.tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                          left outer join cfg_usuario med on (tra.tra_cm_usr_correl = med.usr_correl and med.usr_estado = 'A')
                          left outer join cfg_sucursal lug on (tra.tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = 'A') 
                          left outer join cfg_catalogo cat on(cat.cat_valor = tra.tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :emp_codigo)
                          left outer join cfg_aseguradora ase on (ase.ase_correlativo = tra.tra_cm_aseguradora and ase.ase_estado != 'E')
                          left outer join cfg_cliente cli on (tra.tra_cm_cli_correlativo = cli.cli_correlativo and cli.cli_estado = 'A') 
                      where 1=1
                      and tra.tra_cm_lugar_atencion = :tra_cm_lugar_atencion 
                      and tra.tra_cm_estado = :tra_cm_estado 
                      and (tra.tra_cm_etapa = 3) 
                      and tra_cm_empresa = :emp_codigo 
                      and tra_cm_ambiente = :tra_cm_ambiente 
                      and tra_cm_estado = 'A' 
                      and tra_cm_usr_correl = :id_usuario 
                      limit $pag_inicio, $tamanio";
                      //and (tra.tra_cm_etapa = 1 || tra.tra_cm_etapa = 2 || tra.tra_cm_etapa = 3) 

                      //left outer join tra_bloqueo_agenda ba on (ba.tra_ba_fecha_inicio != tra_cm_fecha_inicio_consulta)
                      //left outer join cfg_catalogo d on(tra_cm_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo' => $emp_codigo,
                        'tra_cm_ambiente' => $amb_codigo,
                        'tra_cm_estado' => $tra_cm_estado,
                        'id_usuario' => $id_usuario,
                        'tra_cm_lugar_atencion' => $age_suc_correlativo
                        //'tra_cm_usr_correl' => $tra_cm_usr_correl
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);

                    if (!empty($stmt2)){
                        foreach ($result1 as $key => $value) {
                                array_unshift($result,array("allDay"=>"1","color"=>$value["color"],'rendering'=>$value["rendering"],"start"=>$value["start"],"textColor"=>$value["textColor"],"title"=>$value["title"],"tra_ba_fecha_inicio"=>$value["tra_ba_fecha_inicio"]));
                                //array_unshift($result,array("allDay"=>"1","color"=>"#A16F6B",'rendering'=>"background","start"=>"2021-11-01 00:00:00","textColor"=>"","title"=>"Inhabilitado","tra_ba_fecha_inicio"=>"2021-11-01 00:00"));
                        }
                    }
                    if (!empty($stmt)) {
                        //array_unshift($result,array("allDay"=>"1","color"=>"#A16F6B",'rendering'=>"background","start"=>"2021-11-01 00:00:00","textColor"=>"","title"=>"Inhabilitado","tra_ba_fecha_inicio"=>"2021-11-01 00:00"));
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una opción'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica tra  
                            left outer join cfg_usuario b on (b.usr_correl = tra.tra_cm_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra.tra_cm_usuariom) 
                            left outer join cfg_producto pro on(tra.tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                            left outer join cfg_usuario med on (tra.tra_cm_usr_correl = med.usr_correl and med.usr_estado = 'A')
                            left outer join cfg_sucursal lug on (tra.tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = 'A')
                            left outer join cfg_catalogo cat on(cat.cat_valor = tra.tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :emp_codigo)
                            ", " 
                             and tra.tra_cm_lugar_atencion = :tra_cm_lugar_atencion 
                             and tra.tra_cm_estado = :tra_cm_estado 
                             and (tra.tra_cm_etapa = 1 || tra.tra_cm_etapa = 2 || tra.tra_cm_etapa = 3) 
                             and tra_cm_empresa = :emp_codigo 
                             and tra_cm_ambiente = :tra_cm_ambiente 
                             and tra_cm_estado = 'A' 
                             and tra_cm_usr_correl = :id_usuario 
                            ", 
                            [
                                'emp_codigo' => $emp_codigo,
                                'tra_cm_ambiente' => $amb_codigo,
                                'tra_cm_estado' => $tra_cm_estado,
                                'id_usuario' => $id_usuario,
                                'tra_cm_lugar_atencion' => $tra_cm_lugar_atencion
                                //'tra_cm_usr_correl' => $tra_cm_usr_correl
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    
    public function selectBloqueoAgenda($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraAgendaMedico', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 367;//$parameter['tamanio'] ?? 10;
                    
                    //$tra_cm_tipo_consulta = $parameter['tra_cm_tipo_consulta'] ?? 0;
                    $tra_ba_suc_correlativo = $parameter['tra_ba_suc_correlativo'] ?? 0;
                    $tra_ba_estado = 'A';
                    $tra_etapa = 1;

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    //tra_ba_correlativo,tra_ba_suc_correlativo,tra_ba_fecha_fin,tra_ba_estado 
                    $sql = " 
                    select 
                      date_format(tra_ba_fecha_inicio, '%Y-%m-%d 00:00') as tra_ba_fecha_inicio,
                      tra_ba_textcolor as textColor,
                      tra_ba_color as color,
                      tra_ba_rendering_background as rendering,
                      tra_ba_fecha_inicio as start,
                      tra_ba_etiqueta as title,
                      tra_ba_age_allDay as allDay 
                      from tra_bloqueo_agenda 
                      where 1=1
                      and tra_ba_suc_correlativo = :tra_ba_suc_correlativo 
                      and tra_ba_estado = :tra_ba_estado 
                      limit $pag_inicio, $tamanio";
                      //left outer join cfg_catalogo d on(tra_cm_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)
                    //var_dump($sql);
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_ba_suc_correlativo' => $tra_ba_suc_correlativo,
                        'tra_ba_estado' => $tra_ba_estado
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_bloqueo_agenda ", " 
                             and tra_ba_suc_correlativo = :tra_ba_suc_correlativo 
                             and tra_ba_estado = :tra_ba_estado 
                            ", 
                            [
                                'tra_ba_suc_correlativo' => $tra_ba_suc_correlativo,
                                'tra_ba_estado' => $tra_ba_estado
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }

    public function selectAseguradora($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraAgendaMedico', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $tra_cm_aseguradora = $parameter['tra_cm_aseguradora'] ?? 0;
                    $filtro = "";
                    if($tra_cm_aseguradora == 2){
                        $filtro = "";
                    }else{
                        $filtro = " and ase_correlativo = 0";
                        $tra_cm_aseguradora = 0;
                    }

                    $sql = " select   
                    ase_correlativo,  
                    ase_nombre 
                    from cfg_aseguradora   
                    where 1 = 1  
                    $filtro 
                    and ase_empresa =:emp_codigo
                    and ase_ambiente =:amb_codigo
                    and ase_estado = 'A'
                    order by ase_nombre asc";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo    
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("ase_correlativo"=>'','ase_nombre'=>'Seleccione una opción'));
                        }else{
                            //array_unshift($result,array("ase_correlativo"=>'','ase_nombre'=>'No existen datos'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectDataPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraAgendaMedico', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    //$cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";


                    $cli_estado = 'A';//$parameter['cli_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.cli_correlativo, 
                    a.cli_nombre,  
                    a.cli_email,  
                    IFNULL(a.cli_facturar,'') as facturar,
                    IFNULL(a.cli_nit,'') as nit,  
                    a.cli_dpi,
                    a.cli_telefono1,  
                    a.cli_telefono2,  
                    a.cli_direccion,  
                    date_format(cli_fecha_nacimiento, '%d/%m/%Y') as fecha_nacimiento,
                    DATE_FORMAT(FROM_DAYS(TO_DAYS(NOW())-TO_DAYS(a.cli_fecha_nacimiento)), '%Y')+0 AS edad,
                    a.cli_edad,
                    IF(a.cli_responsable = 'null','',a.cli_responsable) as cli_responsable,
                    a.cli_estado_civil,
                    a.cli_religion,
                    a.cli_escolaridad,
                    a.cli_ocupacion,
                    a.cli_grupo_sanguineo,
                    d.cat_nombre cat_estado_nombre,  
                    a.cli_estado,  
                    concat(b.usr_nombres,' ',b.usr_apellidos) as cli_usuarioi,  
                    concat(c.usr_nombres,' ',c.usr_apellidos) as cli_usuariom,  
                    a.cli_fechai,  
                    a.cli_fecham  

                    from cfg_cliente a
                    left outer join cfg_catalogo d on(a.cli_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.cli_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.cli_usuariom)
                    
                    where 
                    1=1
                    and a.cli_estado =:cli_estado
                    and ((a.cli_nombre like concat('%',:filter,'%') or a.cli_email like concat('%',:filter,'%') or a.cli_nit like concat('%',:filter,'%')) or (:filter = 'undefined'))

                     and (a.cli_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                     and (a.cli_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                     limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'cli_estado' => $cli_estado,
                    'emp_codigo' => $emp_codigo,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'cli_estado' => $cli_estado,
                    //'cli_correlativo' => $cli_correlativo,
                    'filter' => $filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_cliente a
                        left outer join cfg_catalogo d on(a.cli_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.cli_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.cli_usuariom)
                        ", "   and a.cli_estado =:cli_estado 
                         and ((a.cli_nombre like concat('%',:filter,'%') or a.cli_email like concat('%',:filter,'%') or a.cli_nit like concat('%',:filter,'%')) or (:filter = 'undefined'))
                         and (a.cli_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                         and (a.cli_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                        ", 
                        [
                        'cli_estado' => $cli_estado,
                        'emp_codigo' => $emp_codigo,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'cli_estado' => $cli_estado,
                        //'cli_correlativo' => $cli_correlativo,
                        'filter' => $filter
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function updateConsultaMedica($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraAgendaMedico', 'nuevo');

                if($userFuncionality == 'OK'){
                    $updateConsulta = false;
                    
                    $cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $tra_cm_correlativo = (int)$parameter['tra_cm_correlativo'] ?? 0;
                    $tra_cm_procedencia = (int)$parameter['tra_cm_procedencia'] ?? 0;
                    $tra_cm_aseguradora = (int)$parameter['tra_cm_aseguradora'] ?? 0;

                    $tra_cm_lugar_atencion = $parameter['tra_cm_lugar_atencion'] ?? 0;
                    $tra_cm_nombre_paciente = $parameter['tra_cm_nombre_paciente'] ?? 'null';
                    $tra_cm_telefono = $parameter['tra_cm_telefono'] ?? 'null';
                    $tra_cm_correo = $parameter['tra_cm_correo'] ?? 'null';
                    $tra_cm_observaciones = $parameter['tra_cm_observaciones'] ?? 'null';
                    $cambioFechaConsulta = $parameter['cambioFechaConsulta'] ?? NULL;
                    $tra_cm_paciente_intercalado=(int)$parameter['tra_cm_paciente_intercalado'] ?? 0;

                    
                    //$tra_cm_fecha_inicio_consulta = $parameter['tra_cm_fecha_inicio_consulta'] ?? NULL;
                    $tra_cm_fecha_inicio_consulta = $parameter['tra_cm_fecha_inicio_consulta'] ?? date("Y-m-d H:i");
                    if($tra_cm_fecha_inicio_consulta == ""){//|| $tra_cm_fecha_inicio_consulta = 'Invalid date'
                        $tra_cm_fecha_inicio_consulta = NULL;
                    }
                    $tra_cm_fecha_fin_consulta = "";
                    $tra_cm_fecha_nacimiento = $parameter['tra_cm_fecha_nacimiento'] ?? NULL;
                    if($tra_cm_fecha_nacimiento == "" || $tra_cm_fecha_nacimiento == 'Invalid date'){
                        $tra_cm_fecha_nacimiento = NULL;
                    }
                    

                    $tra_cm_nombre_paciente = $utility->validarLongitudString($tra_cm_nombre_paciente, 0, 150);
                    $tra_cm_telefono = $utility->validarLongitudString($tra_cm_telefono, 0, 15);
                    $tra_cm_correo = $utility->validarLongitudString($tra_cm_correo, 0, 100);
                    $tra_cm_observaciones = $utility->validarLongitudString($tra_cm_observaciones, 0, 150);


                    $observacionRecalendarizacion = "";
                    if($cambioFechaConsulta == 'true'){//
                        $tra_cm_observaciones = 'A';//COMO LA CONSULTA ES PERA UN PARAMETRO tra_cm_observaciones ES IMPORTANTE MANDARLE UN VALOR A ESE PARAMETRO
                        $observacionRecalendarizacion = "tra_cm_estado = :tra_cm_observaciones,";
                    }else if($cambioFechaConsulta == 'false'){
                        $observacionRecalendarizacion = "tra_cm_observaciones_recalendarizacion = :tra_cm_observaciones,";
                        //$tra_cm_observaciones_recalendarizacion = $parameter['tra_cm_observaciones'];
                    }

                    if($tra_cm_fecha_inicio_consulta !=""){
                        //$tra_cm_fecha_fin_consulta = $tra_cm_fecha_inicio_consulta->modify('+40 minute'); 
                        $tra_cm_fecha_fin_consulta = strtotime ( '+40 minute' , strtotime($tra_cm_fecha_inicio_consulta)) ;
                        $tra_cm_fecha_fin_consulta = date( 'Y-m-d H:i:s' , $tra_cm_fecha_fin_consulta);
                    }

                    /*if($tra_cm_paciente_intercalado > 0){
                        $horarioConsultaDisponible = 1;
                    }else{
                        //$horarioConsultaDisponible = 0;
                        $horarioConsultaDisponible = $utility->validarHorarioCosulta($PDO, "tra_consulta_medica", "tra_cm_correlativo","$age_usr_correl","$tra_cm_lugar_atencion","$tra_cm_tipo_consulta", "$tra_cm_fecha_inicio_consulta", "$tra_cm_fecha_fin_consulta", "");
                    }*/

                    $array_cliente = array(
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre'=>$tra_cm_nombre_paciente,
                        'cli_email'=>$tra_cm_correo,
                        'cli_telefono1'=>$tra_cm_telefono,
                        'cli_telefono2'=>$tra_cm_telefono,
                        'cli_fecha_nacimiento' =>$tra_cm_fecha_nacimiento
                    );
                    
                    $cli_correlativo = $utility->clientRegister($PDO,$array_cliente, $id_usuario,1);//1=modificar

                    //si $horarioCentroValido = 0 entonces horario no válido
                    //si $horarioCentroValido = 1 entonces valido
                    $horarioCentroValido = $utility->validarHorarioSucursal($PDO, "cfg_sucursal", "suc_correlativo","$tra_cm_fecha_inicio_consulta","$tra_cm_fecha_fin_consulta","$tra_cm_lugar_atencion"," and suc_empresa = $emp_codigo and suc_ambiente = $amb_codigo");
                    
                    //si $horarioCitaDisponible = 0 entonces horario no válido
                    //si $horarioCitaDisponible = 1 entonces valido
                    $horarioCitaDisponible = $utility->validarHorarioCitas($PDO, "tra_consulta_medica", "tra_cm_correlativo ","$tra_cm_tipo_consulta","$tra_cm_lugar_atencion", "$tra_cm_fecha_inicio_consulta.", "$tra_cm_fecha_fin_consulta", "");

                    //$cli_nit = $utility->validarLongitudNumero($cli_nit, 0, 10);
                    //$tra_cm_correlativo = $utility->CorrelAutomatico($PDO, "tra_consulta_medica", "tra_cm_correlativo ", "");
                    
                     $sql = " UPDATE tra_consulta_medica SET 
                                            tra_cm_procedencia = :tra_cm_procedencia, 
                                            tra_cm_aseguradora = :tra_cm_aseguradora,
                                            tra_cm_fecha_inicio_consulta = :tra_cm_fecha_inicio_consulta,
                                            tra_cm_fecha_fin_consulta = :tra_cm_fecha_fin_consulta,
                                            $observacionRecalendarizacion 
                                            tra_cm_usuariom = :id_usuario,
                                            tra_cm_fecham = now() 
                                            WHERE tra_cm_correlativo = :tra_cm_correlativo and tra_cm_usuariomkkk = :id_usuario";

                                                
                        if($horarioCentroValido > 0){
                            //$updateConsulta = true;
                            if($horarioCitaDisponible == 0){
                                $updateConsulta = true;
                            }else{
                                $updateConsulta = false;
                                $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar la consulta del paciente, el horario seleccionado ya está reservado, por favor revise el horario.', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }else{
                            $updateConsulta = false;
                            $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar la consulta del paciente, el horario seleccionado está fuera del horario del centro, por favor revise el horario del centro de atención', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                        
                        if($updateConsulta == true){
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'tra_cm_correlativo' => $tra_cm_correlativo, 
                                'tra_cm_procedencia' => $tra_cm_procedencia,
                                'tra_cm_aseguradora' => $tra_cm_aseguradora,
                                'tra_cm_fecha_inicio_consulta' => $tra_cm_fecha_inicio_consulta,
                                'tra_cm_fecha_fin_consulta' => $tra_cm_fecha_fin_consulta,
                                'tra_cm_observaciones' => $tra_cm_observaciones,
                                /*'tra_cm_correo' => $tra_cm_correo,
                                'tra_cm_fecha_nacimiento' => $tra_cm_fecha_nacimiento,*/
                                'id_usuario' => $id_usuario
                                ]);
                              
                                
                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente '.$cambioFechaConsulta, 'status'=>200,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado '.$cambioFechaConsulta, 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }
                    
                }else{

                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function selectAgendaCallCenter($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraAgendaMedico', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    
                    $tra_cm_tipo_consulta = $parameter['tra_cm_tipo_consulta'] ?? 0;
                    $tra_cm_lugar_atencion = $parameter['tra_cm_lugar_atencion'] ?? 0;
                    $tra_cm_usr_correl = $parameter['tra_cm_usr_correl'] ?? 0;

                    if($tra_cm_usr_correl > 0){
                        $filtro = "and tra_cm_usr_correl = :tra_cm_usr_correl";
                    }else{
                        $filtro = "and tra_cm_usr_correl >= 0";
                    }
                    $tra_cm_estado = 'A';
                    $tra_etapa = 1;

                    /*INICIO CONSULTA BLOQUEO AGENDA*/
                    $tra_ba_estado = 'A';
                    $pagInicio = 0;
                    $registros = 366;
                    $sqlBloqueoAgenda = " 
                    select 
                      date_format(tra_ba_fecha_inicio, '%Y-%m-%d 00:00') as tra_ba_fecha_inicio,
                      tra_ba_textcolor as textColor,
                      tra_ba_color as color,
                      tra_ba_rendering_background as rendering,
                      tra_ba_fecha_inicio as start,
                      tra_ba_etiqueta as title,
                      tra_ba_age_allDay as allDay 
                      from tra_bloqueo_agenda 
                      where 1=1
                      and tra_ba_suc_correlativo = :tra_ba_suc_correlativo 
                      and tra_ba_estado = :tra_ba_estado 
                      limit $pagInicio, $registros";

                    $stmt2 = $PDO->prepare($sqlBloqueoAgenda);
                    $stmt2->execute([
                        'tra_ba_estado' => $tra_ba_estado,
                        'tra_ba_suc_correlativo' => $tra_cm_lugar_atencion
                        ]);
                    $result1 = $stmt2->fetchAll($PDO::FETCH_ASSOC);
                    
                    $sql = " 
                    select 
                      tra.tra_cm_correlativo,
                      tra.tra_cm_correlativo as id,
                      tra.tra_cm_codigo,
                      tra.tra_cm_empresa,
                      tra.tra_cm_ambiente,
                      tra.tra_cm_procedencia,
                      tra.tra_cm_aseguradora,
                      ase.ase_nombre as tra_cm_nombre_aseguradora,
                      tra.tra_cm_primer_consulta,
                      if(tra.tra_cm_primer_consulta = 1,'Primera Consulta','Reconsulta') as tra_cm_descripcion_consulta,
                      tra.tra_cm_lugar_atencion,
                      tra.tra_cm_tipo_consulta,
                      tra.tra_cm_usr_correl,
                      cli.cli_correlativo,
                      cli.cli_nombre,
                      cli.cli_telefono1,
                      date_format(cli.cli_fecha_nacimiento, '%d/%m/%y') as cli_fecha_nacimiento,
                      cli.cli_email,
                      cli.cli_fecha_nacimiento as fecha_nacimiento,
                      date_format(tra.tra_cm_fecha_inicio_consulta, '%d/%m/%y %H:%i') as tra_cm_fecha_inicio_consulta, 
                      tra.tra_cm_fecha_inicio_consulta as fecha_inicio_consulta, 
                      tra.tra_cm_fecha_fin_consulta,
                      tra.tra_cm_fecha_inicio_consulta as start,
                      tra.tra_cm_fecha_fin_consulta as end,
                      date_format(tra.tra_cm_fecha_inicio_consulta, '%H:%i') as tra_cm_hora_inicio,
                      date_format(tra.tra_cm_fecha_fin_consulta, 'a %H:%i') as tra_cm_hora_fin,
                      concat(date_format(tra.tra_cm_fecha_inicio_consulta, '%H:%i'),'-',date_format(tra.tra_cm_fecha_fin_consulta, '%H:%i')) as duracionConsulta,
                      tra.tra_cm_nombre_paciente,
                      IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'MEDICO NO ASIGNADO') as tra_cm_nombre_medico,
                      pro.pro_nombre as tra_cm_nombre_especialidad,
                      pro.pro_color as tra_cm_color_etiqueta,

                      concat(date_format(tra.tra_cm_fecha_fin_consulta, '%H:%i'),'\n',(cli.cli_nombre),'\n',pro.pro_nombre) as title,
                      
                      pro.pro_color as backgroundColor,
                      pro.pro_color_texto as textColor,
                      pro.pro_tipo_ficha as tra_cm_tipo_ficha,
                      lug.suc_nombre as tra_cm_nombre_lugar_atencion,
                      concat(TIMESTAMPDIFF(MINUTE,tra.tra_cm_fecha_inicio_consulta,tra.tra_cm_fecha_fin_consulta),' ','Minutos') as tra_cm_duracion_minutos,
                      tra.tra_cm_fecha_nacimiento,
                      tra.tra_cm_telefono,
                      tra.tra_cm_direccion,
                      tra.tra_cm_etapa,
                      tra.tra_cm_paciente_intercalado,
                      if(tra.tra_cm_etapa = 1,'No Confirmado','Confirmado') as tra_cm_estado_consulta,
                      tra.tra_cm_fecha_confirmacion,
                      tra.tra_cm_cita_reprogramada_inicio,
                      tra.tra_cm_cita_reprogramada_fin,
                      IF(tra.tra_cm_observaciones = 'undefined', '',tra.tra_cm_observaciones) as tra_cm_observaciones,
                      tra.tra_cm_estado,
                      tra.tra_cm_usuarioi,
                      tra.tra_cm_usuariom,
                      tra.tra_cm_fechai,
                      tra.tra_cm_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra.tra_cm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra.tra_cm_fecham, '%d/%m/%y %T') as age_fecham,
                      cat.cat_nombre as tra_cm_nombre_procedencia 
                      from tra_consulta_medica tra 
                          left outer join cfg_usuario b on (b.usr_correl = tra.tra_cm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra.tra_cm_usuariom) 
                          left outer join cfg_producto pro on(tra.tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                          left outer join cfg_usuario med on (tra.tra_cm_usr_correl = med.usr_correl and med.usr_estado = 'A')
                          left outer join cfg_sucursal lug on (tra.tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = 'A') 
                          left outer join cfg_catalogo cat on(cat.cat_valor = tra.tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :emp_codigo)
                          left outer join cfg_aseguradora ase on (ase.ase_correlativo = tra.tra_cm_aseguradora and ase.ase_estado != 'E')
                          left outer join cfg_cliente cli on (tra.tra_cm_cli_correlativo = cli.cli_correlativo and cli.cli_estado = 'A') 
                      where 1=1
                      and tra.tra_cm_lugar_atencion = :tra_cm_lugar_atencion 
                      and tra.tra_cm_estado = :tra_cm_estado 
                      and (tra.tra_cm_etapa = 1 || tra.tra_cm_etapa = 2 || tra.tra_cm_etapa = 3) 
                      and tra.tra_cm_usr_correl = :id_usuario 
                      $filtro 
                      limit $pag_inicio, $tamanio";
                      //and tra.tra_cm_tipo_consulta = :tra_cm_tipo_consulta//NO BORRAR

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo' => $emp_codigo,
                        'tra_cm_estado' => $tra_cm_estado,
                        'id_usuario' => $id_usuario,
                        'tra_cm_lugar_atencion' => $tra_cm_lugar_atencion,
                        'tra_cm_usr_correl' => $tra_cm_usr_correl
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);

                    if (!empty($stmt2)){
                        foreach ($result1 as $key => $value) {
                                array_unshift($result,array("allDay"=>"1","color"=>$value["color"],'rendering'=>$value["rendering"],"start"=>$value["start"],"textColor"=>$value["textColor"],"title"=>$value["title"],"tra_ba_fecha_inicio"=>$value["tra_ba_fecha_inicio"]));
                                //array_unshift($result,array("allDay"=>"1","color"=>"#A16F6B",'rendering'=>"background","start"=>"2021-11-01 00:00:00","textColor"=>"","title"=>"Inhabilitado","tra_ba_fecha_inicio"=>"2021-11-01 00:00"));
                        }
                    }
                    if (!empty($stmt)) {
                        //array_unshift($result,array("allDay"=>"1","color"=>"#A16F6B",'rendering'=>"background","start"=>"2021-11-01 00:00:00","textColor"=>"","title"=>"Inhabilitado","tra_ba_fecha_inicio"=>"2021-11-01 00:00"));
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una opción'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica tra  
                            left outer join cfg_usuario b on (b.usr_correl = tra.tra_cm_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra.tra_cm_usuariom) 
                            left outer join cfg_producto pro on(tra.tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                            left outer join cfg_usuario med on (tra.tra_cm_usr_correl = med.usr_correl and med.usr_estado = 'A')
                            left outer join cfg_sucursal lug on (tra.tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = 'A')
                            left outer join cfg_catalogo cat on(cat.cat_valor = tra.tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :emp_codigo)
                            ", " 
                             and tra.tra_cm_lugar_atencion = :tra_cm_lugar_atencion 
                             and tra.tra_cm_estado = :tra_cm_estado 
                             and (tra.tra_cm_etapa = 1 || tra.tra_cm_etapa = 2 || tra.tra_cm_etapa = 3) 
                             and tra.tra_cm_usr_correl = :id_usuario 
                             $filtro 
                            ", 
                            [
                                'emp_codigo' => $emp_codigo,
                                'tra_cm_estado' => $tra_cm_estado,
                                'id_usuario' => $id_usuario,
                                'tra_cm_lugar_atencion' => $tra_cm_lugar_atencion,
                                'tra_cm_usr_correl' => $tra_cm_usr_correl
                            ]);
                        //and tra.tra_cm_tipo_consulta = :tra_cm_tipo_consulta //NO BORRAR
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }    
    
}
