<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use Exception;
use PDOException;
class TraAttachmentController{
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_attachment', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $att_objeto= $parameter['att_objeto'] ?? '';
                    $att_objeto_codigo= $parameter['att_objeto_codigo'] ?? 'null';
                    $donwloadPath = DOWNLOAD_DIR;
                    $sql = " select 
                    att_correl,
                    att_codigo,
                    att_empresa,
                    att_objeto,
                    att_objeto_codigo,
                    att_tipo,
                    att_etapa,
                    concat('$donwloadPath',year(att_fechai),'/',DATE_FORMAT(att_fechai,'%m') ) att_direccion,
                    att_archivo,
                    att_visibilidad,
                    att_estado,
                    att_usuarioi,
                    att_usuariom,
                    att_fechai,
                    att_fecham,
                    att_version,
                    att_seccion
                    from 
                    tra_attachment
                    where 
                    1=1
                    and att_objeto=:att_objeto
                    and att_empresa = :att_empresa
                    and (att_objeto_codigo = :att_objeto_codigo or att_objeto_codigo = 'null')
                    and att_estado = 'A'
                    ";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'att_objeto' => $att_objeto,
                        'att_empresa' => $emp_codigo,
                        'att_objeto_codigo' => $att_objeto_codigo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if ($stmt->rowCount() > 0) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_attachment", " and att_objeto=:att_objeto
                        and att_empresa = :att_empresa
                        and (att_objeto_codigo = :att_objeto_codigo or att_objeto_codigo = 'null')
                        and att_estado = 'A'", 
                        [
                            'att_objeto' => $att_objeto,
                            'att_empresa' => $emp_codigo,
                            'att_objeto_codigo' => $att_objeto_codigo
                        ]);
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'data'=>[],'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insert($request,$response,$args) {
        
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_attachment', 'nuevo');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $uploadedFiles = $request->getUploadedFiles();
                    $uploadedFile = $uploadedFiles['file'];
                    if ($uploadedFile->getError() === UPLOAD_ERR_OK) {
                        //creacion de carpeta para almacenar archivos
                        $anio = date("Y");
                        $mes = date('m');
                        $path = UPLOAD_DIR.DIRECTORY_SEPARATOR.$anio.DIRECTORY_SEPARATOR.$mes;
                        
                        if (!file_exists($path)) {
                            mkdir($path, 0777, true);
                        }
                        
                        $nom_archivo = $utility->moveUploadedFile($path,$uploadedFile);
                        
                        //grabamos informacion del archivo guardado
                        $att_correl = $utility->CorrelAutomatico($PDO, "tra_attachment", "att_correl", "");
                        $att_objeto= $parameter['att_objeto'] ?? 'no_object';
                        $att_objeto_codigo= $parameter['att_objeto_codigo'] ?? '';
                        $att_tipo= $parameter['att_tipo'] ?? '';
                        $att_etapa= $parameter['att_etapa'] ?? '';
                        $att_visibilidad= $parameter['att_visibilidad'] ?? '1';
                        $att_estado= $parameter['att_estado'] ?? '';
                        $att_version= $parameter['att_version'] ?? '0';
                        $att_objeto_seccion= $parameter['att_objeto_seccion'] ?? '0';
                        $att_archivo= $nom_archivo;
                        $att_codigo= $att_correl;
                        $att_direccion= $path;
                        $sql = " insert into tra_attachment (
                            att_correl,
                            att_codigo,
                            att_empresa,
                            att_objeto,
                            att_objeto_codigo,
                            att_tipo,
                            att_etapa,
                            att_direccion,
                            att_archivo,
                            att_visibilidad,
                            att_estado,
                            att_usuarioi,
                            att_usuariom,
                            att_fechai,
                            att_fecham,
                            att_version,
                            att_seccion
                            ) values(
                                :att_correl,
                                :att_codigo,
                                :att_empresa,
                                :att_objeto,
                                :att_objeto_codigo,
                                :att_tipo,
                                :att_etapa,
                                :att_direccion,
                                :att_archivo,
                                :att_visibilidad,
                                'A',
                                :att_usuarioi,
                                :att_usuarioi,
                                now(),
                                now(),
                                :att_version,
                                :att_seccion
                            )";
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'att_correl' => $att_correl,
                            'att_codigo' => $att_codigo,
                            'att_empresa' => $emp_codigo,
                            'att_objeto' => $att_objeto,
                            'att_objeto_codigo' => $att_objeto_codigo,
                            'att_tipo' => $att_tipo,
                            'att_etapa' => $att_etapa,
                            'att_direccion' => $att_direccion,
                            'att_archivo' => $att_archivo,
                            'att_visibilidad' => $att_visibilidad,
                            'att_estado' => $att_estado,
                            'att_usuarioi' => $id_usuario,
                            'att_version' => $att_version,
                            'att_seccion'=>$att_objeto_seccion
                        ]);
                        
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Archivo cargado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Archivo no pudo ser cargado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Archivo no pudo ser cargado', 'status'=>500);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(500);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(Exception $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(), 'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_attachment', 'eliminar');
                if($userFuncionality == 'OK'){
                    $att_correl= $parameter['att_correl'] ?? '0';
                    $sql = " update tra_attachment set
                        att_estado = 'E',
                        att_usuariom = :att_usuariom,
                        att_fecham = now()
                        where att_correl = :att_correl
                        and att_empresa = :emp_codigo
                    ";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'att_correl' => $att_correl,
                        'att_usuariom' => $id_usuario,
                        'emp_codigo'=>$emp_codigo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Archivo eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Archivo no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
}