<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;
class TraCitaMedicaController {
    
    public function selectInfoMedico($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $age_estado = 'A';//$parameter['ucf_estado'] ?? "A";

                    
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $usr_tipo = 2;//$parameter['usr_tipo'] ?? 10;
                    $age_pro_correl = $parameter['age_pro_correl'] ?? 10;;
                    
                    $filter = $parameter['filter'] ?? "undefined";
                    
                    $sql = " select 
                            age_correlativo,
                            age_usr_correl,
                            age_pro_correl,
                            age_suc_correlativo,
                            concat(u.usr_nombres,' ', u.usr_apellidos) as medico  
                            FROM cfg_agenda 
                            left outer join cfg_usuario u on (u.usr_correl = age_usr_correl and u.usr_empresa = $emp_codigo)
                            where 1=1 
                            and age_pro_correl = :age_pro_correl 
                            and age_estado = :age_estado 
                            GROUP by age_usr_correl 
                            limit $pag_inicio, $tamanio";

                    //echo $sql;
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        //'usr_empresa' => $emp_codigo,
                        'age_pro_correl' => $age_pro_correl,
                        'age_estado'=>$age_estado
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("age_usr_correl"=>'','medico'=>'Seleccione un médico'));
                        }else{
                            array_unshift($result,array("age_usr_correl"=>'','medico'=>'No existen médicos asignados'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function selectCentrosAtencion($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $age_estado = 'A';//$parameter['ucf_estado'] ?? "A";

                    
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 200;//$parameter['tamanio'] ?? 10;
                    $usr_tipo = 2;//$parameter['usr_tipo'] ?? 10;
                    $age_pro_correl = $parameter['age_pro_correl'] ?? 10;
                    $age_usr_correl = $parameter['age_usr_correl'] ?? 0;
                    //$age_suc_correlativo = $parameter['age_suc_correlativo'] ?? 0;
                    $parametro = "";
                    $filtro = "";
                    if($age_usr_correl > 0){
                        $filtro = "and age_usr_correl = :age_usr_correl";
                        $array_parametros = array(
                            'age_pro_correl' => $age_pro_correl,
                            'age_usr_correl' => $age_usr_correl,
                            'age_estado'=>$age_estado
                        );
                    }else{
                        $array_parametros = array(
                            'age_pro_correl' => $age_pro_correl,
                            'age_estado'=>$age_estado
                        );
                    }
                    
                    //$filter = $parameter['filter'] ?? "undefined";
                    
                    $sql = " select 
                            age_correlativo,
                            age_usr_correl,
                            age_pro_correl,
                            age_suc_correlativo,
                            suc.suc_nombre as nombre_centro,
                            suc.suc_horario_lunes_a_viernes_inicio as horalavinicio,
                            suc.suc_horario_lunes_a_viernes_fin as horalavfin,
                            suc.suc_horario_sabado_inicio as horasabadoinicio,
                            suc.suc_horario_sabado_fin as horasabadofin,
                            suc.suc_horario_domingo_inicio as horadomingoinicio,
                            suc.suc_horario_domingo_fin as horadomingofin    
                            FROM cfg_agenda 
                            left outer join cfg_sucursal suc on (suc.suc_correlativo = age_suc_correlativo and suc.suc_empresa = $emp_codigo and suc.suc_estado='A')
                            where 1=1 
                            and age_pro_correl = :age_pro_correl 
                            and age_estado = :age_estado 
                            $filtro 
                            GROUP BY age_suc_correlativo 
                            limit $pag_inicio, $tamanio";

                    //echo $sql;
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute($array_parametros);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("age_suc_correlativo"=>'','nombre_centro'=>'Seleccione un centro'));
                        }else{
                            array_unshift($result,array("age_suc_correlativo"=>'','nombre_centro'=>'No existen centros disponibles'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
    public function selectSucursal($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');//Cfg_usuario //cfg_usuario_config
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();

                    
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 200;//$parameter['tamanio'] ?? 10;
                    $usr_tipo = 2;//$parameter['usr_tipo'] ?? 10;
                    $suc_estado = 'A';//$parameter['ucf_estado'] ?? "A";
                    //$age_suc_correlativo = $parameter['age_suc_correlativo'] ?? 0;
                    $parametro = "";
                    $filtro = "";
                   
                    $array_parametros = array(
                        'id_usuario'=>$id_usuario,
                        'ucf_objeto'=> 'sucursal'
                    );
                    
                    //$filter = $parameter['filter'] ?? "undefined";
                    
                    $sql = " select 
                            obj.ucf_objeto_codigo as suc_correlativo,
                            suc.suc_nombre as suc_nombre 
                            FROM cfg_usuario_config obj
                            INNER JOIN cfg_sucursal suc on(suc.suc_correlativo = obj.ucf_objeto_codigo and obj.ucf_estado !='E')
                            where 1=1 
                            and ucf_usuario = :id_usuario 
                            and ucf_objeto = :ucf_objeto order by obj.ucf_codigo asc 
                            limit $pag_inicio, $tamanio";

                    //echo $sql;
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute($array_parametros);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'Seleccione un centro'));
                        }else{
                            array_unshift($result,array("suc_correlativo"=>'','suc_nombre'=>'No existen centros disponibles'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
    public function selectCitaMedico($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $age_estado = 'A';//$parameter['ucf_estado'] ?? "A";

                    
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 200;//$parameter['tamanio'] ?? 10;
                    $usr_tipo = 2;//$parameter['usr_tipo'] ?? 10;
                    $age_pro_correl = $parameter['age_pro_correl'] ?? 10;
                    $age_usr_correl = $parameter['age_usr_correl'] ?? 0;
                    //$age_suc_correlativo = $parameter['age_suc_correlativo'] ?? 0;
                    $parametro = "";
                    $filtro = "";
                    if($age_usr_correl > 0){
                        $filtro = "and age_usr_correl = :age_usr_correl";
                        $array_parametros = array(
                            'age_pro_correl' => $age_pro_correl,
                            'age_usr_correl' => $age_usr_correl,
                            'age_estado'=>$age_estado
                        );
                    }else{
                        $array_parametros = array(
                            'age_pro_correl' => $age_pro_correl,
                            'age_estado'=>$age_estado
                        );
                    }
                    
                    //$filter = $parameter['filter'] ?? "undefined";
                    
                    $sql = " select 
                            age_correlativo,
                            age_usr_correl,
                            age_pro_correl,
                            age_suc_correlativo,
                            suc.suc_nombre as nombre_centro,
                            suc.suc_horario_lunes_a_viernes_inicio as horalavinicio,
                            suc.suc_horario_lunes_a_viernes_fin as horalavfin,
                            suc.suc_horario_sabado_inicio as horasabadoinicio,
                            suc.suc_horario_sabado_fin as horasabadofin,
                            suc.suc_horario_domingo_inicio as horadomingoinicio,
                            suc.suc_horario_domingo_fin as horadomingofin    
                            FROM cfg_agenda 
                            left outer join cfg_sucursal suc on (suc.suc_correlativo = age_suc_correlativo and suc.suc_empresa = $emp_codigo and suc.suc_estado='A')
                            where 1=1 
                            and age_pro_correl = :age_pro_correl 
                            and age_estado = :age_estado 
                            $filtro 
                            GROUP BY age_suc_correlativo 
                            limit $pag_inicio, $tamanio";

                    //echo $sql;
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute($array_parametros);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("age_suc_correlativo"=>'','nombre_centro'=>'Seleccione un centro'));
                        }else{
                            array_unshift($result,array("age_suc_correlativo"=>'','nombre_centro'=>'No existen centros disponibles'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
    public function selectAgenda($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = 31;//$parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    //$age_usr_correl = $parameter['age_usr_correl'] ?? 0;
                    $age_pro_correl = $parameter['age_pro_correl'] ?? 0;
                    $age_suc_correlativo = $parameter['age_suc_correlativo'] ?? 0;
                    $age_estado = 'A';//$parameter['age_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.age_correlativo as id, 
                    a.age_usr_correl as idmedico,  
                    concat(med.usr_nombres,' ', med.usr_apellidos) as medico,
                    a.age_pro_correl as idespecialidad, 
                    a.age_suc_correlativo as age_suc_correlativo,  
                    pro.pro_nombre as title, 
                    pro.pro_color as backgroundColor,
                    a.age_fecha_inicio as start,
                    a.age_fecha_fin as end,
                    a.age_fecha_inicio as fechainicio,
                    a.age_fecha_fin as fechafin,
                    date_format(a.age_fecha_inicio, '%H:%i') as hora_inicio,  
                    date_format(a.age_fecha_fin, '%H:%i') as hora_fin,  
                    suc.suc_horario_lunes_a_viernes_inicio as horario_suc_lunaviri,
                    suc.suc_horario_lunes_a_viernes_fin as horario_suc_lunavirf,
                    suc.suc_horario_sabado_inicio as horario_suc_sabadoi,
                    suc.suc_horario_sabado_fin as horario_suc_sabadof,
                    suc.suc_horario_domingo_inicio as horario_suc_domingoi,
                    suc.suc_horario_domingo_fin as horario_suc_domingof,
                    a.age_text_color as textColor,
                    a.age_comentario as comment, 
                    a.age_estado,  
                    d.cat_nombre cat_estado_nombre,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                    date_format(a.age_fechai, '%d/%m/%y %T') as age_fechai,  
                    date_format(a.age_fecham, '%d/%m/%y %T') as age_fecham 
                    from cfg_agenda a
                    left outer join cfg_catalogo d on(a.age_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_producto pro on(a.age_pro_correl= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.age_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.age_usuariom)
                    left outer join cfg_usuario med on (a.age_usr_correl = med.usr_correl)
                    left outer join cfg_sucursal suc on (suc.suc_correlativo = a.age_suc_correlativo and suc.suc_estado = 'A')
                    where 
                    1=1
                    and ((a.age_comentario like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and a.age_estado =:age_estado
                    and a.age_pro_correl = :age_pro_correl 
                    and a.age_suc_correlativo = :age_suc_correlativo 
                    and (a.age_usuarioi >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.age_fecham <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900')
                    limit $pag_inicio, $tamanio";

                    $var1 = '08:00';
                    $var2 = '16:00';
                    $intervarlo = '15';
                    
                    $nombres = $nombres;
                    
                    $x = 0;
                    
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                        'age_pro_correl' => $age_pro_correl,
                        'age_suc_correlativo' => $age_suc_correlativo,
                        'age_estado' => $age_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter,
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_agenda a
                            left outer join cfg_catalogo d on(a.age_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)
                            left outer join cfg_producto pro on(a.age_pro_correl= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                            left outer join cfg_usuario b on (b.usr_correl = a.age_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.age_usuariom)
                            ", " 
                            and ((a.age_comentario like concat('%',:filter,'%')) or (:filter = 'undefined'))
                            and a.age_estado =:age_estado
                            and a.age_pro_correl =:age_pro_correl 
                            and a.age_suc_correlativo = :age_suc_correlativo 
                            and (a.age_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                            and (a.age_fecham <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'age_pro_correl' => $age_pro_correl,
                            'age_suc_correlativo' => $age_suc_correlativo,
                            'age_estado' => $age_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter' => $filter,
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result,'agendaMedico'=>$nombres, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectAgendaCallCenter($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    
                    $tra_cm_tipo_consulta = $parameter['tra_cm_tipo_consulta'] ?? 0;
                    $tra_cm_lugar_atencion = $parameter['tra_cm_lugar_atencion'] ?? 0;
                    $tra_cm_usr_correl = $parameter['tra_cm_usr_correl'] ?? 0;

                    if($tra_cm_usr_correl > 0){
                        $filtro = "and tra_cm_usr_correl = :tra_cm_usr_correl";
                    }else{
                        $filtro = "and tra_cm_usr_correl >= 0";
                    }
                    $tra_cm_estado = 'A';
                    $tra_etapa = 1;

                    /*INICIO CONSULTA BLOQUEO AGENDA*/
                    $tra_ba_estado = 'A';
                    $pagInicio = 0;
                    $registros = 366;
                    $sqlBloqueoAgenda = " 
                    select 
                      date_format(tra_ba_fecha_inicio, '%Y-%m-%d 00:00') as tra_ba_fecha_inicio,
                      tra_ba_textcolor as textColor,
                      tra_ba_color as color,
                      tra_ba_rendering_background as rendering,
                      tra_ba_fecha_inicio as start,
                      tra_ba_etiqueta as title,
                      tra_ba_age_allDay as allDay 
                      from tra_bloqueo_agenda 
                      where 1=1
                      and tra_ba_suc_correlativo = :tra_ba_suc_correlativo 
                      and tra_ba_estado = :tra_ba_estado 
                      limit $pagInicio, $registros";

                    $stmt2 = $PDO->prepare($sqlBloqueoAgenda);
                    $stmt2->execute([
                        'tra_ba_estado' => $tra_ba_estado,
                        'tra_ba_suc_correlativo' => $tra_cm_lugar_atencion
                        ]);
                    $result1 = $stmt2->fetchAll($PDO::FETCH_ASSOC);
                    
                    $sql = " 
                    select 
                      tra.tra_cm_correlativo,
                      tra.tra_cm_correlativo as id,
                      tra.tra_cm_codigo,
                      tra.tra_cm_empresa,
                      tra.tra_cm_ambiente,
                      tra.tra_cm_procedencia,
                      tra.tra_cm_aseguradora,
                      ase.ase_nombre as tra_cm_nombre_aseguradora,
                      tra.tra_cm_primer_consulta,
                      if(tra.tra_cm_primer_consulta = 1,'Primera Consulta','Reconsulta') as tra_cm_descripcion_consulta,
                      tra.tra_cm_lugar_atencion,
                      tra.tra_cm_tipo_consulta,
                      tra.tra_cm_usr_correl,
                      cli.cli_correlativo,
                      cli.cli_nombre,
                      cli.cli_telefono1,
                      date_format(cli.cli_fecha_nacimiento, '%d/%m/%y') as cli_fecha_nacimiento,
                      cli.cli_email,
                      cli.cli_fecha_nacimiento as fecha_nacimiento,
                      date_format(tra.tra_cm_fecha_inicio_consulta, '%d/%m/%y %H:%i') as tra_cm_fecha_inicio_consulta, 
                      tra.tra_cm_fecha_inicio_consulta as fecha_inicio_consulta, 
                      tra.tra_cm_fecha_fin_consulta,
                      tra.tra_cm_fecha_inicio_consulta as start,
                      tra.tra_cm_fecha_fin_consulta as end,
                      date_format(tra.tra_cm_fecha_inicio_consulta, '%H:%i') as tra_cm_hora_inicio,
                      date_format(tra.tra_cm_fecha_fin_consulta, 'a %H:%i') as tra_cm_hora_fin,
                      concat(date_format(tra.tra_cm_fecha_inicio_consulta, '%H:%i'),'-',date_format(tra.tra_cm_fecha_fin_consulta, '%H:%i')) as duracionConsulta,
                      tra.tra_cm_nombre_paciente,
                      IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO') as tra_cm_nombre_medico,
                      pro.pro_nombre as tra_cm_nombre_especialidad,
                      pro.pro_color as tra_cm_color_etiqueta,

                      concat(date_format(tra.tra_cm_fecha_fin_consulta, '%H:%i'),'\n',(cli.cli_nombre),'\n',pro.pro_nombre) as title,
                      
                      pro.pro_color as backgroundColor,
                      pro.pro_color_texto as textColor,
                      pro.pro_tipo_ficha as tra_cm_tipo_ficha,
                      lug.suc_nombre as tra_cm_nombre_lugar_atencion,
                      concat(TIMESTAMPDIFF(MINUTE,tra.tra_cm_fecha_inicio_consulta,tra.tra_cm_fecha_fin_consulta),' ','Minutos') as tra_cm_duracion_minutos,
                      tra.tra_cm_fecha_nacimiento,
                      tra.tra_cm_telefono,
                      tra.tra_cm_direccion,
                      tra.tra_cm_etapa,
                      tra.tra_cm_paciente_intercalado,
                      if(tra.tra_cm_etapa = 1,'No Confirmado','Confirmado') as tra_cm_estado_consulta,
                      tra.tra_cm_fecha_confirmacion,
                      tra.tra_cm_cita_reprogramada_inicio,
                      tra.tra_cm_cita_reprogramada_fin,
                      IF(tra.tra_cm_observaciones = 'undefined', '',tra.tra_cm_observaciones) as tra_cm_observaciones,
                      tra.tra_cm_estado,
                      tra.tra_cm_usuarioi,
                      tra.tra_cm_usuariom,
                      tra.tra_cm_fechai,
                      tra.tra_cm_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra.tra_cm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra.tra_cm_fecham, '%d/%m/%y %T') as age_fecham,
                      cat.cat_nombre as tra_cm_nombre_procedencia 
                      from tra_consulta_medica tra 
                          left outer join cfg_usuario b on (b.usr_correl = tra.tra_cm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra.tra_cm_usuariom) 
                          left outer join cfg_producto pro on(tra.tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                          left outer join cfg_usuario med on (tra.tra_cm_usr_correl = med.usr_correl and med.usr_estado = 'A')
                          left outer join cfg_sucursal lug on (tra.tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = 'A') 
                          left outer join cfg_catalogo cat on(cat.cat_valor = tra.tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :emp_codigo)
                          left outer join cfg_aseguradora ase on (ase.ase_correlativo = tra.tra_cm_aseguradora and ase.ase_estado != 'E')
                          left outer join cfg_cliente cli on (tra.tra_cm_cli_correlativo = cli.cli_correlativo and cli.cli_estado = 'A') 
                      where 1=1
                      and tra.tra_cm_lugar_atencion = :tra_cm_lugar_atencion 
                      and tra.tra_cm_estado = :tra_cm_estado 
                      and (tra.tra_cm_etapa = 1 || tra.tra_cm_etapa = 2 || tra.tra_cm_etapa = 3) 
                      $filtro 
                      limit $pag_inicio, $tamanio";
                      //and tra.tra_cm_tipo_consulta = :tra_cm_tipo_consulta//NO BORRAR

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo' => $emp_codigo,
                        'tra_cm_estado' => $tra_cm_estado,
                        //'tra_cm_tipo_consulta' => $tra_cm_tipo_consulta,//NO BORRAR
                        'tra_cm_lugar_atencion' => $tra_cm_lugar_atencion,
                        'tra_cm_usr_correl' => $tra_cm_usr_correl
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);

                    if (!empty($stmt2)){
                        foreach ($result1 as $key => $value) {
                                array_unshift($result,array("allDay"=>"1","color"=>$value["color"],'rendering'=>$value["rendering"],"start"=>$value["start"],"textColor"=>$value["textColor"],"title"=>$value["title"],"tra_ba_fecha_inicio"=>$value["tra_ba_fecha_inicio"]));
                                //array_unshift($result,array("allDay"=>"1","color"=>"#A16F6B",'rendering'=>"background","start"=>"2021-11-01 00:00:00","textColor"=>"","title"=>"Inhabilitado","tra_ba_fecha_inicio"=>"2021-11-01 00:00"));
                        }
                    }
                    if (!empty($stmt)) {
                        //array_unshift($result,array("allDay"=>"1","color"=>"#A16F6B",'rendering'=>"background","start"=>"2021-11-01 00:00:00","textColor"=>"","title"=>"Inhabilitado","tra_ba_fecha_inicio"=>"2021-11-01 00:00"));
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una opción'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica tra  
                            left outer join cfg_usuario b on (b.usr_correl = tra.tra_cm_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra.tra_cm_usuariom) 
                            left outer join cfg_producto pro on(tra.tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                            left outer join cfg_usuario med on (tra.tra_cm_usr_correl = med.usr_correl and med.usr_estado = 'A')
                            left outer join cfg_sucursal lug on (tra.tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = 'A')
                            left outer join cfg_catalogo cat on(cat.cat_valor = tra.tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :emp_codigo)
                            ", " 
                             and tra.tra_cm_lugar_atencion = :tra_cm_lugar_atencion 
                             and tra.tra_cm_estado = :tra_cm_estado 
                             and (tra.tra_cm_etapa = 1 || tra.tra_cm_etapa = 2 || tra.tra_cm_etapa = 3) 
                             $filtro 
                            ", 
                            [
                                'emp_codigo' => $emp_codigo,
                                'tra_cm_estado' => $tra_cm_estado,
                                //'tra_cm_tipo_consulta' => $tra_cm_tipo_consulta,//NO BORRAR
                                'tra_cm_lugar_atencion' => $tra_cm_lugar_atencion,
                                'tra_cm_usr_correl' => $tra_cm_usr_correl
                            ]);
                        //and tra.tra_cm_tipo_consulta = :tra_cm_tipo_consulta //NO BORRAR
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectCitaSucursal($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";*/
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    /*$filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $age_pro_correl = $parameter['age_pro_correl'] ?? 0;
                    $age_suc_correlativo = $parameter['age_suc_correlativo'] ?? 0;*/
                    $tra_cm_lugar_atencion = $parameter['age_suc_correlativo'] ?? 0;

                    //$filtro = "";

                    $tra_cm_estado = 'A';
                    $tra_etapa = 1;

                    /*INICIO CONSULTA BLOQUEO AGENDA*/
                    $tra_ba_estado = 'A';
                    $pagInicio = 0;
                    $registros = 366;
                    $sqlBloqueoAgenda = " 
                    select 
                      date_format(tra_ba_fecha_inicio, '%Y-%m-%d 00:00') as tra_ba_fecha_inicio,
                      tra_ba_textcolor as textColor,
                      tra_ba_color as color,
                      tra_ba_rendering_background as rendering,
                      tra_ba_fecha_inicio as start,
                      tra_ba_etiqueta as title,
                      tra_ba_age_allDay as allDay 
                      from tra_bloqueo_agenda 
                      where 1=1
                      and tra_ba_suc_correlativo = :tra_ba_suc_correlativo 
                      and tra_ba_estado = :tra_ba_estado 
                      limit $pagInicio, $registros";

                    $stmt2 = $PDO->prepare($sqlBloqueoAgenda);
                    $stmt2->execute([
                        'tra_ba_estado' => $tra_ba_estado,
                        'tra_ba_suc_correlativo' => $tra_cm_lugar_atencion
                        ]);
                    $result1 = $stmt2->fetchAll($PDO::FETCH_ASSOC);
                    
                    $sql = " 
                    select 
                      tra.tra_cm_correlativo,
                      tra.tra_cm_correlativo as id,
                      tra.tra_cm_codigo,
                      tra.tra_cm_empresa,
                      tra.tra_cm_ambiente,
                      tra.tra_cm_procedencia,
                      tra.tra_cm_aseguradora,
                      ase.ase_nombre as tra_cm_nombre_aseguradora,
                      tra.tra_cm_primer_consulta,
                      if(tra.tra_cm_primer_consulta = 1,'Primera Consulta','Reconsulta') as tra_cm_descripcion_consulta,
                      tra.tra_cm_lugar_atencion,
                      tra.tra_cm_tipo_consulta,
                      tra.tra_cm_usr_correl,
                      cli.cli_correlativo,
                      cli.cli_nombre,
                      cli.cli_telefono1,
                      date_format(cli.cli_fecha_nacimiento, '%d/%m/%y') as cli_fecha_nacimiento,
                      cli.cli_email,
                      cli.cli_fecha_nacimiento as fecha_nacimiento,
                      date_format(tra.tra_cm_fecha_inicio_consulta, '%d/%m/%y %H:%i') as tra_cm_fecha_inicio_consulta, 
                      tra.tra_cm_fecha_inicio_consulta as fecha_inicio_consulta, 
                      tra.tra_cm_fecha_fin_consulta,
                      tra.tra_cm_fecha_inicio_consulta as start,
                      tra.tra_cm_fecha_fin_consulta as end,
                      date_format(tra.tra_cm_fecha_inicio_consulta, '%H:%i') as tra_cm_hora_inicio,
                      date_format(tra.tra_cm_fecha_fin_consulta, 'a %H:%i') as tra_cm_hora_fin,
                      concat(date_format(tra.tra_cm_fecha_inicio_consulta, '%H:%i'),'-',date_format(tra.tra_cm_fecha_fin_consulta, '%H:%i')) as duracionConsulta,
                      tra.tra_cm_nombre_paciente,
                      IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO') as tra_cm_nombre_medico,
                      pro.pro_nombre as tra_cm_nombre_especialidad,
                      pro.pro_color as tra_cm_color_etiqueta,

                      concat(date_format(tra.tra_cm_fecha_fin_consulta, '%H:%i'),'\n',(cli.cli_nombre),'\n',pro.pro_nombre) as title,
                      
                      pro.pro_color as backgroundColor,
                      pro.pro_color_texto as textColor,
                      pro.pro_tipo_ficha as tra_cm_tipo_ficha,
                      lug.suc_nombre as tra_cm_nombre_lugar_atencion,
                      concat(TIMESTAMPDIFF(MINUTE,tra.tra_cm_fecha_inicio_consulta,tra.tra_cm_fecha_fin_consulta),' ','Minutos') as tra_cm_duracion_minutos,
                      tra.tra_cm_fecha_nacimiento,
                      tra.tra_cm_telefono,
                      tra.tra_cm_direccion,
                      tra.tra_cm_etapa,
                      tra.tra_cm_paciente_intercalado,
                      if(tra.tra_cm_etapa = 1,'No Confirmado','Confirmado') as tra_cm_estado_consulta,
                      tra.tra_cm_fecha_confirmacion,
                      tra.tra_cm_cita_reprogramada_inicio,
                      tra.tra_cm_cita_reprogramada_fin,
                      IF(tra.tra_cm_observaciones = 'undefined', '',tra.tra_cm_observaciones) as tra_cm_observaciones,
                      tra.tra_cm_estado,
                      tra.tra_cm_usuarioi,
                      tra.tra_cm_usuariom,
                      tra.tra_cm_fechai,
                      tra.tra_cm_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra.tra_cm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra.tra_cm_fecham, '%d/%m/%y %T') as age_fecham,
                      cat.cat_nombre as tra_cm_nombre_procedencia 
                      from tra_consulta_medica tra 
                          left outer join cfg_usuario b on (b.usr_correl = tra.tra_cm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra.tra_cm_usuariom) 
                          left outer join cfg_producto pro on(tra.tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                          left outer join cfg_usuario med on (tra.tra_cm_usr_correl = med.usr_correl and med.usr_estado = 'A')
                          left outer join cfg_sucursal lug on (tra.tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = 'A') 
                          left outer join cfg_catalogo cat on(cat.cat_valor = tra.tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :emp_codigo)
                          left outer join cfg_aseguradora ase on (ase.ase_correlativo = tra.tra_cm_aseguradora and ase.ase_estado != 'E')
                          left outer join cfg_cliente cli on (tra.tra_cm_cli_correlativo = cli.cli_correlativo and cli.cli_estado = 'A') 
                      where 1=1
                      and tra.tra_cm_lugar_atencion = :tra_cm_lugar_atencion 
                      and tra.tra_cm_estado = :tra_cm_estado 
                      and (tra.tra_cm_etapa = 1 || tra.tra_cm_etapa = 2 || tra.tra_cm_etapa = 3) 
                      and tra_cm_empresa = :emp_codigo 
                      and tra_cm_ambiente = :tra_cm_ambiente 
                      and tra_cm_estado = 'A' 
                      limit $pag_inicio, $tamanio";
                      //left outer join tra_bloqueo_agenda ba on (ba.tra_ba_fecha_inicio != tra_cm_fecha_inicio_consulta)
                      //left outer join cfg_catalogo d on(tra_cm_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo' => $emp_codigo,
                        'tra_cm_ambiente' => $amb_codigo,
                        'tra_cm_estado' => $tra_cm_estado,
                        //'tra_cm_tipo_consulta' => $tra_cm_tipo_consulta,
                        'tra_cm_lugar_atencion' => $tra_cm_lugar_atencion
                        //'tra_cm_usr_correl' => $tra_cm_usr_correl
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);

                    if (!empty($stmt2)){
                        foreach ($result1 as $key => $value) {
                                array_unshift($result,array("allDay"=>"1","color"=>$value["color"],'rendering'=>$value["rendering"],"start"=>$value["start"],"textColor"=>$value["textColor"],"title"=>$value["title"],"tra_ba_fecha_inicio"=>$value["tra_ba_fecha_inicio"]));
                                //array_unshift($result,array("allDay"=>"1","color"=>"#A16F6B",'rendering'=>"background","start"=>"2021-11-01 00:00:00","textColor"=>"","title"=>"Inhabilitado","tra_ba_fecha_inicio"=>"2021-11-01 00:00"));
                        }
                    }
                    if (!empty($stmt)) {
                        //array_unshift($result,array("allDay"=>"1","color"=>"#A16F6B",'rendering'=>"background","start"=>"2021-11-01 00:00:00","textColor"=>"","title"=>"Inhabilitado","tra_ba_fecha_inicio"=>"2021-11-01 00:00"));
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una opción'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica tra  
                            left outer join cfg_usuario b on (b.usr_correl = tra.tra_cm_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra.tra_cm_usuariom) 
                            left outer join cfg_producto pro on(tra.tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :emp_codigo)
                            left outer join cfg_usuario med on (tra.tra_cm_usr_correl = med.usr_correl and med.usr_estado = 'A')
                            left outer join cfg_sucursal lug on (tra.tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = 'A')
                            left outer join cfg_catalogo cat on(cat.cat_valor = tra.tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :emp_codigo)
                            ", " 
                             and tra.tra_cm_lugar_atencion = :tra_cm_lugar_atencion 
                             and tra.tra_cm_estado = :tra_cm_estado 
                             and (tra.tra_cm_etapa = 1 || tra.tra_cm_etapa = 2 || tra.tra_cm_etapa = 3) 
                             and tra_cm_empresa = :emp_codigo 
                             and tra_cm_ambiente = :tra_cm_ambiente 
                             and tra_cm_estado = 'A' 
                            ", 
                            [
                                'emp_codigo' => $emp_codigo,
                                'tra_cm_ambiente' => $amb_codigo,
                                'tra_cm_estado' => $tra_cm_estado,
                                //'tra_cm_tipo_consulta' => $tra_cm_tipo_consulta,
                                'tra_cm_lugar_atencion' => $tra_cm_lugar_atencion
                                //'tra_cm_usr_correl' => $tra_cm_usr_correl
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectBloqueoAgenda($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";*/
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 367;//$parameter['tamanio'] ?? 10;
                    /*$filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    
                    $age_suc_correlativo = $parameter['age_suc_correlativo'] ?? 0;*/
                    //$tra_cm_tipo_consulta = $parameter['tra_cm_tipo_consulta'] ?? 0;
                    $tra_ba_suc_correlativo = $parameter['tra_ba_suc_correlativo'] ?? 0;
                    $tra_ba_estado = 'A';
                    $tra_etapa = 1;

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    //tra_ba_correlativo,tra_ba_suc_correlativo,tra_ba_fecha_fin,tra_ba_estado 
                    $sql = " 
                    select 
                      date_format(tra_ba_fecha_inicio, '%Y-%m-%d 00:00') as tra_ba_fecha_inicio,
                      tra_ba_textcolor as textColor,
                      tra_ba_color as color,
                      tra_ba_rendering_background as rendering,
                      tra_ba_fecha_inicio as start,
                      tra_ba_etiqueta as title,
                      tra_ba_age_allDay as allDay 
                      from tra_bloqueo_agenda 
                      where 1=1
                      and tra_ba_suc_correlativo = :tra_ba_suc_correlativo 
                      and tra_ba_estado = :tra_ba_estado 
                      limit $pag_inicio, $tamanio";
                      //left outer join cfg_catalogo d on(tra_cm_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)
                    //var_dump($sql);
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_ba_suc_correlativo' => $tra_ba_suc_correlativo,
                        'tra_ba_estado' => $tra_ba_estado
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_bloqueo_agenda ", " 
                             and tra_ba_suc_correlativo = :tra_ba_suc_correlativo 
                             and tra_ba_estado = :tra_ba_estado 
                            ", 
                            [
                                'tra_ba_suc_correlativo' => $tra_ba_suc_correlativo,
                                'tra_ba_estado' => $tra_ba_estado
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function cmbServiciosGeneral($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                        
                    $sql = " select   
                    pro_correl,   
                    pro_nombre

                    from cfg_producto   
                    where 1 = 1  

                    and pro_empresa =:emp_codigo
                    and pro_ambiente =:amb_codigo
                    and pro_estado = 'A'
                    and pro_clasificacion = 2   
                    order by pro_nombre asc";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo    
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una opción'));
                        }else{
                            array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'No existen datos'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectServicioEspecialidad($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                        
                    $sql = " select   
                    pro_correl,   
                    pro_nombre

                    from cfg_producto   
                    where 1 = 1  

                    and pro_empresa =:emp_codigo
                    and pro_ambiente =:amb_codigo
                    and pro_estado = 'A'
                    and pro_clasificacion = 2   
                    order by pro_nombre asc";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo    
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una opción'));
                        }else{
                            array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'No existen datos'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
     public function selectAseguradoras($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $tra_cm_aseguradora = $parameter['tra_cm_aseguradora'] ?? 0;
                    $filtro = "";
                    if($tra_cm_aseguradora == 2){
                        $filtro = "";
                    }else{
                        $filtro = " and ase_correlativo = 0";
                        $tra_cm_aseguradora = 0;
                    }

                    $sql = " select   
                    ase_correlativo,  
                    ase_nombre 
                    from cfg_aseguradora   
                    where 1 = 1  
                    $filtro 
                    and ase_empresa =:emp_codigo
                    and ase_ambiente =:amb_codigo
                    and ase_estado = 'A'
                    order by ase_nombre asc";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo    
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("ase_correlativo"=>'','ase_nombre'=>'Seleccione una opción'));
                        }else{
                            //array_unshift($result,array("ase_correlativo"=>'','ase_nombre'=>'No existen datos'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectOrdenDeTrabajo($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";

                    $filter1 = $parameter['filter1'] ?? "undefined";
                    if(empty($filter1)) $filter1 = "undefined";

                    $filter2 = $parameter['filter2'] ?? "undefined";
                    if(empty($filter2)) $filter2 = "undefined";

                    $otra_no_consulta = $parameter['otra_no_consulta'] ?? 0;
                    $otra_estado = $parameter['otra_estado'] ?? 'A';
                    

                    $sql = " 
                    select 
                    a.otra_correlativo, 
                    a.otra_cli_cliente,  
                    a.otra_no_consulta,  
                    a.otra_aseguradora,  
                    ase.ase_nombre as cliente,
                    a.otra_plan,  
                    oc.ocf_param_valor as plan,
                    a.otra_tipo_servicio,  
                    a.otra_producto,  
                    a.otra_no_orden,  
                    a.otra_precio,
                    (select sum(tra.otra_precio) as precio from tra_orden_trabajo tra where tra.otra_no_consulta = a.otra_no_consulta and tra.otra_no_orden = a.otra_no_orden and tra.otra_estado !='E') as importe,
                    fac.tra_fac_correlativo,
                    a.otra_estado,
                    a.otra_fechai,  
                    a.otra_fecham  
                    from tra_orden_trabajo a
                    LEFT JOIN cfg_aseguradora ase on(ase.ase_correlativo = a.otra_aseguradora)  
                    LEFT JOIN cfg_objeto_config oc on(oc.ocf_objeto = 'Cfg_aseguradora_plan' and oc.ocf_objeto_codigo = a.otra_aseguradora and oc.ocf_correlativo = a.otra_plan) 
                    LEFT JOIN tra_factura fac on(fac.tra_fac_no_consulta = a.otra_no_consulta and fac.tra_fac_no_orden_trabajo = a.otra_no_orden and fac.tra_fac_estado !='E')
                    where 
                    1=1
                    and a.otra_estado =:otra_estado
                    and a.otra_empresa =:otra_empresa 
                    and a.otra_ambiente =:otra_ambiente 
                    and a.otra_no_consulta =:otra_no_consulta 
                    and ((a.otra_cli_cliente like concat('%',:filter,'%') or a.otra_plan like concat('%',:filter,'%') or a.otra_tipo_servicio like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and (a.otra_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                    and (a.otra_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') GROUP BY a.otra_no_orden 
                    limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'otra_no_consulta' => $otra_no_consulta,
                    'otra_estado' => $otra_estado,
                    'otra_empresa' => $emp_codigo,
                    'otra_ambiente' => $amb_codigo,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'filter' => $filter,
                    'filter1' => $filter1,
                    'filter2' => $filter2
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_orden_trabajo a
                        LEFT JOIN cfg_aseguradora ase on(ase.ase_correlativo = a.otra_aseguradora)  
                        LEFT JOIN cfg_objeto_config oc on(oc.ocf_objeto = 'Cfg_aseguradora_plan' and oc.ocf_objeto_codigo = a.otra_aseguradora and oc.ocf_correlativo = a.otra_plan)  
                        ", "   
                        and a.otra_no_consulta =:otra_no_consulta 
                        and a.otra_estado =:otra_estado
                        and a.otra_empresa =:otra_empresa 
                        and a.otra_ambiente =:otra_ambiente 
                        and ((a.otra_cli_cliente like concat('%',:filter,'%') or a.otra_plan like concat('%',:filter,'%') or a.otra_tipo_servicio like concat('%',:filter,'%')) or (:filter = 'undefined'))
                        and (a.otra_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                        and (a.otra_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') GROUP BY otra_no_orden 
                        ", 
                        [
                        'otra_no_consulta' => $otra_no_consulta,
                        'otra_estado' => $otra_estado,
                        'otra_empresa' => $emp_codigo,
                        'otra_ambiente' => $amb_codigo,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter,
                        'filter1' => $filter1,
                        'filter2' => $filter2
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectNoOrdenDeTrabajo($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";

                    $filter1 = $parameter['filter1'] ?? "undefined";
                    if(empty($filter1)) $filter1 = "undefined";

                    $filter2 = $parameter['filter2'] ?? "undefined";
                    if(empty($filter2)) $filter2 = "undefined";

                    $otra_no_consulta = $parameter['otra_no_consulta'] ?? 0;
                    $otra_estado = $parameter['otra_estado'] ?? 'A';
                    
                    
                    $sql = " 
                    select 
                    (a.otra_no_orden + 1) as no_orden 
                    from tra_orden_trabajo a
                    where 
                    1=1
                    and a.otra_estado =:otra_estado
                    and a.otra_empresa =:otra_empresa 
                    and a.otra_ambiente =:otra_ambiente 
                    and a.otra_no_consulta =:otra_no_consulta 
                    and ((a.otra_cli_cliente like concat('%',:filter,'%') or a.otra_plan like concat('%',:filter,'%') or a.otra_tipo_servicio like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and (a.otra_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                    and (a.otra_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                     ORDER BY a.otra_no_orden DESC  LIMIT 1";
                    //limit $pag_inicio, $tamanio 
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'otra_no_consulta' => $otra_no_consulta,
                    'otra_estado' => $otra_estado,
                    'otra_empresa' => $emp_codigo,
                    'otra_ambiente' => $amb_codigo,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'filter' => $filter,
                    'filter1' => $filter1,
                    'filter2' => $filter2
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_orden_trabajo a
                        ", "   
                        and a.otra_no_consulta =:otra_no_consulta 
                        and a.otra_estado =:otra_estado
                        and a.otra_empresa =:otra_empresa 
                        and a.otra_ambiente =:otra_ambiente 
                        and ((a.otra_cli_cliente like concat('%',:filter,'%') or a.otra_plan like concat('%',:filter,'%') or a.otra_tipo_servicio like concat('%',:filter,'%')) or (:filter = 'undefined'))
                        and (a.otra_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                        and (a.otra_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                        ", 
                        [
                        'otra_no_consulta' => $otra_no_consulta,
                        'otra_estado' => $otra_estado,
                        'otra_empresa' => $emp_codigo,
                        'otra_ambiente' => $amb_codigo,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter,
                        'filter1' => $filter1,
                        'filter2' => $filter2
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    
    public function selectEspecialidades($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $ocf_objeto_permiso = 'Cfg_sucursal';//$parameter['ocf_objeto_permiso'] ?? 'no_object';//corregir
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, $ocf_objeto_permiso, 'lectura');
                if($userFuncionality == 'OK'){
                    $ocf_objeto = $parameter['ocf_objeto'] ?? 'no_object';
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $ocf_estado = $parameter['ocf_estado'] ?? 'A';
                    //$ocf_objeto_codigo = $parameter['ocf_objeto_codigo'] ?? 0;
                    $ocf_param_tipo = $parameter['ocf_param_tipo'] ?? 0;
                    $type = $parameter['type'] ?? 'qry';

                    $sql = " 
                    select 
                    a.ocf_correlativo, 
                    a.ocf_codigo,  
                    a.ocf_cod_cat,  
                    a.ocf_empresa,  
                    a.ocf_objeto,  
                    a.ocf_objeto_codigo,  
                    a.ocf_orden,  
                    a.ocf_param_nombre,  
                    a.ocf_param_tipo,  
                    a.ocf_param_catalogo,  
                    a.ocf_param_valor,  
                    d.cat_nombre cat_estado_nombre,  
                    pro.pro_nombre nombre_especialidad,  
                    a.ocf_estado,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as ocf_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as ocf_usuariom,  
                    a.ocf_fechai,  
                    a.ocf_fecham  
                    from cfg_objeto_config a
                    left outer join cfg_catalogo d on(a.ocf_estado= d.cat_valor and d.cat_tipo = 'COLOCA_CATALOGO_AQUI' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.ocf_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.ocf_usuariom)
                    left outer join cfg_producto pro on (pro.pro_correl = a.ocf_param_tipo and pro.pro_clasificacion=2 and pro.pro_estado='A')
                    where 
                    1=1
                    and a.ocf_empresa = :emp_codigo 
                    and a.ocf_estado =:ocf_estado
                    and a.ocf_objeto = :ocf_objeto
                    and a.ocf_param_tipo = :ocf_param_tipo
                    and (a.ocf_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.ocf_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 

                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                    'ocf_estado' => $ocf_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'ocf_objeto'=>$ocf_objeto,
                    'ocf_param_tipo'=>$ocf_param_tipo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($result)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_objeto_config a
                        left outer join cfg_catalogo d on(a.ocf_estado= d.cat_valor and d.cat_tipo = 'COLOCA_CATALOGO_AQUI' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.ocf_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.ocf_usuariom)
                        ", "   and a.ocf_empresa = :emp_codigo 
                        and a.ocf_estado =:ocf_estado
                        and a.ocf_objeto = :ocf_objeto
                        and a.ocf_param_tipo = :ocf_param_tipo
                        and (a.ocf_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                        and (a.ocf_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                        ", 
                        ['emp_codigo' => $emp_codigo,
                        'ocf_estado' => $ocf_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'ocf_objeto'=>$ocf_objeto,
                        'ocf_param_tipo'=>$ocf_param_tipo
                        ]);
                        
                        array_unshift($result,array("ocf_correlativo"=>'','nombre_especialidad'=>'Seleccione una opción'));

                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                            array_unshift($result,array("ocf_correlativo"=>'','nombre_especialidad'=>'No Existen Especialidades Definidas...'));
                        
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    
    public function cancelarConsulta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_cm_correlativo = (int)$parameter['tra_cm_correlativo'] ?? 0;
                    
                    $sql = "update tra_consulta_medica set tra_cm_estado = 'E',tra_cm_fecham = now() where tra_cm_correlativo = :tra_cm_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'tra_cm_correlativo' => $tra_cm_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Consulta eliminada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Consulta no pudo ser eliminada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function confirmarConsulta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'modificar');
                if($userFuncionality == 'OK'){
                    $tra_cm_correlativo = (int)$parameter['tra_cm_correlativo'] ?? 0;
                    $tra_cm_observaciones = $parameter['tra_cm_observaciones'] ?? 'null';
                    
                    $tra_cm_observaciones = $utility->validarLongitudString($tra_cm_observaciones, 0, 500);
                    $sql = "update tra_consulta_medica set 
                    tra_cm_observaciones = :tra_cm_observaciones,
                    tra_cm_fecha_confirmacion = now(),
                    tra_cm_etapa = 2,
                    tra_cm_usuariom = :id_usuario,
                    tra_cm_fecham = now() 
                    where tra_cm_correlativo = :tra_cm_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'id_usuario' => $id_usuario,
                        'tra_cm_correlativo' => $tra_cm_correlativo,
                        'tra_cm_observaciones' => $tra_cm_observaciones
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Cita confirmada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Cita no pudo ser confirmada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function recalendarizarConsulta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'modificar');//cambiar nombre objeto
                if($userFuncionality == 'OK'){
                    $tra_duracion_consulta = 40;
                    $tra_cm_correlativo = (int)$parameter['tra_cm_correlativo'] ?? 0;
                    $tra_cm_observaciones = $parameter['tra_cm_observaciones'] ?? 'null';
                    $tra_cm_fecha_inicio_consulta = $parameter['tra_cm_fecha_inicio_consulta'] ?? NULL;
                    if($tra_cm_fecha_inicio_consulta == ""){ $tra_cm_fecha_inicio_consulta = NULL;}
                    $tra_cm_fecha_fin_consulta = NULL;

                    if($tra_cm_fecha_inicio_consulta !=""){
                        //$tra_cm_fecha_fin_consulta = $tra_cm_fecha_inicio_consulta->modify('+40 minute'); 
                        $tra_cm_fecha_fin_consulta = strtotime ( '+'.$tra_duracion_consulta.' minute' , strtotime($tra_cm_fecha_inicio_consulta)) ;
                        $tra_cm_fecha_fin_consulta = date( 'Y-m-d H:i:s' , $tra_cm_fecha_fin_consulta);
                        $tra_cm_hora_fin = date( 'H:i' , $tra_cm_fecha_fin_consulta);
                    }
                    
                    $tra_fecha_inicio = date("d/m/Y H:i", strtotime($tra_cm_fecha_inicio_consulta));
                    //$tra_hora_inicio_fin = 'de '.date("H:i", strtotime($tra_cm_fecha_inicio_consulta)).' a '.$tra_cm_hora_fin;
                    //date(tra_cm_fecha_inicio_consulta, '%d/%m/%y de %H:%i') as tra_cm_fecha_inicio_consulta;
                    //$tra_cm_hora_fin =  date_format(tra_cm_fecha_inicio_consulta, '%d/%m/%y de %H:%i') as tra_cm_fecha_inicio_consulta;

                    $sql = "update tra_consulta_medica set 
                    tra_cm_fecha_inicio_consulta = :tra_cm_fecha_inicio_consulta,
                    tra_cm_fecha_fin_consulta = :tra_cm_fecha_fin_consulta,
                    tra_cm_observaciones = :tra_cm_observaciones,
                    tra_cm_usuariom = :id_usuario,
                    tra_cm_fecham = now() 
                    where tra_cm_correlativo = :tra_cm_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'tra_cm_correlativo' => $tra_cm_correlativo,
                        'tra_cm_fecha_inicio_consulta' => $tra_cm_fecha_inicio_consulta,
                        'tra_cm_fecha_fin_consulta' => $tra_cm_fecha_fin_consulta,
                        'tra_cm_observaciones' => $tra_cm_observaciones,
                        'id_usuario' => $id_usuario
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Cita confirmado exitosamente', 'status'=>200,'token'=>$token,'key' => $tra_fecha_inicio.' '.$tra_hora_inicio_fin);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Cita no pudo ser confirmado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function selectConsultaMedica($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    //$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    //$fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $tra_cm_correlativo = $parameter['tra_cm_correlativo'] ?? 0;
                    
                    $tra_cm_estado = 'A';
                    $tra_cm_etapa = 3;//ver que etapa tendra

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 
                      tra_cm_correlativo,
                      tra_cm_codigo,
                      tra_cm_empresa,
                      tra_cm_ambiente,
                      tra_cm_procedencia,
                      tra_cm_aseguradora,
                      ase.ase_nombre as aseguradora,
                      tra_cm_primer_consulta,
                      if(tra_cm_primer_consulta = 1,'Primer Consulta','Reconsulta') as estado_cita,
                      tra_cm_lugar_atencion,
                      tra_cm_tipo_consulta,
                      tra_cm_usr_correl,
                      tra_cm_fecha_inicio_consulta,
                      date_format(tra_cm_fecha_inicio_consulta, '%d/%m/%y %T') as fecha_inicio_consulta, 
                      tra_cm_fecha_fin_consulta,
                      tra_cm_fecha_inicio_consulta as start,
                      tra_cm_fecha_fin_consulta as end,
                      date_format(tra_cm_fecha_inicio_consulta, '%H:%i') as hora_inicio,  
                      date_format(tra_cm_fecha_fin_consulta, '%H:%i') as hora_fin,
                      concat(date_format(tra_cm_fecha_inicio_consulta, '%H:%i'),'-',date_format(tra_cm_fecha_fin_consulta, '%H:%i')) as duracionConsulta,
                      tra_cm_nombre_paciente,
                      IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO') as nombre_medico,
                      concat(med.usr_nombres,' ', med.usr_apellidos) as medico,
                      pro.pro_nombre as nombre_especialidad,
                      pro.pro_color as color_etiqueta,
                      concat(date_format(tra_cm_fecha_fin_consulta, '%H:%i'),'\n',pro.pro_nombre,'\n',IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO')) as title,
                      pro.pro_color as backgroundColor,
                      pro.pro_tipo_ficha as tra_cm_tipo_ficha,
                      lug.suc_nombre as lugar_atencion,
                      concat(TIMESTAMPDIFF(MINUTE,tra_cm_fecha_inicio_consulta,tra_cm_fecha_fin_consulta),' ','Minutos') as minutos,
                      tra_cm_fecha_nacimiento,
                      if(tra_cm_etapa = 1,'No Confirmado','Confirmado') as estado,
                      IF(tra_cm_observaciones = 'undefined', '',tra_cm_observaciones) as tra_cm_observaciones,
                      tra_cm_fecha_confirmacion,
                      tra_cm_cita_reprogramada_inicio,
                      tra_cm_cita_reprogramada_fin,
                      tra_cm_etapa,
                      tra_cm_paciente_intercalado,
                      tra_cm_registro_proxima_cita,
                      tra_cm_proxima_cita,
                      tra_cm_dias,
                      IF(tra_cm_observaciones_proxima_cita = 'undefined', '',tra_cm_observaciones_proxima_cita) as tra_cm_observaciones_proxima_cita,
                      tra_cm_confirmacion_cita,
                      tra_cm_estado,
                      tra_cm_usuarioi,
                      tra_cm_usuariom,
                      tra_cm_fechai,
                      tra_cm_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra_cm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra_cm_fecham, '%d/%m/%y %T') as age_fecham,
                      cat.cat_nombre as procedencia 
                      from tra_consulta_medica 
                          left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra_cm_usuariom) 
                          left outer join cfg_producto pro on(tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :tra_cm_empresa)
                          left outer join cfg_usuario med on (tra_cm_usr_correl = med.usr_correl and med.usr_estado = :tra_cm_estado)
                          left outer join cfg_sucursal lug on (tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = :tra_cm_estado) 
                          left outer join cfg_catalogo cat on(cat.cat_valor = tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :tra_cm_empresa)
                          left outer join cfg_aseguradora ase on (ase.ase_correlativo = tra_cm_aseguradora and ase.ase_estado != 'E')
                      where 1=1
                      and tra_cm_empresa = :tra_cm_empresa 
                      and tra_cm_ambiente = :tra_cm_ambiente 
                      and tra_cm_estado = :tra_cm_estado 
                      and tra_cm_etapa >= :tra_cm_etapa 
                      and tra_cm_correlativo = :tra_cm_correlativo 
                      limit $pag_inicio, $tamanio";
                      //left outer join cfg_catalogo d on(tra_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_cm_empresa' => $emp_codigo,
                        'tra_cm_ambiente' => $amb_codigo,
                        'tra_cm_estado' => $tra_cm_estado,
                        'tra_cm_correlativo' => $tra_cm_correlativo,
                        'tra_cm_etapa' => $tra_cm_etapa
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica 
                            left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra_cm_usuariom) 
                            left outer join cfg_producto pro on(tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :tra_cm_empresa)
                                left outer join cfg_usuario med on (tra_cm_usr_correl = med.usr_correl and med.usr_estado = :tra_cm_estado)
                                left outer join cfg_sucursal lug on (tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = :tra_cm_estado)
                                left outer join cfg_catalogo cat on(cat.cat_valor = tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :tra_cm_empresa)
                            ", " 
                             and tra_cm_empresa = :tra_cm_empresa 
                             and tra_cm_ambiente = :tra_cm_ambiente 
                             and tra_cm_estado = :tra_cm_estado 
                             and tra_cm_etapa >= :tra_cm_etapa 
                             and tra_cm_correlativo = :tra_cm_correlativo 
                            ", 
                            [
                                'tra_cm_empresa' => $emp_codigo,
                                'tra_cm_ambiente' => $amb_codigo,
                                'tra_cm_estado' => $tra_cm_estado,
                                'tra_cm_correlativo' => $tra_cm_correlativo,
                                'tra_cm_etapa' => $tra_cm_etapa
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectUltimasConsultasMedicas($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    //$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    //$fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $tra_cm_correlativo = $parameter['tra_cm_correlativo'] ?? 0;
                    
                    $tra_cm_estado = 'A';
                    $tra_cm_etapa = 3;//ver que etapa tendra

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 
                      tra_cm_correlativo,
                      tra_cm_codigo,
                      tra_cm_empresa,
                      tra_cm_ambiente,
                      tra_cm_procedencia,
                      tra_cm_aseguradora,
                      ase.ase_nombre as aseguradora,
                      tra_cm_primer_consulta,
                      if(tra_cm_primer_consulta = 1,'Primer Consulta','Reconsulta') as estado_cita,
                      tra_cm_lugar_atencion,
                      tra_cm_tipo_consulta,
                      tra_cm_usr_correl,
                      tra_cm_fecha_inicio_consulta,
                      date_format(tra_cm_fecha_inicio_consulta, '%d/%m/%y %T') as fecha_inicio_consulta, 
                      tra_cm_fecha_fin_consulta,
                      tra_cm_fecha_inicio_consulta as start,
                      tra_cm_fecha_fin_consulta as end,
                      date_format(tra_cm_fecha_inicio_consulta, '%H:%i') as hora_inicio,  
                      date_format(tra_cm_fecha_fin_consulta, '%H:%i') as hora_fin,
                      concat(date_format(tra_cm_fecha_inicio_consulta, '%H:%i'),'-',date_format(tra_cm_fecha_fin_consulta, '%H:%i')) as duracionConsulta,
                      tra_cm_nombre_paciente,
                      IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO') as nombre_medico,
                      concat(med.usr_nombres,' ', med.usr_apellidos) as medico,
                      pro.pro_nombre as nombre_especialidad,
                      pro.pro_color as color_etiqueta,
                      concat(date_format(tra_cm_fecha_fin_consulta, '%H:%i'),'\n',pro.pro_nombre,'\n',IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO')) as title,
                      pro.pro_color as backgroundColor,
                      pro.pro_tipo_ficha as tra_cm_tipo_ficha,
                      lug.suc_nombre as lugar_atencion,
                      concat(TIMESTAMPDIFF(MINUTE,tra_cm_fecha_inicio_consulta,tra_cm_fecha_fin_consulta),' ','Minutos') as minutos,
                      tra_cm_fecha_nacimiento,
                      if(tra_cm_etapa = 1,'No Confirmado','Confirmado') as estado,
                      IF(tra_cm_observaciones = 'undefined', '',tra_cm_observaciones) as tra_cm_observaciones,
                      tra_cm_fecha_confirmacion,
                      tra_cm_cita_reprogramada_inicio,
                      tra_cm_cita_reprogramada_fin,
                      tra_cm_etapa,
                      tra_cm_paciente_intercalado,
                      tra_cm_registro_proxima_cita,
                      tra_cm_proxima_cita,
                      tra_cm_dias,
                      IF(tra_cm_observaciones_proxima_cita = 'undefined', '',tra_cm_observaciones_proxima_cita) as tra_cm_observaciones_proxima_cita,
                      tra_cm_confirmacion_cita,
                      tra_cm_estado,
                      tra_cm_usuarioi,
                      tra_cm_usuariom,
                      tra_cm_fechai,
                      tra_cm_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra_cm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra_cm_fecham, '%d/%m/%y %T') as age_fecham,
                      cat.cat_nombre as procedencia 
                      from tra_consulta_medica 
                          left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra_cm_usuariom) 
                          left outer join cfg_producto pro on(tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :tra_cm_empresa)
                          left outer join cfg_usuario med on (tra_cm_usr_correl = med.usr_correl and med.usr_estado = :tra_cm_estado)
                          left outer join cfg_sucursal lug on (tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = :tra_cm_estado) 
                          left outer join cfg_catalogo cat on(cat.cat_valor = tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :tra_cm_empresa)
                          left outer join cfg_aseguradora ase on (ase.ase_correlativo = tra_cm_aseguradora and ase.ase_estado != 'E')
                      where 1=1
                      and tra_cm_empresa = :tra_cm_empresa 
                      and tra_cm_ambiente = :tra_cm_ambiente 
                      and tra_cm_estado = :tra_cm_estado 
                      and tra_cm_etapa > :tra_cm_etapa 
                      and tra_cm_correlativo = :tra_cm_correlativo 
                      limit $pag_inicio, $tamanio";
                      //left outer join cfg_catalogo d on(tra_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_cm_empresa' => $emp_codigo,
                        'tra_cm_ambiente' => $amb_codigo,
                        'tra_cm_estado' => $tra_cm_estado,
                        'tra_cm_correlativo' => $tra_cm_correlativo,
                        'tra_cm_etapa' => $tra_cm_etapa
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica 
                            left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra_cm_usuariom) 
                            left outer join cfg_producto pro on(tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :tra_cm_empresa)
                                left outer join cfg_usuario med on (tra_cm_usr_correl = med.usr_correl and med.usr_estado = :tra_cm_estado)
                                left outer join cfg_sucursal lug on (tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = :tra_cm_estado)
                                left outer join cfg_catalogo cat on(cat.cat_valor = tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :tra_cm_empresa)
                            ", " 
                             and tra_cm_empresa = :tra_cm_empresa 
                             and tra_cm_ambiente = :tra_cm_ambiente 
                             and tra_cm_estado = :tra_cm_estado 
                             and tra_cm_etapa > :tra_cm_etapa 
                             and tra_cm_correlativo = :tra_cm_correlativo 
                            ", 
                            [
                                'tra_cm_empresa' => $emp_codigo,
                                'tra_cm_ambiente' => $amb_codigo,
                                'tra_cm_estado' => $tra_cm_estado,
                                'tra_cm_correlativo' => $tra_cm_correlativo,
                                'tra_cm_etapa' => $tra_cm_etapa
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectUltimaConsulta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    //$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    //$fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $cli_correlativo = $parameter['cli_correlativo'] ?? 0;
                    
                    $tra_cm_estado = 'A';
                    $tra_cm_etapa = 3;//ver que etapa tendra

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 
                      tra_cm_correlativo,
                      tra_cm_codigo,
                      tra_cm_empresa,
                      tra_cm_ambiente,
                      tra_cm_procedencia,
                      tra_cm_aseguradora,
                      ase.ase_nombre as aseguradora,
                      tra_cm_primer_consulta,
                      if(tra_cm_primer_consulta = 1,'Primer Consulta','Reconsulta') as estado_cita,
                      tra_cm_lugar_atencion,
                      tra_cm_tipo_consulta,
                      tra_cm_usr_correl,
                      tra_cm_fecha_inicio_consulta,
                      date_format(tra_cm_fecha_inicio_consulta, '%d/%m/%y %T') as fecha_inicio_consulta, 
                      tra_cm_fecha_fin_consulta,
                      tra_cm_cli_correlativo,
                      tra_cm_fecha_inicio_consulta as start,
                      tra_cm_fecha_fin_consulta as end,
                      date_format(tra_cm_fecha_inicio_consulta, '%H:%i') as hora_inicio,  
                      date_format(tra_cm_fecha_fin_consulta, '%H:%i') as hora_fin,
                      concat(date_format(tra_cm_fecha_inicio_consulta, '%H:%i'),'-',date_format(tra_cm_fecha_fin_consulta, '%H:%i')) as duracionConsulta,
                      tra_cm_nombre_paciente,
                      IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO') as nombre_medico,
                      concat(med.usr_nombres,' ', med.usr_apellidos) as medico,
                      pro.pro_nombre as nombre_especialidad,
                      pro.pro_color as color_etiqueta,
                      concat(date_format(tra_cm_fecha_fin_consulta, '%H:%i'),'\n',pro.pro_nombre,'\n',IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO')) as title,
                      pro.pro_color as backgroundColor,
                      pro.pro_tipo_ficha as tra_cm_tipo_ficha,
                      lug.suc_nombre as lugar_atencion,
                      concat(TIMESTAMPDIFF(MINUTE,tra_cm_fecha_inicio_consulta,tra_cm_fecha_fin_consulta),' ','Minutos') as minutos,
                      tra_cm_fecha_nacimiento,
                      if(tra_cm_etapa = 1,'No Confirmado','Confirmado') as estado,
                      IF(tra_cm_observaciones = 'undefined', '',tra_cm_observaciones) as tra_cm_observaciones,
                      tra_cm_fecha_confirmacion,
                      tra_cm_cita_reprogramada_inicio,
                      tra_cm_cita_reprogramada_fin,
                      tra_cm_etapa,
                      tra_cm_paciente_intercalado,
                      tra_cm_registro_proxima_cita,
                      tra_cm_proxima_cita,
                      tra_cm_dias,
                      IF(tra_cm_observaciones_proxima_cita = 'undefined', '',tra_cm_observaciones_proxima_cita) as tra_cm_observaciones_proxima_cita,
                      tra_cm_confirmacion_cita,
                      tra_cm_estado,
                      tra_cm_usuarioi,
                      tra_cm_usuariom,
                      tra_cm_fechai,
                      tra_cm_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra_cm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra_cm_fecham, '%d/%m/%y %T') as age_fecham,
                      cat.cat_nombre as procedencia 
                      from tra_consulta_medica 
                          left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra_cm_usuariom) 
                          left outer join cfg_producto pro on(tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :tra_cm_empresa)
                          left outer join cfg_usuario med on (tra_cm_usr_correl = med.usr_correl and med.usr_estado = :tra_cm_estado)
                          left outer join cfg_sucursal lug on (tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = :tra_cm_estado) 
                          left outer join cfg_catalogo cat on(cat.cat_valor = tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :tra_cm_empresa)
                          left outer join cfg_aseguradora ase on (ase.ase_correlativo = tra_cm_aseguradora and ase.ase_estado != 'E')
                      where 1=1
                      and tra_cm_empresa = :tra_cm_empresa 
                      and tra_cm_ambiente = :tra_cm_ambiente 
                      and tra_cm_estado = :tra_cm_estado 
                      and tra_cm_etapa > :tra_cm_etapa 
                      and tra_cm_cli_correlativo = :cli_correlativo ORDER BY tra_cm_correlativo DESC 
                      limit 1";//$pag_inicio, $tamanio
                      //left outer join cfg_catalogo d on(tra_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_cm_empresa' => $emp_codigo,
                        'tra_cm_ambiente' => $amb_codigo,
                        'tra_cm_estado' => $tra_cm_estado,
                        'cli_correlativo' => $cli_correlativo,
                        'tra_cm_etapa' => $tra_cm_etapa
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica 
                            left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra_cm_usuariom) 
                            left outer join cfg_producto pro on(tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :tra_cm_empresa)
                                left outer join cfg_usuario med on (tra_cm_usr_correl = med.usr_correl and med.usr_estado = :tra_cm_estado)
                                left outer join cfg_sucursal lug on (tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = :tra_cm_estado)
                                left outer join cfg_catalogo cat on(cat.cat_valor = tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :tra_cm_empresa)
                            ", " 
                             and tra_cm_empresa = :tra_cm_empresa 
                             and tra_cm_ambiente = :tra_cm_ambiente 
                             and tra_cm_estado = :tra_cm_estado 
                             and tra_cm_etapa > :tra_cm_etapa 
                             and tra_cm_cli_correlativo = :tra_cm_cli_correlativo 
                            ", 
                            [
                                'tra_cm_empresa' => $emp_codigo,
                                'tra_cm_ambiente' => $amb_codigo,
                                'tra_cm_estado' => $tra_cm_estado,
                                'tra_cm_cli_correlativo' => $tra_cm_cli_correlativo,
                                'tra_cm_etapa' => $tra_cm_etapa
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectExamenFisico($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    //$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    //$fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $tra_ef_tra_fm_correlativo = $parameter['tra_ef_tra_fm_correlativo'] ?? 0;
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    
                    $cat_estado = 'A';

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    //left outer join tra_examen_fisico ef on(cat_valor = ef.tra_ef_tra_fm_correlativo and cat_estado = 'A')
                    $sql = " 
                    select 
                      cat_correl,
                      cat_empresa,
                      cat_tipo,
                      cat_valor,
                      cat_nombre,
                      cat_estado,
                      cat_usuarioi,
                      cat_usuariom,
                      cat_fechai,
                      cat_fecham,
                      cat_ambiente,
                      ef.tra_ef_normal as ef_normal,
                      ef.tra_ef_anormal,
                      ef.tra_ef_no_explorado,
                      ef.tra_ef_descripcion,
                      date_format(cat_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(cat_fecham, '%d/%m/%y %T') as age_fecham 
                      from cfg_catalogo 
                          left outer join tra_examen_fisico ef on(cat_valor = ef.tra_ef_cat_valor and ef.tra_ef_tra_fm_correlativo = :tra_ef_tra_fm_correlativo and cat_estado = 'A')
                      where 1=1
                      and cat_empresa = :empresa 
                      and cat_ambiente = :ambiente 
                      and cat_estado = :cat_estado 
                      and cat_tipo = 'EXAMEN_FISICO_FM' 
                      limit $pag_inicio, $tamanio";
                      //left outer join cfg_catalogo d on(tra_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'empresa' => $emp_codigo,
                        'ambiente' => $amb_codigo,
                        'cat_estado' => $cat_estado,
                        'tra_ef_tra_fm_correlativo' => $tra_ef_tra_fm_correlativo
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_catalogo 
                            left outer join tra_examen_fisico ef on(cat_valor = ef.tra_ef_tra_fm_correlativo and cat_tipo = 'EXAMEN_FISICO_FM')
                            ", " 
                              and cat_empresa = :empresa 
                              and cat_ambiente = :ambiente 
                              and cat_estado = :cat_estado 
                            ", 
                            [
                                'empresa' => $emp_codigo,
                                'ambiente' => $amb_codigo,
                                'cat_estado' => $cat_estado
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectReceta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    //$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    //$fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $tra_rm_tra_cm_correlativo = $parameter['tra_rm_tra_cm_correlativo'] ?? 0;
                    $tra_rm_tra_no_receta = $parameter['tra_rm_tra_no_receta'] ?? 0;
                    //$tra_rm_tipo_ficha = $parameter['tra_rm_tipo_ficha'] ?? 0;
                    
                    $tra_cm_estado = 'A';
                    $tra_cm_etapa = 2;//ver que etapa tendra

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                    $sql = " 
                    select 
                      tra_rm_correlativo,
                      tra_rm_tra_cm_correlativo,
                      tra_rm_tra_no_receta,
                      tra_rm_descripcion,
                      tra_rm_tipo_ficha,
                      tra_rm_estado 
                      from tra_receta_medica 
                      where 1=1
                      and tra_rm_tra_cm_correlativo = :tra_rm_tra_cm_correlativo 
                      and tra_rm_tra_no_receta = :tra_rm_tra_no_receta 
                      and tra_rm_estado !='E' ORDER BY tra_rm_correlativo DESC
                      limit $pag_inicio, $tamanio";
                      //and tra_rm_tipo_ficha = :tra_rm_tipo_ficha 
                      //left outer join cfg_catalogo d on(tra_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_rm_tra_cm_correlativo' => $tra_rm_tra_cm_correlativo,
                        'tra_rm_tra_no_receta' => $tra_rm_tra_no_receta
                        //'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_receta_medica ", " 
                              and tra_rm_tra_cm_correlativo = :tra_rm_tra_cm_correlativo 
                              and tra_rm_tra_no_receta = :tra_rm_tra_no_receta 
                              and tra_rm_tipo_ficha = :tra_rm_tipo_ficha 
                              and tra_rm_estado !='E' 
                            ", 
                            [
                                'tra_rm_tra_cm_correlativo' => $tra_rm_tra_cm_correlativo,
                                'tra_rm_tra_no_receta' => $tra_rm_tra_no_receta,
                                'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectRecetaExamenComplementario($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    //$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    //$fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $tra_rmex_tra_cm_correlativo = $parameter['tra_rmex_tra_cm_correlativo'] ?? 0;
                    $tra_rmex_tra_no_receta = $parameter['tra_rmex_tra_no_receta'] ?? 0;
                    //$tra_rm_tipo_ficha = $parameter['tra_rm_tipo_ficha'] ?? 0;
                    
                    $tra_cm_etapa = 2;//ver que etapa tendra

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                    $sql = " 
                    select 
                      tra_rmex_correlativo,
                      tra_rmex_tra_cm_correlativo,
                      tra_rmex_tra_no_receta,
                      tra_rmex_descripcion,
                      tra_rmex_tipo_ficha,
                      tra_rmex_estado 
                      from tra_receta_medica_examen_complementario 
                      where 1=1
                      and tra_rmex_tra_cm_correlativo = :tra_rmex_tra_cm_correlativo 
                      and tra_rmex_tra_no_receta = :tra_rmex_tra_no_receta 
                      and tra_rmex_estado !='E' ORDER BY tra_rmex_correlativo DESC
                      limit $pag_inicio, $tamanio";
                      //and tra_rmex_tipo_ficha = :tra_rmex_tipo_ficha 
                      //left outer join cfg_catalogo d on(tra_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_rmex_tra_cm_correlativo' => $tra_rmex_tra_cm_correlativo,
                        'tra_rmex_tra_no_receta' => $tra_rmex_tra_no_receta
                        //'tra_rmex_tipo_ficha' => $tra_rmex_tipo_ficha
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_receta_medica_examen_complementario ", " 
                              and tra_rmex_tra_cm_correlativo = :tra_rmex_tra_cm_correlativo 
                              and tra_rmex_tra_no_receta = :tra_rmex_tra_no_receta 
                              and tra_rmex_estado !='E' 
                            ", 
                            [
                                'tra_rmex_tra_cm_correlativo' => $tra_rmex_tra_cm_correlativo,
                                'tra_rmex_tra_no_receta' => $tra_rmex_tra_no_receta
                                //'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectProximaConsulta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = 100;//$parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";

                    //$pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    //$tamanio = 366;//$parameter['tamanio'] ?? 10;
                    //$tra_cm_correlativo = $parameter['tra_cm_correlativo'] ?? 0;
                    $tra_cm_confirmacion_cita = 1;//$parameter['tra_cm_confirmacion_cita'] ?? 0;
                    
                    $tra_cm_estado = 'A';
                    $tra_cm_etapa = 2;//ver que etapa tendra

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 
                      tra_cm_correlativo,
                      tra_cm_codigo,
                      tra_cm_empresa,
                      tra_cm_ambiente,
                      tra_cm_procedencia,
                      tra_cm_aseguradora,
                      ase.ase_nombre as aseguradora,
                      tra_cm_primer_consulta,
                      if(tra_cm_primer_consulta = 1,'Primer Consulta','Reconsulta') as estado_cita,
                      tra_cm_lugar_atencion,
                      tra_cm_tipo_consulta,
                      tra_cm_usr_correl,
                      tra_cm_fecha_inicio_consulta,
                      date_format(tra_cm_fecha_inicio_consulta, '%d/%m/%y %T') as fecha_inicio_consulta, 
                      tra_cm_fecha_fin_consulta,
                      tra_cm_fecha_inicio_consulta as start,
                      tra_cm_fecha_fin_consulta as end,
                      date_format(tra_cm_fecha_inicio_consulta, '%H:%i') as hora_inicio,  
                      date_format(tra_cm_fecha_fin_consulta, '%H:%i') as hora_fin,
                      concat(date_format(tra_cm_fecha_inicio_consulta, '%H:%i'),'-',date_format(tra_cm_fecha_fin_consulta, '%H:%i')) as duracionConsulta,
                      cli.cli_nombre as tra_cm_nombre_paciente,
                      cli.cli_fecha_nacimiento as fecha_nacimiento,
                      cli.cli_telefono1 as cli_telefono1,
                      cli.cli_email as cli_email,
                      IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO') as nombre_medico,
                      concat(med.usr_nombres,' ', med.usr_apellidos) as medico,
                      pro.pro_nombre as nombre_especialidad,
                      pro.pro_color as color_etiqueta,
                      concat(date_format(tra_cm_fecha_fin_consulta, '%H:%i'),'\n',pro.pro_nombre,'\n',IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO')) as title,
                      pro.pro_color as backgroundColor,
                      pro.pro_tipo_ficha as tra_cm_tipo_ficha,
                      lug.suc_nombre as lugar_atencion,
                      concat(TIMESTAMPDIFF(MINUTE,tra_cm_fecha_inicio_consulta,tra_cm_fecha_fin_consulta),' ','Minutos') as minutos,
                      tra_cm_fecha_nacimiento,
                      if(tra_cm_etapa = 1,'No Confirmado','Confirmado') as estado,
                      IF(tra_cm_observaciones = 'undefined', '',tra_cm_observaciones) as tra_cm_observaciones,
                      tra_cm_fecha_confirmacion,
                      tra_cm_cita_reprogramada_inicio,
                      tra_cm_cita_reprogramada_fin,
                      tra_cm_etapa,
                      tra_cm_paciente_intercalado,
                      date_format(tra_cm_registro_proxima_cita, '%d/%m/%Y %T') as tra_cm_registro_proxima_cita,
                      date_format(tra_cm_proxima_cita, '%d/%m/%Y') as tra_cm_proxima_cita,
                      tra_cm_proxima_cita as proxima_cita,
                      tra_cm_dias,
                      IF(tra_cm_observaciones_proxima_cita = 'null','',tra_cm_observaciones_proxima_cita) as tra_cm_observaciones_proxima_cita,
                      tra_cm_confirmacion_cita,
                      tra_cm_estado,
                      tra_cm_usuarioi,
                      tra_cm_usuariom,
                      tra_cm_fechai,
                      tra_cm_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra_cm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra_cm_fecham, '%d/%m/%y %T') as age_fecham,
                      cat.cat_nombre as procedencia 
                      from tra_consulta_medica 
                          left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra_cm_usuariom) 
                          left outer join cfg_producto pro on(tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :tra_cm_empresa)
                          left outer join cfg_usuario med on (tra_cm_usr_correl = med.usr_correl and med.usr_estado = :tra_cm_estado)
                          left outer join cfg_sucursal lug on (tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = :tra_cm_estado) 
                          left outer join cfg_catalogo cat on(cat.cat_valor = tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :tra_cm_empresa)
                          left outer join cfg_aseguradora ase on (ase.ase_correlativo = tra_cm_aseguradora and ase.ase_estado != 'E')
                          left outer join cfg_cliente cli on (tra_cm_cli_correlativo = cli.cli_correlativo and cli.cli_estado != 'E')
                      where 1=1
                      and tra_cm_empresa = :tra_cm_empresa 
                      and tra_cm_ambiente = :tra_cm_ambiente 
                      and tra_cm_estado = :tra_cm_estado 
                      and (tra_cm_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                      and (tra_cm_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                      and tra_cm_confirmacion_cita = :tra_cm_confirmacion_cita ORDER BY tra_cm_registro_proxima_cita ASC 
                      limit $pag_inicio, $tamanio";

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_cm_empresa' => $emp_codigo,
                        'tra_cm_ambiente' => $amb_codigo,
                        'tra_cm_estado' => $tra_cm_estado,
                        'tra_cm_confirmacion_cita' => $tra_cm_confirmacion_cita,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin
                        //'filter'=>$filter
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica 
                            left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra_cm_usuariom) 
                            left outer join cfg_producto pro on(tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :tra_cm_empresa)
                                left outer join cfg_usuario med on (tra_cm_usr_correl = med.usr_correl and med.usr_estado = :tra_cm_estado)
                                left outer join cfg_sucursal lug on (tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = :tra_cm_estado)
                                left outer join cfg_catalogo cat on(cat.cat_valor = tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :tra_cm_empresa)
                            ", " 
                              and tra_cm_empresa = :tra_cm_empresa 
                              and tra_cm_ambiente = :tra_cm_ambiente 
                              and tra_cm_estado = :tra_cm_estado 
                              and (tra_cm_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                              and (tra_cm_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                              and tra_cm_confirmacion_cita = :tra_cm_confirmacion_cita ORDER BY tra_cm_registro_proxima_cita DESC 
                            ", 
                            [
                                'tra_cm_empresa' => $emp_codigo,
                                'tra_cm_ambiente' => $amb_codigo,
                                'tra_cm_estado' => $tra_cm_estado,
                                'tra_cm_confirmacion_cita' => $tra_cm_confirmacion_cita,
                                'fecha_ini' => $fecha_ini,
                                'fecha_fin' => $fecha_fin
                                //'filter'=>$filter
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectVERIIDSFJSDOFSDIOFJSDFOIDSJFIDOFJSDIOFJDSIFDJFOISDJI($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_sucursal', 'lectura');

                

                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $suc_estado = $parameter['suc_estado'] ?? 'A';

                    //$codUsuario = $utility->codigoUsuario($PDO, "cfg_usuario", "usr_correl", "AND usr_correl= '1'");
                    //echo $codUsuario;
                    $sql = " 
                    select 
                    a.suc_correlativo, 
                    a.suc_codigo,  
                    a.suc_nombre,  
                    a.suc_direccion,  
                    a.suc_responsable, 
                    a.suc_horario_lunes_a_viernes_inicio,
                    a.suc_horario_lunes_a_viernes_fin,
                    a.suc_horario_sabado_inicio,
                    a.suc_horario_sabado_fin,
                    a.suc_horario_domingo_inicio,
                    a.suc_horario_domingo_fin,
                    concat(e.usr_nombres,' ', e.usr_apellidos) as suc_nombre_responsable,  
                    d.cat_nombre cat_estado_nombre,  
                    a.suc_estado,  
                    a.suc_empresa,  
                    a.suc_ambiente,  
                    a.suc_fechai,  
                    a.suc_fecham,  
                    b.usr_nombres,
                    b.usr_apellidos,
                    concat(b.usr_nombres,' ',b.usr_apellidos) as suc_usuarioi,  
                    concat(c.usr_nombres,' ',c.usr_apellidos) as suc_usuariom  

                    from cfg_sucursal a
                    left outer join cfg_catalogo d on(a.suc_estado= d.cat_valor and d.cat_tipo = 'SUCURSAL_ESTADO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.suc_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.suc_usuariom)
                    left outer join cfg_usuario e on (e.usr_correl = a.suc_responsable)

                    
                    where 
                    1=1
                     and a.suc_empresa = :emp_codigo 
                     and a.suc_ambiente =:amb_codigo
                     and a.suc_estado =:suc_estado
                     and ((a.suc_nombre like concat('%',:filter,'%') or a.suc_direccion like concat('%',:filter,'%')) or (:filter = 'undefined'))
                     and (a.suc_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                     and (a.suc_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 

                     limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'emp_codigo' => $emp_codigo,
                    'amb_codigo' => $amb_codigo,
                    'suc_estado' => $suc_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'filter'=>$filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_sucursal a 
                            left outer join cfg_catalogo d on(a.suc_estado= d.cat_valor and d.cat_tipo = 'SUCURSAL_ESTADO' and d.cat_empresa = :emp_codigo)
                            left outer join cfg_usuario b on (b.usr_correl = a.suc_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.suc_usuariom)
                            ", "   and a.suc_empresa = :emp_codigo 
                             and a.suc_estado =:suc_estado 
                             and ((a.suc_nombre like concat('%',:filter,'%') or a.suc_direccion like concat('%',:filter,'%')) or (:filter = 'undefined'))
                             and (a.suc_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                             and (a.suc_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'suc_estado' => $suc_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter'=>$filter
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectConsultaMedicaPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    //$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    //$fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 12;//$parameter['tamanio'] ?? 10;
                    $tra_cm_cli_correlativo = $parameter['tra_cm_cli_correlativo'] ?? 0;
                    $tipoFicha = $parameter['tipoFicha'] ?? 0;
                    
                    $tra_cm_estado = 'A';
                    $tra_cm_etapa = 4;

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $query = "";
                    $campos = "";
                    if($tipoFicha == 1){
                        $campos = "
                          IFNULL(fm.tra_fm_motivo_consulta,'SIN MOTIVO') as motivo_consulta,
                          IFNULL(fm.tra_fm_impresion_diagnostico,'SIN DIAGNÓSTICO') as impresion_diagnostica,
                          IFNULL(fm.tra_fm_tratamiento,'SIN TRATAMIENTO') as tratamiento,
                        ";
                        $query = "left outer join tra_ficha_medica fm on (fm.tra_fm_tra_cm_correlativo = tra_cm_correlativo and fm.tra_fm_estado != 'E')";
                    }else if($tipoFicha == 2){
                        //IFNULL(fn.tra_fm_motivo_consulta,'SIN MOTIVO') as motivo_consulta,
                        $campos = "
                          'SIN MOTIVO' as motivo_consulta,
                          IFNULL(fn.tra_fichamn_impresion_diagnostica,'SIN DIAGNÓSTICO') as impresion_diagnostica,
                          IFNULL(fn.tra_fichamn_tratamiento,'SIN TRATAMIENTO') as tratamiento,
                        ";
                        $query = "left outer join tra_ficha_nutricional fn on (fn.tra_fichamn_tra_cm_correlativo = tra_cm_correlativo and fn.tra_fichamn_estado != 'E')";
                    }
                    $sql = " 
                    select 
                      tra_cm_correlativo,
                      tra_cm_codigo,
                      tra_cm_empresa,
                      tra_cm_ambiente,
                      tra_cm_procedencia,
                      tra_cm_aseguradora,
                      ase.ase_nombre as aseguradora,
                      tra_cm_primer_consulta,
                      if(tra_cm_primer_consulta = 1,'Primer Consulta','Reconsulta') as estado_cita,
                      tra_cm_lugar_atencion,
                      tra_cm_tipo_consulta,
                      tra_cm_usr_correl,
                      tra_cm_fecha_inicio_consulta,
                      date_format(tra_cm_fecha_inicio_consulta, '%d/%m/%y %T') as fecha_inicio_consulta, 
                      tra_cm_fecha_fin_consulta,
                      tra_cm_fecha_inicio_consulta as start,
                      tra_cm_fecha_fin_consulta as end,
                      date_format(tra_cm_fecha_inicio_consulta, '%H:%i') as hora_inicio,  
                      date_format(tra_cm_fecha_fin_consulta, '%H:%i') as hora_fin,
                      concat(date_format(tra_cm_fecha_inicio_consulta, '%H:%i'),'-',date_format(tra_cm_fecha_fin_consulta, '%H:%i')) as duracionConsulta,
                      tra_cm_nombre_paciente,
                      IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO') as nombre_medico,
                      concat(med.usr_nombres,' ', med.usr_apellidos) as medico,
                      pro.pro_nombre as nombre_especialidad,
                      pro.pro_color as color_etiqueta,
                      concat(date_format(tra_cm_fecha_fin_consulta, '%H:%i'),'\n',pro.pro_nombre,'\n',IFNULL(concat(med.usr_nombres,' ', med.usr_apellidos),'Therapeuta NO ASIGNADO')) as title,
                      pro.pro_color as backgroundColor,
                      pro.pro_tipo_ficha as tra_cm_tipo_ficha,
                      lug.suc_nombre as lugar_atencion,
                      concat(TIMESTAMPDIFF(MINUTE,tra_cm_fecha_inicio_consulta,tra_cm_fecha_fin_consulta),' ','Minutos') as minutos,
                      tra_cm_fecha_nacimiento,
                      if(tra_cm_etapa = 1,'No Confirmado','Confirmado') as estado,
                      IF(tra_cm_observaciones = 'null', '',tra_cm_observaciones) as tra_cm_observaciones,
                      tra_cm_fecha_confirmacion,
                      tra_cm_cita_reprogramada_inicio,
                      tra_cm_cita_reprogramada_fin,
                      tra_cm_motivo_consulta,
                      tra_cm_cli_correlativo,
                      tra_cm_etapa,
                      tra_cm_paciente_intercalado,
                      tra_cm_estado,
                      tra_cm_usuarioi,
                      tra_cm_usuariom,
                      tra_cm_fechai,
                      tra_cm_fecham,
                      dc.cli_nombre,
                      dc.cli_email,
                      dc.cli_nit,
                      dc.cli_dpi,
                      dc.cli_telefono1,
                      date_format(dc.cli_fecha_nacimiento, '%d/%m/%y') as fecha_nacimiento,
                      $campos 
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra_cm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra_cm_fecham, '%d/%m/%y %T') as age_fecham,
                      cat.cat_nombre as procedencia 
                      from tra_consulta_medica 
                          left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra_cm_usuariom) 
                          left outer join cfg_producto pro on(tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :tra_cm_empresa)
                          left outer join cfg_usuario med on (tra_cm_usr_correl = med.usr_correl and med.usr_estado = :tra_cm_estado)
                          left outer join cfg_sucursal lug on (tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = :tra_cm_estado) 
                          left outer join cfg_catalogo cat on(cat.cat_valor = tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :tra_cm_empresa)
                          left outer join cfg_aseguradora ase on (ase.ase_correlativo = tra_cm_aseguradora and ase.ase_estado != 'E')
                          left outer join cfg_cliente dc on(dc.cli_correlativo = tra_cm_cli_correlativo) 
                          $query
                          
                      where 1=1
                      and tra_cm_empresa = :tra_cm_empresa 
                      and tra_cm_ambiente = :tra_cm_ambiente 
                      and tra_cm_estado = :tra_cm_estado 
                      and tra_cm_etapa = :tra_cm_etapa 
                      and tra_cm_cli_correlativo = :tra_cm_cli_correlativo order by tra_cm_correlativo desc 
                      limit $pag_inicio, $tamanio";
                      //left outer join cfg_catalogo d on(tra_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_cm_empresa' => $emp_codigo,
                        'tra_cm_ambiente' => $amb_codigo,
                        'tra_cm_estado' => $tra_cm_estado,
                        'tra_cm_cli_correlativo' => $tra_cm_cli_correlativo,
                        'tra_cm_etapa' => $tra_cm_etapa
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica 
                            left outer join cfg_usuario b on (b.usr_correl = tra_cm_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra_cm_usuariom) 
                            left outer join cfg_producto pro on(tra_cm_tipo_consulta= pro.pro_correl and pro.pro_clasificacion = 2 and pro.pro_empresa = :tra_cm_empresa)
                                left outer join cfg_usuario med on (tra_cm_usr_correl = med.usr_correl and med.usr_estado = :tra_cm_estado)
                                left outer join cfg_sucursal lug on (tra_cm_lugar_atencion = lug.suc_correlativo and lug.suc_estado = :tra_cm_estado)
                                left outer join cfg_catalogo cat on(cat.cat_valor = tra_cm_procedencia and cat.cat_tipo = 'PACIENTE_PROCEDENCIA' and cat.cat_empresa = :tra_cm_empresa)
                                $query
                            ", " 
                             and tra_cm_empresa = :tra_cm_empresa 
                             and tra_cm_ambiente = :tra_cm_ambiente 
                             and tra_cm_estado = :tra_cm_estado 
                             and tra_cm_etapa = :tra_cm_etapa 
                             and tra_cm_correlativo = :tra_cm_correlativo 
                            ", 
                            [
                                'tra_cm_empresa' => $emp_codigo,
                                'tra_cm_ambiente' => $amb_codigo,
                                'tra_cm_estado' => $tra_cm_estado,
                                'tra_cm_correlativo' => $tra_cm_correlativo,
                                'tra_cm_etapa' => $tra_cm_etapa
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectConsultaReceta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    //$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    //$fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 12;//$parameter['tamanio'] ?? 10;
                    $tra_rm_tra_cm_correlativo = $parameter['tra_rm_tra_cm_correlativo'] ?? 0;
                    //$tra_rm_tipo_ficha = $parameter['tra_rm_tipo_ficha'] ?? 0;
                    
                    $tra_rm_estado = 'A';
                    $tra_cm_etapa = 4;//ver que etapa tendra

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 
                      tra_rm_correlativo,
                      tra_rm_tra_cm_correlativo,
                      tra_rm_cli_correlativo,
                      tra_rm_tra_no_receta,
                      tra_rm_descripcion,
                      tra_rm_observaciones,
                      tra_rm_tipo_ficha,
                      tra_rm_estado,
                      tra_rm_usuarioi,
                      tra_rm_usuariom,
                      tra_rm_fechai,
                      tra_rm_fecham,
                      tcm.tra_cm_cli_correlativo 
                      from tra_receta_medica 
                      left outer join tra_consulta_medica tcm on(tcm.tra_cm_correlativo = :tra_rm_tra_cm_correlativo and tcm.tra_cm_empresa = :emp_codigo and tcm.tra_cm_ambiente = :amb_codigo) 
                      where 1=1 
                      and tra_rm_estado = :tra_rm_estado 
                      and tra_rm_tra_cm_correlativo = :tra_rm_tra_cm_correlativo GROUP BY tra_rm_tra_no_receta ORDER BY tra_rm_tra_no_receta DESC
                      limit $pag_inicio, $tamanio";
                      //and tra_rm_tipo_ficha = :tra_rm_tipo_ficha
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_rm_estado' => $tra_rm_estado,
                        'tra_rm_tra_cm_correlativo' => $tra_rm_tra_cm_correlativo,
                        //'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha,
                        'emp_codigo' => $emp_codigo,
                        'amb_codigo' => $amb_codigo
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_receta_medica
                            left outer join tra_consulta_medica tcm on(tcm.tra_cm_correlativo = :tra_rm_tra_cm_correlativo and tcm.tra_cm_empresa = :emp_codigo and tcm.tra_cm_ambiente = :amb_codigo) 
                            ", " 
                             and tra_rm_estado = :tra_rm_estado 
                             and tra_rm_tra_cm_correlativo = :tra_rm_tra_cm_correlativo 
                            ", 
                            [
                                'tra_rm_estado' => $tra_rm_estado,
                                'tra_rm_tra_cm_correlativo' => $tra_rm_tra_cm_correlativo,
                                'emp_codigo' => $emp_codigo,
                                'amb_codigo' => $amb_codigo
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectConsultaRecetaExamenComplementario($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    //$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    //$fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 12;//$parameter['tamanio'] ?? 10;
                    $tra_rmex_tra_cm_correlativo = $parameter['tra_rmex_tra_cm_correlativo'] ?? 0;
                    //$tra_rm_tipo_ficha = $parameter['tra_rm_tipo_ficha'] ?? 0;
                    
                    $tra_rmex_estado = 'A';
                    $tra_cm_etapa = 4;//ver que etapa tendra

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 
                      tra_rmex_correlativo,
                      tra_rmex_tra_cm_correlativo,
                      tra_rmex_cli_correlativo,
                      tra_rmex_tra_no_receta,
                      tra_rmex_descripcion,
                      tra_rmex_observaciones,
                      tra_rmex_tipo_ficha,
                      tra_rmex_estado,
                      tra_rmex_usuarioi,
                      tra_rmex_usuariom,
                      tra_rmex_fechai,
                      tra_rmex_fecham,
                      tcm.tra_cm_cli_correlativo 
                      from tra_receta_medica_examen_complementario 
                      left outer join tra_consulta_medica tcm on(tcm.tra_cm_correlativo = :tra_rmex_tra_cm_correlativo and tcm.tra_cm_empresa = :emp_codigo and tcm.tra_cm_ambiente = :amb_codigo) 
                      where 1=1 
                      and tra_rmex_estado = :tra_rmex_estado 
                      and tra_rmex_tra_cm_correlativo = :tra_rmex_tra_cm_correlativo GROUP BY tra_rmex_tra_no_receta ORDER BY tra_rmex_tra_no_receta DESC
                      limit $pag_inicio, $tamanio";
                      //and tra_rm_tipo_ficha = :tra_rm_tipo_ficha
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_rmex_estado' => $tra_rmex_estado,
                        'tra_rmex_tra_cm_correlativo' => $tra_rmex_tra_cm_correlativo,
                        //'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha,
                        'emp_codigo' => $emp_codigo,
                        'amb_codigo' => $amb_codigo
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_receta_medica_examen_complementario
                            left outer join tra_consulta_medica tcm on(tcm.tra_cm_correlativo = :tra_rmex_tra_cm_correlativo and tcm.tra_cm_empresa = :emp_codigo and tcm.tra_cm_ambiente = :amb_codigo) 
                            ", " 
                             and tra_rmex_estado = :tra_rmex_estado 
                             and tra_rmex_tra_cm_correlativo = :tra_rmex_tra_cm_correlativo 
                            ", 
                            [
                                'tra_rmex_estado' => $tra_rmex_estado,
                                'tra_rmex_tra_cm_correlativo' => $tra_rmex_tra_cm_correlativo,
                                'emp_codigo' => $emp_codigo,
                                'amb_codigo' => $amb_codigo
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectConsultaExamen($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    //$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    //$fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 12;//$parameter['tamanio'] ?? 10;
                    $tra_ecom_tra_cm_correlativo = $parameter['tra_ecom_tra_cm_correlativo'] ?? 0;
                    //$tra_ecom_tipo_ficha = $parameter['tra_ecom_tipo_ficha'] ?? 0;
                    
                    $tra_ecom_estado = 'A';
                    $tra_cm_etapa = 4;//ver que etapa tendra

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 
                      tra_ecom_correlativo,
                      tra_ecom_tra_cm_correlativo,
                      tra_ecom_tipo_ficha,
                      tra_ecom_no_examen,
                      tra_ecom_pro_tipo_laboratorio,
                      tra_ecom_pro_correl,
                      tra_ecom_status,
                      tra_ecom_descripcion,
                      tra_ecom_estado,
                      tra_ecom_usuarioi,
                      tra_ecom_usuariom,
                      tra_ecom_fechai,
                      tra_ecom_fecham,
                      pro.pro_nombre as examen 
                      from examenes_complementarios 
                      left outer join cfg_producto pro on(tra_ecom_pro_correl = pro.pro_correl and pro.pro_estado = 'A' and pro.pro_empresa = :emp_codigo)
                      where 1=1 
                      and tra_ecom_estado = :tra_ecom_estado 
                      and tra_ecom_tra_cm_correlativo = :tra_ecom_tra_cm_correlativo GROUP BY tra_ecom_no_examen ORDER BY tra_ecom_no_examen DESC
                      limit $pag_inicio, $tamanio";

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_ecom_estado' => $tra_ecom_estado,
                        'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                        'emp_codigo' => $emp_codigo
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "examenes_complementarios 
                            left outer join cfg_producto pro on(tra_ecom_pro_correl = pro.pro_correl and pro.pro_estado = 'A' and pro.pro_empresa = :emp_codigo)
                            ", " 
                             and tra_ecom_estado = :tra_ecom_estado 
                             and tra_ecom_tra_cm_correlativo = :tra_ecom_tra_cm_correlativo 
                            ", 
                            [
                                'tra_ecom_estado' => $tra_ecom_estado,
                                'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                                'emp_codigo' => $emp_codigo
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    
    public function selectFichaMedica($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";*/
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $tra_fm_tra_cm_correlativo = $parameter['tra_fm_tra_cm_correlativo'] ?? 0;
                    
                    $tra_fm_estado = 'A';
                    $tra_fm_etapa = 3;

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 
                      tra_fm_correlativo,
                      tra_fm_tra_cm_correlativo,
                      tra_fm_usr_correl,
                      tra_fm_app,
                      tra_fm_apf,
                      tra_fm_alcohol,
                      tra_fm_cafe,
                      tra_fm_tabaco,
                      tra_fm_otros,
                      tra_fm_peso_kg,
                      tra_fm_talla_mts,
                      tra_fm_valor_imc,
                      tra_fm_valor_fc,
                      tra_fm_valor_fr,
                      tra_fm_valor_ta,
                      tra_fm_valor_temperatura,
                      tra_fm_estado_nutricional,
                      tra_fm_g,
                      tra_fm_p,
                      tra_fm_a,
                      tra_fm_hv,
                      tra_fm_hm,
                      tra_fm_fur,
                      tra_fm_ciclos,
                      tra_fm_eg,
                      tra_fm_fpp,
                      tra_fm_motivo_consulta,
                      tra_fm_resumen_hea,
                      tra_fm_examen_fisico,
                      tra_fm_impresion_diagnostico,
                      tra_fm_tratamiento,
                      tra_fm_observacion,
                      tra_fm_estado,
                      tra_fm_usuarioi,
                      tra_fm_usuariom,
                      tra_fm_fechai,
                      tra_fm_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra_fm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra_fm_fecham, '%d/%m/%y %T') as age_fecham 
                      from tra_ficha_medica 
                          left outer join cfg_usuario b on (b.usr_correl = tra_fm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra_fm_usuariom) 
                      where 1=1
                      and tra_fm_estado = :tra_fm_estado 
                      and tra_fm_tra_cm_correlativo = :tra_fm_tra_cm_correlativo 
                      limit $pag_inicio, $tamanio";
                      //left outer join cfg_catalogo d on(tra_fm_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_fm_estado' => $tra_fm_estado,
                        'tra_fm_tra_cm_correlativo' => $tra_fm_tra_cm_correlativo
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_ficha_medica 
                            left outer join cfg_usuario b on (b.usr_correl = tra_fm_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra_fm_usuariom) 
                            ", " 
                             and tra_fm_estado = :tra_fm_estado 
                             and tra_fm_tra_cm_correlativo = :tra_fm_tra_cm_correlativo 
                            ", 
                            [
                                'tra_fm_estado' => $tra_fm_estado,
                                'tra_fm_tra_cm_correlativo' => $tra_fm_tra_cm_correlativo
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectFichaOcupacional($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";*/
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $tra_fo_tra_cm_correlativo = $parameter['tra_fo_tra_cm_correlativo'] ?? 0;
                    
                    $tra_fo_estado = 'A';
                    $tra_fm_etapa = 3;

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 
                      tra_fo_correlativo,
                      tra_fo_tra_cm_correlativo,
                      tra_fo_usr_correl,
                      tra_fo_medicamento_consume_actualmente,
                      tra_fo_habito_suenio,
                      tra_fo_habito_urinario,
                      tra_fo_habito_defecacion,
                      tra_fo_actividad_fisica,
                      tra_fo_laboratorio,
                      tra_fo_otros_datos_interes,
                      tra_fo_impresion_diagnostica,
                      tra_fo_tratamiento,
                      tra_fo_observaciones,
                      tra_fo_estado,
                      tra_fo_usuarioi,
                      tra_fo_usuariom,
                      tra_fo_fechai,
                      tra_fo_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra_fo_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra_fo_fecham, '%d/%m/%y %T') as age_fecham 
                      from tra_ficha_ocupacional 
                          left outer join cfg_usuario b on (b.usr_correl = tra_fo_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra_fo_usuariom) 
                      where 1=1
                      and tra_fo_estado = :tra_fo_estado 
                      and tra_fo_tra_cm_correlativo = :tra_fo_tra_cm_correlativo 
                      limit $pag_inicio, $tamanio";
                      //left outer join cfg_catalogo d on(tra_fo_estado= d.cat_valor and d.cat_tipo = 'ESTADO_AGENDA' and d.cat_empresa = :emp_codigo)

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_fo_estado' => $tra_fo_estado,
                        'tra_fo_tra_cm_correlativo' => $tra_fo_tra_cm_correlativo
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_ficha_ocupacional 
                            left outer join cfg_usuario b on (b.usr_correl = tra_fo_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra_fo_usuariom) 
                            ", " 
                             and tra_fo_estado = :tra_fo_estado 
                             and tra_fo_tra_cm_correlativo = :tra_fo_tra_cm_correlativo 
                            ", 
                            [
                                'tra_fo_estado' => $tra_fo_estado,
                                'tra_fo_tra_cm_correlativo' => $tra_fo_tra_cm_correlativo
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectFichaNutricional($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";*/
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $tra_fichamn_tra_cm_correlativo = $parameter['tra_fichamn_tra_cm_correlativo'] ?? 0;
                    $tra_fichamn_tipo = $parameter['tra_fichamn_tipo'] ?? 0;
                    
                    $tra_fichamn_estado = 'A';
                    $tra_etapa = 2;

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 
                      tra_fichamn_correl,
                      tra_fichamn_tra_cm_correlativo,
                      tra_fichamn_glucosa_pre,
                      tra_fichamn_acido_urico,
                      tra_fichamn_colesterol,
                      tra_fichamn_trigliceridos,
                      tra_fichamn_otros,
                      tra_fichamn_tipo,
                      tra_fichamn_alcohol,
                      tra_fichamn_cafe,
                      tra_fichamn_tabaco,
                      tra_fichamn_ht_otros,
                      tra_fichamn_talla,
                      tra_fichamn_peso_anterior,
                      tra_fichamn_peso_actual,
                      tra_fichamn_imc_anterior,
                      tra_fichamn_imc_actual,
                      tra_fichamn_grasa,
                      tra_fichamn_musculo,
                      tra_fichamn_edad_metabolica,
                      tra_fichamn_presion_arterial,
                      tra_fichamn_bebidas_azucaradas,
                      tra_fichamn_comida_chatarra,
                      tra_fichamn_harinas_refinadas,
                      tra_fichamn_actividad_fnombre,
                      tra_fichamn_actividad_fduracion,
                      tra_fichamn_activiad_fporsemana,
                      tra_fichamn_cirabdominal_anterior,
                      tra_fichamn_cirabdominal_actual,
                      tra_fichamn_cirbiceps_anterior,
                      tra_fichamn_cirbiceps_actual,
                      tra_fichamn_cirpecho_anterior,
                      tra_fichamn_cirpecho_actual,
                      tra_fichamn_cirmuslo_anterior,
                      tra_fichamn_cirmuslo_actual,
                      tra_fichamn_cirpantorrilla_anterior,
                      tra_fichamn_cirpantorrilla_actual,
                      tra_fichamn_antecedentes_medicos,
                      tra_fichamn_alergias,
                      tra_fichamn_alimentos_noconsume,
                      tra_fichamn_suplementos_medicamenots_consume,
                      tra_fichamn_datos_interes,
                      tra_fichamn_impresion_diagnostica,
                      tra_fichamn_tratamiento,
                      tra_fichamn_estado,
                      tra_fichamn_fechai,
                      tra_fichamn_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra_fichamn_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra_fichamn_fecham, '%d/%m/%y %T') as age_fecham 
                      from tra_ficha_nutricional 
                          left outer join cfg_usuario b on (b.usr_correl = tra_fichamn_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra_fichamn_usuariom) 
                      where 1=1
                      and tra_fichamn_estado = :tra_fichamn_estado 
                      and tra_fichamn_tra_cm_correlativo = :tra_fichamn_tra_cm_correlativo 
                      limit $pag_inicio, $tamanio";//and tra_fichamn_tipo = :tra_fichamn_tipo 

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_fichamn_estado' => $tra_fichamn_estado,
                        'tra_fichamn_tra_cm_correlativo' => $tra_fichamn_tra_cm_correlativo
                        //'tra_fichamn_tipo' => $tra_fichamn_tipo
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_ficha_nutricional 
                            left outer join cfg_usuario b on (b.usr_correl = tra_fichamn_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra_fichamn_usuariom) 
                            ", " 
                             and tra_fichamn_estado = :tra_fichamn_estado 
                             and tra_fichamn_tra_cm_correlativo = :tra_fichamn_tra_cm_correlativo 
                            ", 
                            [
                                'tra_fichamn_estado' => $tra_fichamn_estado,
                                'tra_fichamn_tra_cm_correlativo' => $tra_fichamn_tra_cm_correlativo
                                //'tra_fichamn_tipo' => $tra_fichamn_tipo
                            ]);
                        //echo $data; and tra_fichamn_tipo = :tra_fichamn_tipo 
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectUltimaFichaNutricional($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";*/
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 1;//$parameter['tamanio'] ?? 10;
                    $tra_fichamn_cli_correlativo = $parameter['tra_fichamn_cli_correlativo'] ?? 0;
                    $tra_fichamn_tra_cm_correlativo = $parameter['tra_fichamn_tra_cm_correlativo'] ?? 0;
                    //$tra_fichamn_tipo = $parameter['tra_fichamn_tipo'] ?? 0;
                    
                    $tra_fichamn_estado = 'A';
                    $tra_etapa = 4;

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    
                    $tra_fichamn_tra_cm_correlativo = $utility->obtenerUltimaConsultaPaciente($PDO, "tra_consulta_medica", $tra_fichamn_cli_correlativo, "");

                    $sql = " 
                    select 
                      tra_fichamn_correl,
                      tra_fichamn_tra_cm_correlativo,
                      tra_fichamn_cli_correlativo,
                      tra_fichamn_glucosa_pre,
                      tra_fichamn_acido_urico,
                      tra_fichamn_colesterol,
                      tra_fichamn_trigliceridos,
                      tra_fichamn_otros,
                      tra_fichamn_tipo,
                      tra_fichamn_alcohol,
                      tra_fichamn_cafe,
                      tra_fichamn_tabaco,
                      tra_fichamn_ht_otros,
                      tra_fichamn_talla,
                      tra_fichamn_peso_anterior,
                      tra_fichamn_peso_actual,
                      tra_fichamn_imc_anterior,
                      tra_fichamn_imc_actual,
                      tra_fichamn_grasa,
                      tra_fichamn_musculo,
                      tra_fichamn_edad_metabolica,
                      tra_fichamn_presion_arterial,
                      tra_fichamn_bebidas_azucaradas,
                      tra_fichamn_comida_chatarra,
                      tra_fichamn_harinas_refinadas,
                      tra_fichamn_actividad_fnombre,
                      tra_fichamn_actividad_fduracion,
                      tra_fichamn_activiad_fporsemana,
                      tra_fichamn_cirabdominal_anterior,
                      tra_fichamn_cirabdominal_actual,
                      tra_fichamn_cirbiceps_anterior,
                      tra_fichamn_cirbiceps_actual,
                      tra_fichamn_cirpecho_anterior,
                      tra_fichamn_cirpecho_actual,
                      tra_fichamn_cirmuslo_anterior,
                      tra_fichamn_cirmuslo_actual,
                      tra_fichamn_cirpantorrilla_anterior,
                      tra_fichamn_cirpantorrilla_actual,
                      tra_fichamn_antecedentes_medicos,
                      tra_fichamn_alergias,
                      tra_fichamn_alimentos_noconsume,
                      tra_fichamn_suplementos_medicamenots_consume,
                      tra_fichamn_datos_interes,
                      tra_fichamn_impresion_diagnostica,
                      tra_fichamn_tratamiento,
                      tra_fichamn_estado,
                      tra_fichamn_fechai,
                      tra_fichamn_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra_fichamn_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra_fichamn_fecham, '%d/%m/%y %T') as age_fecham 
                      from tra_ficha_nutricional 
                          left outer join cfg_usuario b on (b.usr_correl = tra_fichamn_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra_fichamn_usuariom) 
                      where 1=1
                      and tra_fichamn_estado = :tra_fichamn_estado 
                      and tra_fichamn_tra_cm_correlativo = :tra_fichamn_tra_cm_correlativo  
                      and tra_fichamn_cli_correlativo = :tra_fichamn_cli_correlativo ORDER BY tra_fichamn_correl DESC";
                      //limit $pag_inicio, $tamanio
                      //and tra_fichamn_tra_cm_correlativo = :tra_fichamn_tra_cm_correlativo 
                      //and tra_fichamn_tipo = :tra_fichamn_tipo 
                      //left outer join tra_consulta_medica cm on (cm.tra_cm_correlativo = tra_fichamn_tra_cm_correlativo and cm.tra_cm_etapa = 4 and cm.tra_cm_estado = 'A')

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_fichamn_estado' => $tra_fichamn_estado,
                        'tra_fichamn_cli_correlativo' => $tra_fichamn_cli_correlativo,
                        'tra_fichamn_tra_cm_correlativo' => $tra_fichamn_tra_cm_correlativo
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_ficha_nutricional 
                            left outer join cfg_usuario b on (b.usr_correl = tra_fichamn_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra_fichamn_usuariom) 
                            ", " 
                            and tra_fichamn_estado = :tra_fichamn_estado 
                            and tra_fichamn_tra_cm_correlativo = :tra_fichamn_tra_cm_correlativo  
                            and tra_fichamn_cli_correlativo = :tra_fichamn_cli_correlativo ORDER BY tra_fichamn_correl DESC
                            ", 
                            [
                                'tra_fichamn_estado' => $tra_fichamn_estado,
                                'tra_fichamn_cli_correlativo' => $tra_fichamn_cli_correlativo,
                                'tra_fichamn_tra_cm_correlativo' => $tra_fichamn_tra_cm_correlativo
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";



                    $cli_estado = 'A';//$parameter['cli_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.cli_correlativo, 
                    a.cli_nombre,  
                    a.cli_email,  
                    IFNULL(a.cli_facturar,'') as facturar,
                    IFNULL(a.cli_nit,'') as nit,  
                    a.cli_dpi,
                    a.cli_telefono1,  
                    a.cli_telefono2,  
                    a.cli_direccion,  
                    a.cli_fecha_nacimiento,
                    DATE_FORMAT(FROM_DAYS(TO_DAYS(NOW())-TO_DAYS(a.cli_fecha_nacimiento)), '%Y')+0 AS edad,
                    a.cli_edad,
                    IF(a.cli_responsable = 'null','',a.cli_responsable) as cli_responsable,
                    a.cli_estado_civil,
                    a.cli_religion,
                    a.cli_escolaridad,
                    a.cli_ocupacion,
                    a.cli_grupo_sanguineo,
                    d.cat_nombre cat_estado_nombre,  
                    a.cli_estado,  
                    concat(b.usr_nombres,' ',b.usr_apellidos) as cli_usuarioi,  
                    concat(c.usr_nombres,' ',c.usr_apellidos) as cli_usuariom,  
                    a.cli_fechai,  
                    a.cli_fecham  

                    from cfg_cliente a
                    left outer join cfg_catalogo d on(a.cli_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.cli_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.cli_usuariom)
                    
                    where 
                    1=1
                    and a.cli_estado =:cli_estado
                    and ((a.cli_nombre like concat('%',:filter,'%') or a.cli_email like concat('%',:filter,'%') or a.cli_nit like concat('%',:filter,'%')) or (:filter = 'undefined'))

                     and (a.cli_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                     and (a.cli_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                     and cli_correlativo = :cli_correlativo 
                     limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'cli_estado' => $cli_estado,
                    'emp_codigo' => $emp_codigo,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'cli_estado' => $cli_estado,
                    'cli_correlativo' => $cli_correlativo,
                    'filter' => $filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_cliente a
                        left outer join cfg_catalogo d on(a.cli_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.cli_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.cli_usuariom)
                        ", "   and a.cli_estado =:cli_estado 
                         and ((a.cli_nombre like concat('%',:filter,'%') or a.cli_email like concat('%',:filter,'%') or a.cli_nit like concat('%',:filter,'%')) or (:filter = 'undefined'))
                         and (a.cli_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                         and (a.cli_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                         and cli_correlativo = :cli_correlativo 
                        ", 
                        [
                        'cli_estado' => $cli_estado,
                        'emp_codigo' => $emp_codigo,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'cli_estado' => $cli_estado,
                        'cli_correlativo' => $cli_correlativo,
                        'filter' => $filter
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectDataPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    //$cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";


                    $cli_estado = 'A';//$parameter['cli_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.cli_correlativo, 
                    a.cli_nombre,  
                    a.cli_email,  
                    IFNULL(a.cli_facturar,'') as facturar,
                    IFNULL(a.cli_nit,'') as nit,  
                    a.cli_dpi,
                    a.cli_telefono1,  
                    a.cli_telefono2,  
                    a.cli_direccion,  
                    date_format(cli_fecha_nacimiento, '%d/%m/%Y') as fecha_nacimiento,
                    DATE_FORMAT(FROM_DAYS(TO_DAYS(NOW())-TO_DAYS(a.cli_fecha_nacimiento)), '%Y')+0 AS edad,
                    a.cli_edad,
                    IF(a.cli_responsable = 'null','',a.cli_responsable) as cli_responsable,
                    a.cli_estado_civil,
                    a.cli_religion,
                    a.cli_escolaridad,
                    a.cli_ocupacion,
                    a.cli_grupo_sanguineo,
                    d.cat_nombre cat_estado_nombre,  
                    a.cli_estado,  
                    concat(b.usr_nombres,' ',b.usr_apellidos) as cli_usuarioi,  
                    concat(c.usr_nombres,' ',c.usr_apellidos) as cli_usuariom,  
                    a.cli_fechai,  
                    a.cli_fecham  

                    from cfg_cliente a
                    left outer join cfg_catalogo d on(a.cli_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.cli_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.cli_usuariom)
                    
                    where 
                    1=1
                    and a.cli_estado =:cli_estado
                    and ((a.cli_nombre like concat('%',:filter,'%') or a.cli_email like concat('%',:filter,'%') or a.cli_nit like concat('%',:filter,'%')) or (:filter = 'undefined'))

                     and (a.cli_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                     and (a.cli_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                     limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'cli_estado' => $cli_estado,
                    'emp_codigo' => $emp_codigo,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'cli_estado' => $cli_estado,
                    //'cli_correlativo' => $cli_correlativo,
                    'filter' => $filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_cliente a
                        left outer join cfg_catalogo d on(a.cli_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.cli_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.cli_usuariom)
                        ", "   and a.cli_estado =:cli_estado 
                         and ((a.cli_nombre like concat('%',:filter,'%') or a.cli_email like concat('%',:filter,'%') or a.cli_nit like concat('%',:filter,'%')) or (:filter = 'undefined'))
                         and (a.cli_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                         and (a.cli_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                        ", 
                        [
                        'cli_estado' => $cli_estado,
                        'emp_codigo' => $emp_codigo,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'cli_estado' => $cli_estado,
                        //'cli_correlativo' => $cli_correlativo,
                        'filter' => $filter
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectConsultaPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $cli_correlativo = $parameter['cli_correlativo'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";


                    $cli_estado = 'A';//$parameter['cli_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.tra_fichamn_peso_actual 
                    from tra_ficha_nutricional a 
                    where 
                    1=1
                    and a.tra_fichamn_estado = 'A' 
                    and a.tra_fichamn_cli_correlativo = :cli_correlativo ORDER BY a.tra_fichamn_correl DESC   
                    limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'cli_correlativo' => $cli_correlativo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_ficha_nutricional a
                        ", "  
                            and a.tra_fichamn_estado = 'A' 
                            and a.tra_fichamn_cli_correlativo = :cli_correlativo ORDER BY a.tra_fichamn_correl ASC  
                        ", 
                        [
                        'cli_correlativo' => $cli_correlativo
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectPesoFichaPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tra_fichamn_cli_correlativo = $parameter['cli_correlativo'] ?? 0;
                    $tra_fichamn_tra_cm_correlativo = $parameter['tra_fichamn_tra_cm_correlativo'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";

                    /*$filter1 = $parameter['filter1'] ?? "undefined";
                    if(empty($filter1)) $filter1 = "undefined";

                    $filter2 = $parameter['filter2'] ?? "undefined";
                    if(empty($filter2)) $filter2 = "undefined";*/


                    $cli_estado = 'A';//$parameter['cli_estado'] ?? 'A';

                    $sql = " 
                    select 
                    a.tra_fichamn_peso_actual 
                    from tra_ficha_nutricional a 
                    where 
                    1=1
                    and a.tra_fichamn_estado = 'A' 
                    and a.tra_fichamn_cli_correlativo = :tra_fichamn_cli_correlativo 
                    and a.tra_fichamn_tra_cm_correlativo = :tra_fichamn_tra_cm_correlativo ORDER BY a.tra_fichamn_correl DESC   
                    limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    //'cli_estado' => $cli_estado,
                    // 'emp_codigo' => $emp_codigo,
                    'tra_fichamn_tra_cm_correlativo' => $tra_fichamn_tra_cm_correlativo,
                    'tra_fichamn_cli_correlativo' => $tra_fichamn_cli_correlativo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_ficha_nutricional a
                        ", "  
                            and a.tra_fichamn_estado = 'A' 
                            and a.tra_fichamn_cli_correlativo = :tra_fichamn_cli_correlativo 
                            and a.tra_fichamn_tra_cm_correlativo = :tra_fichamn_tra_cm_correlativo ORDER BY a.tra_fichamn_correl DESC  
                        ", 
                        [
                        // 'cli_estado' => $cli_estado,
                        // 'emp_codigo' => $emp_codigo,
                        'tra_fichamn_tra_cm_correlativo' => $tra_fichamn_tra_cm_correlativo,
                        'tra_fichamn_cli_correlativo' => $tra_fichamn_cli_correlativo
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectImcPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";


                    $cli_estado = 'A';//$parameter['cli_estado'] ?? 'A';

                    $sql = " 
                    select 
                    IF(fn.tra_fichamn_talla > 0,(fn.tra_fichamn_peso_actual/fn.tra_fichamn_talla),'0') as valor_imc 
                    from tra_consulta_medica  
                    inner join tra_ficha_nutricional fn on(fn.tra_fichamn_tra_cm_correlativo = tra_cm_correlativo and fn.tra_fichamn_estado = 'A')
                    where 1=1 
                    and tra_cm_estado = :cli_estado 
                    and tra_cm_empresa = :emp_codigo 
                    and tra_cm_ambiente = :amb_codigo  
                    and tra_cm_cli_correlativo = :cli_correlativo ORDER BY tra_cm_correlativo DESC 
                    limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'cli_estado' => $cli_estado,
                    'emp_codigo' => $emp_codigo,
                    'amb_codigo' => $amb_codigo,
                    'cli_correlativo' => $cli_correlativo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica
                        inner join tra_ficha_nutricional fn on(fn.tra_fichamn_tra_cm_correlativo = tra_cm_correlativo and fn.tra_fichamn_estado = 'A')
                        ", "  
                            and tra_cm_estado = :cli_estado 
                            and tra_cm_empresa = :emp_codigo 
                            and tra_cm_ambiente = :amb_codigo  
                            and tra_cm_cli_correlativo = :cli_correlativo ORDER BY tra_cm_correlativo DESC 
                        ", 
                        [
                        'cli_estado' => $cli_estado,
                        'emp_codigo' => $emp_codigo,
                        'amb_codigo' => $amb_codigo,
                        'cli_correlativo' => $cli_correlativo
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectExamenLaboratorio($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 2000;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $pro_estado = $parameter['pro_estado'] ?? 'A';
                    $pro_clasificacion = 1;

                    
                    $sql = " 
                    select 
                    a.pro_correl, 
                    a.pro_codigo,  
                    a.pro_empresa,  
                    a.pro_nombre,  
                    a.pro_nombre_corto,  
                    a.pro_codigo_ext,  
                    a.pro_clasificacion,  
                    IF(a.pro_clasificacion = 1, 'Producto','Servicio médico') as servicio,
                    a.pro_tipo_laboratorio,
                    pro_tipo_ficha,
                    a.pro_cod_padre,  
                    a.pro_activo,
                    a.pro_color, 
                    d.cat_nombre cat_estado_nombre,  
                    a.pro_estado,  
                    concat(b.usr_nombres,' ', b.usr_apellidos) as pro_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as pro_usuariom,  
                    date_format(a.pro_fechai, '%d/%m/%y %T') as pro_fechai,  
                    date_format(a.pro_fecham, '%d/%m/%y %T') as pro_fecham,  
                    a.pro_ambiente  
                    from cfg_producto a
                    left outer join cfg_catalogo d on(a.pro_estado= d.cat_valor and d.cat_tipo = 'ESTADO_PRODUCTO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.pro_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.pro_usuariom)
                    where 
                    1=1
                    and ((a.pro_nombre like concat('%',:filter,'%') or a.pro_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and a.pro_empresa = :emp_codigo 
                    and (a.pro_estado = 'A' || a.pro_estado = 'I') 
                    and a.pro_clasificacion =:pro_clasificacion 
                    and (a.pro_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.pro_fechai <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900')
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                        'pro_estado' => $pro_estado,
                        'pro_clasificacion' => $pro_clasificacion,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter,
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_producto a
                            left outer join cfg_catalogo d on(a.pro_estado= d.cat_valor and d.cat_tipo = 'ESTADO_PRODUCTO' and d.cat_empresa = :emp_codigo)
                            left outer join cfg_usuario b on (b.usr_correl = a.pro_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.pro_usuariom)
                            ", "   and a.pro_empresa = :emp_codigo 
                            and ((a.pro_nombre like concat('%',:filter,'%') or a.pro_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                            and a.pro_estado =:pro_estado
                            and (a.pro_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                            and (a.pro_fechai <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'pro_estado' => $pro_estado,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter' => $filter,
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectExamenLab($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $tra_ecom_tra_cm_correlativo = $parameter['tra_ecom_tra_cm_correlativo'] ?? 0;
                    $tra_ecom_no_examen = $parameter['tra_ecom_no_examen'] ?? 0;
                    $tra_ecom_tipo_ficha = $parameter['tra_ecom_tipo_ficha'] ?? 0;
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 2000;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $pro_estado = $parameter['pro_estado'] ?? 'A';
                    $pro_clasificacion = 1;

                    
                    $sql = " 
                    select 
                    a.pro_correl, 
                    a.pro_codigo,  
                    a.pro_empresa,  
                    a.pro_nombre,  
                    a.pro_nombre_corto,  
                    a.pro_codigo_ext,  
                    a.pro_clasificacion,  
                    IF(a.pro_clasificacion = 1, 'Producto','Servicio médico') as servicio,
                    a.pro_tipo_laboratorio,
                    pro_tipo_ficha,
                    a.pro_cod_padre,  
                    a.pro_activo,
                    a.pro_color, 
                    d.cat_nombre cat_estado_nombre,  
                    a.pro_estado,
                    ec.tra_ecom_status,
                    ec.tra_ecom_correlativo,
                    ec.tra_ecom_descripcion,
                    concat(b.usr_nombres,' ', b.usr_apellidos) as pro_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as pro_usuariom,  
                    date_format(a.pro_fechai, '%d/%m/%y %T') as pro_fechai,  
                    date_format(a.pro_fecham, '%d/%m/%y %T') as pro_fecham,  
                    a.pro_ambiente  
                    from cfg_producto a
                    left outer join cfg_catalogo d on(a.pro_estado= d.cat_valor and d.cat_tipo = 'ESTADO_PRODUCTO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.pro_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.pro_usuariom)
                    left outer join examenes_complementarios ec on (ec.tra_ecom_pro_correl = a.pro_correl and ec.tra_ecom_tra_cm_correlativo =:tra_ecom_tra_cm_correlativo 
                    and ec.tra_ecom_no_examen =:tra_ecom_no_examen and ec.tra_ecom_estado = 'A') 
                    where 
                    1=1
                    and ((a.pro_nombre like concat('%',:filter,'%') or a.pro_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and a.pro_empresa = :emp_codigo 
                    and (a.pro_estado = 'A' || a.pro_estado = 'I') 
                    and a.pro_clasificacion =:pro_clasificacion 
                    and (a.pro_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.pro_fechai <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                    limit $pag_inicio, $tamanio";
                    //and ec.tra_ecom_tipo_ficha =:tra_ecom_tipo_ficha
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                        'pro_estado' => $pro_estado,
                        'pro_clasificacion' => $pro_clasificacion,
                        'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                        'tra_ecom_no_examen' => $tra_ecom_no_examen,
                        //'tra_ecom_tipo_ficha' => $tra_ecom_tipo_ficha,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter,
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_producto a
                            left outer join cfg_catalogo d on(a.pro_estado= d.cat_valor and d.cat_tipo = 'ESTADO_PRODUCTO' and d.cat_empresa = :emp_codigo)
                            left outer join cfg_usuario b on (b.usr_correl = a.pro_usuarioi)
                            left outer join cfg_usuario c on (c.usr_correl = a.pro_usuariom)
                            left outer join examenes_complementarios ec on (ec.tra_ecom_pro_correl = a.pro_correl and ec.tra_ecom_tra_cm_correlativo =:tra_ecom_tra_cm_correlativo 
                            and ec.tra_ecom_no_examen =:tra_ecom_no_examen and ec.tra_ecom_estado = 'A') 
                            ", "   and a.pro_empresa = :emp_codigo 
                            and ((a.pro_nombre like concat('%',:filter,'%') or a.pro_nombre_corto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                            and a.pro_estado =:pro_estado
                            and (a.pro_fechai >=str_to_date(:fecha_ini|| '00:00','%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                            and (a.pro_fechai <=str_to_date(:fecha_fin|| '23:59','%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                            ", 
                            ['emp_codigo' => $emp_codigo,
                            'pro_estado' => $pro_estado,
                            'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                            'tra_ecom_no_examen' => $tra_ecom_no_examen,
                            //'tra_ecom_tipo_ficha' => $tra_ecom_tipo_ficha,
                            'fecha_ini' => $fecha_ini,
                            'fecha_fin' => $fecha_fin,
                            'filter' => $filter,
                            ]);
                        //and ec.tra_ecom_tipo_ficha =:tra_ecom_tipo_ficha 
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insertConsultaMedica($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'nuevo');

                if($userFuncionality == 'OK'){
                    $registrarCita = false;
                    $tra_cm_lugar_atencion  = (int)$parameter['tra_cm_lugar_atencion'] ?? 0;
                    $tra_cm_tipo_consulta=(int)$parameter['tra_cm_tipo_consulta'] ?? 0;
                    $tra_cm_procedencia=(int)$parameter['tra_cm_procedencia'] ?? 0;
                    $tra_cm_primer_consulta=(int)$parameter['tra_cm_primer_consulta'] ?? 0;
                    $tra_cm_paciente_intercalado=(int)$parameter['tra_cm_paciente_intercalado'] ?? 0;
                    $tra_cm_aseguradora=(int)$parameter['tra_cm_aseguradora'] ?? 0;
                    $tra_cm_usr_correl=(int)$parameter['tra_cm_usr_correl'] ?? 0;
                    
                    $tra_cm_fecha_inicio_consulta=$parameter['tra_cm_fecha_inicio_consulta'] ?? date("Y-m-d H:i");
                    $tra_cm_fecha_fin_consulta= "";
                    $tra_cm_nombre_paciente=$parameter['tra_cm_nombre_paciente'] ?? NULL;
                    $tra_cm_fecha_nacimiento=$parameter['tra_cm_fecha_nacimiento'] ?? date("Y-m-d");
                    $tra_cm_correo=$parameter['tra_cm_correo'] ?? 'null';
                    if($tra_cm_fecha_nacimiento == "" || $tra_cm_fecha_nacimiento == "Invalid date"){
                        $tra_cm_fecha_nacimiento = NULL;
                    }
                    $tra_cm_telefono= $parameter['tra_cm_telefono'] ?? NULL;
                    //$tra_cm_menor  = $parameter['tra_cm_menor'] ?? 0;
                    $tra_cm_responsable_menor=$parameter['tra_cm_responsable_menor'] ?? NULL;
                    $tra_cm_direccion=$parameter['tra_cm_direccion'] ?? NULL;
                    $agendarReConnsulta=(int)$parameter['agendarReConnsulta'] ?? 0;

                    $tra_cm_etapa  = 1;
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';
                    
                    if($tra_cm_fecha_inicio_consulta !=""){
                        //$tra_fecha_fin_consulta = $tra_cm_fecha_inicio_consulta->modify('+40 minute'); 
                        $tra_cm_fecha_fin_consulta = strtotime ( '+40 minute' , strtotime($tra_cm_fecha_inicio_consulta)) ;
                        $tra_cm_fecha_fin_consulta = date( 'Y-m-d H:i:s' , $tra_cm_fecha_fin_consulta);
                    }
                    $tra_cm_nombre_paciente = $utility->validarLongitudString($tra_cm_nombre_paciente, 0, 200);
                    $tra_cm_correo = $utility->validarLongitudString($tra_cm_correo, 0, 100);
                    $tra_cm_telefono = $utility->validarLongitudString($tra_cm_telefono, 0, 15);
                    $tra_cm_direccion = $utility->validarLongitudString($tra_cm_direccion, 0, 150);
                    
                    //DATE_ADD(tra_cm_fecha_inicio_consulta, INTERVAL @intervalo MINUTE), 
                    $horaConsulta = "18:00";
                    $horarioCentroValido = $utility->validarHorarioSucursal($PDO, "cfg_sucursal", "suc_correlativo","$tra_cm_fecha_inicio_consulta","$tra_cm_fecha_fin_consulta","$tra_cm_lugar_atencion"," and suc_empresa = $emp_codigo and suc_ambiente = $amb_codigo");
                    
                    $horarioMedicoDisponible = 1;//$utility->validarDisponibilidadHorarioMedico($PDO, "cfg_agenda", "age_correlativo","$age_usr_correl","$age_suc_correlativo","$age_pro_correl", "$tra_cm_fecha_inicio_consulta", "$tra_cm_fecha_fin_consulta", "order by age_correlativo desc");


                    if($tra_cm_paciente_intercalado > 0){
                        $registrarConsulta = 0;
                    }else{
                        //$registrarConsulta = 0;
                        $registrarConsulta = $utility->validarHorarioCosulta($PDO, "tra_consulta_medica", "tra_cm_correlativo","$age_usr_correl","$tra_cm_lugar_atencion","$tra_cm_tipo_consulta", "$tra_cm_fecha_inicio_consulta", "$tra_cm_fecha_fin_consulta", "");
                    }
                    
                    $tra_cm_correlativo = $utility->CorrelAutomatico($PDO, "tra_consulta_medica", "tra_cm_correlativo", "");

                    $array_cliente = array(
                        'cli_nombre'=>$tra_cm_nombre_paciente,
                        'cli_email'=>$tra_cm_correo,
                        'cli_telefono1'=>$tra_cm_telefono,
                        'cli_telefono2'=>$tra_cm_telefono,
                        'cli_fecha_nacimiento'=>$tra_cm_fecha_nacimiento
                    );
                    //identificamos al cliente
                    $tra_cm_cli_correlativo = $utility->clientRegister($PDO,$array_cliente, $id_usuario,0);
                    
                    if($agendarReConnsulta >= 1){
                        $tra_cm_confirmacion_cita = 2;
                        $tra_cm_proxima_cita = "";

                        $sqlU = 
                        "UPDATE tra_consulta_medica SET 
                                                tra_cm_fecha_confirmacion_proxima_cita = now(),
                                                tra_cm_confirmacion_cita = :tra_cm_confirmacion_cita,
                                                tra_cm_usuariom = :id_usuario,
                                                tra_cm_no_consulta = :tra_cm_correlativo,
                                                tra_cm_fecham = now() 
                                                where tra_cm_correlativo = :agendarReConnsulta";//and tra_fichamn_tra_correlativo = :tra_fichamn_tra_correlativo
            
                        $stmtU = $PDO->prepare($sqlU);
                        $result = $stmtU->execute([
                            'id_usuario' => $id_usuario,
                            'agendarReConnsulta' => $agendarReConnsulta,
                            'tra_cm_confirmacion_cita' => $tra_cm_confirmacion_cita,
                            'tra_cm_correlativo' => $tra_cm_correlativo
                            //'tra_cm_proxima_cita' => $tra_cm_proxima_cita
                        ]);

                    }
                    
                     $sql = " 
                     insert into tra_consulta_medica (
                                            tra_cm_correlativo, 
                                            tra_cm_codigo, 
                                            tra_cm_empresa, 
                                            tra_cm_ambiente,
                                            tra_cm_procedencia,
                                            tra_cm_aseguradora,
                                            tra_cm_primer_consulta,
                                            tra_cm_lugar_atencion,
                                            tra_cm_tipo_consulta,
                                            tra_cm_usr_correl,
                                            tra_cm_fecha_inicio_consulta, 
                                            tra_cm_fecha_fin_consulta,
                                            tra_cm_cli_correlativo,
                                            tra_cm_nombre_paciente, 
                                            tra_cm_correo,
                                            tra_cm_telefono,
                                            tra_cm_direccion, 
                                            tra_cm_etapa,
                                            tra_cm_paciente_intercalado,
                                            tra_cm_estado,
                                            tra_cm_usuarioi,
                                            tra_cm_usuariom,
                                            tra_cm_fechai,
                                            tra_cm_fecham
                                            ) values(
                                            :tra_cm_correlativo, 
                                            :tra_cm_codigo, 
                                            :tra_cm_empresa, 
                                            :tra_cm_ambiente,
                                            :tra_cm_procedencia,
                                            :tra_cm_aseguradora,
                                            :tra_cm_primer_consulta,
                                            :tra_cm_lugar_atencion,
                                            :tra_cm_tipo_consulta, 
                                            :tra_cm_usr_correl,
                                            :tra_cm_fecha_inicio_consulta,
                                            :tra_cm_fecha_fin_consulta,
                                            :tra_cm_cli_correlativo,
                                            :tra_cm_nombre_paciente, 
                                            :tra_cm_correo,
                                            :tra_cm_telefono,
                                            :tra_cm_direccion, 
                                            :tra_cm_etapa,
                                            :tra_cm_paciente_intercalado,
                                            :tra_cm_estado,
                                            :id_usuario, 
                                            :id_usuario, 
                                            now(), 
                                            now()
                                            )";

                                                
                        if($horarioCentroValido > 0){
                            //$registrarCita = true;
                            if($registrarConsulta == 0){//&& $registrarConsulta != undefined && $registrarConsulta !=""
                                $registrarCita = true;
                            }else{
                                $registrarCita = false;
                                $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar la consulta del paciente, el horario seleccionado ya está reservado, por favor cambie el horario.', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                            /*if($horarioMedicoDisponible > 0){
                                $registrarCita = true;
                            }else{
                                $registrarCita = false;
                                $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar la consulta del paciente, el horario seleccionado ya está reservado, por favor revise el horario del médico', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }*/
                        }else{
                            $registrarCita = false;
                            $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar la consulta del paciente, el horario seleccionado está fuera del horario del centro, por favor revise el horario del centro de atención', 'status'=>402,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(402);
                        }
                        
                        if($registrarCita == true){
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'tra_cm_correlativo' => $tra_cm_correlativo, 
                                'tra_cm_codigo' => $tra_cm_correlativo, 
                                'tra_cm_empresa' => $emp_codigo, 
                                'tra_cm_ambiente' => $amb_codigo,
                                'tra_cm_usr_correl' => $tra_cm_usr_correl,
                                'tra_cm_primer_consulta' => $tra_cm_primer_consulta,
                                'tra_cm_procedencia' => $tra_cm_procedencia,
                                'tra_cm_aseguradora' => $tra_cm_aseguradora,
                                'tra_cm_lugar_atencion' => $tra_cm_lugar_atencion,
                                'tra_cm_tipo_consulta' => $tra_cm_tipo_consulta, 
                                'tra_cm_fecha_inicio_consulta' => $tra_cm_fecha_inicio_consulta, 
                                'tra_cm_fecha_fin_consulta' => $tra_cm_fecha_fin_consulta, 
                                'tra_cm_cli_correlativo' => $tra_cm_cli_correlativo,
                                'tra_cm_nombre_paciente' => $tra_cm_nombre_paciente, 
                                'tra_cm_correo' => $tra_cm_correo,
                                //'tra_cm_fecha_nacimiento' =>$tra_cm_fecha_nacimiento,
                                'tra_cm_telefono' => $tra_cm_telefono,
                                'tra_cm_direccion' => $tra_cm_direccion, 
                                'tra_cm_etapa' => $tra_cm_etapa,
                                'tra_cm_paciente_intercalado' => $tra_cm_paciente_intercalado,
                                'tra_cm_estado' => $tra_cm_estado,
                                'id_usuario' => $id_usuario, 
                                'id_usuario' => $id_usuario
                                ]);
                              
                                
                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_cm_correlativo);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }
                    
                }else{

                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function updateConsultaMedica($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'nuevo');

                if($userFuncionality == 'OK'){
                    $updateConsulta = false;
                    
                    $cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $tra_cm_correlativo = (int)$parameter['tra_cm_correlativo'] ?? 0;
                    $tra_cm_procedencia = (int)$parameter['tra_cm_procedencia'] ?? 0;
                    $tra_cm_aseguradora = (int)$parameter['tra_cm_aseguradora'] ?? 0;
                    $tra_cm_paciente_intercalado=(int)$parameter['tra_cm_paciente_intercalado'] ?? 0;
                    $tra_cm_lugar_atencion = $parameter['tra_cm_lugar_atencion'] ?? 0;
                    $tra_cm_tipo_consulta = $parameter['tra_cm_tipo_consulta'] ?? 0;
                    $tra_cm_usr_correl = $parameter['tra_cm_usr_correl'] ?? 0;
                    $tra_cm_nombre_paciente = $parameter['tra_cm_nombre_paciente'] ?? 'null';
                    $tra_cm_telefono = $parameter['tra_cm_telefono'] ?? 'null';
                    $tra_cm_correo = $parameter['tra_cm_correo'] ?? 'null';
                    $tra_cm_observaciones = $parameter['tra_cm_observaciones'] ?? 'null';
                    $cambioFechaConsulta = $parameter['cambioFechaConsulta'] ?? NULL;

                    
                    //$tra_cm_fecha_inicio_consulta = $parameter['tra_cm_fecha_inicio_consulta'] ?? NULL;
                    $tra_cm_fecha_inicio_consulta = $parameter['tra_cm_fecha_inicio_consulta'] ?? date("Y-m-d H:i");
                    if($tra_cm_fecha_inicio_consulta == ""){//|| $tra_cm_fecha_inicio_consulta = 'Invalid date'
                        $tra_cm_fecha_inicio_consulta = NULL;
                    }
                    $tra_cm_fecha_fin_consulta = "";
                    $tra_cm_fecha_nacimiento = $parameter['tra_cm_fecha_nacimiento'] ?? NULL;
                    if($tra_cm_fecha_nacimiento == "" || $tra_cm_fecha_nacimiento == 'Invalid date'){
                        $tra_cm_fecha_nacimiento = NULL;
                    }
                    

                    $tra_cm_nombre_paciente = $utility->validarLongitudString($tra_cm_nombre_paciente, 0, 150);
                    $tra_cm_telefono = $utility->validarLongitudString($tra_cm_telefono, 0, 15);
                    $tra_cm_correo = $utility->validarLongitudString($tra_cm_correo, 0, 100);
                    $tra_cm_observaciones = $utility->validarLongitudString($tra_cm_observaciones, 0, 150);


                    $observacionRecalendarizacion = "";
                    if($cambioFechaConsulta == 'true'){//
                        $tra_cm_observaciones = 'A';//COMO LA CONSULTA ES PERA UN PARAMETRO tra_cm_observaciones ES IMPORTANTE MANDARLE UN VALOR A ESE PARAMETRO
                        $observacionRecalendarizacion = "tra_cm_estado = :tra_cm_observaciones,";
                    }else if($cambioFechaConsulta == 'false'){
                        $observacionRecalendarizacion = "tra_cm_observaciones_recalendarizacion = :tra_cm_observaciones,";
                        //$tra_cm_observaciones_recalendarizacion = $parameter['tra_cm_observaciones'];
                    }

                    if($tra_cm_fecha_inicio_consulta !=""){
                        //$tra_cm_fecha_fin_consulta = $tra_cm_fecha_inicio_consulta->modify('+40 minute'); 
                        $tra_cm_fecha_fin_consulta = strtotime ( '+40 minute' , strtotime($tra_cm_fecha_inicio_consulta)) ;
                        $tra_cm_fecha_fin_consulta = date( 'Y-m-d H:i:s' , $tra_cm_fecha_fin_consulta);
                    }

                    $array_cliente = array(
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre'=>$tra_cm_nombre_paciente,
                        'cli_email'=>$tra_cm_correo,
                        'cli_telefono1'=>$tra_cm_telefono,
                        'cli_telefono2'=>$tra_cm_telefono,
                        'cli_fecha_nacimiento' =>$tra_cm_fecha_nacimiento
                    );
                    
                    $cli_correlativo = $utility->clientRegister($PDO,$array_cliente, $id_usuario,1);//1=modificar

                    //si $horarioCentroValido = 0 entonces horario no válido
                    //si $horarioCentroValido = 1 entonces valido
                    $horarioCentroValido = $utility->validarHorarioSucursal($PDO, "cfg_sucursal", "suc_correlativo","$tra_cm_fecha_inicio_consulta","$tra_cm_fecha_fin_consulta","$tra_cm_lugar_atencion"," and suc_empresa = $emp_codigo and suc_ambiente = $amb_codigo");

                    $codPaciente = $utility->obtenerCodigoConsulta($PDO, "tra_consulta_medica", $tra_cm_correlativo, "");
                    if($tra_cm_paciente_intercalado > 0){
                        $registrarConsulta = 0;
                    }else{
                        if($codPaciente[0]->tra_cm_fecha_inicio_consulta == $tra_cm_fecha_inicio_consulta.':00'){
                            $registrarConsulta = 0;
                        }else{
                            $registrarConsulta = $utility->validarHorarioCosulta($PDO, "tra_consulta_medica", "tra_cm_correlativo","$tra_cm_usr_correl","$tra_cm_lugar_atencion","$tra_cm_tipo_consulta", "$tra_cm_fecha_inicio_consulta", "$tra_cm_fecha_fin_consulta", "");
                            /*$horarioCitaDisponible = $utility->validarHorarioCitas($PDO, "tra_consulta_medica", "tra_cm_correlativo ","$tra_cm_tipo_consulta","$tra_cm_lugar_atencion", "$tra_cm_fecha_inicio_consulta.", "$tra_cm_fecha_fin_consulta", "");*/
                        }
                    }
                    

                    //$cli_nit = $utility->validarLongitudNumero($cli_nit, 0, 10);
                    //$tra_cm_correlativo = $utility->CorrelAutomatico($PDO, "tra_consulta_medica", "tra_cm_correlativo ", "");
                    
                     $sql = " 
                     UPDATE tra_consulta_medica SET 
                                            tra_cm_procedencia = :tra_cm_procedencia, 
                                            tra_cm_aseguradora = :tra_cm_aseguradora,
                                            tra_cm_fecha_inicio_consulta = :tra_cm_fecha_inicio_consulta,
                                            tra_cm_fecha_fin_consulta = :tra_cm_fecha_fin_consulta,
                                            tra_cm_paciente_intercalado = :tra_cm_paciente_intercalado,
                                            $observacionRecalendarizacion 
                                            tra_cm_usuariom = :id_usuario,
                                            tra_cm_fecham = now() 
                                            WHERE tra_cm_correlativo = :tra_cm_correlativo";

                //.$codPaciente[0]->tra_cm_fecha_inicio_consulta.' '.$codPaciente[0]->tra_cm_cli_correlativo.' '.$codPaciente[0]->tra_cm_fecha_fin_consulta                      
                        if($horarioCentroValido > 0){
                            //$updateConsulta = true;
                            if($registrarConsulta == 0){//$horarioCitaDisponible
                                $updateConsulta = true;
                            }else{
                                $updateConsulta = false;
                                $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar la cita del paciente, el horario seleccionado ya está reservado, por favor revise el horario en el calendario.', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }else{
                            $updateConsulta = false;
                            $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar la cita del paciente, el horario seleccionado está fuera del horario del centro, por favor revise el horario del centro de atención', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                        
                        if($updateConsulta == true){
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'tra_cm_correlativo' => $tra_cm_correlativo, 
                                'tra_cm_procedencia' => $tra_cm_procedencia,
                                'tra_cm_aseguradora' => $tra_cm_aseguradora,
                                'tra_cm_fecha_inicio_consulta' => $tra_cm_fecha_inicio_consulta,
                                'tra_cm_fecha_fin_consulta' => $tra_cm_fecha_fin_consulta,
                                'tra_cm_observaciones' => $tra_cm_observaciones,
                                'tra_cm_paciente_intercalado' => $tra_cm_paciente_intercalado,
                                /*'tra_cm_correo' => $tra_cm_correo,
                                'tra_cm_fecha_nacimiento' => $tra_cm_fecha_nacimiento,*/
                                'id_usuario' => $id_usuario
                                ]);
                              
                                
                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }
                    
                }else{

                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    /*
    public function insertFichaMedica($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){


                    //PARAMETROS USUARIO
                    $cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $cli_nombre = $parameter['cli_nombre'] ?? 'null';
                    $cli_email = $parameter['cli_email'] ?? 'null';
                    $cli_fecha_nacimiento = $parameter['cli_fecha_nacimiento'] ?? NULL;
                    if($cli_fecha_nacimiento == ""){$cli_fecha_nacimiento = NULL;}
                    $cli_dpi = $parameter['cli_dpi'] ?? 'null';
                    $cli_telefono1 = $parameter['cli_telefono1'] ?? NULL;
                    $cli_edad = 0;//$parameter['cli_edad'] ?? 'null';
                    $cli_responsable = $parameter['cli_responsable'] ?? NULL;
                    $cli_direccion = $parameter['cli_direccion'] ?? NULL;
                    $cli_estado_civil = $parameter['cli_estado_civil'] ?? NULL;
                    $cli_religion = $parameter['cli_religion'] ?? 'null';
                    $cli_escolaridad = $parameter['cli_escolaridad'] ?? NULL;
                    $cli_ocupacion = $parameter['cli_ocupacion'] ?? NULL;
                    $cli_grupo_sanguineo = $parameter['cli_grupo_sanguineo'] ?? NULL;

                    //PARAMETROS FICHA MEDICA
                    $tra_fm_tra_cm_correlativo = (int)$parameter['tra_fm_tra_cm_correlativo'] ?? 0;
                    $tra_fm_usr_correl = (int)$parameter['tra_fm_usr_correl'] ?? 0;
                    $tra_fm_app = $parameter['tra_fm_app'] ?? NULL;
                    $tra_fm_apf = $parameter['tra_fm_apf'] ?? NULL;
                    $tra_fm_alcohol = $parameter['tra_fm_alcohol'] ?? false;
                    $tra_fm_cafe = $parameter['tra_fm_cafe'] ?? false;
                    $tra_fm_tabaco = $parameter['tra_fm_tabaco'] ?? false;
                    $tra_fm_otros = $parameter['tra_fm_otros'] ?? NULL;

                    if($tra_fm_alcohol == "true" || $tra_fm_alcohol == 'true'){$tra_fm_alcohol = 1;}else{$tra_fm_alcohol = 0;}
                    if($tra_fm_cafe == "true" || $tra_fm_cafe == 'true'){$tra_fm_cafe = 1;}else{$tra_fm_cafe = 0;}
                    if($tra_fm_tabaco == "true" || $tra_fm_tabaco == 'true'){$tra_fm_tabaco = 1;}else{$tra_fm_tabaco = 0;}

                    $tra_fm_peso_kg = $parameter['tra_fm_peso_kg'] ?? 0.0;
                    $tra_fm_talla_mts = $parameter['tra_fm_talla_mts'] ?? 0.0;
                    $tra_fm_valor_imc = $parameter['tra_fm_valor_imc'] ?? 0.0;
                    $tra_fm_valor_fc = $parameter['tra_fm_valor_fc'] ?? 0.0;
                    $tra_fm_valor_fr = $parameter['tra_fm_valor_fr'] ?? 0.0;
                    $tra_fm_valor_ta = $parameter['tra_fm_valor_ta'] ?? 0.0;
                    $tra_fm_valor_temperatura = $parameter['tra_fm_valor_temperatura'] ?? 0.0;
                    $tra_fm_estado_nutricional = $parameter['tra_fm_estado_nutricional'] ?? NULL;

                    $tra_fm_g = $parameter['tra_fm_g'] ?? NULL;
                    $tra_fm_p = $parameter['tra_fm_p'] ?? NULL;
                    $tra_fm_a = $parameter['tra_fm_a'] ?? NULL;
                    $tra_fm_hv = $parameter['tra_fm_hv'] ?? NULL;
                    $tra_fm_hm = $parameter['tra_fm_hm'] ?? NULL;
                    $tra_fm_fur = $parameter['tra_fm_fur'] ?? NULL;
                    $tra_fm_ciclos = $parameter['tra_fm_ciclos'] ?? NULL;
                    $tra_fm_eg = $parameter['tra_fm_eg'] ?? NULL;
                    $tra_fm_fpp = $parameter['tra_fm_fpp'] ?? NULL;
                    $tra_fm_motivo_consulta = $parameter['tra_fm_motivo_consulta'] ?? NULL;
                    $tra_fm_resumen_hea = $parameter['tra_fm_resumen_hea'] ?? NULL;
                    $tra_fm_impresion_diagnostico = $parameter['tra_fm_impresion_diagnostico'] ?? NULL;
                    $tra_fm_tratamiento = $parameter['tra_fm_tratamiento'] ?? NULL;
                    $tra_fm_observacion = $parameter['tra_fm_observacion'] ?? NULL;
                    
                    $cli_grupo_sanguineo = $utility->validarLongitudString($cli_grupo_sanguineo, 0, 300);
                    $cli_responsable = $utility->validarLongitudString($cli_responsable, 0, 150);
                    $tra_fm_motivo_consulta = $utility->validarLongitudString($tra_fm_motivo_consulta, 0, 500);
                    $tra_fm_resumen_hea = $utility->validarLongitudString($tra_fm_resumen_hea, 0, 3000);
                    $tra_fm_impresion_diagnostico = $utility->validarLongitudString($tra_fm_impresion_diagnostico, 0, 500);
                    $tra_fm_tratamiento = $utility->validarLongitudString($tra_fm_tratamiento, 0, 2000);
                    $tra_fm_observacion = $utility->validarLongitudString($tra_fm_observacion, 0, 3000);
                    $tra_fm_estado_nutricional = $utility->validarLongitudString($tra_fm_estado_nutricional, 0, 1000);
                    
                    
                    //ACTUALIZACION DATOS USUARIO
                    $sqlUser = "update cfg_cliente set 
                    cli_nombre = :cli_nombre,
                    cli_email = :cli_email,
                    cli_dpi = :cli_dpi,
                    cli_telefono1 = :cli_telefono1,
                    cli_direccion = :cli_direccion,
                    cli_fecha_nacimiento = :cli_fecha_nacimiento,
                    cli_edad = :cli_edad,
                    cli_responsable = :cli_responsable,
                    cli_estado_civil = :cli_estado_civil,
                    cli_religion = :cli_religion,
                    cli_escolaridad  = :cli_escolaridad,
                    cli_ocupacion = :cli_ocupacion,
                    cli_usuariom = :id_usuario,
                    cli_grupo_sanguineo = :cli_grupo_sanguineo,
                    cli_fecham = now() 
                    where cli_correlativo = :cli_correlativo";

                    $stmtUser = $PDO->prepare($sqlUser);
                    $resultUser = $stmtUser->execute([
                        'id_usuario' => $id_usuario,
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre' => $cli_nombre,
                        'cli_email' => $cli_email,
                        //'cli_nit' => $cli_nit,
                        'cli_dpi' => $cli_dpi,
                        'cli_telefono1' => $cli_telefono1,
                        'cli_direccion' => $cli_direccion,
                        'cli_fecha_nacimiento' => $cli_fecha_nacimiento,
                        'cli_edad' => $cli_edad,
                        'cli_responsable' => $cli_responsable,
                        'cli_estado_civil' => $cli_estado_civil,
                        'cli_religion' => $cli_religion,
                        'cli_escolaridad' => $cli_escolaridad,
                        'cli_ocupacion' => $cli_ocupacion,
                        'cli_grupo_sanguineo' => $cli_grupo_sanguineo
                    ]);
                    
                    $tra_fm_correlativo = $utility->CorrelAutomatico($PDO, "tra_ficha_medica", "tra_fm_correlativo ", "");

                    if ($resultUser == true) {
                        //ACTUALIZACION DATOS FICHA MEDICA
                        $sqlFM = "insert into tra_ficha_medica (
                            tra_fm_correlativo,
                            tra_fm_tra_cm_correlativo,
                            tra_fm_usr_correl,
                            tra_fm_app,
                            tra_fm_apf,
                            tra_fm_alcohol,
                            tra_fm_cafe,
                            tra_fm_tabaco,
                            tra_fm_otros,
                            tra_fm_grupo_sanguineo,
                            tra_fm_peso_kg,
                            tra_fm_talla_mts,
                            tra_fm_valor_imc,
                            tra_fm_valor_fc,
                            tra_fm_valor_fr,
                            tra_fm_valor_ta,
                            tra_fm_valor_temperatura,
                            tra_fm_estado_nutricional,
                            tra_fm_g,
                            tra_fm_p,
                            tra_fm_a,
                            tra_fm_hv,
                            tra_fm_hm,
                            tra_fm_fur,
                            tra_fm_ciclos,
                            tra_fm_eg,
                            tra_fm_fpp,
                            tra_fm_motivo_consulta,
                            tra_fm_resumen_hea,
                            tra_fm_impresion_diagnostico,
                            tra_fm_tratamiento,
                            tra_fm_observacion,
                            tra_fm_estado,
                            tra_fm_usuarioi,
                            tra_fm_usuariom,
                            tra_fm_fechai,
                            tra_fm_fecham
                        )values(
                            :tra_fm_correlativo,
                            :tra_fm_tra_cm_correlativo,
                            :id_usuario,
                            :tra_fm_app,
                            :tra_fm_apf,
                            :tra_fm_alcohol,
                            :tra_fm_cafe,
                            :tra_fm_tabaco,
                            :tra_fm_otros,
                            :tra_fm_grupo_sanguineo,
                            :tra_fm_peso_kg,
                            :tra_fm_talla_mts,
                            :tra_fm_valor_imc,
                            :tra_fm_valor_fc,
                            :tra_fm_valor_fr,
                            :tra_fm_valor_ta,
                            :tra_fm_valor_temperatura,
                            :tra_fm_estado_nutricional,
                            :tra_fm_g,
                            :tra_fm_p,
                            :tra_fm_a,
                            :tra_fm_hv,
                            :tra_fm_hm,
                            :tra_fm_fur,
                            :tra_fm_ciclos,
                            :tra_fm_eg,
                            :tra_fm_fpp,
                            :tra_fm_motivo_consulta,
                            :tra_fm_resumen_hea,
                            :tra_fm_impresion_diagnostico,
                            :tra_fm_tratamiento,
                            :tra_fm_observacion,
                            'A',
                            :id_usuario,
                            :id_usuario,
                            now(),
                            now()
                        )
                        ";
            
                        $stmtFM = $PDO->prepare($sqlFM);
                        $resultFM = $stmtFM->execute([
                            'id_usuario' => $id_usuario,
                            'tra_fm_correlativo' => $tra_fm_correlativo,
                            'tra_fm_tra_cm_correlativo' => $tra_fm_tra_cm_correlativo,
                            'tra_fm_usr_correl' => $tra_fm_usr_correl,
                            'tra_fm_app' => $tra_fm_app,
                            'tra_fm_apf' => $tra_fm_apf,
                            'tra_fm_alcohol' => $tra_fm_alcohol,
                            'tra_fm_cafe' => $tra_fm_cafe,
                            'tra_fm_tabaco' => $tra_fm_tabaco,
                            'tra_fm_otros' => $tra_fm_otros,
                            'tra_fm_peso_kg' => $tra_fm_peso_kg,
                            'tra_fm_talla_mts' => $tra_fm_talla_mts,
                            'tra_fm_valor_imc' => $tra_fm_valor_imc,
                            'tra_fm_valor_fc' => $tra_fm_valor_fc,
                            'tra_fm_valor_fr' => $tra_fm_valor_fr,
                            'tra_fm_valor_ta' => $tra_fm_valor_ta,
                            'tra_fm_valor_temperatura' => $tra_fm_valor_temperatura,
                            'tra_fm_estado_nutricional' => $tra_fm_estado_nutricional,
                            'tra_fm_g' => $tra_fm_g,
                            'tra_fm_p' => $tra_fm_p,
                            'tra_fm_a' => $tra_fm_a,
                            'tra_fm_hv' => $tra_fm_hv,
                            'tra_fm_hm' => $tra_fm_hm,
                            'tra_fm_fur' => $tra_fm_fur,
                            'tra_fm_ciclos' => $tra_fm_ciclos,
                            'tra_fm_eg' => $tra_fm_eg,
                            'tra_fm_fpp' => $tra_fm_fpp,
                            'tra_fm_motivo_consulta' => $tra_fm_motivo_consulta,
                            'tra_fm_resumen_hea' => $tra_fm_resumen_hea,
                            'tra_fm_impresion_diagnostico' => $tra_fm_impresion_diagnostico,
                            'tra_fm_tratamiento' => $tra_fm_tratamiento,
                            'tra_fm_observacion' => $tra_fm_observacion,
                            'tra_fm_grupo_sanguineo' => $cli_grupo_sanguineo
                        ]);
                        if ($resultFM == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_fm_correlativo);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function updateFichaMedica($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){


                    //PARAMETROS USUARIO
                    $cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $cli_nombre = $parameter['cli_nombre'] ?? NULL;
                    $cli_email = $parameter['cli_email'] ?? NULL;
                    $cli_fecha_nacimiento = $parameter['cli_fecha_nacimiento'] ?? NULL;
                    if($cli_fecha_nacimiento == ""){$cli_fecha_nacimiento = NULL;}
                    $cli_dpi = $parameter['cli_dpi'] ?? NULL;
                    $cli_telefono1 = $parameter['cli_telefono1'] ?? NULL;
                    $cli_edad = 0;//$parameter['cli_edad'] ?? NULL;
                    $cli_responsable = $parameter['cli_responsable'] ?? NULL;
                    $cli_direccion = $parameter['cli_direccion'] ?? NULL;
                    $cli_estado_civil = $parameter['cli_estado_civil'] ?? NULL;
                    $cli_religion = $parameter['cli_religion'] ?? NULL;
                    $cli_escolaridad = $parameter['cli_escolaridad'] ?? NULL;
                    $cli_ocupacion = $parameter['cli_ocupacion'] ?? NULL;
                    $cli_grupo_sanguineo = $parameter['cli_grupo_sanguineo'] ?? NULL;

                    //PARAMETROS FICHA MEDICA
                    $tra_fm_correlativo = (int)$parameter['tra_fm_correlativo'] ?? 0;
                    //$tra_fm_tra_cm_correlativo = (int)$parameter['tra_fm_tra_cm_correlativo'] ?? 0;
                    $tra_fm_usr_correl = (int)$parameter['tra_fm_usr_correl'] ?? 0;
                    $tra_fm_app = $parameter['tra_fm_app'] ?? NULL;
                    $tra_fm_apf = $parameter['tra_fm_apf'] ?? NULL;
                    $tra_fm_alcohol = $parameter['tra_fm_alcohol'] ?? false;
                    $tra_fm_cafe = $parameter['tra_fm_cafe'] ?? false;
                    $tra_fm_tabaco = $parameter['tra_fm_tabaco'] ?? false;
                    $tra_fm_otros = $parameter['tra_fm_otros'] ?? NULL;

                    if($tra_fm_alcohol == "true" || $tra_fm_alcohol == 'true'){$tra_fm_alcohol = 1;}else{$tra_fm_alcohol = 0;}
                    if($tra_fm_cafe == "true" || $tra_fm_cafe == 'true'){$tra_fm_cafe = 1;}else{$tra_fm_cafe = 0;}
                    if($tra_fm_tabaco == "true" || $tra_fm_tabaco == 'true'){$tra_fm_tabaco = 1;}else{$tra_fm_tabaco = 0;}

                    $tra_fm_peso_kg = $parameter['tra_fm_peso_kg'] ?? 0.0;
                    $tra_fm_talla_mts = $parameter['tra_fm_talla_mts'] ?? 0.0;
                    $tra_fm_valor_imc = $parameter['tra_fm_valor_imc'] ?? 0.0;
                    $tra_fm_valor_fc = $parameter['tra_fm_valor_fc'] ?? 0.0;
                    $tra_fm_valor_fr = $parameter['tra_fm_valor_fr'] ?? 0.0;
                    $tra_fm_valor_ta = $parameter['tra_fm_valor_ta'] ?? 0.0;
                    $tra_fm_valor_temperatura = $parameter['tra_fm_valor_temperatura'] ?? 0.0;
                    $tra_fm_estado_nutricional = $parameter['tra_fm_estado_nutricional'] ?? NULL;
                    

                    $tra_fm_g = $parameter['tra_fm_g'] ?? NULL;
                    $tra_fm_p = $parameter['tra_fm_p'] ?? NULL;
                    $tra_fm_a = $parameter['tra_fm_a'] ?? NULL;
                    $tra_fm_hv = $parameter['tra_fm_hv'] ?? NULL;
                    $tra_fm_hm = $parameter['tra_fm_hm'] ?? NULL;
                    $tra_fm_fur = $parameter['tra_fm_fur'] ?? NULL;
                    $tra_fm_ciclos = $parameter['tra_fm_ciclos'] ?? NULL;
                    $tra_fm_eg = $parameter['tra_fm_eg'] ?? NULL;
                    $tra_fm_fpp = $parameter['tra_fm_fpp'] ?? NULL;
                    $tra_fm_motivo_consulta = $parameter['tra_fm_motivo_consulta'] ?? NULL;
                    $tra_fm_resumen_hea = $parameter['tra_fm_resumen_hea'] ?? NULL;
                    $tra_fm_impresion_diagnostico = $parameter['tra_fm_impresion_diagnostico'] ?? NULL;
                    $tra_fm_tratamiento = $parameter['tra_fm_tratamiento'] ?? NULL;
                    $tra_fm_observacion = $parameter['tra_fm_observacion'] ?? NULL;
                    
                    $cli_grupo_sanguineo = $utility->validarLongitudString($cli_grupo_sanguineo, 0, 300);

                    $tra_fm_motivo_consulta = $utility->validarLongitudString($tra_fm_motivo_consulta, 0, 500);
                    $tra_fm_resumen_hea = $utility->validarLongitudString($tra_fm_resumen_hea, 0, 3000);
                    $tra_fm_impresion_diagnostico = $utility->validarLongitudString($tra_fm_impresion_diagnostico, 0, 500);
                    $tra_fm_tratamiento = $utility->validarLongitudString($tra_fm_tratamiento, 0, 2000);
                    $tra_fm_observacion = $utility->validarLongitudString($tra_fm_observacion, 0, 3000);
                    $tra_fm_estado_nutricional = $utility->validarLongitudString($tra_fm_estado_nutricional, 0, 3000);
                    
                    
                    //ACTUALIZACION DATOS USUARIO
                    $sqlUser = "update cfg_cliente set 
                    cli_nombre = :cli_nombre,
                    cli_email = :cli_email,
                    cli_dpi = :cli_dpi,
                    cli_telefono1 = :cli_telefono1,
                    cli_direccion = :cli_direccion,
                    cli_fecha_nacimiento = :cli_fecha_nacimiento,
                    cli_edad = :cli_edad,
                    cli_responsable = :cli_responsable,
                    cli_estado_civil = :cli_estado_civil,
                    cli_religion = :cli_religion,
                    cli_escolaridad  = :cli_escolaridad,
                    cli_ocupacion = :cli_ocupacion,
                    cli_usuariom = :id_usuario,
                    cli_grupo_sanguineo = :cli_grupo_sanguineo,
                    cli_fecham = now() 
                    where cli_correlativo = :cli_correlativo";

                    $stmtUser = $PDO->prepare($sqlUser);
                    $resultUser = $stmtUser->execute([
                        'id_usuario' => $id_usuario,
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre' => $cli_nombre,
                        'cli_email' => $cli_email,
                        //'cli_nit' => $cli_nit,
                        'cli_dpi' => $cli_dpi,
                        'cli_telefono1' => $cli_telefono1,
                        'cli_direccion' => $cli_direccion,
                        'cli_fecha_nacimiento' => $cli_fecha_nacimiento,
                        'cli_edad' => $cli_edad,
                        'cli_responsable' => $cli_responsable,
                        'cli_estado_civil' => $cli_estado_civil,
                        'cli_religion' => $cli_religion,
                        'cli_escolaridad' => $cli_escolaridad,
                        'cli_ocupacion' => $cli_ocupacion,
                        'cli_grupo_sanguineo' => $cli_grupo_sanguineo
                    ]);
                    
                    
                    if ($resultUser == true) {
                        //ACTUALIZACION DATOS FICHA MEDICA
                        $sqlFM = "update tra_ficha_medica set 
                        tra_fm_app = :tra_fm_app,
                        tra_fm_apf = :tra_fm_apf,
                        tra_fm_alcohol = :tra_fm_alcohol,
                        tra_fm_cafe = :tra_fm_cafe,
                        tra_fm_tabaco = :tra_fm_tabaco,
                        tra_fm_otros = :tra_fm_otros,
                        tra_fm_grupo_sanguineo = :tra_fm_grupo_sanguineo,
                        tra_fm_peso_kg = :tra_fm_peso_kg,
                        tra_fm_talla_mts = :tra_fm_talla_mts,
                        tra_fm_valor_imc = :tra_fm_valor_imc,
                        tra_fm_valor_fc = :tra_fm_valor_fc,
                        tra_fm_valor_fr = :tra_fm_valor_fr,
                        tra_fm_valor_ta = :tra_fm_valor_ta,
                        tra_fm_valor_temperatura = :tra_fm_valor_temperatura,
                        tra_fm_estado_nutricional = :tra_fm_estado_nutricional,
                        tra_fm_g = :tra_fm_g,
                        tra_fm_p = :tra_fm_p,
                        tra_fm_a = :tra_fm_a,
                        tra_fm_hv = :tra_fm_hv,
                        tra_fm_hm = :tra_fm_hm,
                        tra_fm_fur = :tra_fm_fur,
                        tra_fm_ciclos = :tra_fm_ciclos,
                        tra_fm_eg = :tra_fm_eg,
                        tra_fm_fpp = :tra_fm_fpp,
                        tra_fm_motivo_consulta = :tra_fm_motivo_consulta,
                        tra_fm_resumen_hea = :tra_fm_resumen_hea,
                        tra_fm_impresion_diagnostico = :tra_fm_impresion_diagnostico,
                        tra_fm_tratamiento = :tra_fm_tratamiento,
                        tra_fm_observacion = :tra_fm_observacion,
                        tra_fm_usuariom = :id_usuario,
                        tra_fm_fecham = now() 
                        where tra_fm_correlativo = :tra_fm_correlativo";
            
                        $stmtFM = $PDO->prepare($sqlFM);
                        $resultFM = $stmtFM->execute([
                            'id_usuario' => $id_usuario,
                            'tra_fm_correlativo' => $tra_fm_correlativo,
                            'tra_fm_app' => $tra_fm_app,
                            'tra_fm_apf' => $tra_fm_apf,
                            'tra_fm_alcohol' => $tra_fm_alcohol,
                            'tra_fm_cafe' => $tra_fm_cafe,
                            'tra_fm_tabaco' => $tra_fm_tabaco,
                            'tra_fm_otros' => $tra_fm_otros,
                            'tra_fm_peso_kg' => $tra_fm_peso_kg,
                            'tra_fm_talla_mts' => $tra_fm_talla_mts,
                            'tra_fm_valor_imc' => $tra_fm_valor_imc,
                            'tra_fm_valor_fc' => $tra_fm_valor_fc,
                            'tra_fm_valor_fr' => $tra_fm_valor_fr,
                            'tra_fm_valor_ta' => $tra_fm_valor_ta,
                            'tra_fm_valor_temperatura' => $tra_fm_valor_temperatura,
                            'tra_fm_estado_nutricional' => $tra_fm_estado_nutricional,
                            'tra_fm_g' => $tra_fm_g,
                            'tra_fm_p' => $tra_fm_p,
                            'tra_fm_a' => $tra_fm_a,
                            'tra_fm_hv' => $tra_fm_hv,
                            'tra_fm_hm' => $tra_fm_hm,
                            'tra_fm_fur' => $tra_fm_fur,
                            'tra_fm_ciclos' => $tra_fm_ciclos,
                            'tra_fm_eg' => $tra_fm_eg,
                            'tra_fm_fpp' => $tra_fm_fpp,
                            'tra_fm_motivo_consulta' => $tra_fm_motivo_consulta,
                            'tra_fm_resumen_hea' => $tra_fm_resumen_hea,
                            'tra_fm_impresion_diagnostico' => $tra_fm_impresion_diagnostico,
                            'tra_fm_tratamiento' => $tra_fm_tratamiento,
                            'tra_fm_observacion' => $tra_fm_observacion,
                            'tra_fm_grupo_sanguineo' => $cli_grupo_sanguineo
                        ]);
                        if ($resultFM == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertFichaOcupacional($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'nuevo');
                if($userFuncionality == 'OK'){


                    //PARAMETROS FICHA MEDICA
                    $tra_fo_tra_cm_correlativo = (int)$parameter['tra_fo_tra_cm_correlativo'] ?? 0;
                    $tra_fo_medicamento_consume_actualmente = $parameter['tra_fo_medicamento_consume_actualmente'] ?? NULL;
                    $tra_fo_habito_suenio = $parameter['tra_fo_habito_suenio'] ?? NULL;
                    $tra_fo_habito_urinario = $parameter['tra_fo_habito_urinario'] ?? NULL;
                    $tra_fo_habito_defecacion = $parameter['tra_fo_habito_defecacion'] ?? NULL;
                    $tra_fo_actividad_fisica = $parameter['tra_fo_actividad_fisica'] ?? NULL;
                    $tra_fo_laboratorio = $parameter['tra_fo_laboratorio'] ?? NULL;
                    $tra_fo_otros_datos_interes = $parameter['tra_fo_otros_datos_interes'] ?? NULL;
                    $tra_fo_impresion_diagnostica = $parameter['tra_fo_impresion_diagnostica'] ?? NULL;
                    $tra_fo_tratamiento = $parameter['tra_fo_tratamiento'] ?? NULL;
                    $tra_fo_observaciones = $parameter['tra_fo_observaciones'] ?? NULL;
                    
                    $tra_fo_medicamento_consume_actualmente = $utility->validarLongitudString($tra_fo_medicamento_consume_actualmente, 0, 500);
                    $tra_fo_habito_suenio = $utility->validarLongitudString($tra_fo_habito_suenio, 0, 500);
                    $tra_fo_habito_urinario = $utility->validarLongitudString($tra_fo_habito_urinario, 0, 500);
                    $tra_fo_habito_defecacion = $utility->validarLongitudString($tra_fo_habito_defecacion, 0, 500);
                    $tra_fo_actividad_fisica = $utility->validarLongitudString($tra_fo_actividad_fisica, 0, 500);
                    $tra_fo_laboratorio = $utility->validarLongitudString($tra_fo_laboratorio, 0, 500);
                    $tra_fo_otros_datos_interes = $utility->validarLongitudString($tra_fo_otros_datos_interes, 0, 500);
                    $tra_fo_impresion_diagnostica = $utility->validarLongitudString($tra_fo_impresion_diagnostica, 0, 2000);
                    $tra_fo_tratamiento = $utility->validarLongitudString($tra_fo_tratamiento, 0, 2000);
                    $tra_fo_observaciones = $utility->validarLongitudString($tra_fo_observaciones, 0, 300);
                    
                    
                    $tra_fo_correlativo = $utility->CorrelAutomatico($PDO, "tra_ficha_ocupacional", "tra_fo_correlativo ", "");

                    //if ($resultUser == true) {
                        //ACTUALIZACION DATOS FICHA MEDICA
                        $sqlFO = "insert into tra_ficha_ocupacional (
                            tra_fo_correlativo,
                            tra_fo_tra_cm_correlativo,
                            tra_fo_usr_correl,
                            tra_fo_medicamento_consume_actualmente,
                            tra_fo_habito_suenio,
                            tra_fo_habito_urinario,
                            tra_fo_habito_defecacion,
                            tra_fo_actividad_fisica,
                            tra_fo_laboratorio,
                            tra_fo_otros_datos_interes,
                            tra_fo_impresion_diagnostica,
                            tra_fo_tratamiento,
                            tra_fo_observaciones,
                            tra_fo_estado,
                            tra_fo_usuarioi,
                            tra_fo_usuariom,
                            tra_fo_fechai,
                            tra_fo_fecham
                        )values(
                            :tra_fo_correlativo,
                            :tra_fo_tra_cm_correlativo,
                            :id_usuario,
                            :tra_fo_medicamento_consume_actualmente,
                            :tra_fo_habito_suenio,
                            :tra_fo_habito_urinario,
                            :tra_fo_habito_defecacion,
                            :tra_fo_actividad_fisica,
                            :tra_fo_laboratorio,
                            :tra_fo_otros_datos_interes,
                            :tra_fo_impresion_diagnostica,
                            :tra_fo_tratamiento,
                            :tra_fo_observaciones,
                            'A',
                            :id_usuario,
                            :id_usuario,
                            now(),
                            now()
                        )
                        ";
            
                        $stmtFO = $PDO->prepare($sqlFO);
                        $resultFO = $stmtFO->execute([
                            'tra_fo_correlativo' => $tra_fo_correlativo,
                            'tra_fo_tra_cm_correlativo' => $tra_fo_tra_cm_correlativo,
                            'tra_fo_medicamento_consume_actualmente' => $tra_fo_medicamento_consume_actualmente,
                            'tra_fo_habito_suenio' => $tra_fo_habito_suenio,
                            'tra_fo_habito_urinario' => $tra_fo_habito_urinario,
                            'tra_fo_habito_defecacion' => $tra_fo_habito_defecacion,
                            'tra_fo_actividad_fisica' => $tra_fo_actividad_fisica,
                            'tra_fo_laboratorio' => $tra_fo_laboratorio,
                            'tra_fo_otros_datos_interes' => $tra_fo_otros_datos_interes,
                            'tra_fo_impresion_diagnostica' => $tra_fo_impresion_diagnostica,
                            'tra_fo_tratamiento' => $tra_fo_tratamiento,
                            'tra_fo_observaciones' => $tra_fo_observaciones,
                            'id_usuario' => $id_usuario
                        ]);
                        if ($resultFO == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_fo_correlativo);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function updateFichaOcupacional($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'modificar');
                if($userFuncionality == 'OK'){
                    $tra_fo_correlativo = (int)$parameter['tra_fo_correlativo'] ?? 0;
                    
                    $tra_fo_medicamento_consume_actualmente = $parameter['tra_fo_medicamento_consume_actualmente'] ?? NULL;
                    $tra_fo_habito_suenio = $parameter['tra_fo_habito_suenio'] ?? NULL;
                    $tra_fo_habito_urinario = $parameter['tra_fo_habito_urinario'] ?? NULL;
                    $tra_fo_habito_defecacion = $parameter['tra_fo_habito_defecacion'] ?? NULL;
                    $tra_fo_actividad_fisica = $parameter['tra_fo_actividad_fisica'] ?? NULL;
                    $tra_fo_laboratorio = $parameter['tra_fo_laboratorio'] ?? NULL;
                    $tra_fo_otros_datos_interes = $parameter['tra_fo_otros_datos_interes'] ?? NULL;
                    $tra_fo_impresion_diagnostica = $parameter['tra_fo_impresion_diagnostica'] ?? NULL;
                    $tra_fo_tratamiento = $parameter['tra_fo_tratamiento'] ?? NULL;
                    $tra_fo_observaciones = $parameter['tra_fo_observaciones'] ?? NULL;
                    
                    $tra_fo_medicamento_consume_actualmente = $utility->validarLongitudString($tra_fo_medicamento_consume_actualmente, 0, 500);
                    $tra_fo_habito_suenio = $utility->validarLongitudString($tra_fo_habito_suenio, 0, 500);
                    $tra_fo_habito_urinario = $utility->validarLongitudString($tra_fo_habito_urinario, 0, 500);
                    $tra_fo_habito_defecacion = $utility->validarLongitudString($tra_fo_habito_defecacion, 0, 500);
                    $tra_fo_actividad_fisica = $utility->validarLongitudString($tra_fo_actividad_fisica, 0, 500);
                    $tra_fo_laboratorio = $utility->validarLongitudString($tra_fo_laboratorio, 0, 500);
                    $tra_fo_otros_datos_interes = $utility->validarLongitudString($tra_fo_otros_datos_interes, 0, 500);
                    $tra_fo_impresion_diagnostica = $utility->validarLongitudString($tra_fo_impresion_diagnostica, 0, 2000);
                    $tra_fo_tratamiento = $utility->validarLongitudString($tra_fo_tratamiento, 0, 2000);
                    $tra_fo_observaciones = $utility->validarLongitudString($tra_fo_observaciones, 0, 300);
                    
                    $sql = "update tra_ficha_ocupacional set 
                    tra_fo_medicamento_consume_actualmente = :tra_fo_medicamento_consume_actualmente,
                    tra_fo_habito_suenio = :tra_fo_habito_suenio,
                    tra_fo_habito_urinario = :tra_fo_habito_urinario,
                    tra_fo_habito_defecacion = :tra_fo_habito_defecacion,
                    tra_fo_actividad_fisica = :tra_fo_actividad_fisica,
                    tra_fo_laboratorio = :tra_fo_laboratorio,
                    tra_fo_otros_datos_interes = :tra_fo_otros_datos_interes,
                    tra_fo_impresion_diagnostica = :tra_fo_impresion_diagnostica,
                    tra_fo_tratamiento = :tra_fo_tratamiento,
                    tra_fo_observaciones = :tra_fo_observaciones 
                    where tra_fo_correlativo = :tra_fo_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'tra_fo_correlativo' => $tra_fo_correlativo,
                        'tra_fo_medicamento_consume_actualmente' => $tra_fo_medicamento_consume_actualmente,
                        'tra_fo_habito_suenio' => $tra_fo_habito_suenio,
                        'tra_fo_habito_urinario' => $tra_fo_habito_urinario,
                        'tra_fo_habito_defecacion' => $tra_fo_habito_defecacion,
                        'tra_fo_actividad_fisica' => $tra_fo_actividad_fisica,
                        'tra_fo_laboratorio' => $tra_fo_laboratorio,
                        'tra_fo_otros_datos_interes' => $tra_fo_otros_datos_interes,
                        'tra_fo_impresion_diagnostica' => $tra_fo_impresion_diagnostica,
                        'tra_fo_tratamiento' => $tra_fo_tratamiento,
                        'tra_fo_observaciones' => $tra_fo_observaciones
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente'.$tra_alcohol.' '.$tra_cafe.' '.$tra_tabaco, 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertFichaNutricional($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    //PARAMETROS USUARIO
                    $cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $cli_nombre = $parameter['cli_nombre'] ?? NULL;
                    $cli_email = $parameter['cli_email'] ?? NULL;
                    $cli_fecha_nacimiento = $parameter['cli_fecha_nacimiento'] ?? NULL;
                    if($cli_fecha_nacimiento == ""){$cli_fecha_nacimiento = NULL;}
                    $cli_dpi = $parameter['cli_dpi'] ?? NULL;
                    $cli_telefono1 = $parameter['cli_telefono1'] ?? NULL;
                    $cli_edad = $parameter['cli_edad'] ?? NULL;
                    $cli_responsable = $parameter['cli_responsable'] ?? NULL;
                    $cli_direccion = $parameter['cli_direccion'] ?? NULL;
                    $cli_estado_civil = $parameter['cli_estado_civil'] ?? NULL;
                    $cli_religion = $parameter['cli_religion'] ?? NULL;
                    $cli_escolaridad = $parameter['cli_escolaridad'] ?? NULL;
                    $cli_ocupacion = $parameter['cli_ocupacion'] ?? NULL;
                    
                    $tra_fichamn_tipo = $parameter['tra_fichamn_tipo'] ?? 0;
                    $tra_fichamn_tra_cm_correlativo = $parameter['tra_fichamn_tra_cm_correlativo'] ?? 0;
                    //$tra_fichamn_tra_correlativo = $parameter['tra_fichamn_tra_correlativo'] ?? 0;
                    $tra_fichamn_glucosa_pre = $parameter['tra_fichamn_glucosa_pre'] ?? 0.0;
                    $tra_fichamn_acido_urico = $parameter['tra_fichamn_acido_urico'] ?? 0.0;
                    $tra_fichamn_colesterol = $parameter['tra_fichamn_colesterol'] ?? 0.0;
                    $tra_fichamn_trigliceridos = $parameter['tra_fichamn_trigliceridos'] ?? 0.0;
                    $tra_fichamn_otros = $parameter['tra_fichamn_otros'] ?? NULL;

                    $tra_fichamn_talla = $parameter['tra_fichamn_talla'] ?? NULL;
                    $tra_fichamn_peso_anterior = $parameter['tra_fichamn_peso_anterior'] ?? NULL;
                    $tra_fichamn_peso_actual = $parameter['tra_fichamn_peso_actual'] ?? NULL;
                    $tra_fichamn_imc_anterior = $parameter['tra_fichamn_imc_anterior'] ?? NULL;
                    $tra_fichamn_imc_actual = $parameter['tra_fichamn_imc_actual'] ?? NULL;
                    $tra_fichamn_grasa = $parameter['tra_fichamn_grasa'] ?? NULL;
                    $tra_fichamn_musculo = $parameter['tra_fichamn_musculo'] ?? NULL;
                    $tra_fichamn_edad_metabolica = $parameter['tra_fichamn_edad_metabolica'] ?? NULL;
                    $tra_fichamn_presion_arterial = $parameter['tra_fichamn_presion_arterial'] ?? NULL;

                    $tra_fichamn_bebidas_azucaradas = $parameter['tra_fichamn_bebidas_azucaradas'] ?? NULL;
                    $tra_fichamn_comida_chatarra = $parameter['tra_fichamn_comida_chatarra'] ?? NULL;
                    $tra_fichamn_harinas_refinadas = $parameter['tra_fichamn_harinas_refinadas'] ?? NULL;
                    $tra_fichamn_actividad_fnombre = $parameter['tra_fichamn_actividad_fnombre'] ?? NULL;
                    $tra_fichamn_actividad_fduracion = $parameter['tra_fichamn_actividad_fduracion'] ?? NULL;
                    $tra_fichamn_activiad_fporsemana = $parameter['tra_fichamn_activiad_fporsemana'] ?? NULL;

                    $tra_fichamn_cirabdominal_anterior = $parameter['tra_fichamn_cirabdominal_anterior'] ?? 0.0;
                    $tra_fichamn_cirabdominal_actual = $parameter['tra_fichamn_cirabdominal_actual'] ?? 0.0;
                    $tra_fichamn_cirbiceps_anterior = $parameter['tra_fichamn_cirbiceps_anterior'] ?? 0.0;
                    $tra_fichamn_cirbiceps_actual = $parameter['tra_fichamn_cirbiceps_actual'] ?? 0.0;
                    $tra_fichamn_cirpecho_anterior = $parameter['tra_fichamn_cirpecho_anterior'] ?? 0.0;
                    $tra_fichamn_cirpecho_actual = $parameter['tra_fichamn_cirpecho_actual'] ?? 0.0;
                    $tra_fichamn_cirmuslo_anterior = $parameter['tra_fichamn_cirmuslo_anterior'] ?? 0.0;
                    $tra_fichamn_cirmuslo_actual = $parameter['tra_fichamn_cirmuslo_actual'] ?? 0.0;
                    $tra_fichamn_cirpantorrilla_anterior = $parameter['tra_fichamn_cirpantorrilla_anterior'] ?? 0.0;
                    $tra_fichamn_cirpantorrilla_actual = $parameter['tra_fichamn_cirpantorrilla_actual'] ?? 0.0;

                    $tra_fichamn_antecedentes_medicos = $parameter['tra_fichamn_antecedentes_medicos'] ?? NULL;
                    $tra_fichamn_alergias = $parameter['tra_fichamn_alergias'] ?? NULL;
                    $tra_fichamn_alimentos_noconsume = $parameter['tra_fichamn_alimentos_noconsume'] ?? NULL;
                    $tra_fichamn_suplementos_medicamenots_consume = $parameter['tra_fichamn_suplementos_medicamenots_consume'] ?? NULL;
                    $tra_fichamn_datos_interes = $parameter['tra_fichamn_datos_interes'] ?? NULL;
                    $tra_fichamn_impresion_diagnostica = $parameter['tra_fichamn_impresion_diagnostica'] ?? NULL;
                    $tra_fichamn_tratamiento = $parameter['tra_fichamn_tratamiento'] ?? NULL;

                    $tra_fichamn_alcohol = $parameter['tra_fichamn_alcohol'] ?? false;
                    $tra_fichamn_cafe = $parameter['tra_fichamn_cafe'] ?? false;
                    $tra_fichamn_tabaco = $parameter['tra_fichamn_tabaco'] ?? false;
                    $tra_fichamn_ht_otros = $parameter['tra_fichamn_ht_otros'] ?? NULL;

                    if($tra_fichamn_alcohol == "true" || $tra_fichamn_alcohol == 'true'){$tra_fichamn_alcohol = 1;}else{$tra_fichamn_alcohol = 0;}
                    if($tra_fichamn_cafe == "true" || $tra_fichamn_cafe == 'true'){$tra_fichamn_cafe = 1;}else{$tra_fichamn_cafe = 0;}
                    if($tra_fichamn_tabaco == "true" || $tra_fichamn_tabaco == 'true'){$tra_fichamn_tabaco = 1;}else{$tra_fichamn_tabaco = 0;}

                    $tra_fichamn_actividad_fnombre = $utility->validarLongitudString($tra_fichamn_actividad_fnombre, 0, 500);
                    $tra_fichamn_glucosa_pre = $utility->validarLongitudString($tra_fichamn_glucosa_pre, 0, 18);
                    $tra_fichamn_acido_urico = $utility->validarLongitudString($tra_fichamn_acido_urico, 0, 18);
                    $tra_fichamn_colesterol = $utility->validarLongitudString($tra_fichamn_colesterol, 0, 18);
                    $tra_fichamn_trigliceridos = $utility->validarLongitudString($tra_fichamn_trigliceridos, 0, 18);
                    $tra_fichamn_otros = $utility->validarLongitudString($tra_fichamn_otros, 0, 500);

                    $tra_fichamn_talla = $utility->validarLongitudString($tra_fichamn_talla, 0, 50);
                    $tra_fichamn_peso_anterior = $utility->validarLongitudString($tra_fichamn_peso_anterior, 0, 50);
                    $tra_fichamn_peso_actual = $utility->validarLongitudString($tra_fichamn_peso_actual, 0, 50);
                    $tra_fichamn_imc_anterior = $utility->validarLongitudString($tra_fichamn_imc_anterior, 0, 50);
                    $tra_fichamn_imc_actual = $utility->validarLongitudString($tra_fichamn_imc_actual, 0, 50);
                    $tra_fichamn_grasa = $utility->validarLongitudString($tra_fichamn_grasa, 0, 50);
                    $tra_fichamn_musculo = $utility->validarLongitudString($tra_fichamn_musculo, 0, 50);
                    $tra_fichamn_edad_metabolica = $utility->validarLongitudString($tra_fichamn_edad_metabolica, 0, 50);
                    $tra_fichamn_presion_arterial = $utility->validarLongitudString($tra_fichamn_presion_arterial, 0, 50);

                    $tra_fichamn_bebidas_azucaradas = $utility->validarLongitudString($tra_fichamn_bebidas_azucaradas, 0, 500);
                    $tra_fichamn_comida_chatarra = $utility->validarLongitudString($tra_fichamn_comida_chatarra, 0, 500);
                    $tra_fichamn_harinas_refinadas = $utility->validarLongitudString($tra_fichamn_harinas_refinadas, 0, 500);
                    $tra_fichamn_actividad_fduracion = $utility->validarLongitudString($tra_fichamn_actividad_fduracion, 0, 500);
                    $tra_fichamn_activiad_fporsemana = $utility->validarLongitudString($tra_fichamn_activiad_fporsemana, 0, 500);

                    $tra_fichamn_cirabdominal_anterior = $utility->validarLongitudString($tra_fichamn_cirabdominal_anterior, 0, 20);
                    $tra_fichamn_cirabdominal_actual = $utility->validarLongitudString($tra_fichamn_cirabdominal_actual, 0, 20);
                    $tra_fichamn_cirbiceps_anterior = $utility->validarLongitudString($tra_fichamn_cirbiceps_anterior, 0, 20);
                    $tra_fichamn_cirbiceps_actual = $utility->validarLongitudString($tra_fichamn_cirbiceps_actual, 0, 20);
                    $tra_fichamn_cirpecho_anterior = $utility->validarLongitudString($tra_fichamn_cirpecho_anterior, 0, 20);
                    $tra_fichamn_cirpecho_actual = $utility->validarLongitudString($tra_fichamn_cirpecho_actual, 0, 20);
                    $tra_fichamn_cirmuslo_anterior = $utility->validarLongitudString($tra_fichamn_cirmuslo_anterior, 0, 20);
                    $tra_fichamn_cirmuslo_actual = $utility->validarLongitudString($tra_fichamn_cirmuslo_actual, 0, 20);
                    $tra_fichamn_cirpantorrilla_anterior = $utility->validarLongitudString($tra_fichamn_cirpantorrilla_anterior, 0, 20);
                    $tra_fichamn_cirpantorrilla_actual = $utility->validarLongitudString($tra_fichamn_cirpantorrilla_actual, 0, 20);

                    $tra_fichamn_antecedentes_medicos = $utility->validarLongitudString($tra_fichamn_antecedentes_medicos, 0, 1000);
                    $tra_fichamn_alergias = $utility->validarLongitudString($tra_fichamn_alergias, 0, 1000);
                    $tra_fichamn_alimentos_noconsume = $utility->validarLongitudString($tra_fichamn_alimentos_noconsume, 0, 1000);
                    $tra_fichamn_suplementos_medicamenots_consume = $utility->validarLongitudString($tra_fichamn_suplementos_medicamenots_consume, 0, 1000);
                    $tra_fichamn_datos_interes = $utility->validarLongitudString($tra_fichamn_datos_interes, 0, 1000);
                    $tra_fichamn_impresion_diagnostica = $utility->validarLongitudString($tra_fichamn_impresion_diagnostica, 0, 1000);
                    $tra_fichamn_tratamiento = $utility->validarLongitudString($tra_fichamn_tratamiento, 0, 2000);

                    //ACTUALIZACION DATOS USUARIO
                    $sqlUser = "update cfg_cliente set 
                    cli_nombre = :cli_nombre,
                    cli_email = :cli_email,
                    cli_dpi = :cli_dpi,
                    cli_telefono1 = :cli_telefono1,
                    cli_direccion = :cli_direccion,
                    cli_fecha_nacimiento = :cli_fecha_nacimiento,
                    cli_edad = :cli_edad,
                    cli_responsable = :cli_responsable,
                    cli_estado_civil = :cli_estado_civil,
                    cli_religion = :cli_religion,
                    cli_escolaridad  = :cli_escolaridad,
                    cli_ocupacion = :cli_ocupacion,
                    cli_usuariom = :id_usuario,
                    cli_fecham = now() 
                    where cli_correlativo = :cli_correlativo";

                    $stmtUser = $PDO->prepare($sqlUser);
                    $resultUser = $stmtUser->execute([
                        'id_usuario' => $id_usuario,
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre' => $cli_nombre,
                        'cli_email' => $cli_email,
                        //'cli_nit' => $cli_nit,
                        'cli_dpi' => $cli_dpi,
                        'cli_telefono1' => $cli_telefono1,
                        'cli_direccion' => $cli_direccion,
                        'cli_fecha_nacimiento' => $cli_fecha_nacimiento,
                        'cli_edad' => $cli_edad,
                        'cli_responsable' => $cli_responsable,
                        'cli_estado_civil' => $cli_estado_civil,
                        'cli_religion' => $cli_religion,
                        'cli_escolaridad' => $cli_escolaridad,
                        'cli_ocupacion' => $cli_ocupacion
                    ]);

                    $tra_fichamn_correl = $utility->CorrelAutomatico($PDO, "tra_ficha_nutricional", "tra_fichamn_correl ", "");
                    if ($resultUser == true) {
                        $sql = 
                        "insert into tra_ficha_nutricional (
                                                tra_fichamn_correl, 
                                                tra_fichamn_tra_cm_correlativo,
                                                tra_fichamn_usr_correl,
                                                tra_fichamn_cli_correlativo,
                                                tra_fichamn_glucosa_pre, 
                                                tra_fichamn_acido_urico,
                                                tra_fichamn_colesterol,
                                                tra_fichamn_trigliceridos,
                                                tra_fichamn_otros,
                                                tra_fichamn_tipo,
                                                tra_fichamn_alcohol,
                                                tra_fichamn_cafe,
                                                tra_fichamn_tabaco,
                                                tra_fichamn_ht_otros,
                                                tra_fichamn_talla,
                                                tra_fichamn_peso_anterior,
                                                tra_fichamn_peso_actual,
                                                tra_fichamn_imc_anterior,
                                                tra_fichamn_imc_actual,
                                                tra_fichamn_grasa,
                                                tra_fichamn_musculo,
                                                tra_fichamn_edad_metabolica,
                                                tra_fichamn_presion_arterial,
                                                tra_fichamn_bebidas_azucaradas,
                                                tra_fichamn_comida_chatarra,
                                                tra_fichamn_harinas_refinadas,
                                                tra_fichamn_actividad_fnombre,
                                                tra_fichamn_actividad_fduracion,
                                                tra_fichamn_activiad_fporsemana,
                                                tra_fichamn_cirabdominal_anterior,
                                                tra_fichamn_cirabdominal_actual,
                                                tra_fichamn_cirbiceps_anterior,
                                                tra_fichamn_cirbiceps_actual,
                                                tra_fichamn_cirpecho_anterior,
                                                tra_fichamn_cirpecho_actual,
                                                tra_fichamn_cirmuslo_anterior,
                                                tra_fichamn_cirmuslo_actual,
                                                tra_fichamn_cirpantorrilla_anterior,
                                                tra_fichamn_cirpantorrilla_actual,
                                                tra_fichamn_antecedentes_medicos,
                                                tra_fichamn_alergias,
                                                tra_fichamn_alimentos_noconsume,
                                                tra_fichamn_suplementos_medicamenots_consume,
                                                tra_fichamn_datos_interes,
                                                tra_fichamn_impresion_diagnostica,
                                                tra_fichamn_tratamiento,
                                                tra_fichamn_estado,
                                                tra_fichamn_usuarioi, 
                                                tra_fichamn_usuariom,
                                                tra_fichamn_fechai,
                                                tra_fichamn_fecham
                                                ) values(
                                                :tra_fichamn_correl, 
                                                :tra_fichamn_tra_cm_correlativo,
                                                :id_usuario,
                                                :tra_fichamn_cli_correlativo,
                                                :tra_fichamn_glucosa_pre, 
                                                :tra_fichamn_acido_urico,
                                                :tra_fichamn_colesterol,
                                                :tra_fichamn_trigliceridos,
                                                :tra_fichamn_otros,
                                                :tra_fichamn_tipo,
                                                :tra_fichamn_alcohol,
                                                :tra_fichamn_cafe,
                                                :tra_fichamn_tabaco,
                                                :tra_fichamn_ht_otros,
                                                :tra_fichamn_talla,
                                                :tra_fichamn_peso_anterior,
                                                :tra_fichamn_peso_actual,
                                                :tra_fichamn_imc_anterior,
                                                :tra_fichamn_imc_actual,
                                                :tra_fichamn_grasa,
                                                :tra_fichamn_musculo,
                                                :tra_fichamn_edad_metabolica,
                                                :tra_fichamn_presion_arterial,
                                                :tra_fichamn_bebidas_azucaradas,
                                                :tra_fichamn_comida_chatarra,
                                                :tra_fichamn_harinas_refinadas,
                                                :tra_fichamn_actividad_fnombre,
                                                :tra_fichamn_actividad_fduracion,
                                                :tra_fichamn_activiad_fporsemana,
                                                :tra_fichamn_cirabdominal_anterior,
                                                :tra_fichamn_cirabdominal_actual,
                                                :tra_fichamn_cirbiceps_anterior,
                                                :tra_fichamn_cirbiceps_actual,
                                                :tra_fichamn_cirpecho_anterior,
                                                :tra_fichamn_cirpecho_actual,
                                                :tra_fichamn_cirmuslo_anterior,
                                                :tra_fichamn_cirmuslo_actual,
                                                :tra_fichamn_cirpantorrilla_anterior,
                                                :tra_fichamn_cirpantorrilla_actual,
                                                :tra_fichamn_antecedentes_medicos,
                                                :tra_fichamn_alergias,
                                                :tra_fichamn_alimentos_noconsume,
                                                :tra_fichamn_suplementos_medicamenots_consume,
                                                :tra_fichamn_datos_interes,
                                                :tra_fichamn_impresion_diagnostica,
                                                :tra_fichamn_tratamiento,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'tra_fichamn_correl' => $tra_fichamn_correl,
                            'tra_fichamn_tipo' => $tra_fichamn_tipo,
                            'tra_fichamn_cli_correlativo' => $cli_correlativo,
                            'tra_fichamn_tra_cm_correlativo' => $tra_fichamn_tra_cm_correlativo, 
                            'tra_fichamn_glucosa_pre' => $tra_fichamn_glucosa_pre,
                            'tra_fichamn_acido_urico' => $tra_fichamn_acido_urico,
                            'tra_fichamn_colesterol' => $tra_fichamn_colesterol,
                            'tra_fichamn_trigliceridos' => $tra_fichamn_trigliceridos,
                            'tra_fichamn_alcohol' => $tra_fichamn_alcohol,
                            'tra_fichamn_cafe' => $tra_fichamn_cafe,
                            'tra_fichamn_tabaco' => $tra_fichamn_tabaco,
                            'tra_fichamn_ht_otros' => $tra_fichamn_ht_otros,
                            'tra_fichamn_otros' => $tra_fichamn_otros,
                            'id_usuario' => $id_usuario,
                            'tra_fichamn_talla' => $tra_fichamn_talla,
                            'tra_fichamn_peso_anterior' => $tra_fichamn_peso_anterior,
                            'tra_fichamn_peso_actual' => $tra_fichamn_peso_actual,
                            'tra_fichamn_imc_anterior' => $tra_fichamn_imc_anterior,
                            'tra_fichamn_imc_actual' => $tra_fichamn_imc_actual,
                            'tra_fichamn_grasa' => $tra_fichamn_grasa,
                            'tra_fichamn_musculo' => $tra_fichamn_musculo,
                            'tra_fichamn_edad_metabolica' => $tra_fichamn_edad_metabolica,
                            'tra_fichamn_presion_arterial' => $tra_fichamn_presion_arterial,
                            'tra_fichamn_bebidas_azucaradas' => $tra_fichamn_bebidas_azucaradas,
                            'tra_fichamn_comida_chatarra' => $tra_fichamn_comida_chatarra,
                            'tra_fichamn_harinas_refinadas' => $tra_fichamn_harinas_refinadas,
                            'tra_fichamn_actividad_fnombre' => $tra_fichamn_actividad_fnombre,
                            'tra_fichamn_actividad_fduracion' => $tra_fichamn_actividad_fduracion,
                            'tra_fichamn_activiad_fporsemana' => $tra_fichamn_activiad_fporsemana,
                            'tra_fichamn_cirabdominal_anterior' => $tra_fichamn_cirabdominal_anterior,
                            'tra_fichamn_cirabdominal_actual' => $tra_fichamn_cirabdominal_actual,
                            'tra_fichamn_cirbiceps_anterior' => $tra_fichamn_cirbiceps_anterior,
                            'tra_fichamn_cirbiceps_actual' => $tra_fichamn_cirbiceps_actual,
                            'tra_fichamn_cirpecho_anterior' => $tra_fichamn_cirpecho_anterior,
                            'tra_fichamn_cirpecho_actual' => $tra_fichamn_cirpecho_actual,
                            'tra_fichamn_cirmuslo_anterior' => $tra_fichamn_cirmuslo_anterior,
                            'tra_fichamn_cirmuslo_actual' => $tra_fichamn_cirmuslo_actual,
                            'tra_fichamn_cirpantorrilla_anterior' => $tra_fichamn_cirpantorrilla_anterior,
                            'tra_fichamn_cirpantorrilla_actual' => $tra_fichamn_cirpantorrilla_actual,
                            'tra_fichamn_antecedentes_medicos' => $tra_fichamn_antecedentes_medicos,
                            'tra_fichamn_alergias' => $tra_fichamn_alergias,
                            'tra_fichamn_alimentos_noconsume' => $tra_fichamn_alimentos_noconsume,
                            'tra_fichamn_suplementos_medicamenots_consume' => $tra_fichamn_suplementos_medicamenots_consume,
                            'tra_fichamn_datos_interes' => $tra_fichamn_datos_interes,
                            'tra_fichamn_impresion_diagnostica' => $tra_fichamn_impresion_diagnostica,
                            'tra_fichamn_tratamiento' => $tra_fichamn_tratamiento
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_fichamn_correl);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function updateFichaNutricional($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    //PARAMETROS USUARIO
                    $cli_correlativo = $parameter['cli_correlativo'] ?? 0;
                    $cli_nombre = $parameter['cli_nombre'] ?? NULL;
                    $cli_email = $parameter['cli_email'] ?? NULL;
                    $cli_fecha_nacimiento = $parameter['cli_fecha_nacimiento'] ?? NULL;
                    if($cli_fecha_nacimiento == ""){$cli_fecha_nacimiento = NULL;}
                    $cli_dpi = $parameter['cli_dpi'] ?? NULL;
                    $cli_telefono1 = $parameter['cli_telefono1'] ?? NULL;
                    $cli_edad = $parameter['cli_edad'] ?? NULL;
                    $cli_responsable = $parameter['cli_responsable'] ?? NULL;
                    $cli_direccion = $parameter['cli_direccion'] ?? NULL;
                    $cli_estado_civil = $parameter['cli_estado_civil'] ?? NULL;
                    $cli_religion = $parameter['cli_religion'] ?? NULL;
                    $cli_escolaridad = $parameter['cli_escolaridad'] ?? NULL;
                    $cli_ocupacion = $parameter['cli_ocupacion'] ?? NULL;
                    
                    $tra_fichamn_correl = $parameter['tra_fichamn_correl'] ?? 0;
                    $tra_fichamn_tipo = $parameter['tra_fichamn_tipo'] ?? 0;
                    $tra_fichamn_tra_cm_correlativo = $parameter['tra_fichamn_tra_cm_correlativo'] ?? 0;
                    $tra_fichamn_glucosa_pre = $parameter['tra_fichamn_glucosa_pre'] ?? 0.0;
                    $tra_fichamn_acido_urico = $parameter['tra_fichamn_acido_urico'] ?? 0.0;
                    $tra_fichamn_colesterol = $parameter['tra_fichamn_colesterol'] ?? 0.0;
                    $tra_fichamn_trigliceridos = $parameter['tra_fichamn_trigliceridos'] ?? 0.0;
                    $tra_fichamn_otros = $parameter['tra_fichamn_otros'] ?? NULL;

                    $tra_fichamn_talla = $parameter['tra_fichamn_talla'] ?? NULL;
                    $tra_fichamn_peso_anterior = $parameter['tra_fichamn_peso_anterior'] ?? NULL;
                    $tra_fichamn_peso_actual = $parameter['tra_fichamn_peso_actual'] ?? NULL;
                    $tra_fichamn_imc_anterior = $parameter['tra_fichamn_imc_anterior'] ?? NULL;
                    $tra_fichamn_imc_actual = $parameter['tra_fichamn_imc_actual'] ?? NULL;
                    $tra_fichamn_grasa = $parameter['tra_fichamn_grasa'] ?? NULL;
                    $tra_fichamn_musculo = $parameter['tra_fichamn_musculo'] ?? NULL;
                    $tra_fichamn_edad_metabolica = $parameter['tra_fichamn_edad_metabolica'] ?? NULL;
                    $tra_fichamn_presion_arterial = $parameter['tra_fichamn_presion_arterial'] ?? NULL;

                    $tra_fichamn_bebidas_azucaradas = $parameter['tra_fichamn_bebidas_azucaradas'] ?? NULL;
                    $tra_fichamn_comida_chatarra = $parameter['tra_fichamn_comida_chatarra'] ?? NULL;
                    $tra_fichamn_harinas_refinadas = $parameter['tra_fichamn_harinas_refinadas'] ?? NULL;
                    $tra_fichamn_actividad_fnombre = $parameter['tra_fichamn_actividad_fnombre'] ?? NULL;
                    $tra_fichamn_actividad_fduracion = $parameter['tra_fichamn_actividad_fduracion'] ?? NULL;
                    $tra_fichamn_activiad_fporsemana = $parameter['tra_fichamn_activiad_fporsemana'] ?? NULL;

                    $tra_fichamn_cirabdominal_anterior = $parameter['tra_fichamn_cirabdominal_anterior'] ?? 0.0;
                    $tra_fichamn_cirabdominal_actual = $parameter['tra_fichamn_cirabdominal_actual'] ?? 0.0;
                    $tra_fichamn_cirbiceps_anterior = $parameter['tra_fichamn_cirbiceps_anterior'] ?? 0.0;
                    $tra_fichamn_cirbiceps_actual = $parameter['tra_fichamn_cirbiceps_actual'] ?? 0.0;
                    $tra_fichamn_cirpecho_anterior = $parameter['tra_fichamn_cirpecho_anterior'] ?? 0.0;
                    $tra_fichamn_cirpecho_actual = $parameter['tra_fichamn_cirpecho_actual'] ?? 0.0;
                    $tra_fichamn_cirmuslo_anterior = $parameter['tra_fichamn_cirmuslo_anterior'] ?? 0.0;
                    $tra_fichamn_cirmuslo_actual = $parameter['tra_fichamn_cirmuslo_actual'] ?? 0.0;
                    $tra_fichamn_cirpantorrilla_anterior = $parameter['tra_fichamn_cirpantorrilla_anterior'] ?? 0.0;
                    $tra_fichamn_cirpantorrilla_actual = $parameter['tra_fichamn_cirpantorrilla_actual'] ?? 0.0;

                    $tra_fichamn_antecedentes_medicos = $parameter['tra_fichamn_antecedentes_medicos'] ?? NULL;
                    $tra_fichamn_alergias = $parameter['tra_fichamn_alergias'] ?? NULL;
                    $tra_fichamn_alimentos_noconsume = $parameter['tra_fichamn_alimentos_noconsume'] ?? NULL;
                    $tra_fichamn_suplementos_medicamenots_consume = $parameter['tra_fichamn_suplementos_medicamenots_consume'] ?? NULL;
                    $tra_fichamn_datos_interes = $parameter['tra_fichamn_datos_interes'] ?? NULL;
                    $tra_fichamn_impresion_diagnostica = $parameter['tra_fichamn_impresion_diagnostica'] ?? NULL;
                    $tra_fichamn_tratamiento = $parameter['tra_fichamn_tratamiento'] ?? NULL;

                    $tra_fichamn_alcohol = $parameter['tra_fichamn_alcohol'] ?? false;
                    $tra_fichamn_cafe = $parameter['tra_fichamn_cafe'] ?? false;
                    $tra_fichamn_tabaco = $parameter['tra_fichamn_tabaco'] ?? false;
                    $tra_fichamn_ht_otros = $parameter['tra_fichamn_ht_otros'] ?? NULL;

                    if($tra_fichamn_alcohol == "true" || $tra_fichamn_alcohol == 'true'){$tra_fichamn_alcohol = 1;}else{$tra_fichamn_alcohol = 0;}
                    if($tra_fichamn_cafe == "true" || $tra_fichamn_cafe == 'true'){$tra_fichamn_cafe = 1;}else{$tra_fichamn_cafe = 0;}
                    if($tra_fichamn_tabaco == "true" || $tra_fichamn_tabaco == 'true'){$tra_fichamn_tabaco = 1;}else{$tra_fichamn_tabaco = 0;}

                    $tra_fichamn_glucosa_pre = $utility->validarLongitudString($tra_fichamn_glucosa_pre, 0, 18);
                    $tra_fichamn_acido_urico = $utility->validarLongitudString($tra_fichamn_acido_urico, 0, 18);
                    $tra_fichamn_colesterol = $utility->validarLongitudString($tra_fichamn_colesterol, 0, 18);
                    $tra_fichamn_trigliceridos = $utility->validarLongitudString($tra_fichamn_trigliceridos, 0, 18);
                    $tra_fichamn_otros = $utility->validarLongitudString($tra_fichamn_otros, 0, 500);

                    $tra_fichamn_talla = $utility->validarLongitudString($tra_fichamn_talla, 0, 50);
                    $tra_fichamn_peso_anterior = $utility->validarLongitudString($tra_fichamn_peso_anterior, 0, 50);
                    $tra_fichamn_peso_actual = $utility->validarLongitudString($tra_fichamn_peso_actual, 0, 50);
                    $tra_fichamn_imc_anterior = $utility->validarLongitudString($tra_fichamn_imc_anterior, 0, 50);
                    $tra_fichamn_imc_actual = $utility->validarLongitudString($tra_fichamn_imc_actual, 0, 50);
                    $tra_fichamn_grasa = $utility->validarLongitudString($tra_fichamn_grasa, 0, 50);
                    $tra_fichamn_musculo = $utility->validarLongitudString($tra_fichamn_musculo, 0, 50);
                    $tra_fichamn_edad_metabolica = $utility->validarLongitudString($tra_fichamn_edad_metabolica, 0, 50);
                    $tra_fichamn_presion_arterial = $utility->validarLongitudString($tra_fichamn_presion_arterial, 0, 50);

                    $tra_fichamn_bebidas_azucaradas = $utility->validarLongitudString($tra_fichamn_bebidas_azucaradas, 0, 500);
                    $tra_fichamn_comida_chatarra = $utility->validarLongitudString($tra_fichamn_comida_chatarra, 0, 500);
                    $tra_fichamn_harinas_refinadas = $utility->validarLongitudString($tra_fichamn_harinas_refinadas, 0, 500);
                    $tra_fichamn_actividad_fnombre = $utility->validarLongitudString($tra_fichamn_actividad_fnombre, 0, 500);
                    $tra_fichamn_actividad_fduracion = $utility->validarLongitudString($tra_fichamn_actividad_fduracion, 0, 500);
                    $tra_fichamn_activiad_fporsemana = $utility->validarLongitudString($tra_fichamn_activiad_fporsemana, 0, 500);

                    $tra_fichamn_cirabdominal_anterior = $utility->validarLongitudString($tra_fichamn_cirabdominal_anterior, 0, 20);
                    $tra_fichamn_cirabdominal_actual = $utility->validarLongitudString($tra_fichamn_cirabdominal_actual, 0, 20);
                    $tra_fichamn_cirbiceps_anterior = $utility->validarLongitudString($tra_fichamn_cirbiceps_anterior, 0, 20);
                    $tra_fichamn_cirbiceps_actual = $utility->validarLongitudString($tra_fichamn_cirbiceps_actual, 0, 20);
                    $tra_fichamn_cirpecho_anterior = $utility->validarLongitudString($tra_fichamn_cirpecho_anterior, 0, 20);
                    $tra_fichamn_cirpecho_actual = $utility->validarLongitudString($tra_fichamn_cirpecho_actual, 0, 20);
                    $tra_fichamn_cirmuslo_anterior = $utility->validarLongitudString($tra_fichamn_cirmuslo_anterior, 0, 20);
                    $tra_fichamn_cirmuslo_actual = $utility->validarLongitudString($tra_fichamn_cirmuslo_actual, 0, 20);
                    $tra_fichamn_cirpantorrilla_anterior = $utility->validarLongitudString($tra_fichamn_cirpantorrilla_anterior, 0, 20);
                    $tra_fichamn_cirpantorrilla_actual = $utility->validarLongitudString($tra_fichamn_cirpantorrilla_actual, 0, 20);

                    $tra_fichamn_antecedentes_medicos = $utility->validarLongitudString($tra_fichamn_antecedentes_medicos, 0, 1000);
                    $tra_fichamn_alergias = $utility->validarLongitudString($tra_fichamn_alergias, 0, 1000);
                    $tra_fichamn_alimentos_noconsume = $utility->validarLongitudString($tra_fichamn_alimentos_noconsume, 0, 1000);
                    $tra_fichamn_suplementos_medicamenots_consume = $utility->validarLongitudString($tra_fichamn_suplementos_medicamenots_consume, 0, 1000);
                    $tra_fichamn_datos_interes = $utility->validarLongitudString($tra_fichamn_datos_interes, 0, 1000);
                    $tra_fichamn_impresion_diagnostica = $utility->validarLongitudString($tra_fichamn_impresion_diagnostica, 0, 1000);
                    $tra_fichamn_tratamiento = $utility->validarLongitudString($tra_fichamn_tratamiento, 0, 2000);

                    //ACTUALIZACION DATOS USUARIO
                    $sqlUser = "update cfg_cliente set 
                    cli_nombre = :cli_nombre,
                    cli_email = :cli_email,
                    cli_dpi = :cli_dpi,
                    cli_telefono1 = :cli_telefono1,
                    cli_direccion = :cli_direccion,
                    cli_fecha_nacimiento = :cli_fecha_nacimiento,
                    cli_edad = :cli_edad,
                    cli_responsable = :cli_responsable,
                    cli_estado_civil = :cli_estado_civil,
                    cli_religion = :cli_religion,
                    cli_escolaridad  = :cli_escolaridad,
                    cli_ocupacion = :cli_ocupacion,
                    cli_usuariom = :id_usuario,
                    cli_fecham = now() 
                    where cli_correlativo = :cli_correlativo";

                    $stmtUser = $PDO->prepare($sqlUser);
                    $resultUser = $stmtUser->execute([
                        'id_usuario' => $id_usuario,
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre' => $cli_nombre,
                        'cli_email' => $cli_email,
                        //'cli_nit' => $cli_nit,
                        'cli_dpi' => $cli_dpi,
                        'cli_telefono1' => $cli_telefono1,
                        'cli_direccion' => $cli_direccion,
                        'cli_fecha_nacimiento' => $cli_fecha_nacimiento,
                        'cli_edad' => $cli_edad,
                        'cli_responsable' => $cli_responsable,
                        'cli_estado_civil' => $cli_estado_civil,
                        'cli_religion' => $cli_religion,
                        'cli_escolaridad' => $cli_escolaridad,
                        'cli_ocupacion' => $cli_ocupacion
                    ]);

                    //$tra_fichamn_correl = $utility->CorrelAutomatico($PDO, "tra_ficha_nutricional", "tra_fichamn_correl ", "");
                    if ($resultUser == true) {
                        $sql = 
                        "UPDATE tra_ficha_nutricional SET 
                                                tra_fichamn_glucosa_pre = :tra_fichamn_glucosa_pre, 
                                                tra_fichamn_acido_urico = :tra_fichamn_acido_urico,
                                                tra_fichamn_colesterol = :tra_fichamn_colesterol,
                                                tra_fichamn_trigliceridos = :tra_fichamn_trigliceridos,
                                                tra_fichamn_alcohol = :tra_fichamn_alcohol,
                                                tra_fichamn_cafe = :tra_fichamn_cafe,
                                                tra_fichamn_tabaco = :tra_fichamn_tabaco,
                                                tra_fichamn_ht_otros = :tra_fichamn_ht_otros,
                                                tra_fichamn_otros = :tra_fichamn_otros,
                                                tra_fichamn_tipo = :tra_fichamn_tipo,
                                                tra_fichamn_talla = :tra_fichamn_talla,
                                                tra_fichamn_peso_anterior = :tra_fichamn_peso_anterior,
                                                tra_fichamn_peso_actual = :tra_fichamn_peso_actual,
                                                tra_fichamn_imc_anterior = :tra_fichamn_imc_anterior,
                                                tra_fichamn_imc_actual = :tra_fichamn_imc_actual,
                                                tra_fichamn_grasa = :tra_fichamn_grasa,
                                                tra_fichamn_musculo = :tra_fichamn_musculo,
                                                tra_fichamn_edad_metabolica = :tra_fichamn_edad_metabolica,
                                                tra_fichamn_presion_arterial = :tra_fichamn_presion_arterial,
                                                tra_fichamn_bebidas_azucaradas = :tra_fichamn_bebidas_azucaradas,
                                                tra_fichamn_comida_chatarra = :tra_fichamn_comida_chatarra,
                                                tra_fichamn_harinas_refinadas = :tra_fichamn_harinas_refinadas,
                                                tra_fichamn_actividad_fnombre = :tra_fichamn_actividad_fnombre,
                                                tra_fichamn_actividad_fduracion = :tra_fichamn_actividad_fduracion,
                                                tra_fichamn_activiad_fporsemana = :tra_fichamn_activiad_fporsemana,
                                                tra_fichamn_cirabdominal_anterior = :tra_fichamn_cirabdominal_anterior,
                                                tra_fichamn_cirabdominal_actual = :tra_fichamn_cirabdominal_actual,
                                                tra_fichamn_cirbiceps_anterior = :tra_fichamn_cirbiceps_anterior,
                                                tra_fichamn_cirbiceps_actual = :tra_fichamn_cirbiceps_actual,
                                                tra_fichamn_cirpecho_anterior = :tra_fichamn_cirpecho_anterior,
                                                tra_fichamn_cirpecho_actual = :tra_fichamn_cirpecho_actual,
                                                tra_fichamn_cirmuslo_anterior = :tra_fichamn_cirmuslo_anterior,
                                                tra_fichamn_cirmuslo_actual = :tra_fichamn_cirmuslo_actual,
                                                tra_fichamn_cirpantorrilla_anterior = :tra_fichamn_cirpantorrilla_anterior,
                                                tra_fichamn_cirpantorrilla_actual = :tra_fichamn_cirpantorrilla_actual,
                                                tra_fichamn_antecedentes_medicos = :tra_fichamn_antecedentes_medicos,
                                                tra_fichamn_alergias = :tra_fichamn_alergias,
                                                tra_fichamn_alimentos_noconsume = :tra_fichamn_alimentos_noconsume,
                                                tra_fichamn_suplementos_medicamenots_consume = :tra_fichamn_suplementos_medicamenots_consume,
                                                tra_fichamn_datos_interes = :tra_fichamn_datos_interes,
                                                tra_fichamn_impresion_diagnostica = :tra_fichamn_impresion_diagnostica,
                                                tra_fichamn_tratamiento = :tra_fichamn_tratamiento,
                                                tra_fichamn_usuariom = :id_usuario,
                                                tra_fichamn_fecham = now() 
                                                where tra_fichamn_correl = :tra_fichamn_correl";//and tra_fichamn_tra_correlativo = :tra_fichamn_tra_correlativo
                        //tra_fichamn_actividad_fnombre = :tra_fichamn_actividad_fnombre,
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'tra_fichamn_correl' => $tra_fichamn_correl,
                            //'tra_fichamn_tra_correlativo' => $tra_fichamn_tra_correlativo,
                            'tra_fichamn_tipo' => $tra_fichamn_tipo,
                            'tra_fichamn_glucosa_pre' => $tra_fichamn_glucosa_pre,
                            'tra_fichamn_acido_urico' => $tra_fichamn_acido_urico,
                            'tra_fichamn_colesterol' => $tra_fichamn_colesterol,
                            'tra_fichamn_trigliceridos' => $tra_fichamn_trigliceridos,
                            'tra_fichamn_alcohol' => $tra_fichamn_alcohol,
                            'tra_fichamn_cafe' => $tra_fichamn_cafe,
                            'tra_fichamn_tabaco' => $tra_fichamn_tabaco,
                            'tra_fichamn_ht_otros' => $tra_fichamn_ht_otros,
                            'tra_fichamn_otros' => $tra_fichamn_otros,
                            'id_usuario' => $id_usuario,
                            'tra_fichamn_talla' => $tra_fichamn_talla,
                            'tra_fichamn_peso_anterior' => $tra_fichamn_peso_anterior,
                            'tra_fichamn_peso_actual' => $tra_fichamn_peso_actual,
                            'tra_fichamn_imc_anterior' => $tra_fichamn_imc_anterior,
                            'tra_fichamn_imc_actual' => $tra_fichamn_imc_actual,
                            'tra_fichamn_grasa' => $tra_fichamn_grasa,
                            'tra_fichamn_musculo' => $tra_fichamn_musculo,
                            'tra_fichamn_edad_metabolica' => $tra_fichamn_edad_metabolica,
                            'tra_fichamn_presion_arterial' => $tra_fichamn_presion_arterial,
                            'tra_fichamn_bebidas_azucaradas' => $tra_fichamn_bebidas_azucaradas,
                            'tra_fichamn_comida_chatarra' => $tra_fichamn_comida_chatarra,
                            'tra_fichamn_harinas_refinadas' => $tra_fichamn_harinas_refinadas,
                            'tra_fichamn_actividad_fduracion' => $tra_fichamn_actividad_fduracion,
                            'tra_fichamn_activiad_fporsemana' => $tra_fichamn_activiad_fporsemana,
                            'tra_fichamn_cirabdominal_anterior' => $tra_fichamn_cirabdominal_anterior,
                            'tra_fichamn_cirabdominal_actual' => $tra_fichamn_cirabdominal_actual,
                            'tra_fichamn_cirbiceps_anterior' => $tra_fichamn_cirbiceps_anterior,
                            'tra_fichamn_cirbiceps_actual' => $tra_fichamn_cirbiceps_actual,
                            'tra_fichamn_cirpecho_anterior' => $tra_fichamn_cirpecho_anterior,
                            'tra_fichamn_cirpecho_actual' => $tra_fichamn_cirpecho_actual,
                            'tra_fichamn_cirmuslo_anterior' => $tra_fichamn_cirmuslo_anterior,
                            'tra_fichamn_cirmuslo_actual' => $tra_fichamn_cirmuslo_actual,
                            'tra_fichamn_cirpantorrilla_anterior' => $tra_fichamn_cirpantorrilla_anterior,
                            'tra_fichamn_cirpantorrilla_actual' => $tra_fichamn_cirpantorrilla_actual,
                            'tra_fichamn_antecedentes_medicos' => $tra_fichamn_antecedentes_medicos,
                            'tra_fichamn_alergias' => $tra_fichamn_alergias,
                            'tra_fichamn_alimentos_noconsume' => $tra_fichamn_alimentos_noconsume,
                            'tra_fichamn_suplementos_medicamenots_consume' => $tra_fichamn_suplementos_medicamenots_consume,
                            'tra_fichamn_datos_interes' => $tra_fichamn_datos_interes,
                            'tra_fichamn_impresion_diagnostica' => $tra_fichamn_impresion_diagnostica,
                            'tra_fichamn_tratamiento' => $tra_fichamn_tratamiento,
                            'tra_fichamn_actividad_fnombre' => $tra_fichamn_actividad_fnombre
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_fichamn_correl);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function updateProximaCita($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    //PARAMETROS PROXIMA CITA
                    
                    $tra_cm_correlativo = $parameter['tra_cm_correlativo'] ?? 0;
                    $tra_cm_dias = $parameter['tra_cm_dias'] ?? 0;
                    $tra_cm_observaciones_proxima_cita = $parameter['tra_cm_observaciones_proxima_cita'] ?? 0;
                    $tra_cm_proxima_cita = "";

                    $tra_cm_correlativo = $utility->validarLongitudString($tra_cm_correlativo, 0, 4);
                    $tra_cm_observaciones_proxima_cita = $utility->validarLongitudString($tra_cm_observaciones_proxima_cita, 0, 2000);
                    $fechaActual = date("Y-m-d");
                    $tra_cm_proxima_cita = date("Y-m-d",strtotime($fechaActual."+ $tra_cm_dias days"));

                        $sql = 
                        "UPDATE tra_consulta_medica SET 
                                                tra_cm_registro_proxima_cita = now(),
                                                tra_cm_proxima_cita = :tra_cm_proxima_cita, 
                                                tra_cm_dias = :tra_cm_dias,
                                                tra_cm_observaciones_proxima_cita = :tra_cm_observaciones_proxima_cita,
                                                tra_cm_confirmacion_cita = 1,
                                                tra_cm_etapa = 4,
                                                tra_cm_usuariom = :id_usuario,
                                                tra_cm_fecham = now() 
                                                where tra_cm_correlativo = :tra_cm_correlativo";//and tra_fichamn_tra_correlativo = :tra_fichamn_tra_correlativo
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_cm_correlativo' => $tra_cm_correlativo,
                            'tra_cm_proxima_cita' => $tra_cm_proxima_cita,
                            'tra_cm_dias' => $tra_cm_dias,
                            'tra_cm_observaciones_proxima_cita' => $tra_cm_observaciones_proxima_cita
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_fichamn_correl);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function updateItemReceta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_rm_correlativo = $parameter['tra_rm_correlativo'] ?? 0;
                    $tra_rm_correlativo = $utility->validarLongitudString($tra_rm_correlativo, 0, 4);
                    //$tra_cm_observaciones_proxima_cita = $utility->validarLongitudString($tra_cm_observaciones_proxima_cita, 0, 2000);
                        $sql = 
                        "UPDATE tra_receta_medica SET 
                                                tra_rm_estado = 'E',
                                                tra_rm_usuariom = :id_usuario,
                                                tra_rm_fecham = now() 
                                                where tra_rm_correlativo = :tra_rm_correlativo";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_rm_correlativo' => $tra_rm_correlativo
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser eliminado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function updateItemRecetaExamenComplementario($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_rmex_correlativo = $parameter['tra_rmex_correlativo'] ?? 0;
                    $tra_rmex_correlativo = $utility->validarLongitudString($tra_rmex_correlativo, 0, 4);
                    //$tra_cm_observaciones_proxima_cita = $utility->validarLongitudString($tra_cm_observaciones_proxima_cita, 0, 2000);
                        $sql = 
                        "UPDATE tra_receta_medica_examen_complementario SET 
                                                tra_rmex_estado = 'E',
                                                tra_rmex_usuariom = :id_usuario,
                                                tra_rmex_fecham = now() 
                                                where tra_rmex_correlativo = :tra_rmex_correlativo";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_rmex_correlativo' => $tra_rmex_correlativo
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser eliminado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function deleteItemReceta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_ecom_tra_cm_correlativo = $parameter['tra_ecom_tra_cm_correlativo'] ?? 0;
                    $tra_ecom_tipo_ficha = NULL;//$parameter['tra_ecom_tipo_ficha'] ?? 0;
                    $tra_ecom_no_examen = $parameter['tra_ecom_no_examen'] ?? 0;
                    $tra_ecom_pro_tipo_laboratorio = $parameter['tra_ecom_pro_tipo_laboratorio'] ?? 0;
                    $tra_ecom_pro_correl = $parameter['tra_ecom_pro_correl'] ?? 0;
                    $examen = $parameter['examen'] ?? NULL;

                    $tra_ecom_tra_cm_correlativo = $utility->validarLongitudString($tra_ecom_tra_cm_correlativo, 0, 11);
                    $tra_ecom_tipo_ficha = $utility->validarLongitudString($tra_ecom_tipo_ficha, 0, 11);
                    $tra_ecom_no_examen = $utility->validarLongitudString($tra_ecom_no_examen, 0, 11);
                    $tra_ecom_pro_tipo_laboratorio = $utility->validarLongitudString($tra_ecom_pro_tipo_laboratorio, 0, 11);
                    $tra_ecom_pro_correl = $utility->validarLongitudString($tra_ecom_pro_correl, 0, 11);
                        $sql = 
                        "UPDATE examenes_complementarios SET 
                                                tra_ecom_estado = 'E',
                                                tra_ecom_usuariom = :id_usuario,
                                                tra_ecom_fecham = now() 
                                                where tra_ecom_tra_cm_correlativo = :tra_ecom_tra_cm_correlativo 
                                                and tra_ecom_no_examen = :tra_ecom_no_examen 
                                                and tra_ecom_pro_tipo_laboratorio = :tra_ecom_pro_tipo_laboratorio 
                                                and tra_ecom_pro_correl = :tra_ecom_pro_correl 
                                                ";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                            //'tra_ecom_tipo_ficha' => $tra_ecom_tipo_ficha,
                            'tra_ecom_no_examen' => $tra_ecom_no_examen,
                            'tra_ecom_pro_tipo_laboratorio' => $tra_ecom_pro_tipo_laboratorio,
                            'tra_ecom_pro_correl' => $tra_ecom_pro_correl
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>$examen.' eliminado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>$examen.' no pudo ser eliminado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function deleteItemExamen($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_ecom_tra_cm_correlativo = $parameter['tra_ecom_tra_cm_correlativo'] ?? 0;
                    $tra_ecom_no_examen = $parameter['tra_ecom_no_examen'] ?? 0;
                    $tra_ecom_pro_correl = $parameter['tra_ecom_pro_correl'] ?? 0;
                    $examen = $parameter['examen'] ?? NULL;
                    

                    $tra_ecom_tra_cm_correlativo = $utility->validarLongitudString($tra_ecom_tra_cm_correlativo, 0, 11);
                    $tra_ecom_no_examen = $utility->validarLongitudString($tra_ecom_no_examen, 0, 11);
                    $tra_ecom_pro_correl = $utility->validarLongitudString($tra_ecom_pro_correl, 0, 11);
                        $sql = 
                        "UPDATE examenes_complementarios SET 
                                                tra_ecom_estado = 'E',
                                                tra_ecom_usuariom = :id_usuario,
                                                tra_ecom_fecham = now() 
                                                where tra_ecom_tra_cm_correlativo = :tra_ecom_tra_cm_correlativo 
                                                and tra_ecom_no_examen = :tra_ecom_no_examen 
                                                and tra_ecom_pro_correl = :tra_ecom_pro_correl and tra_ecom_estado != 'E'";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                            'tra_ecom_no_examen' => $tra_ecom_no_examen,
                            'tra_ecom_pro_correl' => $tra_ecom_pro_correl
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>$examen.' eliminado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>$examen.' no pudo ser eliminado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function deleteExamenLaboratorio($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_ecom_tra_cm_correlativo = $parameter['tra_ecom_tra_cm_correlativo'] ?? 0;
                    $tra_ecom_no_examen = $parameter['tra_ecom_no_examen'] ?? 0;
                    

                    $tra_ecom_tra_cm_correlativo = $utility->validarLongitudString($tra_ecom_tra_cm_correlativo, 0, 11);
                    $tra_ecom_no_examen = $utility->validarLongitudString($tra_ecom_no_examen, 0, 11);
                    
                        $sql = 
                        "UPDATE examenes_complementarios SET 
                                                tra_ecom_estado = 'E',
                                                tra_ecom_usuariom = :id_usuario,
                                                tra_ecom_fecham = now() 
                                                where tra_ecom_tra_cm_correlativo = :tra_ecom_tra_cm_correlativo 
                                                and tra_ecom_no_examen = :tra_ecom_no_examen 
                                                and tra_ecom_estado != 'E'";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                            'tra_ecom_no_examen' => $tra_ecom_no_examen
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Laboratorio eliminado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Laboratorio no pudo ser eliminado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function deleteReceta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_rm_tra_cm_correlativo = $parameter['tra_rm_tra_cm_correlativo'] ?? 0;
                    $tra_rm_tra_no_receta = $parameter['tra_rm_tra_no_receta'] ?? 0;
                    

                    $tra_rm_tra_cm_correlativo = $utility->validarLongitudString($tra_rm_tra_cm_correlativo, 0, 11);
                    $tra_rm_tra_no_receta = $utility->validarLongitudString($tra_rm_tra_no_receta, 0, 11);
                    
                        $sql = 
                        "UPDATE tra_receta_medica SET 
                                                tra_rm_estado = 'E',
                                                tra_rm_usuariom = :id_usuario,
                                                tra_rm_fecham = now() 
                                                where tra_rm_tra_cm_correlativo = :tra_rm_tra_cm_correlativo 
                                                and tra_rm_tra_no_receta = :tra_rm_tra_no_receta 
                                                and tra_rm_estado != 'E'";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_rm_tra_cm_correlativo' => $tra_rm_tra_cm_correlativo,
                            'tra_rm_tra_no_receta' => $tra_rm_tra_no_receta
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Laboratorio eliminado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Laboratorio no pudo ser eliminado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function deleteRecetaExamenComplementario($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_rmex_tra_cm_correlativo = $parameter['tra_rmex_tra_cm_correlativo'] ?? 0;
                    $tra_rmex_tra_no_receta = $parameter['tra_rmex_tra_no_receta'] ?? 0;
                    

                    $tra_rmex_tra_cm_correlativo = $utility->validarLongitudString($tra_rmex_tra_cm_correlativo, 0, 11);
                    $tra_rmex_tra_no_receta = $utility->validarLongitudString($tra_rmex_tra_no_receta, 0, 11);
                    
                        $sql = 
                        "UPDATE tra_receta_medica_examen_complementario SET 
                                                tra_rmex_estado = 'E',
                                                tra_rmex_usuariom = :id_usuario,
                                                tra_rmex_fecham = now() 
                                                where tra_rmex_tra_cm_correlativo = :tra_rmex_tra_cm_correlativo 
                                                and tra_rmex_tra_no_receta = :tra_rmex_tra_no_receta 
                                                and tra_rmex_estado != 'E'";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_rmex_tra_cm_correlativo' => $tra_rmex_tra_cm_correlativo,
                            'tra_rmex_tra_no_receta' => $tra_rmex_tra_no_receta
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Laboratorio eliminado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Laboratorio no pudo ser eliminado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function updateAllReceta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_rm_tra_cm_correlativo = $parameter['tra_rm_tra_cm_correlativo'] ?? 0;
                    $tra_rm_tra_no_receta = $parameter['tra_rm_tra_no_receta'] ?? 0;
                    //$tra_rm_tipo_ficha = $parameter['tra_rm_tipo_ficha'] ?? 0;

                    //$tra_rm_correlativo = $utility->validarLongitudString($tra_rm_correlativo, 0, 4);
                    //$tra_cm_observaciones_proxima_cita = $utility->validarLongitudString($tra_cm_observaciones_proxima_cita, 0, 2000);
                        $sql = 
                        "UPDATE tra_receta_medica SET 
                                                tra_rm_estado = 'E',
                                                tra_rm_usuariom = :id_usuario,
                                                tra_rm_fecham = now() 
                                                where tra_rm_tra_cm_correlativo = :tra_rm_tra_cm_correlativo and tra_rm_tra_no_receta = :tra_rm_tra_no_receta";
                        //and tra_rm_tipo_ficha = :tra_rm_tipo_ficha
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_rm_tra_cm_correlativo' => $tra_rm_tra_cm_correlativo,
                            'tra_rm_tra_no_receta' => $tra_rm_tra_no_receta
                            //'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Receta eliminada exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Receta no pudo ser eliminada', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function updateAllRecetaExaComplementario($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_rmex_tra_cm_correlativo = $parameter['tra_rmex_tra_cm_correlativo'] ?? 0;
                    $tra_rmex_tra_no_receta = $parameter['tra_rmex_tra_no_receta'] ?? 0;
                    //$tra_rm_tipo_ficha = $parameter['tra_rm_tipo_ficha'] ?? 0;

                    //$tra_rm_correlativo = $utility->validarLongitudString($tra_rm_correlativo, 0, 4);
                    //$tra_cm_observaciones_proxima_cita = $utility->validarLongitudString($tra_cm_observaciones_proxima_cita, 0, 2000);
                        $sql = 
                        "UPDATE tra_receta_medica_examen_complementario SET 
                                                tra_rmex_estado = 'E',
                                                tra_rmex_usuariom = :id_usuario,
                                                tra_rmex_fecham = now() 
                                                where tra_rmex_tra_cm_correlativo = :tra_rmex_tra_cm_correlativo and tra_rmex_tra_no_receta = :tra_rmex_tra_no_receta";
                        //and tra_rm_tipo_ficha = :tra_rm_tipo_ficha
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_rmex_tra_cm_correlativo' => $tra_rmex_tra_cm_correlativo,
                            'tra_rmex_tra_no_receta' => $tra_rmex_tra_no_receta
                            //'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Receta eliminada exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Receta no pudo ser eliminada', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function updateAllRecetaExamenComplementario($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_rmex_tra_cm_correlativo = $parameter['tra_rmex_tra_cm_correlativo'] ?? 0;
                    $tra_rmex_tra_no_receta = $parameter['tra_rmex_tra_no_receta'] ?? 0;
                    //$tra_rm_tipo_ficha = $parameter['tra_rm_tipo_ficha'] ?? 0;

                    //$tra_rm_correlativo = $utility->validarLongitudString($tra_rm_correlativo, 0, 4);
                    //$tra_cm_observaciones_proxima_cita = $utility->validarLongitudString($tra_cm_observaciones_proxima_cita, 0, 2000);
                        $sql = 
                        "UPDATE tra_receta_medica_examen_complementario SET 
                                                tra_rmex_estado = 'E',
                                                tra_rmex_usuariom = :id_usuario,
                                                tra_rmex_fecham = now() 
                                                where tra_rmex_tra_cm_correlativo = :tra_rmex_tra_cm_correlativo and tra_rmex_tra_no_receta = :tra_rmex_tra_no_receta";
                        //and tra_rm_tipo_ficha = :tra_rm_tipo_ficha
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_rmex_tra_cm_correlativo' => $tra_rmex_tra_cm_correlativo,
                            'tra_rmex_tra_no_receta' => $tra_rmex_tra_no_receta
                            //'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Receta eliminada exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Receta no pudo ser eliminada', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function deleteLaboratorio($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_ecom_tra_cm_correlativo = $parameter['tra_ecom_tra_cm_correlativo'] ?? 0;
                    //$tra_ecom_tipo_ficha = $parameter['tra_ecom_tipo_ficha'] ?? 0;
                    $tra_ecom_no_examen = $parameter['tra_ecom_no_examen'] ?? 0;
                    $tra_ecom_tra_cm_correlativo = $utility->validarLongitudString($tra_ecom_tra_cm_correlativo, 0, 4);
                    //$tra_cm_observaciones_proxima_cita = $utility->validarLongitudString($tra_cm_observaciones_proxima_cita, 0, 2000);
                        $sql = 
                        "UPDATE examenes_complementarios SET 
                                                tra_ecom_estado = 'E',
                                                tra_ecom_usuariom = :id_usuario,
                                                tra_ecom_fecham = now() 
                                                where tra_ecom_tra_cm_correlativo = :tra_ecom_tra_cm_correlativo 
                                                and tra_ecom_no_examen = :tra_ecom_no_examen";
                        //and tra_ecom_tipo_ficha = :tra_ecom_tipo_ficha 
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            //'tra_ecom_tipo_ficha' => $tra_ecom_tipo_ficha,
                            'tra_ecom_no_examen' => $tra_ecom_no_examen,
                            'id_usuario' => $id_usuario,
                            'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser eliminado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function confirmacionProximaConsulta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'eliminar');
                if($userFuncionality == 'OK'){
                    //PARAMETROS PROXIMA CITA
                    
                    $tra_cm_correlativo = $parameter['tra_cm_correlativo'] ?? 0;
                    $tra_cm_confirmacion_cita = $parameter['tra_cm_confirmacion_cita'] ?? 0;
                    
                    $tra_cm_proxima_cita = "";

                    $tra_cm_correlativo = $utility->validarLongitudString($tra_cm_correlativo, 0, 4);
                    $tra_cm_observaciones_proxima_cita = $utility->validarLongitudString($tra_cm_observaciones_proxima_cita, 0, 2000);
                    $fechaActual = date("Y-m-d");
                    $tra_cm_proxima_cita = date("Y-m-d",strtotime($fechaActual."+ $tra_cm_dias days"));
                    

                        $sql = 
                        "UPDATE tra_consulta_medica SET 
                                                tra_cm_fecha_confirmacion_proxima_cita = now(),
                                                tra_cm_confirmacion_cita = :tra_cm_confirmacion_cita,
                                                tra_cm_usuariom = :id_usuario,
                                                tra_cm_fecham = now() 
                                                where tra_cm_correlativo = :tra_cm_correlativo";//and tra_fichamn_tra_correlativo = :tra_fichamn_tra_correlativo
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_cm_correlativo' => $tra_cm_correlativo,
                            'tra_cm_confirmacion_cita' => $tra_cm_confirmacion_cita
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_fichamn_correl);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    */
    public function cancelarProximaConsulta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'eliminar');
                if($userFuncionality == 'OK'){
                    //PARAMETROS PROXIMA CITA
                    
                    $tra_cm_correlativo = $parameter['tra_cm_correlativo'] ?? 0;
                    $tra_cm_confirmacion_cita = $parameter['tra_cm_confirmacion_cita'] ?? 0;
                    
                    $tra_cm_proxima_cita = "";

                    $tra_cm_correlativo = $utility->validarLongitudString($tra_cm_correlativo, 0, 4);
                    $tra_cm_observaciones_proxima_cita = $utility->validarLongitudString($tra_cm_observaciones_proxima_cita, 0, 2000);
                    $fechaActual = date("Y-m-d");
                    $tra_cm_proxima_cita = date("Y-m-d",strtotime($fechaActual."+ $tra_cm_dias days"));

                        $sql = 
                        "UPDATE tra_consulta_medica SET 
                                                tra_cm_fecha_confirmacion_proxima_cita = now(),
                                                tra_cm_confirmacion_cita = :tra_cm_confirmacion_cita,
                                                tra_cm_usuariom = :id_usuario,
                                                tra_cm_fecham = now() 
                                                where tra_cm_correlativo = :tra_cm_correlativo";//and tra_fichamn_tra_correlativo = :tra_fichamn_tra_correlativo
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'id_usuario' => $id_usuario,
                            'tra_cm_correlativo' => $tra_cm_correlativo,
                            'tra_cm_confirmacion_cita' => $tra_cm_confirmacion_cita
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_fichamn_correl);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    /*
    public function insertReceta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    //$tra_correlativo = (int)$parameter['tra_correlativo'] ?? 0;
                    
                    $tra_rm_tipo_ficha = $parameter['tra_rm_tipo_ficha'] ?? 0;
                    $tra_rm_tra_cm_correlativo = $parameter['tra_rm_tra_cm_correlativo'] ?? 0;
                    $tra_rm_observaciones = $parameter['tra_rm_observaciones'] ?? NULL;
                    //$tra_rm_descripcion = "";//$parameter['tra_rm_descripcion'] ?? array();
                    $data= $parameter['data'] ?? array();

                
                    $tra_rm_tipo_ficha = $utility->validarLongitudString($tra_rm_tipo_ficha, 0, 11);
                    $tra_rm_tra_cm_correlativo = $utility->validarLongitudString($tra_rm_tra_cm_correlativo, 0, 11);
                    //$tra_rm_descripcion = $utility->validarLongitudString($tra_rm_descripcion, 0, 2000);

                    $tra_rm_tra_no_receta = $utility->CorrelAutomatico($PDO, "tra_receta_medica", "tra_rm_tra_no_receta ", " and tra_rm_tra_cm_correlativo = $tra_rm_tra_cm_correlativo and tra_rm_tipo_ficha = $tra_rm_tipo_ficha and tra_rm_estado !='E'");
                    
                    foreach($data as $value){
                        $tra_rm_correlativo = $utility->CorrelAutomatico($PDO, "tra_receta_medica", "tra_rm_correlativo ", "");
                        //if(isset($value['examen'])){$tra_rm_descripcion = $value['examen'];}
                        $tra_rm_descripcion = $value['descripcion'];
                        
                        $sql = 
                        "insert into tra_receta_medica (
                                                tra_rm_correlativo, 
                                                tra_rm_tra_cm_correlativo,
                                                tra_rm_tra_no_receta,
                                                tra_rm_descripcion, 
                                                tra_rm_observaciones,
                                                tra_rm_tipo_ficha,
                                                tra_rm_estado,
                                                tra_rm_usuarioi,
                                                tra_rm_usuariom,
                                                tra_rm_fechai,
                                                tra_rm_fecham
                                                ) values(
                                                :tra_rm_correlativo, 
                                                :tra_rm_tra_cm_correlativo,
                                                :tra_rm_tra_no_receta,
                                                :tra_rm_descripcion, 
                                                :tra_rm_observaciones,
                                                :tra_rm_tipo_ficha,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'tra_rm_correlativo' => $tra_rm_correlativo,
                            'tra_rm_tra_cm_correlativo' => $tra_rm_tra_cm_correlativo,
                            'tra_rm_tra_no_receta' => $tra_rm_tra_no_receta,
                            'tra_rm_descripcion' => $tra_rm_descripcion, 
                            'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha,
                            'id_usuario' => $id_usuario,
                            'tra_rm_observaciones' => $tra_rm_observaciones
                        ]);
                    }

                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_rm_tra_no_receta);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertRecetaExamen($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    //$tra_correlativo = (int)$parameter['tra_correlativo'] ?? 0;
                    
                    //$tra_rm_tipo_ficha = $parameter['tra_rm_tipo_ficha'] ?? 0;
                    $tra_rmex_tra_cm_correlativo = $parameter['tra_rmex_tra_cm_correlativo'] ?? 0;
                    $tra_rmex_observaciones = $parameter['tra_rmex_observaciones'] ?? NULL;
                    //$tra_rm_descripcion = "";//$parameter['tra_rm_descripcion'] ?? array();
                    $data= $parameter['data'] ?? array();

                
                    $tra_rmex_tipo_ficha = NULL;//$utility->validarLongitudString($tra_rmex_tipo_ficha, 0, 11);
                    $tra_rmex_tra_cm_correlativo = $utility->validarLongitudString($tra_rmex_tra_cm_correlativo, 0, 11);
                    //$tra_rm_descripcion = $utility->validarLongitudString($tra_rm_descripcion, 0, 2000);

                    $tra_rmex_tra_no_receta = $utility->CorrelAutomatico($PDO, "tra_receta_medica_examen_complementario", "tra_rmex_tra_no_receta ", " and tra_rmex_tra_cm_correlativo = $tra_rmex_tra_cm_correlativo and tra_rmex_estado !='E'");//and tra_rm_tipo_ficha = $tra_rm_tipo_ficha 
                    
                    
                    foreach($data as $value){
                        $tra_rmex_correlativo = $utility->CorrelAutomatico($PDO, "tra_receta_medica_examen_complementario", "tra_rmex_correlativo ", "");
                        //if(isset($value['examen'])){$tra_rm_descripcion = $value['examen'];}
                        $tra_rmex_descripcion = $value['descripcion'];
                        
                        $sql = 
                        "insert into tra_receta_medica_examen_complementario (
                                                tra_rmex_correlativo, 
                                                tra_rmex_tra_cm_correlativo,
                                                tra_rmex_tra_no_receta,
                                                tra_rmex_descripcion, 
                                                tra_rmex_observaciones,
                                                tra_rmex_tipo_ficha,
                                                tra_rmex_estado,
                                                tra_rmex_usuarioi,
                                                tra_rmex_usuariom,
                                                tra_rmex_fechai,
                                                tra_rmex_fecham
                                                ) values(
                                                :tra_rmex_correlativo, 
                                                :tra_rmex_tra_cm_correlativo,
                                                :tra_rmex_tra_no_receta,
                                                :tra_rmex_descripcion, 
                                                :tra_rmex_observaciones,
                                                :tra_rmex_tipo_ficha,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'tra_rmex_correlativo' => $tra_rmex_correlativo,
                            'tra_rmex_tra_cm_correlativo' => $tra_rmex_tra_cm_correlativo,
                            'tra_rmex_tra_no_receta' => $tra_rmex_tra_no_receta,
                            'tra_rmex_descripcion' => $tra_rmex_descripcion, 
                            'tra_rmex_tipo_ficha' => $tra_rmex_tipo_ficha,
                            'id_usuario' => $id_usuario,
                            'tra_rmex_observaciones' => $tra_rmex_observaciones
                        ]);
                    }

                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_rmex_tra_no_receta);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertItemReceta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    //$tra_correlativo = (int)$parameter['tra_correlativo'] ?? 0;
                    
                    $tra_rm_tipo_ficha = NULL;//$parameter['tra_rm_tipo_ficha'] ?? 0;
                    $tra_rm_tra_cm_correlativo = $parameter['tra_rm_tra_cm_correlativo'] ?? 0;
                    $tra_rm_descripcion = $parameter['tra_rm_descripcion'] ?? '';
                    $tra_rm_tra_no_receta = $parameter['tra_rm_tra_no_receta'] ?? 0;
                    $tra_rm_observaciones = $parameter['tra_rm_observaciones'] ?? NULL;
                    //$tra_rm_descripcion = "";//$parameter['tra_rm_descripcion'] ?? array();
                    //$data= $parameter['data'] ?? array();

                
                    $tra_rm_tipo_ficha = $utility->validarLongitudString($tra_rm_tipo_ficha, 0, 11);
                    $tra_rm_tra_cm_correlativo = $utility->validarLongitudString($tra_rm_tra_cm_correlativo, 0, 11);
                    $tra_rm_descripcion = $utility->validarLongitudString($tra_rm_descripcion, 0, 2000);
                    $tra_rm_observaciones = $utility->validarLongitudString($tra_rm_observaciones, 0, 150);

                    $tra_rm_correlativo = $utility->CorrelAutomatico($PDO, "tra_receta_medica", "tra_rm_correlativo ", "");
                    
                    $sql = 
                    "insert into tra_receta_medica (
                                            tra_rm_correlativo, 
                                            tra_rm_tra_cm_correlativo,
                                            tra_rm_tra_no_receta,
                                            tra_rm_descripcion, 
                                            tra_rm_observaciones,
                                            tra_rm_tipo_ficha,
                                            tra_rm_estado,
                                            tra_rm_usuarioi,
                                            tra_rm_usuariom,
                                            tra_rm_fechai,
                                            tra_rm_fecham
                                            ) values(
                                            :tra_rm_correlativo, 
                                            :tra_rm_tra_cm_correlativo,
                                            :tra_rm_tra_no_receta,
                                            :tra_rm_descripcion, 
                                            :tra_rm_observaciones,
                                            :tra_rm_tipo_ficha,
                                            'A',
                                            :id_usuario, 
                                            :id_usuario, 
                                            now(), 
                                            now()
                                            )";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'tra_rm_correlativo' => $tra_rm_correlativo,
                        'tra_rm_tra_cm_correlativo' => $tra_rm_tra_cm_correlativo,
                        'tra_rm_tra_no_receta' => $tra_rm_tra_no_receta,
                        'tra_rm_descripcion' => $tra_rm_descripcion, 
                        'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha,
                        'id_usuario' => $id_usuario,
                        'tra_rm_observaciones' => $tra_rm_observaciones
                    ]);

                    if ($result == true) {
                        $sqlU="update tra_receta_medica set tra_rm_observaciones = :tra_rm_observaciones where tra_rm_tra_cm_correlativo = :tra_rm_tra_cm_correlativo and tra_rm_tra_no_receta = :tra_rm_tra_no_receta and tra_rm_estado != 'E'";
                        $stmtU = $PDO->prepare($sqlU);
                        $resultU = $stmtU->execute([
                            'tra_rm_tra_cm_correlativo' => $tra_rm_tra_cm_correlativo,
                            'tra_rm_tra_no_receta' => $tra_rm_tra_no_receta,
                            'tra_rm_observaciones' => $tra_rm_observaciones
                        ]);

                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_rm_correlativo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function insertItemRecetaExamenComplementario($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    //$tra_correlativo = (int)$parameter['tra_correlativo'] ?? 0;
                    
                    $tra_rmex_tipo_ficha = NULL;//$parameter['tra_rmex_tipo_ficha'] ?? 0;
                    $tra_rmex_tra_cm_correlativo = $parameter['tra_rmex_tra_cm_correlativo'] ?? 0;
                    $tra_rmex_descripcion = $parameter['tra_rmex_descripcion'] ?? '';
                    $tra_rmex_tra_no_receta = $parameter['tra_rmex_tra_no_receta'] ?? 0;
                    $tra_rmex_observaciones = $parameter['tra_rmex_observaciones'] ?? NULL;
                    //$tra_rmex_descripcion = "";//$parameter['tra_rmex_descripcion'] ?? array();
                    //$data= $parameter['data'] ?? array();

                
                    //$tra_rmex_tipo_ficha = $utility->validarLongitudString($tra_rmex_tipo_ficha, 0, 11);
                    $tra_rmex_tra_cm_correlativo = $utility->validarLongitudString($tra_rmex_tra_cm_correlativo, 0, 11);
                    $tra_rmex_descripcion = $utility->validarLongitudString($tra_rmex_descripcion, 0, 2000);
                    $tra_rmex_observaciones = $utility->validarLongitudString($tra_rmex_observaciones, 0, 150);

                    $tra_rmex_correlativo = $utility->CorrelAutomatico($PDO, "tra_receta_medica_examen_complementario", "tra_rmex_correlativo ", "");
                    
                    $sql = 
                    "insert into tra_receta_medica_examen_complementario (
                                            tra_rmex_correlativo, 
                                            tra_rmex_tra_cm_correlativo,
                                            tra_rmex_tra_no_receta,
                                            tra_rmex_descripcion, 
                                            tra_rmex_observaciones,
                                            tra_rmex_tipo_ficha,
                                            tra_rmex_estado,
                                            tra_rmex_usuarioi,
                                            tra_rmex_usuariom,
                                            tra_rmex_fechai,
                                            tra_rmex_fecham
                                            ) values(
                                            :tra_rmex_correlativo, 
                                            :tra_rmex_tra_cm_correlativo,
                                            :tra_rmex_tra_no_receta,
                                            :tra_rmex_descripcion, 
                                            :tra_rmex_observaciones,
                                            :tra_rmex_tipo_ficha,
                                            'A',
                                            :id_usuario, 
                                            :id_usuario, 
                                            now(), 
                                            now()
                                            )";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'tra_rmex_correlativo' => $tra_rmex_correlativo,
                        'tra_rmex_tra_cm_correlativo' => $tra_rmex_tra_cm_correlativo,
                        'tra_rmex_tra_no_receta' => $tra_rmex_tra_no_receta,
                        'tra_rmex_descripcion' => $tra_rmex_descripcion, 
                        'tra_rmex_tipo_ficha' => $tra_rmex_tipo_ficha,
                        'id_usuario' => $id_usuario,
                        'tra_rmex_observaciones' => $tra_rmex_observaciones
                    ]);

                    if ($result == true) {
                        $sqlU="update tra_receta_medica_examen_complementario set tra_rmex_observaciones = :tra_rmex_observaciones where tra_rmex_tra_cm_correlativo = :tra_rmex_tra_cm_correlativo and tra_rmex_tra_no_receta = :tra_rmex_tra_no_receta and tra_rmex_estado != 'E'";
                        $stmtU = $PDO->prepare($sqlU);
                        $resultU = $stmtU->execute([
                            'tra_rmex_tra_cm_correlativo' => $tra_rmex_tra_cm_correlativo,
                            'tra_rmex_tra_no_receta' => $tra_rmex_tra_no_receta,
                            'tra_rmex_observaciones' => $tra_rmex_observaciones
                        ]);

                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_rm_correlativo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function insertExamenLaboratorio($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    //$tra_correlativo = (int)$parameter['tra_correlativo'] ?? 0;
                    
                    $tra_ecom_tipo_ficha = NULL;//$parameter['tra_ecom_tipo_ficha'] ?? 0;
                    $tra_ecom_status = $parameter['tra_ecom_status'] ?? 0;
                    $tra_ecom_tra_cm_correlativo = $parameter['tra_ecom_tra_cm_correlativo'] ?? 0;
                    $tra_ecom_status = $parameter['tra_ecom_status'] ?? 0;
                    $tra_ecom_descripcion = $parameter['tra_ecom_descripcion'] ?? NULL;
                    $data= $parameter['data'] ?? array();

                
                    //$tra_ecom_tipo_ficha = $utility->validarLongitudString($tra_ecom_tipo_ficha, 0, 11);
                    $tra_ecom_tra_cm_correlativo = $utility->validarLongitudString($tra_ecom_tra_cm_correlativo, 0, 11);
                    //$tra_rm_descripcion = $utility->validarLongitudString($tra_rm_descripcion, 0, 2000);

                    $tra_ecom_no_examen = $utility->CorrelAutomatico($PDO, "examenes_complementarios", "tra_ecom_no_examen ", " and tra_ecom_tra_cm_correlativo = $tra_ecom_tra_cm_correlativo and tra_ecom_estado !='E'");//and tra_ecom_tipo_ficha = $tra_ecom_tipo_ficha
                    
                    
                    foreach($data as $value){
                        $tra_ecom_correlativo = $utility->CorrelAutomatico($PDO, "examenes_complementarios", "tra_ecom_correlativo", "");
                        //if(isset($value['examen'])){$tra_rm_descripcion = $value['examen'];}
                        $result = explode("_",$value);
                        $tra_ecom_pro_tipo_laboratorio = $result[0];
                        $tra_ecom_pro_correl = $result[1];
                        
                        $sql = 
                        "insert into examenes_complementarios (
                                                tra_ecom_correlativo, 
                                                tra_ecom_tra_cm_correlativo,
                                                tra_ecom_tipo_ficha,
                                                tra_ecom_no_examen,
                                                tra_ecom_pro_tipo_laboratorio,
                                                tra_ecom_pro_correl, 
                                                tra_ecom_status,
                                                tra_ecom_descripcion,
                                                tra_ecom_estado,
                                                tra_ecom_usuarioi,
                                                tra_ecom_usuariom,
                                                tra_ecom_fechai,
                                                tra_ecom_fecham
                                                ) values(
                                                :tra_ecom_correlativo, 
                                                :tra_ecom_tra_cm_correlativo,
                                                :tra_ecom_tipo_ficha,
                                                :tra_ecom_no_examen,
                                                :tra_ecom_pro_tipo_laboratorio,
                                                :tra_ecom_pro_correl, 
                                                :tra_ecom_status,
                                                :tra_ecom_descripcion,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'tra_ecom_correlativo' => $tra_ecom_correlativo,
                            'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                            'tra_ecom_tipo_ficha' => $tra_ecom_tipo_ficha,
                            'tra_ecom_no_examen' => $tra_ecom_no_examen,
                            'tra_ecom_pro_tipo_laboratorio' => $tra_ecom_pro_tipo_laboratorio,
                            'tra_ecom_pro_correl' => $tra_ecom_pro_correl, 
                            'tra_ecom_status' => $tra_ecom_status,
                            'id_usuario' => $id_usuario,
                            'tra_ecom_descripcion' => $tra_ecom_descripcion
                        ]);
                    }

                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_ecom_no_examen);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertItemExamenesLaboratorio($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    //$tra_correlativo = (int)$parameter['tra_correlativo'] ?? 0;
                    $tra_ecom_tra_cm_correlativo = $parameter['tra_ecom_tra_cm_correlativo'] ?? 0;
                    $tra_ecom_tipo_ficha = NULL;//$parameter['tra_ecom_tipo_ficha'] ?? 0;
                    $tra_ecom_status = $parameter['tra_ecom_status'] ?? 'N';
                    $tra_ecom_no_examen = $parameter['tra_ecom_no_examen'] ?? 0;
                    $tra_ecom_descripcion = $parameter['tra_ecom_descripcion'] ?? NULL;
                    $tra_ecom_pro_correl = $parameter['tra_ecom_pro_correl'] ?? 0;
                    $tra_ecom_pro_tipo_laboratorio = $parameter['tra_ecom_pro_tipo_laboratorio'] ?? 0;
                    $examen = $parameter['examen'] ?? NULL;
                    
                    //$data= $parameter['data'] ?? array();

                
                    //$tra_ecom_tipo_ficha = $utility->validarLongitudString($tra_ecom_tipo_ficha, 0, 11);
                    $tra_ecom_tra_cm_correlativo = $utility->validarLongitudString($tra_ecom_tra_cm_correlativo, 0, 11);
                    //$tra_rm_descripcion = $utility->validarLongitudString($tra_rm_descripcion, 0, 2000);

                    //$tra_ecom_no_examen = $utility->CorrelAutomatico($PDO, "examenes_complementarios", "tra_ecom_no_examen ", " and tra_ecom_tra_cm_correlativo = $tra_ecom_tra_cm_correlativo and tra_ecom_estado !='E'");//and tra_ecom_tipo_ficha = $tra_ecom_tipo_ficha
                    
                    
                        $tra_ecom_correlativo = $utility->CorrelAutomatico($PDO, "examenes_complementarios", "tra_ecom_correlativo", "");
                        
                        $sql = 
                        "insert into examenes_complementarios (
                                                tra_ecom_correlativo, 
                                                tra_ecom_tra_cm_correlativo,
                                                tra_ecom_tipo_ficha,
                                                tra_ecom_no_examen,
                                                tra_ecom_pro_tipo_laboratorio,
                                                tra_ecom_pro_correl, 
                                                tra_ecom_status,
                                                tra_ecom_descripcion,
                                                tra_ecom_estado,
                                                tra_ecom_usuarioi,
                                                tra_ecom_usuariom,
                                                tra_ecom_fechai,
                                                tra_ecom_fecham
                                                ) values(
                                                :tra_ecom_correlativo, 
                                                :tra_ecom_tra_cm_correlativo,
                                                :tra_ecom_tipo_ficha,
                                                :tra_ecom_no_examen,
                                                :tra_ecom_pro_tipo_laboratorio,
                                                :tra_ecom_pro_correl, 
                                                :tra_ecom_status,
                                                :tra_ecom_descripcion,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'tra_ecom_correlativo' => $tra_ecom_correlativo,
                            'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                            'tra_ecom_tipo_ficha' => $tra_ecom_tipo_ficha,
                            'tra_ecom_no_examen' => $tra_ecom_no_examen,
                            'tra_ecom_pro_tipo_laboratorio' => $tra_ecom_pro_tipo_laboratorio,
                            'tra_ecom_pro_correl' => $tra_ecom_pro_correl, 
                            'tra_ecom_status' => $tra_ecom_status,
                            'id_usuario' => $id_usuario,
                            'tra_ecom_descripcion' => $tra_ecom_descripcion
                        ]);

                    if ($result == true) {
                        $sqlU= "update examenes_complementarios set tra_ecom_descripcion = :tra_ecom_descripcion where tra_ecom_tra_cm_correlativo = :tra_ecom_tra_cm_correlativo and tra_ecom_no_examen = :tra_ecom_no_examen and tra_ecom_estado != 'E'";
                        //and tra_ecom_correlativo = :tra_ecom_correlativo
                        $stmtU = $PDO->prepare($sqlU);
                        $resultU = $stmtU->execute([
                            //'tra_ecom_correlativo' => $tra_ecom_correlativo,
                            'tra_ecom_descripcion' => $tra_ecom_descripcion,
                            'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                            'tra_ecom_no_examen' => $tra_ecom_no_examen
                        ]);

                        $data = array('estado'=>'OK', 'mensaje'=>$examen.' Registrado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_ecom_no_examen);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>$examen.' no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertItemExamenLaboratorio($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'eliminar');
                if($userFuncionality == 'OK'){
                    //$tra_correlativo = (int)$parameter['tra_correlativo'] ?? 0;
                    $tra_ecom_tra_cm_correlativo = $parameter['tra_ecom_tra_cm_correlativo'] ?? 0;
                    $tra_ecom_tipo_ficha = NULL;//$parameter['tra_ecom_tipo_ficha'] ?? 0;
                    $tra_ecom_no_examen = $parameter['tra_ecom_no_examen'] ?? 0;
                    $tra_ecom_pro_tipo_laboratorio = $parameter['tra_ecom_pro_tipo_laboratorio'] ?? 0;
                    $tra_ecom_pro_correl = $parameter['tra_ecom_pro_correl'] ?? 0;
                    $tra_ecom_status = 'S';
                    $examen = $parameter['examen'] ?? NULL;
                    $tra_ecom_descripcion = $parameter['otros_examenes'] ?? NULL;
                    
                    
                    //$data= $parameter['data'] ?? array();

                    $tra_ecom_descripcion = $utility->validarLongitudString($tra_ecom_descripcion, 0, 250);
                    $tra_ecom_tipo_ficha = $utility->validarLongitudString($tra_ecom_tipo_ficha, 0, 11);
                    $tra_ecom_tra_cm_correlativo = $utility->validarLongitudString($tra_ecom_tra_cm_correlativo, 0, 11);
                    //$tra_rm_descripcion = $utility->validarLongitudString($tra_rm_descripcion, 0, 2000);

                    //$tra_ecom_no_examen = $utility->CorrelAutomatico($PDO, "examenes_complementarios", "tra_ecom_no_examen ", " and tra_ecom_tra_cm_correlativo = $tra_ecom_tra_cm_correlativo and tra_ecom_tipo_ficha = $tra_ecom_tipo_ficha and tra_ecom_estado !='E'");
                    
                    
                        $tra_ecom_correlativo = $utility->CorrelAutomatico($PDO, "examenes_complementarios", "tra_ecom_correlativo", "");
                        
                        $sql = 
                        "insert into examenes_complementarios (
                                                tra_ecom_correlativo, 
                                                tra_ecom_tra_cm_correlativo,
                                                tra_ecom_tipo_ficha,
                                                tra_ecom_no_examen,
                                                tra_ecom_pro_tipo_laboratorio,
                                                tra_ecom_pro_correl, 
                                                tra_ecom_status,
                                                tra_ecom_descripcion,
                                                tra_ecom_estado,
                                                tra_ecom_usuarioi,
                                                tra_ecom_usuariom,
                                                tra_ecom_fechai,
                                                tra_ecom_fecham
                                                ) values(
                                                :tra_ecom_correlativo, 
                                                :tra_ecom_tra_cm_correlativo,
                                                :tra_ecom_tipo_ficha,
                                                :tra_ecom_no_examen,
                                                :tra_ecom_pro_tipo_laboratorio,
                                                :tra_ecom_pro_correl, 
                                                :tra_ecom_status,
                                                :tra_ecom_descripcion,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'tra_ecom_correlativo' => $tra_ecom_correlativo,
                            'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                            'tra_ecom_tipo_ficha' => $tra_ecom_tipo_ficha,
                            'tra_ecom_no_examen' => $tra_ecom_no_examen,
                            'tra_ecom_pro_tipo_laboratorio' => $tra_ecom_pro_tipo_laboratorio,
                            'tra_ecom_pro_correl' => $tra_ecom_pro_correl, 
                            'tra_ecom_status' => $tra_ecom_status,
                            'id_usuario' => $id_usuario,
                            'tra_ecom_descripcion' => $tra_ecom_descripcion
                        ]);

                    if ($result == true) {
                        $sqlU= "update examenes_complementarios set tra_ecom_descripcion = :tra_ecom_descripcion where tra_ecom_tra_cm_correlativo = :tra_ecom_tra_cm_correlativo and tra_ecom_no_examen = :tra_ecom_no_examen and tra_ecom_estado != 'E'";
                        //and tra_ecom_correlativo = :tra_ecom_correlativo
                        $stmtU = $PDO->prepare($sqlU);
                        $resultU = $stmtU->execute([
                            //'tra_ecom_correlativo' => $tra_ecom_correlativo,
                            'tra_ecom_descripcion' => $tra_ecom_descripcion,
                            'tra_ecom_tra_cm_correlativo' => $tra_ecom_tra_cm_correlativo,
                            'tra_ecom_no_examen' => $tra_ecom_no_examen
                        ]);
                        $data = array('estado'=>'OK', 'mensaje'=>$examen.' ingresado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_ecom_correlativo);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>$examen.' no pudo ser ingresado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }*/
    
    /*
    public function selectRecetaFichamedica($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $tra_rm_tra_cm_correlativo = $parameter['tra_rm_tra_cm_correlativo'] ?? 0;
                    $tra_rm_tipo_ficha = $parameter['tra_rm_tipo_ficha'] ?? 0;
                    
                    $tra_rm_estado = 'A';
                    $tra_etapa = 2;

                    //concat(date_format(tra_fecha_inicio_consulta, '%H:%i'),'-', date_format(tra_fecha_fin_consulta, '%H:%i')) as title,
                    $sql = " 
                    select 

                      tra_rm_correlativo,
                      tra_rm_tra_cm_correlativo,
                      tra_rm_tra_no_receta,
                      tra_rm_descripcion,
                      tra_rm_tipo_ficha,
                      tra_rm_estado,
                      tra_rm_fechai,
                      tra_rm_fecham,
                      concat(b.usr_nombres,' ', b.usr_apellidos) as age_usuarioi, 
                      concat(c.usr_nombres,' ', c.usr_apellidos) as age_usuariom,  
                      date_format(tra_rm_fechai, '%d/%m/%y %T') as age_fechai,  
                      date_format(tra_rm_fecham, '%d/%m/%y %T') as age_fecham 
                      from tra_receta_medica 
                          left outer join cfg_usuario b on (b.usr_correl = tra_rm_usuarioi) 
                          left outer join cfg_usuario c on (c.usr_correl = tra_rm_usuariom) 
                      where 1=1
                      
                      and tra_rm_tipo_ficha = :tra_rm_tipo_ficha 
                      and tra_rm_tra_cm_correlativo = :tra_rm_tra_cm_correlativo 
                      limit $pag_inicio, $tamanio";

                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        //'tra_rm_estado' => $tra_rm_estado,
                        'tra_rm_tra_cm_correlativo' => $tra_rm_tra_cm_correlativo,
                        'tra_rm_tipo_ficha' => $tra_rm_tipo_ficha
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_receta_medica 
                            left outer join cfg_usuario b on (b.usr_correl = tra_fichamn_usuarioi) 
                            left outer join cfg_usuario c on (c.usr_correl = tra_fichamn_usuariom) 
                            ", " 
                             and tra_fichamn_estado = :tra_fichamn_estado 
                             and tra_fichamn_tipo = :tra_fichamn_tipo 
                             and tra_fichamn_tra_correlativo = :tra_fichamn_tra_correlativo 
                            ", 
                            [
                                'tra_fichamn_estado' => $tra_fichamn_estado,
                                'tra_fichamn_tra_correlativo' => $tra_fichamn_tra_correlativo,
                                'tra_fichamn_tipo' => $tra_fichamn_tipo
                            ]);
                        //echo $data;
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }

    public function insertChecklist($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();


                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_producto', 'nuevo');
                if($userFuncionality == 'OK'){
                    $correlativo = $parameter['correlativo'] ?? 0;
                    $data=$parameter['data'] ?? array();
                    
                    $sqlDelete = " delete from tra_examen_fisico where tra_ef_tra_fm_correlativo = :tra_ef_tra_fm_correlativo";
                    $stmt = $PDO->prepare($sqlDelete);
                    $result = $stmt->execute([
                        'tra_ef_tra_fm_correlativo' => $correlativo
                    ]);

                    foreach($data as $value){
                        $tra_ef_correlativo = $utility->CorrelAutomatico($PDO, "tra_examen_fisico", "tra_ef_correlativo", "");
                        //$correlativo = 0;
                        $normal = "N";
                        $anormal = "N";
                        $noexplorado = "N";
                        $descripcion= "";
                        if(isset($value['cat_valor'])){$cat_valor = $value['cat_valor'];}
                        if(isset($value['ef_normal'])){$normal = $value['ef_normal'][0];}
                        if(isset($value['tra_ef_anormal'])){$anormal = $value['tra_ef_anormal'][0];}
                        if(isset($value['tra_ef_no_explorado'])){$noexplorado = $value['tra_ef_no_explorado'][0];}
                        if(isset($value['tra_ef_descripcion'])){$descripcion = $value['tra_ef_descripcion'];}

                        
                        

                        $sql = " insert into tra_examen_fisico (
                            tra_ef_correlativo,
                            tra_ef_tra_fm_correlativo,
                            tra_ef_cat_valor,
                            tra_ef_normal,
                            tra_ef_anormal,
                            tra_ef_no_explorado,
                            tra_ef_descripcion,
                            tra_ef_estado,
                            tra_ef_usuarioi,
                            tra_ef_usuariom,
                            tra_ef_fechai,
                            tra_ef_fecham      
    
                        ) values(
                            :tra_ef_correlativo,
                            :tra_ef_tra_fm_correlativo,
                            :tra_ef_cat_valor,
                            :tra_ef_normal,
                            :tra_ef_anormal,
                            :tra_ef_no_explorado,
                            :tra_ef_descripcion,
                            'A',
                            :id_usuario,
                            :id_usuario,
                            now(),
                            now()
                        )
                        ";
    
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                        'tra_ef_correlativo' => $tra_ef_correlativo,
                        'tra_ef_tra_fm_correlativo' => $correlativo,
                        'tra_ef_cat_valor' =>$cat_valor,
                        'tra_ef_normal' =>$normal,
                        'tra_ef_anormal' =>$anormal,
                        'tra_ef_no_explorado' => $noexplorado,
                        'tra_ef_descripcion' => $descripcion,
                        'id_usuario' => $id_usuario,
                        ]);
                    }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }*/
    public function deleteOrdenTrabajo($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'TraCallCenter', 'eliminar');
                if($userFuncionality == 'OK'){
                    $otra_no_consulta = (int)$parameter['otra_no_consulta'] ?? 0;
                    $otra_no_orden = (int)$parameter['otra_no_orden'] ?? 0;

                    $existeFactura = $utility->existeFacturaOrdenTrabajo($PDO,"tra_factura","$otra_no_consulta","$otra_no_orden","");
                    $montoPagoOrdenTrabajo = $utility->existePagoOrdenTrabajo($PDO,"tra_formas_pago_ordenes_trabajo","$otra_no_consulta","$otra_no_orden","");
                    
                    $sql = "update tra_orden_trabajo set otra_estado = 'E',otra_fecham = now() where otra_no_consulta = :otra_no_consulta and otra_no_orden = :otra_no_orden";

                    $correlFActura = 0;
                    

                    if($existeFactura[0]->tra_fac_correlativo <= 0 ){
                        if($montoPagoOrdenTrabajo[0]->importePagado <= 0 || $montoPagoOrdenTrabajo[0]->importePagado == NULL){
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'otra_no_consulta' => $otra_no_consulta,
                                'otra_no_orden' => $otra_no_orden
                            ]);
                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Orden de trabajo No.: '.$otra_no_orden.' eliminado exitosamente', 'status'=>200,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'Orden de trabajo No.: '.$otra_no_orden.' no pudo ser eliminado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'No se puede eliminar la orden de trabajo No.: '.$otra_no_orden.' ,actualmente tiene pagos registrados, Monto Pagado: Q'.$montoPagoOrdenTrabajo[0]->importePagado, 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                        }
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'No se puede eliminar la orden de trabajo No.: '.$otra_no_orden.' ,actualmente tiene una factura asignada, Serie Factura: '.$existeFactura[0]->tra_fac_serie.', Monto:'.$existeFactura[0]->tra_fac_monto, 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    
}
