<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;


class TraFacturacionPeriodicaController{
	
    public function select($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $tra_fp_aseguradora = $parameter['tra_fp_aseguradora'] ?? 0;
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";

                    $filter1 = $parameter['filter1'] ?? "undefined";
                    if(empty($filter1)) $filter1 = "undefined";

                    $filter2 = $parameter['filter2'] ?? "undefined";
                    if(empty($filter2)) $filter2 = "undefined";

                    $filtrar = "";
                    if($tra_fp_aseguradora == "" || $tra_fp_aseguradora <= 0){
                        $filtrar = " and a.tra_fp_aseguradora > 0 ";
                    }else{
                        $filtrar = " and a.tra_fp_aseguradora = :tra_fp_aseguradora ";
                    }

                    $tra_fp_estado = $parameter['tra_fp_estado'] ?? 'A';

                    $monto = $utility->informacionOrdenTrabajo($PDO,"tra_orden_trabajo","$otra_no_consulta","$otra_no_orden","");
					//($monto[0]->monto) as importe_total,
                    $sql = " 
                    select 
                    a.tra_fp_correlativo,
                    a.tra_fp_no_consulta,  
                    a.tra_fp_no_orden,  
                    a.tra_fp_forma_pago,  
                    CONCAT('Q', a.tra_fp_monto) as tra_fp_monto,
                    a.tra_fp_monto as monto_servicio,
                    CONCAT('Q', (select sum(ot.otra_precio) as monto from tra_orden_trabajo ot where 1=1 and ot.otra_no_consulta = a.tra_fp_no_consulta  and ot.otra_no_orden = a.tra_fp_no_orden and ot.otra_estado !='E')) as importe_total_orden,
                    CONCAT('Q', (select otm.otra_total_otros as monto_otro from tra_orden_trabajo otm where 1=1 and otm.otra_no_consulta = a.tra_fp_no_consulta  and otm.otra_no_orden = a.tra_fp_no_orden and otm.otra_estado !='E' GROUP BY otm.otra_no_consulta)) as importe_otros_cobros,
                    a.tra_fp_aseguradora,  
                    ase.ase_nombre as nombre_cliente,
                    a.tra_fp_tipo_cupon,  
                    a.tra_fp_fac_correlativo,
                    fac.tra_fac_serie as tra_fp_serie,
                    fac.tra_fac_no_referencia as tra_fp_no_referencia,
                    fac.tra_fac_autorizacion as tra_fp_autorizacion,
                    date_format(fac.tra_fac_fecha_emision, '%d/%m/%Y') as tra_fp_fecha_fac, 
                    fac.tra_fac_monto as fac_monto,
                    fac.tra_fac_no_referencia as tra_fp_factura,
                    d.cat_nombre as cat_estado_nombre,
                    cat.cat_nombre as forma_pago,
                    con.tra_cm_cli_correlativo as cli_cliente,
                    cli.cli_nombre as cli_nombre_paciente,
                    obj.ocf_param_valor as plan_cliente,
                    a.tra_fp_estado,  
                    concat(b.usr_nombres,' ',b.usr_apellidos) as usuarioi,  
                    concat(c.usr_nombres,' ',c.usr_apellidos) as usuariom,  
                    a.tra_fp_fechai,  
                    date_format(a.tra_fp_fechai, '%d/%m/%Y') as fecha_registro, 
                    a.tra_fp_fecham  
                    from tra_formas_pago_ordenes_trabajo a
                    left outer join cfg_catalogo d on(a.tra_fp_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_catalogo cat on(a.tra_fp_forma_pago= cat.cat_valor and cat.cat_tipo = 'FORMAS_DE_PAGO' and cat.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.tra_fp_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.tra_fp_usuariom)
                    left outer join tra_consulta_medica con on (con.tra_cm_correlativo = a.tra_fp_no_consulta)
                    left outer join cfg_cliente cli on (cli.cli_correlativo = con.tra_cm_cli_correlativo)
                    left outer join cfg_objeto_config obj on (obj.ocf_correlativo = (select otra_plan from tra_orden_trabajo ot where ot.otra_no_consulta = a.tra_fp_no_consulta and ot.otra_no_orden = a.tra_fp_no_orden limit 1))
                    left outer join tra_factura fac on (fac.tra_fac_correlativo = a.tra_fp_fac_correlativo and fac.tra_fac_estado !='E')
                    left outer join cfg_aseguradora ase on (ase.ase_correlativo = a.tra_fp_aseguradora) 
                    where 
                    1=1
                    and a.tra_fp_estado = 'A'
                    $filtrar 
                    and ((a.tra_fp_no_consulta like concat('%',:filter,'%') or a.tra_fp_no_orden like concat('%',:filter,'%') or a.tra_fp_monto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                    and DATE_FORMAT(tra_fp_fechai, '%Y-%m-%d') BETWEEN :fecha_ini AND :fecha_fin ORDER BY DATE_FORMAT(tra_fp_fechai, '%Y-%m-%d') ASC
                    ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'tra_fp_estado' => $tra_fp_estado,
                    'tra_fp_aseguradora' => $tra_fp_aseguradora,
                    'emp_codigo' => $emp_codigo,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'filter' => $filter
                    /*'filter1' => $filter1,
                    'filter2' => $filter2*/
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_formas_pago_ordenes_trabajo a
                        left outer join cfg_catalogo d on(a.tra_fp_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_catalogo cat on(a.tra_fp_forma_pago= cat.cat_valor and cat.cat_tipo = 'FORMAS_DE_PAGO' and cat.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.tra_fp_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.tra_fp_usuariom)
                        left outer join tra_consulta_medica con on (con.tra_cm_correlativo = a.tra_fp_no_consulta)
                        left outer join cfg_cliente cli on (cli.cli_correlativo = con.tra_cm_cli_correlativo)
                        left outer join tra_factura fac on (fac.tra_fac_correlativo = a.tra_fp_fac_correlativo and fac.tra_fac_estado !='E')
                        ", " and a.tra_fp_estado = 'A'
                        and a.tra_fp_aseguradora = :tra_fp_aseguradora 
                        and ((a.tra_fp_no_consulta like concat('%',:filter,'%') or a.tra_fp_no_orden like concat('%',:filter,'%') or a.tra_fp_monto like concat('%',:filter,'%')) or (:filter = 'undefined'))
                        and DATE_FORMAT(tra_fp_fechai, '%Y-%m-%d') BETWEEN :fecha_ini AND :fecha_fin
                        ", 
                        [
                        'tra_fp_estado' => $tra_fp_estado,
                        'tra_fp_aseguradora' => $tra_fp_aseguradora,
                        'emp_codigo' => $emp_codigo,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'filter' => $filter
                        // 'filter1' => $filter1,
                        // 'filter2' => $filter2
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insert($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'nuevo');
                if($userFuncionality == 'OK'){
                    $cli_nombre=$parameter['cli_nombre'] ?? 'null';
                    $cli_email=$parameter['cli_email'] ?? 'null';
                    $cli_facturar=$parameter['cli_facturar'] ?? 'NA';
                    $cli_nit=$parameter['cli_nit'] ?? 'cf';
                    $cli_telefono1=$parameter['cli_telefono1'] ?? 'null';
                    $cli_telefono2=$parameter['cli_telefono2'] ?? 'null';
                    $cli_direccion=$parameter['cli_direccion'] ?? 'null';
                    $cli_estado=$parameter['cli_estado'] ?? 'A';

                    $cli_correlativo = $utility->CorrelAutomatico($PDO, "cfg_cliente", "cli_correlativo", "");
                    
                    $existeCorreo = 0;$existeNit = 0;
					$existeCorreo = $utility->buscarRegistro($PDO, "cfg_cliente", "cli_correlativo dato,cli_email", " and UPPER(cli_email)=UPPER(:valorCampo1) and cli_estado = 'A'",$cli_email);
                    
                    
                    if($cli_nit == "CF" || $cli_nit == "cf"){
                        $existeNit = 0;
                    }else{
                        $existeNit = $utility->buscarRegistro($PDO, "cfg_cliente", "cli_correlativo dato,cli_nit", " and UPPER(cli_nit)=UPPER(:valorCampo1) and cli_estado = 'A'",$cli_nit);
                    }
                    
                    
                    $sql = " insert into cfg_cliente (
                        					cli_correlativo, 
											cli_nombre, 
											cli_email, 
											cli_facturar, 
											cli_nit, 
											cli_telefono1, 
											cli_telefono2, 
											cli_direccion, 
											cli_estado, 
											cli_usuarioi, 
											cli_usuariom, 
											cli_fechai, 
											cli_fecham 

                                ) values(
                            				:cli_correlativo, 
											:cli_nombre, 
											:cli_email, 
											:cli_facturar, 
											:cli_nit, 
											:cli_telefono1, 
											:cli_telefono2, 
											:cli_direccion, 
											:cli_estado, 
											:id_usuario, 
											:id_usuario, 
											now(), 
											now() 

                        )
                    ";
                    $datosRegistrado = "";
                    if($existeCorreo > 0){
                        $datosRegistrado .= "Corre: ".$cli_email." ";
                    }
                    if($existeNit > 0){
                        $datosRegistrado .= "Nit: ".$cli_nit;
                    }

                    if($existeCorreo > 0 || $existeNit > 0){
                        $data = array('estado'=>'ERROR', 'mensaje'=>$datosRegistrado, 'status'=>400,'token'=>$token);//'Registro duplicado'
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(400);
                    }else{
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre' => $cli_nombre,
                        'cli_email' => $cli_email,
                        'cli_facturar' => $cli_facturar,
                        'cli_nit' => $cli_nit,
                        'cli_telefono1' => $cli_telefono1,
                        'cli_telefono2' => $cli_telefono2,
                        'cli_direccion' => $cli_direccion,
                        'cli_estado' => $cli_estado,
                        'id_usuario' => $id_usuario
                        ]);
                        
                        
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro registrado exitosamente', 'status'=>200,'token'=>$token,'key'=>$cli_correlativo);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser registrado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertFacturaCliente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $tra_fac_no_consulta = -1;//$parameter['tra_fac_no_consulta'] ?? 0;
                    $tra_fac_no_orden_trabajo = -1;//$parameter['tra_fac_no_orden'] ?? 0;
                    $tra_fac_monto = $parameter['tra_fac_monto'] ?? 0.00;
                    $tra_fac_serie = $parameter['tra_fac_serie'] ?? "";
                    $tra_fac_no_referencia = $parameter['tra_fac_no_referencia'] ?? "";
                    $tra_fac_autorizacion = $parameter['tra_fac_autorizacion'] ?? "";
                    $tra_fac_fecha_emision = $parameter['tra_fac_fecha_emision'] ?? NULL;
                    $tra_fac_aseguradora = $parameter['tra_fac_aseguradora'] ?? 0;
                    $data= $parameter['data'] ?? array();
                    
                    if($parameter['tra_fac_monto'] == ''){
                        $tra_fac_monto = 0.00;
                    }
                    if($parameter['tra_fac_fecha_emision'] == ''){
                        $tra_fac_fecha_emision = NULL;
                    }else{
                        $tra_fac_fecha_emision = explode("/",$tra_fac_fecha_emision);
                        $dia = $tra_fac_fecha_emision[0];
                        $mes = $tra_fac_fecha_emision[1];
                        $anio = $tra_fac_fecha_emision[2];
                        $tra_fac_fecha_emision = $anio."-".$mes."-".$dia;
                    }

                    $tra_fac_serie = $utility->validarLongitudString($tra_fac_serie, 0, 250);
                    $tra_fac_no_referencia = $utility->validarLongitudString($tra_fac_no_referencia, 0, 250);
                    $tra_fac_autorizacion = $utility->validarLongitudString($tra_fac_autorizacion, 0, 250);
                    $tra_fac_monto = $utility->validarLongitudString($tra_fac_monto, 0, 18);
                    
                    $tra_cm_etapa  = 1;
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';

                    //$montoAPagar = $utility->montoOrdenDeTrabajo($PDO, "tra_orden_trabajo", "otra_precio", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    //$montoPagado = $utility->montoPagoRealizado($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_monto", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    
                    $tra_fac_correlativo = $utility->CorrelAutomatico($PDO, "tra_factura", "tra_fac_correlativo", "");
                    
                    $tra_fac_claves = "";//array();
                    foreach($data as $value){
                        if(isset($value['tra_fp_correlativo'])){
                            $tra_fac_claves .= $value['tra_fp_correlativo'].',';
                            //$tra_fac_claves = $value['tra_fp_correlativo'];
                            //array_unshift($tra_fac_claves,$value['tra_fp_correlativo']);
                            //array_push($tra_fac_claves,$value['tra_fp_correlativo']);
                        }
                    }
                    $sql = 
                    "insert into tra_factura (
                                            tra_fac_correlativo, 
                                            tra_fac_no_consulta,
                                            tra_fac_no_orden_trabajo,
                                            tra_fac_monto,
                                            tra_fac_serie, 
                                            tra_fac_no_referencia,
                                            tra_fac_autorizacion,
                                            tra_fac_fecha_emision,
                                            tra_fac_aseguradora,
                                            tra_fac_claves,
                                            tra_fac_estado,
                                            tra_fac_usuarioi,
                                            tra_fac_usuariom,
                                            tra_fac_fechai,
                                            tra_fac_fecham
                                            ) values(
                                            :tra_fac_correlativo, 
                                            :tra_fac_no_consulta,
                                            :tra_fac_no_orden_trabajo,
                                            :tra_fac_monto,
                                            :tra_fac_serie, 
                                            :tra_fac_no_referencia,
                                            :tra_fac_autorizacion,
                                            :tra_fac_fecha_emision,
                                            :tra_fac_aseguradora,
                                            :tra_fac_claves,
                                            'A',
                                            :id_usuario, 
                                            :id_usuario, 
                                            now(), 
                                            now()
                                            )";
                    //}

                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'tra_fac_correlativo' => $tra_fac_correlativo,
                        'tra_fac_no_consulta' => $tra_fac_no_consulta,
                        'tra_fac_no_orden_trabajo' => $tra_fac_no_orden_trabajo,
                        'tra_fac_monto' => $tra_fac_monto, 
                        'tra_fac_serie' => $tra_fac_serie,
                        'tra_fac_no_referencia' => $tra_fac_no_referencia,
                        'tra_fac_autorizacion' => $tra_fac_autorizacion,
                        'tra_fac_fecha_emision' => $tra_fac_fecha_emision,
                        'tra_fac_aseguradora' => $tra_fac_aseguradora,
                        'id_usuario' => $id_usuario,
                        'tra_fac_claves' => $tra_fac_claves
                    ]);
                    if($result == true){
                        foreach($data as $value){
                            //$tra_rm_correlativo = $utility->CorrelAutomatico($PDO, "tra_receta_medica", "tra_rm_correlativo ", "");
                            if(isset($value['tra_fp_correlativo'])){$tra_fp_correlativo = $value['tra_fp_correlativo'];}
                            // if(isset($value['tra_fp_no_consulta'])){$tra_fp_no_consulta = $value['tra_fp_no_consulta'];}
                            // if(isset($value['tra_fp_no_orden'])){$tra_fp_no_orden = $value['tra_fp_no_orden'];}
                            $sqlU = "UPDATE tra_formas_pago_ordenes_trabajo SET 
                                                    tra_fp_fac_correlativo = :tra_fp_fac_correlativo 
                                                    WHERE tra_fp_correlativo = :tra_fp_correlativo";
                
                            $stmtU = $PDO->prepare($sqlU);
                            $resultU = $stmtU->execute([
                                'tra_fp_correlativo' => $tra_fp_correlativo,
                                'tra_fp_fac_correlativo' => $tra_fac_correlativo
                            ]);
                        }
                    }
                    if ($resultU == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Factura Registrada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'La Factura no pudo ser Registrada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function update($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'modificar');
                if($userFuncionality == 'OK'){
                    $cli_correlativo=(int)$parameter['cli_correlativo'] ?? 0;
                    $cli_nombre=$parameter['cli_nombre'] ?? 'null';
                    $cli_email=$parameter['cli_email'] ?? 'null';
                    $cli_facturar=$parameter['cli_facturar'] ?? 'null';
                    $cli_nit=$parameter['cli_nit'] ?? 'null';
                    $cli_telefono1=$parameter['cli_telefono1'] ?? 'null';
                    $cli_telefono2=$parameter['cli_telefono2'] ?? 'null';
                    $cli_direccion=$parameter['cli_direccion'] ?? 'null';
                    $cli_estado=$parameter['cli_estado'] ?? 'A';


                    $existeCorreo = $utility->buscarRegistro($PDO, "cfg_cliente", "cli_correlativo dato,cli_email", " and UPPER(cli_email)=UPPER(:valorCampo1) and cli_estado = 'A'",$cli_email);

                    if($cli_nit == "CF" || $cli_nit == "cf"){
                        $existeNit = 0;
                    }else{
                        $existeNit = $utility->buscarRegistro($PDO, "cfg_cliente", "cli_correlativo dato,cli_nit", " and UPPER(cli_nit)=UPPER(:valorCampo1) and cli_estado = 'A'",$cli_nit);
                    }
                    

                    $sql = " update cfg_cliente set
                        					cli_nombre = :cli_nombre,  
											cli_email = :cli_email,  
											cli_facturar = :cli_facturar,  
											cli_nit = :cli_nit,  
											cli_telefono1 = :cli_telefono1,  
											cli_telefono2 = :cli_telefono2,  
											cli_direccion = :cli_direccion,  
											cli_estado = :cli_estado,  
											cli_usuariom = :id_usuario,
											cli_fecham=now()  

                        where cli_correlativo=:cli_correlativo";
                    $datosRegistrado = "";
                    if($existeCorreo > 0){//&& $cli_correlativo <> $existeCorreo
                        $datosRegistrado .= "Corre: ".$cli_email." ";
                    }
                    if($existeNit > 0){//&& $cli_correlativo <> $existeNit
                        $datosRegistrado .= "Nit: ".$cli_nit;
                    }
                    if($cli_correlativo == $existeCorreo && $cli_correlativo == $existeNit){//
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre' => $cli_nombre,
                        'cli_email' => $cli_email,
                        'cli_facturar' => $cli_facturar,
                        'cli_nit' => $cli_nit,
                        'cli_telefono1' => $cli_telefono1,
                        'cli_telefono2' => $cli_telefono2,
                        'cli_direccion' => $cli_direccion,
                        'cli_estado' => $cli_estado,
                        'id_usuario' => $id_usuario
                        ]);
                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente'.$cli_correlativo.' '.$existeNit, 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        if(($existeCorreo > 0 && $cli_correlativo <> $existeCorreo) && ($existeNit > 0 && $cli_correlativo == $existeNit)){//|| $existeNit > 0
                            $data = array('estado'=>'ERROR', 'mensaje'=>$datosRegistrado, 'status'=>400,'token'=>$token);//'Registro duplicado'
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(400);
                        }else{//Registro no existe
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'cli_correlativo' => $cli_correlativo,
                                'cli_nombre' => $cli_nombre,
                                'cli_email' => $cli_email,
                                'cli_facturar' => $cli_facturar,
                                'cli_nit' => $cli_nit,
                                'cli_telefono1' => $cli_telefono1,
                                'cli_telefono2' => $cli_telefono2,
                                'cli_direccion' => $cli_direccion,
                                'cli_estado' => $cli_estado,
                                'id_usuario' => $id_usuario
                            ]);
                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente'.$cli_correlativo.' '.$existeNit, 'status'=>200,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function delete($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Cfg_cliente', 'eliminar');
                if($userFuncionality == 'OK'){
                    $cli_correlativo= (int)$parameter['cli_correlativo'] ?? 0;
                    
                    
                    $sql = " delete from cfg_cliente where cli_correlativo = :cli_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'cli_correlativo' => $cli_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Catalogo no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function getSign($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_recepcion', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $att_objeto_codigo = $parameter['att_objeto_codigo'] ?? 0;
                    $att_objeto = $parameter['att_objeto'] ?? 'no_object';
                    
                    $download_dir = DOWNLOAD_DIR_FIRMA;                    

					
                    $sql = "select concat('$download_dir', to_char(att_fechai,'YYYY'),'/',to_char(att_fechai,'MM'),att_archivo) as firma from tra_attachment
                    where 
                    att_objeto_codigo = :att_objeto_codigo and att_objeto = :att_objeto and att_estado = 'A'
                    ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['att_objeto' => $att_objeto,
                    'att_objeto_codigo' => $att_objeto_codigo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($result)) {
                        
                        $path = $result[0]->firma;
                        $type = pathinfo($path, PATHINFO_EXTENSION);
                        $data = file_get_contents($path);
                        $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
                        
                        
                        $data = array('estado'=>'OK', 'data'=>$base64, 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    
}
