<?php
namespace App\Controllers;
use App\DB\DBConnection;
use App\Utility\UtilityDB;
use PDOException;

class TraRecepcionPacienteController {

	public function selectConsulta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";*/
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $tra_cm_correlativo = $parameter['tra_cm_correlativo'] ?? 0;
                    $tra_cm_estado = 'A';//$parameter['tra_cm_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.tra_cm_correlativo, 
                    a.tra_cm_procedencia,  
                    a.tra_cm_aseguradora,  
                    a.tra_cm_primer_consulta,  
                    a.tra_cm_lugar_atencion,  
                    a.tra_cm_tipo_consulta,
                    a.tra_cm_usr_correl 
                    from tra_consulta_medica a 
                    where 
                    1=1 
                    and a.tra_cm_correlativo = :tra_cm_correlativo
                    and a.tra_cm_empresa = :emp_codigo 
                    and a.tra_cm_ambiente = :amb_codigo 
                    and a.tra_cm_estado = :tra_cm_estado 
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo' => $emp_codigo,
                        'amb_codigo' => $amb_codigo,
                        'tra_cm_correlativo' => $tra_cm_correlativo,
                        'tra_cm_estado' => $tra_cm_estado
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una especialidad'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_consulta_medica a
                            ", " 
                            and a.tra_cm_correlativo = :tra_cm_correlativo
		                    and a.tra_cm_empresa = :emp_codigo 
		                    and a.tra_cm_ambiente = :amb_codigo 
		                    and a.tra_cm_estado = :tra_cm_estado 
                            ", 
                            [
	                            'emp_codigo' => $emp_codigo,
		                        'amb_codigo' => $amb_codigo,
		                        'tra_cm_correlativo' => $tra_cm_correlativo,
		                        'tra_cm_estado' => $tra_cm_estado
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'No existen especialidades'));
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $tra_cm_correlativo = (int)$parameter['tra_cm_correlativo'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";

                    /*$filter1 = $parameter['filter1'] ?? "undefined";
                    if(empty($filter1)) $filter1 = "undefined";

                    $filter2 = $parameter['filter2'] ?? "undefined";
                    if(empty($filter2)) $filter2 = "undefined";*/


                    $cli_estado = 'A';//$parameter['cli_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.cli_correlativo, 
                    a.cli_nombre,  
                    a.cli_email,  
                    IFNULL(a.cli_facturar,'') as facturar,
                    IFNULL(a.cli_nit,'') as nit,  
                    a.cli_dpi,
                    a.cli_telefono1,  
                    a.cli_telefono2,  
                    a.cli_direccion,  
                    DATE_FORMAT(a.cli_fecha_nacimiento,'%d/%m/%Y') as fecha_nacimiento,
                    DATE_FORMAT(FROM_DAYS(TO_DAYS(NOW())-TO_DAYS(a.cli_fecha_nacimiento)), '%Y')+0 AS edad,
                    a.cli_edad,
                    IF(a.cli_responsable = 'null','',a.cli_responsable) as cli_responsable,
                    a.cli_estado_civil,
                    a.cli_religion,
                    a.cli_escolaridad,
                    a.cli_ocupacion,
                    a.cli_grupo_sanguineo,
                    d.cat_nombre cat_estado_nombre,  
                    cm.tra_cm_usr_correl,
                    a.cli_estado,  
                    concat(b.usr_nombres,' ',b.usr_apellidos) as cli_usuarioi,  
                    concat(c.usr_nombres,' ',c.usr_apellidos) as cli_usuariom,  
                    a.cli_fechai,  
                    a.cli_fecham  

                    from cfg_cliente a
                    left outer join cfg_catalogo d on(a.cli_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.cli_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.cli_usuariom)
                    left outer join tra_consulta_medica cm on (cm.tra_cm_correlativo = :tra_cm_correlativo)
                    where 
                    1=1
                    and a.cli_estado =:cli_estado
                    and ((a.cli_nombre like concat('%',:filter,'%') or a.cli_email like concat('%',:filter,'%') or a.cli_nit like concat('%',:filter,'%')) or (:filter = 'undefined'))

                     and (a.cli_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                     and (a.cli_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                     and cli_correlativo = :cli_correlativo 
                     limit $pag_inicio, $tamanio ";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'cli_estado' => $cli_estado,
                    'emp_codigo' => $emp_codigo,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'cli_estado' => $cli_estado,
                    'cli_correlativo' => $cli_correlativo,
                    'tra_cm_correlativo' => $tra_cm_correlativo,
                    'filter' => $filter
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_cliente a
                        left outer join cfg_catalogo d on(a.cli_estado= d.cat_valor and d.cat_tipo = 'CLIENTE_ESTADO' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.cli_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.cli_usuariom)
                        left outer join tra_consulta_medica cm on (cm.tra_cm_correlativo = :tra_cm_correlativo)
                        ", "   and a.cli_estado =:cli_estado 
                         and ((a.cli_nombre like concat('%',:filter,'%') or a.cli_email like concat('%',:filter,'%') or a.cli_nit like concat('%',:filter,'%')) or (:filter = 'undefined'))
                         and (a.cli_fechai >=STR_TO_DATE(:fecha_ini,'%d/%m/%y %T') OR :fecha_ini='01/01/1900') 
                         and (a.cli_fechai <=STR_TO_DATE(:fecha_fin,'%d/%m/%y %T') OR :fecha_fin='01/01/1900') 
                         and cli_correlativo = :cli_correlativo 
                        ", 
                        [
                        'cli_estado' => $cli_estado,
                        'emp_codigo' => $emp_codigo,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'cli_estado' => $cli_estado,
                        'cli_correlativo' => $cli_correlativo,
                        'tra_cm_correlativo' => $tra_cm_correlativo,
                        'filter' => $filter
                        ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectUsuarioCortesia($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    /*$parameter = $request->getParsedBody();
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $cli_correlativo = (int)$parameter['cli_correlativo'] ?? 0;
                    $tra_cm_correlativo = (int)$parameter['tra_cm_correlativo'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";*/

                    /*$filter1 = $parameter['filter1'] ?? "undefined";
                    if(empty($filter1)) $filter1 = "undefined";

                    $filter2 = $parameter['filter2'] ?? "undefined";
                    if(empty($filter2)) $filter2 = "undefined";*/


                    $objeto = 'Usuario_Autoriza_Cortesia';//$parameter['cli_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    *
                    from
                    cfg_usuario,
                    cfg_usuario_rol,
                    cfg_rol,
                    cfg_rol_funcionalidad,
                    cfg_funcionalidad,
                    cfg_funcionalidad_ambiente,
                    cfg_empresa
                    where
                    1=1
                    and usr_estado='A'
                    and rol_empresa=:emp_codigo
                    and uro_usuario = usr_codigo
                    and rol_codigo = uro_rol
                    and rol_estado = 'A'
                    and fun_empresa = :emp_codigo
                    and rof_rol = rol_codigo
                    and rol_ambiente =:amb_codigo
                    and fun_correlativo= rof_funcionalidad
                    and fua_funcionalidad = fun_correlativo
                    and fun_estado ='A'
                    and rof_estado='A'
                    and fua_ambiente = :amb_codigo
                    and fun_objeto = :objeto
                    and emp_codigo = rol_empresa
                    and emp_estado ='A'";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'objeto' => $objeto,
                    'emp_codigo' => $emp_codigo,
                    'amb_codigo' => $amb_codigo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("usr_correl"=>'','usr_nombres'=>'Seleccione un usuario'));
                        }else{
                            array_unshift($result,array("usr_correl"=>'','usr_nombres'=>'No existen usuarios'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function calcularMontoOrdenTrabajo($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $otra_no_consulta = (int)$parameter['otra_no_consulta'] ?? 0;
                    $otra_no_orden = (int)$parameter['otra_no_orden'] ?? 0;
                    //sum(select otra_precio from tra_orden_trabajo where otra_no_consulta = :otra_no_consulta and otra_no_orden = :otra_no_orden and otra_estado ='A') as importeTotal 
                    $sql = " 
                    select 
                    otra_cliente_porcentaje,
                    otra_paciente_porcentaje,
                    ROUND(sum(otra_precio),2) as importeTotal,
                    ROUND(IFNULL(otra_total_otros,0),2) as otra_total_otros,
                    ROUND(((sum(otra_precio)*(otra_paciente_porcentaje/100))+otra_total_otros),2) as importePaciente,
                    ROUND((sum(otra_precio)-ROUND(((sum(otra_precio)*(otra_paciente_porcentaje/100))+otra_total_otros),2)),2) as importeCliente,
                    ROUND(IFNULL((select sum(tra_fp_monto) from tra_formas_pago_ordenes_trabajo where tra_fp_no_consulta = :otra_no_consulta 
                    and tra_fp_no_orden = :otra_no_orden and tra_fp_aseguradora > 0 and tra_fp_estado ='A'),0),2) as montoPagadoCliente,

                    ROUND(IFNULL((select sum(tra_fp_monto) from tra_formas_pago_ordenes_trabajo where tra_fp_no_consulta = :otra_no_consulta 
                    and tra_fp_no_orden = :otra_no_orden and tra_fp_estado ='A' and tra_fp_aseguradora IS NULL),0),2) as montoPagadoPaciente 
                    from
                    tra_orden_trabajo
                    where
                    1=1
                    and otra_estado ='A'
                    and otra_no_consulta = :otra_no_consulta 
                    and otra_no_orden = :otra_no_orden";
                    //((importeTotal*otra_paciente_porcentaje)) as importePaciente 
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    'otra_no_consulta' => $otra_no_consulta,
                    'otra_no_orden' => $otra_no_orden
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectMedico($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = $request->getAttribute('id');
                $emp_codigo = $request->getAttribute('emp_codigo');
                $amb_codigo = $request->getAttribute('amb_codigo');
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $age_estado = 'A';//$parameter['ucf_estado'] ?? "A";

                    
                    $pag_inicio = 0;//$parameter['pag_inicio'] ?? 0;
                    $tamanio = 366;//$parameter['tamanio'] ?? 10;
                    $usr_tipo = 2;//$parameter['usr_tipo'] ?? 10;
                    $age_pro_correl = $parameter['age_pro_correl'] ?? 10;
                    $age_suc_correlativo = $parameter['age_suc_correlativo'] ?? 10;
                    
                    $filter = $parameter['filter'] ?? "undefined";
                    
                    $sql = " select 
                            age_correlativo,
                            age_usr_correl,
                            age_pro_correl,
                            age_suc_correlativo,
                            concat(u.usr_nombres,' ', u.usr_apellidos) as medico  
                            FROM cfg_agenda 
                            left outer join cfg_usuario u on (u.usr_correl = age_usr_correl and u.usr_empresa = $emp_codigo)
                            where 1=1 
                            and age_pro_correl = :age_pro_correl 
                            and age_suc_correlativo = :age_suc_correlativo 
                            and age_estado = :age_estado 
                            GROUP by age_usr_correl 
                            limit $pag_inicio, $tamanio";

                    //echo $sql;
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'age_suc_correlativo' => $age_suc_correlativo,
                        'age_pro_correl' => $age_pro_correl,
                        'age_estado'=>$age_estado
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("age_usr_correl"=>'','medico'=>'Seleccione un médico'));
                        }else{
                            array_unshift($result,array("age_usr_correl"=>'','medico'=>'No existen médicos asignados'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function selectItemOrdenTrabajo($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";*/
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $otra_no_consulta = $parameter['otra_no_consulta'] ?? 0;
                    $otra_no_orden = $parameter['otra_no_orden'] ?? 0;
                    $otra_estado = 'A';//$parameter['tra_cm_estado'] ?? 'A';

                    $sql = " 
                    select 
                    a.otra_correlativo, 
                    a.otra_cli_cliente,  
                    a.otra_no_consulta, 
                    a.otra_tipo_servicio, 
                    IF(cat.cat_nombre = 'Examen de Diagnóstico','Exámen',cat.cat_nombre) as tipo_servicio, 
                    pro.pro_nombre,
                    a.otra_producto,  
                    a.otra_precio,
                    a.otra_plan,
                    a.otra_cliente_porcentaje,
                    IF(a.otra_cliente_porcentaje > 0, a.otra_cliente_porcentaje/100,0) as porcentaje_cliente,
                    a.otra_paciente_porcentaje,
                    IF(a.otra_paciente_porcentaje > 0, a.otra_paciente_porcentaje/100,0) as porcentaje_paciente,
                    (a.otra_precio + a.otra_precio) as otra_monto_total,
                    (select sum(ROUND(otra_precio,2)) from tra_orden_trabajo ot where a.otra_no_consulta = ot.otra_no_consulta and ot.otra_estado = 'A') as importe,
                    (select sum(otra_precio) from tra_orden_trabajo ot2 where a.otra_no_consulta = ot2.otra_no_consulta and ot2.otra_estado = 'A') as importe_paciente,
                    a.otra_costo,
                    a.otra_total_otros,
                    a.otra_descripcion_total_otros   
                    from tra_orden_trabajo a 
                    INNER JOIN cfg_catalogo cat on(cat.cat_valor = a.otra_tipo_servicio && cat.cat_tipo = 'TIPO_SERVICIO' && cat.cat_estado = 'A')
                    INNER JOIN cfg_producto pro on(pro.pro_correl = a.otra_producto && pro.pro_estado = 'A')
                    where 
                    1=1 
                    and a.otra_no_consulta = :otra_no_consulta
                    and a.otra_no_orden = :otra_no_orden
                    and a.otra_empresa = :emp_codigo 
                    and a.otra_ambiente = :amb_codigo 
                    and a.otra_estado = :otra_estado 
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo' => $emp_codigo,
                        'amb_codigo' => $amb_codigo,
                        'otra_no_consulta' => $otra_no_consulta,
                        'otra_no_orden' => $otra_no_orden,
                        'otra_estado' => $otra_estado
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una especialidad'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_orden_trabajo a
                            INNER JOIN cfg_catalogo cat on(cat.cat_valor = a.otra_tipo_servicio && cat.cat_tipo = 'TIPO_SERVICIO' && cat.cat_estado = 'A')
                            INNER JOIN cfg_producto pro on(pro.pro_correl = a.otra_producto && pro.pro_estado = 'A')
                            ", " 
                            and a.otra_no_consulta = :otra_no_consulta
                            and a.otra_no_orden = :otra_no_orden
                            and a.otra_empresa = :emp_codigo 
                            and a.otra_ambiente = :amb_codigo 
                            and a.otra_estado = :otra_estado 
                            ", 
                            [
                                'emp_codigo' => $emp_codigo,
                                'amb_codigo' => $amb_codigo,
                                'otra_no_consulta' => $otra_no_consulta,
                                'otra_no_orden' => $otra_no_orden,
                                'otra_estado' => $otra_estado
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'No existen especialidades'));
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectFacturaPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";*/
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 10;
                    $tra_fac_no_consulta = $parameter['tra_fac_no_consulta'] ?? 0;
                    $tra_fac_no_orden_trabajo = $parameter['tra_fac_no_orden_trabajo'] ?? 0;
                    $tra_fac_estado = 'A';//$parameter['tra_cm_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.tra_fac_correlativo,
                    a.tra_fac_monto, 
                    a.tra_fac_serie,  
                    a.tra_fac_no_referencia,  
                    a.tra_fac_autorizacion, 
                    a.tra_fac_fecha_emision 
                    from tra_factura a 
                    where 
                    1=1 
                    and a.tra_fac_no_consulta = :tra_fac_no_consulta
                    and a.tra_fac_no_orden_trabajo = :tra_fac_no_orden_trabajo
                    and a.tra_fac_estado = :tra_fac_estado 
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_fac_no_consulta' => $tra_fac_no_consulta,
                        'tra_fac_no_orden_trabajo' => $tra_fac_no_orden_trabajo,
                        'tra_fac_estado' => $tra_fac_estado
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una especialidad'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_factura a
                            ", " 
                            and a.tra_fac_no_consulta = :tra_fac_no_consulta
                            and a.tra_fac_no_orden_trabajo = :tra_fac_no_orden_trabajo
                            and a.tra_fac_estado = :tra_fac_estado 
                            ", 
                            [
                                'tra_fac_no_consulta' => $tra_fac_no_consulta,
                                'tra_fac_no_orden_trabajo' => $tra_fac_no_orden_trabajo,
                                'tra_fac_estado' => $tra_fac_estado
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'No existen especialidades'));
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectFormaPago($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";*/
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 100;
                    $tra_fp_no_consulta = $parameter['tra_fp_no_consulta'] ?? 0;
                    $tra_fp_no_orden = $parameter['tra_fp_no_orden'] ?? 0;
                    $tra_fp_estado = 'A';//$parameter['tra_cm_estado'] ?? 'A';

                    
                    $sql = " 
                    select 
                    a.tra_fp_correlativo, 
                    a.tra_fp_forma_pago,  
                    a.tra_fp_monto,  
                    a.tra_fp_autorizado_por,
                    a.tra_fp_aseguradora,
                    a.tra_fp_tipo_cupon,
                    a.tra_fp_no_referencia,
                    cat.cat_nombre 
                    from tra_formas_pago_ordenes_trabajo a 
                    LEFT JOIN cfg_catalogo cat on(cat.cat_valor = a.tra_fp_forma_pago && cat.cat_tipo = 'FORMAS_DE_PAGO' && cat.cat_estado = 'A')
                    where 
                    1=1 
                    and a.tra_fp_no_consulta = :tra_fp_no_consulta
                    and a.tra_fp_no_orden = :tra_fp_no_orden
                    and a.tra_fp_estado = :tra_fp_estado ORDER BY a.tra_fp_correlativo ASC 
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'tra_fp_no_consulta' => $tra_fp_no_consulta,
                        'tra_fp_no_orden' => $tra_fp_no_orden,
                        'tra_fp_estado' => $tra_fp_estado
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    if (!empty($stmt)) {
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una especialidad'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "tra_formas_pago_ordenes_trabajo a
                            LEFT JOIN cfg_catalogo cat on(cat.cat_valor = a.tra_fp_forma_pago && cat.cat_tipo = 'FORMAS_DE_PAGO' && cat.cat_estado = 'A')
                            ", " 
                            and a.tra_fp_no_consulta = :tra_fp_no_consulta
                            and a.tra_fp_no_orden = :tra_fp_no_orden
                            and a.tra_fp_estado = :tra_fp_estado
                            ", 
                            [
                                'tra_fp_no_consulta' => $tra_fp_no_consulta,
                                'tra_fp_no_orden' => $tra_fp_no_orden,
                                'tra_fp_estado' => $tra_fp_estado
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'No existen especialidades'));
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectAseguradora($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $tra_cm_aseguradora = $parameter['tra_cm_aseguradora'] ?? 0;
                    $filtro = "";
                    if($tra_cm_aseguradora == 2){
                        $filtro = "";
                    }else{
                        $filtro = " and ase_correlativo = 0";
                        $tra_cm_aseguradora = 0;
                    }

                    $sql = " select   
                    ase_correlativo,  
                    ase_nombre,
                    ase_numero,
                    ase_correo,
                    ase_nit,
                    ase_direccion 
                    from cfg_aseguradora   
                    where 1 = 1  
                    $filtro 
                    and ase_empresa =:emp_codigo
                    and ase_ambiente =:amb_codigo
                    and ase_estado = 'A'
                    order by ase_nombre asc";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo    
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("ase_correlativo"=>'','ase_nombre'=>'Seleccione una opción'));
                        }else{
                            array_unshift($result,array("ase_correlativo"=>'','ase_nombre'=>'No existen aseguradoras'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectPlan($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                //$ocf_objeto_permiso = "Cfg_aseguradora";//$parameter['ocf_objeto_permiso'] ?? 'no_object';
                $utility = new UtilityDB();
                //$userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, $ocf_objeto_permiso, 'lectura');
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $ocf_objeto = $parameter['ocf_objeto'] ?? 'no_object';
                    $fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    //$pag_inicio = $parameter['pag_inicio'] ?? 0;
                    //$tamanio = $parameter['tamanio'] ?? 10;
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $ocf_estado = $parameter['ocf_estado'] ?? 'A';
                    $ocf_objeto_codigo = $parameter['ocf_objeto_codigo'] ?? 0;
					$type = $parameter['type'] ?? 'qry';

                    $sql = " 
                    select 
                    a.ocf_correlativo, 
                    a.ocf_codigo,  
                    a.ocf_cod_cat,  
                    a.ocf_empresa,  
                    a.ocf_objeto,  
                    a.ocf_objeto_codigo,  
                    a.ocf_orden,  
                    a.ocf_param_nombre,  
                    a.ocf_param_tipo,  
                    a.ocf_param_catalogo,  
                    a.ocf_param_valor,  
                    d.cat_nombre cat_estado_nombre, 
                    pro.pro_nombre nombre_especialidad,  
                    a.ocf_estado,  
                    a.ocf_porcentaje_uno,
                    a.ocf_porcentaje_dos,
                    (a.ocf_porcentaje_uno/100) as porcenta_cliente,
                    (a.ocf_porcentaje_dos/100) as porcenta_paciente,
                    concat(b.usr_nombres,' ', b.usr_apellidos) as ocf_usuarioi,  
                    concat(c.usr_nombres,' ', c.usr_apellidos) as ocf_usuariom,  
                    a.ocf_fechai,  
                    a.ocf_fecham  
                    from cfg_objeto_config a
                    left outer join cfg_catalogo d on(a.ocf_estado= d.cat_valor and d.cat_tipo = 'COLOCA_CATALOGO_AQUI' and d.cat_empresa = :emp_codigo)
                    left outer join cfg_usuario b on (b.usr_correl = a.ocf_usuarioi)
                    left outer join cfg_usuario c on (c.usr_correl = a.ocf_usuariom)
                    left outer join cfg_producto pro on (pro.pro_correl = a.ocf_param_tipo and pro.pro_clasificacion=2 and pro.pro_estado='A')
                    where 
                    1=1
					and a.ocf_empresa = :emp_codigo 
                    and a.ocf_estado =:ocf_estado
                    and a.ocf_objeto = :ocf_objeto
                    and a.ocf_objeto_codigo = :ocf_objeto_codigo
                    and (a.ocf_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                    and (a.ocf_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                    order by ocf_param_valor asc ";
                    //limit $pag_inicio, $tamanio
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute(['emp_codigo' => $emp_codigo,
                    'ocf_estado' => $ocf_estado,
                    'fecha_ini' => $fecha_ini,
                    'fecha_fin' => $fecha_fin,
                    'ocf_objeto'=>$ocf_objeto,
                    'ocf_objeto_codigo'=>$ocf_objeto_codigo
                    ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($result)) {
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_objeto_config a
                        left outer join cfg_catalogo d on(a.ocf_estado= d.cat_valor and d.cat_tipo = 'COLOCA_CATALOGO_AQUI' and d.cat_empresa = :emp_codigo)
                        left outer join cfg_usuario b on (b.usr_correl = a.ocf_usuarioi)
                        left outer join cfg_usuario c on (c.usr_correl = a.ocf_usuariom)
                        ", "   and a.ocf_empresa = :emp_codigo 
                        and a.ocf_estado =:ocf_estado
                        and a.ocf_objeto = :ocf_objeto
                        and a.ocf_objeto_codigo = :ocf_objeto_codigo
                        and (a.ocf_fechai >=str_to_date(:fecha_ini,'%d,%m,%Y') OR :fecha_ini='01/01/1900') 
                        and (a.ocf_fechai <=str_to_date(:fecha_fin,'%d,%m,%Y') OR :fecha_fin='01/01/1900') 
                        ", 
                        ['emp_codigo' => $emp_codigo,
                        'ocf_estado' => $ocf_estado,
                        'fecha_ini' => $fecha_ini,
                        'fecha_fin' => $fecha_fin,
                        'ocf_objeto'=>$ocf_objeto,
                        'ocf_objeto_codigo'=>$ocf_objeto_codigo
                        ]);
                        
                        if($type == 'cmb'){
                            array_unshift($result,array("ocf_correlativo"=>'','ocf_param_valor'=>'Seleccione una opción'));
                        }

                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{

                        if($type == 'cmb'){
                            array_unshift($result,array("ocf_correlativo"=>'','ocf_param_valor'=>'No Existen Planes Definidos...'));
                        }
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectServicio($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');

                $prp_cod_aseg = 4;
                $prp_plan = 9;
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    $pro_clasificacion = $parameter['pro_clasificacion'] ?? 0;
                    //LEFT JOIN cfg_producto_plan cpp on(cpp.prp_cod_prod = 1 and cpp.prp_cod_aseg = :prp_cod_aseg and cpp.prp_plan = :prp_plan)     
                    $sql = " select   
                    pro_correl,   
                    pro_nombre 
                    from cfg_producto   
                    where 1 = 1  
                    and pro_empresa =:emp_codigo
                    and pro_ambiente =:amb_codigo
                    and pro_estado = 'A'
                    and pro_clasificacion = :pro_clasificacion 
                    order by pro_nombre asc";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo,
                        'pro_clasificacion'=>$pro_clasificacion
                        //'prp_plan'=>$prp_plan
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una opción'));
                        }else{
                            array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'No existen datos'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectPrecio($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();

                    $prp_cod_aseg = $parameter['prp_cod_aseg'] ?? 0;
                    $plan = $parameter['plan'] ?? 0;
                    $prp_cod_prod = $parameter['prp_cod_prod'] ?? 0;
                    $consulta = $parameter['consulta'] ?? 0;
                    //$prp_cod_aseg = 4;
                    //$prp_plan = 9;
                    //LEFT JOIN cfg_producto_plan cpp on(cpp.prp_cod_prod = 1 and cpp.prp_cod_aseg = :prp_cod_aseg and cpp.prp_plan = :prp_plan)     
                    /*$sql = " select   
                    pro_correl 
                    from cfg_producto 
                    where 1 = 1  
                    and pro_empresa =:emp_codigo
                    and pro_ambiente =:amb_codigo
                    and pro_estado = 'A' 
                    and pro_correl = :prp_cod_prod 
                    order by pro_nombre asc";*/
                    $sql = " select   
                    prp_precio,
                    proc.cpro_costo as prp_costo  
                    from cfg_producto_plan  
                    LEFT JOIN tra_consulta_medica cm on(cm.tra_cm_correlativo = :tra_cm_correlativo) 
                    LEFT JOIN cfg_producto_costo proc on(proc.cpro_cod_producto = :prp_cod_prod and proc.cpro_cod_centro = cm.tra_cm_lugar_atencion and proc.cpro_estado = 'A') 
                    where 1 = 1  
                    and prp_empresa = :emp_codigo
                    and prp_ambiente = :amb_codigo
                    and prp_estado = 'A' 
                    and prp_cod_aseg = :prp_cod_aseg 
                    and prp_cod_prod = :prp_cod_prod 
                    order by prp_correlativo asc";
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                        'emp_codigo'=>$emp_codigo,
                        'amb_codigo'=>$amb_codigo,
                        'prp_cod_prod'=>$prp_cod_prod,
                        'prp_cod_aseg'=>$prp_cod_aseg,
                        'tra_cm_correlativo'=>$consulta
                    ]);
                    
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        $totalRegistros =$stmt->rowCount();
                        if($totalRegistros > 0){
                            //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una opción'));
                        }else{
                            //array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'No existen datos'));
                        }
                        
                        $data = array('estado'=>'OK', 'data'=>$result,'mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos','mensaje'=> $stmt, 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function selectExamen($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'lectura');
                if($userFuncionality == 'OK'){
                    $parameter = $request->getParsedBody();
                    /*$fecha_ini = $parameter['fecha_ini'] ?? "01/01/1900";
                    $fecha_fin = $parameter['fecha_fin'] ?? "01/01/1900";
                    $filter = $parameter['filter'] ?? "undefined";
                    if(empty($filter)) $filter = "undefined";
                    $pro_estado = $parameter['pro_estado'] ?? 'A';*/
                    $pag_inicio = $parameter['pag_inicio'] ?? 0;
                    $tamanio = $parameter['tamanio'] ?? 100;
                    $pro_tipo_laboratorio = $parameter['pro_tipo_laboratorio'] ?? 'A';
                    $pro_clasificacion = 1;

                    
                    $sql = " 
                    select 
                    a.pro_correl, 
                    a.pro_nombre 
                    from cfg_producto a
                    where 
                    1=1
                    and a.pro_empresa = :emp_codigo 
                    and a.pro_ambiente = :amb_codigo 
                    and a.pro_clasificacion = :pro_clasificacion 
                    and a.pro_tipo_laboratorio = :pro_tipo_laboratorio 
                    and (a.pro_estado = 'A') 
                    limit $pag_inicio, $tamanio";
                    
                    $stmt = $PDO->prepare($sql);
                    $stmt->execute([
                    	'emp_codigo' => $emp_codigo,
                    	'amb_codigo' => $amb_codigo,
                        'pro_clasificacion' => $pro_clasificacion,
                        'pro_tipo_laboratorio' => $pro_tipo_laboratorio
                        ]);
                    $result = $stmt->fetchAll($PDO::FETCH_OBJ);
                    
                    if (!empty($stmt)) {
                        array_unshift($result,array("pro_correl"=>'','pro_nombre'=>'Seleccione una opción'));
                        $totalRegistros =$utility->RegistrosTotal($PDO, "cfg_producto a
                            ", "   and a.pro_empresa = :emp_codigo 
				                    and a.pro_ambiente = :amb_codigo 
				                    and a.pro_clasificacion = :pro_clasificacion 
				                    and a.pro_tipo_laboratorio = :pro_tipo_laboratorio 
				                    and (a.pro_estado = 'A') 
                            ", 
                            [
                            	'emp_codigo' => $emp_codigo,
		                    	'amb_codigo' => $amb_codigo,
		                        'pro_clasificacion' => $pro_clasificacion,
		                        'pro_tipo_laboratorio' => $pro_tipo_laboratorio
                            ]);
                        
                        $data = array('estado'=>'OK', 'data'=>$result, 'status'=>200,'token'=>$token,'totalRegistros'=>$totalRegistros);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'NODATA', 'mensaje'=>'No existen datos', 'status'=>200,'token'=>$token,'totalRegistros'=>"0");
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
            
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(200);
        }
        return $response;
    }
    public function insertServicio($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $otra_no_consulta = $parameter['tra_cm_correlativo'] ?? 0;
                    $otra_aseguradora = $parameter['tra_cm_aseguradora'] ?? 0;
                    $otra_plan = $parameter['tra_cm_plan_salud'] ?? 0;
                    $otra_no_orden = $parameter['tra_cm_no_orden'] ?? 0;
                    $otra_porcentaje_cliente = $parameter['otra_porcentaje_cliente'] ?? 0;
                    $otra_porcentaje_paciente = $parameter['otra_porcentaje_paciente'] ?? 0;
                    
                    
                    //OTROS COBROS VALIDAR
                    $otra_descripcion_total_otros = $parameter['tra_oc_descripcion'] ?? NULL;
                    $otra_total_otros = $parameter['tra_oc_monto'] ?? 0;
                    
                    $data= $parameter['data'] ?? array();
                    
                    $tra_cm_etapa  = 1;
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';
                    
                    
                    //$tra_cm_procedencia = $utility->validarLongitudString($tra_cm_procedencia, 0, 11);
                    $otra_aseguradora = $utility->validarLongitudString($otra_aseguradora, 0, 11);
                    $otra_plan = $utility->validarLongitudString($otra_plan, 0, 11);

                    $sql = " update tra_consulta_medica set 
                            tra_cm_usuariom = :id_usuario 
                            where
                            tra_cm_correlativo=:otra_no_consulta";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'otra_no_consulta' => $otra_no_consulta,
                        'id_usuario' => $id_usuario
                        ]);
                    
                    
                    foreach($data as $value){
                        $otra_correlativo = $utility->CorrelAutomatico($PDO, "tra_orden_trabajo", "otra_correlativo", "");
                        if(isset($value['tra_cm_id_producto'])){$otra_producto = $value['tra_cm_id_producto'];}
                        if(isset($value['tra_cm_id_tipo_servicio'])){$otra_tipo_servicio = $value['tra_cm_id_tipo_servicio'];}
                        if(isset($value['tra_cm_precio'])){$otra_precio = $value['tra_cm_precio'];}
                        if(isset($value['tra_cm_costo'])){$otra_costo = $value['tra_cm_costo'];}
                        
                        $sql = 
                        "insert into tra_orden_trabajo (
                                                otra_correlativo, 
                                                otra_empresa,
                                                otra_ambiente,
                                                otra_cli_cliente, 
                                                otra_no_consulta,
                                                otra_aseguradora,
                                                otra_plan,
                                                otra_tipo_servicio,
                                                otra_producto,
                                                otra_no_orden,
                                                otra_precio,
                                                otra_costo,
                                                otra_total_otros,
                                                otra_descripcion_total_otros,
                                                otra_porcentaje_cliente,
                                                otra_porcentaje_paciente,
                                                otra_total_cliente,
                                                otra_total_paciente,
                                                otra_estado,
                                                otra_usuarioi,
                                                otra_usuariom,
                                                otra_fechai,
                                                otra_fecham
                                                ) values(
                                                :otra_correlativo, 
                                                :otra_empresa,
                                                :otra_ambiente,
                                                :otra_cli_cliente, 
                                                :otra_no_consulta,
                                                :otra_aseguradora,
                                                :otra_plan,
                                                :otra_tipo_servicio,
                                                :otra_producto,
                                                :otra_no_orden,
                                                :otra_precio,
                                                :otra_costo,
                                                :otra_total_otros,
                                                :otra_descripcion_total_otros,
                                                :otra_porcentaje_cliente,
                                                :otra_porcentaje_paciente,
                                                0,
                                                0,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
            
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'otra_correlativo' => $otra_correlativo,
                            'otra_empresa' => $emp_codigo,
                            'otra_ambiente' => $amb_codigo,
                            'otra_cli_cliente' => 0, //solucionar
                            'otra_no_consulta' => $otra_no_consulta,
                            'otra_aseguradora' => $otra_aseguradora,
                            'otra_plan' => $otra_plan,
                            'otra_tipo_servicio' => $otra_tipo_servicio,
                            'otra_producto' => $otra_producto,
                            'otra_no_orden' => $otra_no_orden,
                            'otra_precio' => $otra_precio,
                            'otra_costo' => $otra_costo,
                            'otra_total_otros' => $otra_total_otros,
                            'otra_descripcion_total_otros' => $otra_descripcion_total_otros,
                            'otra_porcentaje_cliente' => $otra_porcentaje_cliente,
                            'otra_porcentaje_paciente' => $otra_porcentaje_paciente,
                            'id_usuario' => $id_usuario
                        ]);
                    }

                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function insertServicioOrdenTrabajo($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $registrarServicio = false;
                    
                    $otra_no_consulta = $parameter['tra_cm_correlativo'] ?? 0;
                    $otra_aseguradora = $parameter['tra_cm_aseguradora'] ?? 0;
                    $otra_plan = $parameter['tra_cm_plan_salud'] ?? 0;
                    $otra_no_orden = $parameter['tra_cm_no_orden'] ?? 0;
                    $otra_porcentaje_cliente = $parameter['otra_porcentaje_cliente'] ?? 0;
                    $otra_porcentaje_paciente = $parameter['otra_porcentaje_paciente'] ?? 0;

                    $otra_producto = $parameter['otra_producto'] ?? 0;
                    $otra_tipo_servicio = $parameter['otra_tipo_servicio'] ?? 0;

                    $otra_cliente_porcentaje = $parameter['otra_cliente_porcentaje'] ?? 0;
                    $otra_paciente_porcentaje = $parameter['otra_paciente_porcentaje'] ?? 0;

                    $otra_precio = $parameter['otra_precio'] ?? 0.00;
                    if($parameter['otra_precio'] == ''){
                        $otra_precio = 0.00;
                    }

                    $otra_costo = $parameter['otra_costo'] ?? 0.00;
                    if($parameter['otra_costo'] == ''){
                        $otra_costo = 0.00;
                    }
                    
                    
                    //OTROS COBROS VALIDAR
                    $otra_descripcion_total_otros = $parameter['tra_oc_descripcion'] ?? NULL;
                    $otra_total_otros = $parameter['tra_oc_monto'] ?? NULL;
                    if($parameter['tra_oc_monto'] == ''){
                        $otra_total_otros = 0.00;
                    }

                    
                    $tra_cm_etapa  = 1;
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';
                    
                
                    $otra_aseguradora = $utility->validarLongitudString($otra_aseguradora, 0, 11);
                    $otra_plan = $utility->validarLongitudString($otra_plan, 0, 11);

                    $sql = " update tra_consulta_medica set 
                            tra_cm_usuariom = :id_usuario 
                            where
                            tra_cm_correlativo=:otra_no_consulta";
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'otra_no_consulta' => $otra_no_consulta,
                        'id_usuario' => $id_usuario
                        ]);
                    
                    //MOISESAJU

                    $codigoPlanAseguradora = $utility->verificarPlanAseguradora($PDO, "tra_orden_trabajo", "otra_plan", $otra_no_consulta, $otra_no_orden, "");
                    $planActual = $utility->nombrePlan($PDO, "cfg_objeto_config", "ocf_param_valor", $codigoPlanAseguradora, "");
                    $planNuevo = $utility->nombrePlan($PDO, "cfg_objeto_config", "ocf_param_valor", $otra_plan, "");
                    //echo $codigoPlanAseguradora;
                        $otra_correlativo = $utility->CorrelAutomatico($PDO, "tra_orden_trabajo", "otra_correlativo", "");
                        
                        $sql = 
                        "insert into tra_orden_trabajo (
                                                otra_correlativo, 
                                                otra_empresa,
                                                otra_ambiente,
                                                otra_cli_cliente, 
                                                otra_no_consulta,
                                                otra_aseguradora,
                                                otra_plan,
                                                otra_cliente_porcentaje,
                                                otra_paciente_porcentaje,
                                                otra_tipo_servicio,
                                                otra_producto,
                                                otra_no_orden,
                                                otra_precio,
                                                otra_costo,
                                                otra_total_otros,
                                                otra_descripcion_total_otros,
                                                otra_total_cliente,
                                                otra_total_paciente,
                                                otra_estado,
                                                otra_usuarioi,
                                                otra_usuariom,
                                                otra_fechai,
                                                otra_fecham
                                                ) values(
                                                :otra_correlativo, 
                                                :otra_empresa,
                                                :otra_ambiente,
                                                :otra_cli_cliente, 
                                                :otra_no_consulta,
                                                :otra_aseguradora,
                                                :otra_plan,
                                                :otra_cliente_porcentaje,
                                                :otra_paciente_porcentaje,
                                                :otra_tipo_servicio,
                                                :otra_producto,
                                                :otra_no_orden,
                                                :otra_precio,
                                                :otra_costo,
                                                :otra_total_otros,
                                                :otra_descripcion_total_otros,
                                                0,
                                                0,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
                    
                    if($codigoPlanAseguradora == 0){
                        $registrarServicio = true;
                    }else if($otra_plan == $codigoPlanAseguradora){
                        $registrarServicio = true;
                    }

                    if($registrarServicio == true){//true
                        $actualizarOtrosCobros = $utility->actualizarOtrosCobros($PDO, "tra_orden_trabajo", "$otra_total_otros","$otra_descripcion_total_otros", $otra_no_consulta, $otra_no_orden, "");
                        $stmt = $PDO->prepare($sql);
                        $result = $stmt->execute([
                            'otra_correlativo' => $otra_correlativo,
                            'otra_empresa' => $emp_codigo,
                            'otra_ambiente' => $amb_codigo,
                            'otra_cli_cliente' => 0, //solucionar
                            'otra_no_consulta' => $otra_no_consulta,
                            'otra_aseguradora' => $otra_aseguradora,
                            'otra_plan' => $otra_plan,
                            'otra_tipo_servicio' => $otra_tipo_servicio,
                            'otra_producto' => $otra_producto,
                            'otra_no_orden' => $otra_no_orden,
                            'otra_precio' => $otra_precio,
                            'otra_costo' => $otra_costo,
                            'otra_total_otros' => $otra_total_otros,
                            'otra_descripcion_total_otros' => $otra_descripcion_total_otros,
                            'otra_cliente_porcentaje' => $otra_cliente_porcentaje,
                            'otra_paciente_porcentaje' => $otra_paciente_porcentaje,
                            'id_usuario' => $id_usuario
                        ]);
                        

                        if ($result == true) {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        $data = array('estado'=>'WARNING', 'mensaje'=>'Esta intentando registrar un producto/servicio con el plan: '.$planNuevo.' , Actualmente ya existen servicios registrados con el plan:'.$planActual.' ,si desea registrar este producto/servicio con el plan: '.$planNuevo.' debe eliminar el producto/servicio registrado con anterioridad.', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }

                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function updateOtrosCobros($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $registrarServicio = false;
                    $otra_no_consulta = $parameter['tra_cm_correlativo'] ?? 0;
                    $otra_aseguradora = $parameter['tra_cm_aseguradora'] ?? 0;
                    $otra_plan = $parameter['tra_cm_plan_salud'] ?? 0;
                    $otra_no_orden = $parameter['tra_cm_no_orden'] ?? 0;
                    $otra_porcentaje_cliente = $parameter['otra_porcentaje_cliente'] ?? 0;
                    $otra_porcentaje_paciente = $parameter['otra_porcentaje_paciente'] ?? 0;

                    $otra_producto = $parameter['otra_producto'] ?? 0;
                    $otra_tipo_servicio = $parameter['otra_tipo_servicio'] ?? 0;

                    $otra_cliente_porcentaje = $parameter['otra_cliente_porcentaje'] ?? 0;
                    $otra_paciente_porcentaje = $parameter['otra_paciente_porcentaje'] ?? 0;

                    $otra_precio = $parameter['otra_precio'] ?? 0.00;
                    if($parameter['otra_precio'] == ''){
                        $otra_precio = 0.00;
                    }

                    $otra_costo = $parameter['otra_costo'] ?? 0.00;
                    if($parameter['otra_costo'] == ''){
                        $otra_costo = 0.00;
                    }
                    
                    
                    //OTROS COBROS VALIDAR
                    $otra_descripcion_total_otros = $parameter['tra_oc_descripcion'] ?? NULL;
                    $otra_total_otros = $parameter['tra_oc_monto'] ?? NULL;
                    if($parameter['tra_oc_monto'] == ''){
                        $otra_total_otros = 0.00;
                    }
                    
                    $tra_cm_etapa  = 1;
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';
                    
                    
                    //$tra_cm_procedencia = $utility->validarLongitudString($tra_cm_procedencia, 0, 11);
                    $otra_aseguradora = $utility->validarLongitudString($otra_aseguradora, 0, 11);
                    $otra_plan = $utility->validarLongitudString($otra_plan, 0, 11);

                    
                    
                    $codigoPlanAseguradora = $utility->verificarPlanAseguradora($PDO, "tra_orden_trabajo", "otra_plan", $otra_no_consulta, $otra_no_orden, "");
                    $planActual = $utility->nombrePlan($PDO, "cfg_objeto_config", "ocf_param_valor", $codigoPlanAseguradora, "");
                    $planNuevo = $utility->nombrePlan($PDO, "cfg_objeto_config", "ocf_param_valor", $otra_plan, "");

                    $otra_correlativo = $utility->CorrelAutomatico($PDO, "tra_orden_trabajo", "otra_correlativo", "");
                    
                    if($codigoPlanAseguradora == 0){
                        $registrarServicio = true;
                    }else if($otra_plan == $codigoPlanAseguradora){
                        $registrarServicio = true;
                    }

                    if($registrarServicio == true){
                        
                        $actualizarOtrosCobros = $utility->actualizarOtrosCobros($PDO, "tra_orden_trabajo", "$otra_total_otros","$otra_descripcion_total_otros", $otra_no_consulta, $otra_no_orden, "");

                        if ($actualizarOtrosCobros == "OK") {
                            $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(200);
                        }else{
                            $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        $data = array('estado'=>'WARNING', 'mensaje'=>'Esta intentando Actualizar otros cobros con el plan: '.$planNuevo.' , Actualmente ya existen servicios registrados con el plan:'.$planActual.' ,no es posible actualizar otros cobros.', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }

                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertPagoEfectivo($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $registrarPago = false;
                    $tra_fp_no_consulta = $parameter['tra_fp_no_consulta'] ?? 0;
                    $tra_fp_no_orden = $parameter['tra_fp_no_orden'] ?? 0;
                    $tra_fp_forma_pago = $parameter['tra_fp_forma_pago'] ?? 0;
                    $tra_fp_monto = $parameter['tra_fp_monto'] ?? 0;
                    
                    if($parameter['tra_fp_monto'] == ''){
                        $tra_fp_monto = 0.00;
                    }
                    
                    //$data= $parameter['data'] ?? array();
                    
                    $tra_fp_fecha_movimiento  = NULL;
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';

                    $tra_fp_monto = $utility->validarLongitudString($tra_fp_monto, 0, 18);
                    $dataOT = $utility->calcularMontoOrdenTra($PDO, "tra_orden_trabajo", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    //$montoTotalaPagar = $utility->montoOrdenDeTrabajo($PDO, "tra_orden_trabajo", "otra_precio", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    //$montoPagado = $utility->montoPagoRealizado($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_monto", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    
                        $tra_fp_correlativo = $utility->CorrelAutomatico($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_correlativo", "");
                        
                        $sql = 
                        "insert into tra_formas_pago_ordenes_trabajo (
                                                tra_fp_correlativo, 
                                                tra_fp_no_consulta,
                                                tra_fp_no_orden,
                                                tra_fp_forma_pago, 
                                                tra_fp_monto,
                                                tra_fp_fecha_movimiento,
                                                tra_fp_estado,
                                                tra_fp_usuarioi,
                                                tra_fp_usuariom,
                                                tra_fp_fechai,
                                                tra_fp_fecham
                                                ) values(
                                                :tra_fp_correlativo, 
                                                :tra_fp_no_consulta,
                                                :tra_fp_no_orden,
                                                :tra_fp_forma_pago, 
                                                :tra_fp_monto,
                                                :tra_fp_fecha_movimiento,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
                    //if(($montoPagado+$tra_fp_monto) > $montoTotalaPagar){
                    if(
                        round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2) > round($dataOT[0]->importeTotal,2)
                    ){
                        $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar: Q'.round(($dataOT[0]->importeTotal-($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente)),2).'', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }else{
                        if($tra_fp_forma_pago > 1){
                            if(round(($tra_fp_monto+$dataOT[0]->montoPagadoPaciente),2) <= round($dataOT[0]->importePaciente,2)){
                                $registrarPago = true;
                            }
                        }else{
                            if(round(($tra_fp_monto+$dataOT[0]->montoPagadoCliente),2) <= round($dataOT[0]->importeCliente,2)){
                                $registrarPago = true;
                            }
                        }
                        if($registrarPago == true){
                            $montoTotalPagado = round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2);
                            $resultado = round($dataOT[0]->importeTotal,2)-round($montoTotalPagado,2);
                            if($resultado <= 0){
                                $sqlU = "update tra_consulta_medica set tra_cm_etapa = 3 where tra_cm_correlativo = :tra_cm_correlativo";
                                $stmtU = $PDO->prepare($sqlU);
                                $resultU = $stmtU->execute([
                                    'tra_cm_correlativo' => $tra_fp_no_consulta
                                ]);
                            }
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'tra_fp_correlativo' => $tra_fp_correlativo,
                                'tra_fp_no_consulta' => $tra_fp_no_consulta,
                                'tra_fp_no_orden' => $tra_fp_no_orden,
                                'tra_fp_forma_pago' => $tra_fp_forma_pago,
                                'tra_fp_monto' => $tra_fp_monto,
                                'id_usuario' => $id_usuario,
                                'tra_fp_fecha_movimiento' => $tra_fp_fecha_movimiento
                            ]);

                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Pago Registrado exitosamente', 'status'=>200,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'El pago no pudo ser Registrado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }else{
                            $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar por el paciente: Q'.round(($dataOT[0]->importePaciente-($dataOT[0]->montoPagadoPaciente)),2).'', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);    
                        }
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertPagoCortesia($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $registrarPago = false;
                    $tra_fp_no_consulta = $parameter['tra_fp_no_consulta'] ?? 0;
                    $tra_fp_no_orden = $parameter['tra_fp_no_orden'] ?? 0;
                    $tra_fp_forma_pago = $parameter['tra_fp_forma_pago'] ?? 0;
                    $tra_fp_autorizado_por = $parameter['tra_fp_autorizado_por'] ?? 0;
                    $tra_fp_monto = (double)$parameter['tra_fp_monto'] ?? 0;
                    
                    if($parameter['tra_fp_monto'] == ''){
                        $tra_fp_monto = 0.00;
                    }
                    
                    //$data= $parameter['data'] ?? array();
                    
                    $tra_fp_fecha_movimiento  = NULL;
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';

                    $tra_fp_monto = $utility->validarLongitudString($tra_fp_monto, 0, 19);

                    $dataOT = $utility->calcularMontoOrdenTra($PDO, "tra_orden_trabajo", $tra_fp_no_consulta, $tra_fp_no_orden, "");

                    $tra_fp_correlativo = $utility->CorrelAutomatico($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_correlativo", "");
                      
                        $sql = 
                        "insert into tra_formas_pago_ordenes_trabajo (
                                                tra_fp_correlativo, 
                                                tra_fp_no_consulta,
                                                tra_fp_no_orden,
                                                tra_fp_forma_pago, 
                                                tra_fp_monto,
                                                tra_fp_autorizado_por,
                                                tra_fp_fecha_movimiento,
                                                tra_fp_estado,
                                                tra_fp_usuarioi,
                                                tra_fp_usuariom,
                                                tra_fp_fechai,
                                                tra_fp_fecham
                                                ) values(
                                                :tra_fp_correlativo, 
                                                :tra_fp_no_consulta,
                                                :tra_fp_no_orden,
                                                :tra_fp_forma_pago, 
                                                :tra_fp_monto,
                                                :tra_fp_autorizado_por,
                                                :tra_fp_fecha_movimiento,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
                    //if(($montoPagadoPaciente+$montoPagadoCliente+$tra_fp_monto) > $montoTotalaPagar){
                    if(
                        round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2) > round($dataOT[0]->importeTotal,2)
                    ){
                    
                        $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar: Q'.round(($dataOT[0]->importeTotal-($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente)),2).'', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }else{
                        if($tra_fp_forma_pago > 1){
                            if(round(($tra_fp_monto+$dataOT[0]->montoPagadoPaciente),2) <= round($dataOT[0]->importePaciente,2)){
                                $registrarPago = true;
                            }
                        }else{
                            if(round(($tra_fp_monto+$dataOT[0]->montoPagadoCliente),2) <= round($dataOT[0]->importeCliente,2)){
                                $registrarPago = true;
                            }
                        }
                        if($registrarPago == true){
                            $montoTotalPagado = round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2);
                            $resultado = round($dataOT[0]->importeTotal,2)-round($montoTotalPagado,2);
                            if($resultado <= 0){
                                $sqlU = "update tra_consulta_medica set tra_cm_etapa = 3 where tra_cm_correlativo = :tra_cm_correlativo";
                                $stmtU = $PDO->prepare($sqlU);
                                $resultU = $stmtU->execute([
                                    'tra_cm_correlativo' => $tra_fp_no_consulta
                                ]);
                            }
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'tra_fp_correlativo' => $tra_fp_correlativo,
                                'tra_fp_no_consulta' => $tra_fp_no_consulta,
                                'tra_fp_no_orden' => $tra_fp_no_orden,
                                'tra_fp_forma_pago' => $tra_fp_forma_pago,
                                'tra_fp_autorizado_por' => $tra_fp_autorizado_por,
                                'tra_fp_monto' => $tra_fp_monto,
                                'id_usuario' => $id_usuario,
                                'tra_fp_fecha_movimiento' => $tra_fp_fecha_movimiento
                            ]);

                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Pago Registrado exitosamente', 'status'=>200,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'El pago no pudo ser Registrado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }else{
                            $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar por el paciente: Q'.round(($dataOT[0]->importePaciente-($dataOT[0]->montoPagadoPaciente)),2).'', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);    
                        }
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertPagoDepositoTransferencia($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $registrarPago = false;
                    $tra_fp_no_consulta = $parameter['tra_fp_no_consulta'] ?? 0;
                    $tra_fp_no_orden = $parameter['tra_fp_no_orden'] ?? 0;
                    $tra_fp_forma_pago = $parameter['tra_fp_forma_pago'] ?? 0;

                    $tra_fp_no_referencia = $parameter['tra_fp_no_referencia'] ?? 0;
                    $tra_fp_monto = $parameter['tra_fp_monto'] ?? 0;
                    $tra_fp_fecha_movimiento = $parameter['tra_fp_fecha_movimiento'] ?? 0;
                    
                    if($parameter['tra_fp_monto'] == ''){
                        $tra_fp_monto = 0.00;
                    }

                    if($tra_fp_fecha_movimiento == "" || $tra_fp_fecha_movimiento == 'Invalid date'){
                        $tra_fp_fecha_movimiento = NULL;
                    }else{
                        $tra_fp_fecha_movimiento = explode("/",$tra_fp_fecha_movimiento);
                        $dia = $tra_fp_fecha_movimiento[0];
                        $mes = $tra_fp_fecha_movimiento[1];
                        $anio = $tra_fp_fecha_movimiento[2];
                        $tra_fp_fecha_movimiento = $anio."-".$mes."-".$dia;
                    }
                    
                    //$data= $parameter['data'] ?? array();
                    
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';

                    $dataOT = $utility->calcularMontoOrdenTra($PDO, "tra_orden_trabajo", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    //$montoTotalaPagar = $utility->montoOrdenDeTrabajo($PDO, "tra_orden_trabajo", "otra_precio", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    //$montoPagado = $utility->montoPagoRealizado($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_monto", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    
                    $tra_fp_no_referencia = $utility->validarLongitudString($tra_fp_no_referencia, 0, 150);
                    $tra_fp_monto = $utility->validarLongitudString($tra_fp_monto, 0, 18);
                    // $otra_plan = $utility->validarLongitudString($otra_plan, 0, 11);
                    
                    $tra_fp_correlativo = $utility->CorrelAutomatico($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_correlativo", "");

                    $sql = 
                        "insert into tra_formas_pago_ordenes_trabajo (
                                                tra_fp_correlativo, 
                                                tra_fp_no_consulta,
                                                tra_fp_no_orden,
                                                tra_fp_forma_pago, 
                                                tra_fp_monto,
                                                tra_fp_no_referencia,
                                                tra_fp_fecha_movimiento,
                                                tra_fp_estado,
                                                tra_fp_usuarioi,
                                                tra_fp_usuariom,
                                                tra_fp_fechai,
                                                tra_fp_fecham
                                                ) values(
                                                :tra_fp_correlativo, 
                                                :tra_fp_no_consulta,
                                                :tra_fp_no_orden,
                                                :tra_fp_forma_pago, 
                                                :tra_fp_monto,
                                                :tra_fp_no_referencia,
                                                :tra_fp_fecha_movimiento,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
                    //if(($montoPagado+$tra_fp_monto) > $montoTotalaPagar){
                    if(
                        round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2) > round($dataOT[0]->importeTotal,2)
                    ){
                        $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar: Q'.round(($dataOT[0]->importeTotal-($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente)),2).'', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }else{
                        if($tra_fp_forma_pago > 1){
                            if(round(($tra_fp_monto+$dataOT[0]->montoPagadoPaciente),2) <= round($dataOT[0]->importePaciente,2)){
                                $registrarPago = true;
                            }
                        }else{
                            if(round(($tra_fp_monto+$dataOT[0]->montoPagadoCliente),2) <= round($dataOT[0]->importeCliente,2)){
                                $registrarPago = true;
                            }
                        }
                        if($registrarPago == true){
                            $montoTotalPagado = round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2);
                            $resultado = round($dataOT[0]->importeTotal,2)-round($montoTotalPagado,2);
                            if($resultado <= 0){
                                $sqlU = "update tra_consulta_medica set tra_cm_etapa = 3 where tra_cm_correlativo = :tra_cm_correlativo";
                                $stmtU = $PDO->prepare($sqlU);
                                $resultU = $stmtU->execute([
                                    'tra_cm_correlativo' => $tra_fp_no_consulta
                                ]);
                            }
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'tra_fp_correlativo' => $tra_fp_correlativo,
                                'tra_fp_no_consulta' => $tra_fp_no_consulta,
                                'tra_fp_no_orden' => $tra_fp_no_orden,
                                'tra_fp_forma_pago' => $tra_fp_forma_pago,
                                'tra_fp_monto' => $tra_fp_monto,
                                'tra_fp_no_referencia' => $tra_fp_no_referencia,
                                'id_usuario' => $id_usuario,
                                'tra_fp_fecha_movimiento' => $tra_fp_fecha_movimiento
                            ]);

                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Pago Registrado exitosamente', 'status'=>200,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'El pago no pudo ser Registrado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }else{
                            $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar por el paciente: Q'.round(($dataOT[0]->importePaciente-($dataOT[0]->montoPagadoPaciente)),2).'', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403); 
                        }
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertPagoCupon($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $registrarPago = false;
                    $tra_fp_no_consulta = $parameter['tra_fp_no_consulta'] ?? 0;
                    $tra_fp_no_orden = $parameter['tra_fp_no_orden'] ?? 0;
                    $tra_fp_forma_pago = $parameter['tra_fp_forma_pago'] ?? 0;

                    $tra_fp_tipo_cupon = $parameter['tra_fp_tipo_cupon'] ?? 0;
                    //$tra_fp_cup_correlativo = $parameter['tra_fp_cup_correlativo'] ?? 0;
                    $tra_fp_no_referencia = $parameter['tra_fp_no_referencia'] ?? 0;
                    $tra_fp_serie = $parameter['tra_fp_serie'] ?? 0;
                    $tra_fp_monto = $parameter['tra_fp_monto'] ?? 0;
                    $tra_fp_fecha_movimiento = NULL;//$parameter['tra_fp_fecha_movimiento'] ?? 0;
                    
                    if($parameter['tra_fp_monto'] == ''){
                        $tra_fp_monto = 0.00;
                    }

                    
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';

                    $tra_fp_cup_correlativo = $utility->verificarNoCupon($PDO, "cfg_cupon", $tra_fp_tipo_cupon, $tra_fp_serie, $tra_fp_no_referencia, $tra_fp_monto, "");

                    $dataOT = $utility->calcularMontoOrdenTra($PDO, "tra_orden_trabajo", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    /*$montoTotalaPagar = $utility->montoOrdenDeTrabajo($PDO, "tra_orden_trabajo", "otra_precio", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    $montoPagado = $utility->montoPagoRealizado($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_monto", $tra_fp_no_consulta, $tra_fp_no_orden, "");*/

                    $cuponUsado = $utility->validarCuponUsado($PDO, "tra_formas_pago_ordenes_trabajo", $tra_fp_tipo_cupon, $tra_fp_serie, $tra_fp_no_referencia, $tra_fp_monto, "");
                        
                    $tra_fp_tipo_cupon = $utility->validarLongitudString($tra_fp_tipo_cupon, 0, 11);
                    $tra_fp_serie = $utility->validarLongitudString($tra_fp_serie, 0, 150);
                    $tra_fp_no_referencia = $utility->validarLongitudString($tra_fp_no_referencia, 0, 150);
                    $tra_fp_monto = $utility->validarLongitudString($tra_fp_monto, 0, 18);
                    // $otra_plan = $utility->validarLongitudString($otra_plan, 0, 11);
                    
                    $tra_fp_correlativo = $utility->CorrelAutomatico($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_correlativo", "");

                    $sql = 
                        "insert into tra_formas_pago_ordenes_trabajo (
                                                tra_fp_correlativo, 
                                                tra_fp_no_consulta,
                                                tra_fp_no_orden,
                                                tra_fp_forma_pago, 
                                                tra_fp_monto,
                                                tra_fp_tipo_cupon,
                                                tra_fp_cup_correlativo,
                                                tra_fp_no_referencia,
                                                tra_fp_serie,
                                                tra_fp_fecha_movimiento,
                                                tra_fp_estado,
                                                tra_fp_usuarioi,
                                                tra_fp_usuariom,
                                                tra_fp_fechai,
                                                tra_fp_fecham
                                                ) values(
                                                :tra_fp_correlativo, 
                                                :tra_fp_no_consulta,
                                                :tra_fp_no_orden,
                                                :tra_fp_forma_pago, 
                                                :tra_fp_monto,
                                                :tra_fp_tipo_cupon,
                                                :tra_fp_cup_correlativo,
                                                :tra_fp_no_referencia,
                                                :tra_fp_serie,
                                                :tra_fp_fecha_movimiento,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
                    if($tra_fp_cup_correlativo > 0){
                        if($cuponUsado == 0){
                            //if(($montoPagado+$tra_fp_monto) > $montoTotalaPagar){
                            if(
                                round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2) > round($dataOT[0]->importeTotal,2)
                            ){
                                $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar: Q'.round(($dataOT[0]->importeTotal-($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente)),2).'', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }else{
                                if($tra_fp_forma_pago > 1){
                                    if(round(($tra_fp_monto+$dataOT[0]->montoPagadoPaciente),2) <= round($dataOT[0]->importePaciente,2)){
                                        $registrarPago = true;
                                    }
                                }else{
                                    if(round(($tra_fp_monto+$dataOT[0]->montoPagadoCliente),2) <= round($dataOT[0]->importeCliente,2)){
                                        $registrarPago = true;
                                    }
                                }
                                if($registrarPago == true){
                                    $montoTotalPagado = round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2);
                                    $resultado = round($dataOT[0]->importeTotal,2)-round($montoTotalPagado,2);
                                    if($resultado <= 0){
                                        $sqlU = "update tra_consulta_medica set tra_cm_etapa = 3 where tra_cm_correlativo = :tra_cm_correlativo";
                                        $stmtU = $PDO->prepare($sqlU);
                                        $resultU = $stmtU->execute([
                                            'tra_cm_correlativo' => $tra_fp_no_consulta
                                        ]);
                                    }

                                    $stmt = $PDO->prepare($sql);
                                    $result = $stmt->execute([
                                        'tra_fp_correlativo' => $tra_fp_correlativo,
                                        'tra_fp_no_consulta' => $tra_fp_no_consulta,
                                        'tra_fp_no_orden' => $tra_fp_no_orden,
                                        'tra_fp_forma_pago' => $tra_fp_forma_pago,
                                        'tra_fp_monto' => $tra_fp_monto,
                                        'tra_fp_tipo_cupon' => $tra_fp_tipo_cupon,
                                        'tra_fp_cup_correlativo' => $tra_fp_cup_correlativo,
                                        'tra_fp_no_referencia' => $tra_fp_no_referencia,
                                        'tra_fp_serie' => $tra_fp_serie,
                                        'id_usuario' => $id_usuario,
                                        'tra_fp_fecha_movimiento' => $tra_fp_fecha_movimiento
                                    ]);

                                    if ($result == true) {
                                        $data = array('estado'=>'OK', 'mensaje'=>'Pago Registrado exitosamente', 'status'=>200,'token'=>$token);
                                        $payload = json_encode($data);
                                        $response->getBody()->write($payload);
                                        $response = $response->withStatus(200);
                                    }else{
                                        $data = array('estado'=>'ERROR', 'mensaje'=>'El pago no pudo ser Registrado', 'status'=>403,'token'=>$token);
                                        $payload = json_encode($data);
                                        $response->getBody()->write($payload);
                                        $response = $response->withStatus(403);
                                    }
                                }else{
                                    $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar por el paciente: Q'.round(($dataOT[0]->importePaciente-($dataOT[0]->montoPagadoPaciente)),2).'', 'status'=>403,'token'=>$token);
                                        $payload = json_encode($data);
                                        $response->getBody()->write($payload);
                                        $response = $response->withStatus(403); 
                                }
                            }
                        }else{
                            $data = array('estado'=>'WARNING', 'mensaje'=>'El cupón ingresado ya fué utilizado', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                    }else{
                        $data = array('estado'=>'WARNING', 'mensaje'=>'El cupón ingresado no es Válido', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertPagoTarjeta($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $registrarPago = false;
                    $tra_fp_no_consulta = $parameter['tra_fp_no_consulta'] ?? 0;
                    $tra_fp_no_orden = $parameter['tra_fp_no_orden'] ?? 0;
                    $tra_fp_forma_pago = $parameter['tra_fp_forma_pago'] ?? 0;

                    $tra_fp_tipo_tarjeta = $parameter['tra_fp_tipo_tarjeta'] ?? 0;
                    $tra_fp_no_referencia = $parameter['tra_fp_no_referencia'] ?? 0;
                    $tra_fp_autorizacion = $parameter['tra_fp_autorizacion'] ?? 0;
                    $tra_fp_monto = $parameter['tra_fp_monto'] ?? 0;
                    $tra_fp_fecha_movimiento = NULL;
                    
                    if($parameter['tra_fp_monto'] == ''){
                        $tra_fp_monto = 0.00;
                    }

                    
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';
                    $dataOT = $utility->calcularMontoOrdenTra($PDO, "tra_orden_trabajo", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    //$montoTotalaPagar = $utility->montoOrdenDeTrabajo($PDO, "tra_orden_trabajo", "otra_precio", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    //$montoPagado = $utility->montoPagoRealizado($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_monto", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    
                    $tra_fp_no_referencia = $utility->validarLongitudString($tra_fp_no_referencia, 0, 150);
                    $tra_fp_monto = $utility->validarLongitudString($tra_fp_monto, 0, 18);
                    // $otra_plan = $utility->validarLongitudString($otra_plan, 0, 11);
                    
                    $tra_fp_correlativo = $utility->CorrelAutomatico($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_correlativo", "");

                    $sql = 
                        "insert into tra_formas_pago_ordenes_trabajo (
                                                tra_fp_correlativo, 
                                                tra_fp_no_consulta,
                                                tra_fp_no_orden,
                                                tra_fp_forma_pago, 
                                                tra_fp_monto,
                                                tra_fp_no_referencia,
                                                tra_fp_tipo_tarjeta,
                                                tra_fp_autorizacion,
                                                tra_fp_fecha_movimiento,
                                                tra_fp_estado,
                                                tra_fp_usuarioi,
                                                tra_fp_usuariom,
                                                tra_fp_fechai,
                                                tra_fp_fecham
                                                ) values(
                                                :tra_fp_correlativo, 
                                                :tra_fp_no_consulta,
                                                :tra_fp_no_orden,
                                                :tra_fp_forma_pago, 
                                                :tra_fp_monto,
                                                :tra_fp_no_referencia,
                                                :tra_fp_tipo_tarjeta,
                                                :tra_fp_autorizacion,
                                                :tra_fp_fecha_movimiento,
                                                'A',
                                                :id_usuario, 
                                                :id_usuario, 
                                                now(), 
                                                now()
                                                )";
                    //if(($montoPagado+$tra_fp_monto) > $montoTotalaPagar){
                    if(
                        round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2) > round($dataOT[0]->importeTotal,2)
                    ){
                        $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar: Q'.round(($dataOT[0]->importeTotal-($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente)),2).'', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }else{
                        if($tra_fp_forma_pago > 1){
                            if(round(($tra_fp_monto+$dataOT[0]->montoPagadoPaciente),2) <= round($dataOT[0]->importePaciente,2)){
                                $registrarPago = true;
                            }
                        }else{
                            if(round(($tra_fp_monto+$dataOT[0]->montoPagadoCliente),2) <= round($dataOT[0]->importeCliente,2)){
                                $registrarPago = true;
                            }
                        }
                        if($registrarPago == true){
                            $montoTotalPagado = round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2);
                            $resultado = round($dataOT[0]->importeTotal,2)-round($montoTotalPagado,2);
                            if($resultado <= 0){
                                $sqlU = "update tra_consulta_medica set tra_cm_etapa = 3 where tra_cm_correlativo = :tra_cm_correlativo";
                                $stmtU = $PDO->prepare($sqlU);
                                $resultU = $stmtU->execute([
                                    'tra_cm_correlativo' => $tra_fp_no_consulta
                                ]);
                            }
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'tra_fp_correlativo' => $tra_fp_correlativo,
                                'tra_fp_no_consulta' => $tra_fp_no_consulta,
                                'tra_fp_no_orden' => $tra_fp_no_orden,
                                'tra_fp_forma_pago' => $tra_fp_forma_pago,
                                'tra_fp_monto' => $tra_fp_monto,
                                'tra_fp_no_referencia' => $tra_fp_no_referencia,
                                'tra_fp_tipo_tarjeta' => $tra_fp_tipo_tarjeta,
                                'tra_fp_autorizacion' => $tra_fp_autorizacion,
                                'id_usuario' => $id_usuario,
                                'tra_fp_fecha_movimiento' => $tra_fp_fecha_movimiento
                            ]);

                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Pago Registrado exitosamente', 'status'=>200,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'El pago no pudo ser Registrado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }else{
                            $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar por el paciente: Q'.round(($dataOT[0]->importePaciente-($dataOT[0]->montoPagadoPaciente)),2).'', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);    
                        }
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertPagoCredito($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $registrarPago = false;
                    $tra_fp_aseguradora = $parameter['tra_fp_aseguradora'] ?? 0;
                    $tra_fp_no_consulta = $parameter['tra_fp_no_consulta'] ?? 0;
                    $tra_fp_no_orden = $parameter['tra_fp_no_orden'] ?? 0;
                    $tra_fp_forma_pago = $parameter['tra_fp_forma_pago'] ?? 0;
                    $tra_fp_monto = $parameter['tra_fp_monto'] ?? 0;
                    
                    if($parameter['tra_fp_monto'] == ''){
                        $tra_fp_monto = 0.00;
                    }
                    
                    //$data= $parameter['data'] ?? array();
                    
                    $tra_fp_fecha_movimiento  = NULL;
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';

                    $dataOT = $utility->calcularMontoOrdenTra($PDO, "tra_orden_trabajo", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    //$montoTotalaPagar = $utility->montoOrdenDeTrabajo($PDO, "tra_orden_trabajo", "otra_precio", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    //$montoPagado = $utility->montoPagoRealizado($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_monto", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    
                    $tra_fp_correlativo = $utility->CorrelAutomatico($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_correlativo", "");
                    
                    $sql = 
                    "insert into tra_formas_pago_ordenes_trabajo (
                                            tra_fp_correlativo, 
                                            tra_fp_no_consulta,
                                            tra_fp_no_orden,
                                            tra_fp_forma_pago, 
                                            tra_fp_monto,
                                            tra_fp_aseguradora,
                                            tra_fp_fecha_movimiento,
                                            tra_fp_estado,
                                            tra_fp_usuarioi,
                                            tra_fp_usuariom,
                                            tra_fp_fechai,
                                            tra_fp_fecham
                                            ) values(
                                            :tra_fp_correlativo, 
                                            :tra_fp_no_consulta,
                                            :tra_fp_no_orden,
                                            :tra_fp_forma_pago, 
                                            :tra_fp_monto,
                                            :tra_fp_aseguradora,
                                            :tra_fp_fecha_movimiento,
                                            'A',
                                            :id_usuario, 
                                            :id_usuario, 
                                            now(), 
                                            now()
                                            )";
                    //if(($montoPagado+$tra_fp_monto) > $montoTotalaPagar){
                    if(
                        round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2) > round($dataOT[0]->importeTotal,2)
                    ){
                        $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar: Q'.round(($dataOT[0]->importeTotal-($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente)),2).'', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }else{
                        if($tra_fp_forma_pago > 1){
                            if(round(($tra_fp_monto+$dataOT[0]->montoPagadoPaciente),2) <= round($dataOT[0]->importePaciente,2)){
                                $registrarPago = true;
                            }
                        }else{
                            if(round(($tra_fp_monto+$dataOT[0]->montoPagadoCliente),2) <= round($dataOT[0]->importeCliente,2)){
                                $registrarPago = true;
                            }
                        }
                        if($registrarPago == true){
                            $montoTotalPagado = round(($dataOT[0]->montoPagadoPaciente+$dataOT[0]->montoPagadoCliente+$tra_fp_monto),2);
                            $resultado = round($dataOT[0]->importeTotal,2)-round($montoTotalPagado,2);
                            if($resultado <= 0){
                                $sqlU = "update tra_consulta_medica set tra_cm_etapa = 3 where tra_cm_correlativo = :tra_cm_correlativo";
                                $stmtU = $PDO->prepare($sqlU);
                                $resultU = $stmtU->execute([
                                    'tra_cm_correlativo' => $tra_fp_no_consulta
                                ]);
                            }
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'tra_fp_aseguradora' => $tra_fp_aseguradora,
                                'tra_fp_correlativo' => $tra_fp_correlativo,
                                'tra_fp_no_consulta' => $tra_fp_no_consulta,
                                'tra_fp_no_orden' => $tra_fp_no_orden,
                                'tra_fp_forma_pago' => $tra_fp_forma_pago,
                                'tra_fp_monto' => $tra_fp_monto,
                                'id_usuario' => $id_usuario,
                                'tra_fp_fecha_movimiento' => $tra_fp_fecha_movimiento
                            ]);

                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Pago Registrado exitosamente', 'status'=>200,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'Pago no pudo ser Registrado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }else{
                            $data = array('estado'=>'WARNING', 'mensaje'=>'El monto que intenta registrar es mayor al monto total a  pagar. Monto pendiente a pagar por el cliente: Q'.round(($dataOT[0]->importeCliente-($dataOT[0]->montoPagadoCliente)),2).'', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);  
                        }
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertFacturaPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $tra_fac_no_consulta = $parameter['tra_fac_no_consulta'] ?? 0;
                    $tra_fac_no_orden_trabajo = $parameter['tra_fac_no_orden'] ?? 0;
                    $tra_fac_monto = $parameter['tra_fac_monto'] ?? 0.00;
                    $tra_fac_serie = $parameter['tra_fac_serie'] ?? "";
                    $tra_fac_no_referencia = $parameter['tra_fac_no_referencia'] ?? "";
                    $tra_fac_autorizacion = $parameter['tra_fac_autorizacion'] ?? "";
                    $tra_fac_fecha_emision = $parameter['tra_fac_fecha_emision'] ?? NULL;
                    $tra_fac_aseguradora = 0;
                    
                    if($parameter['tra_fac_monto'] == ''){
                        $tra_fac_monto = 0.00;
                    }
                    if($parameter['tra_fac_fecha_emision'] == ''){
                        $tra_fac_fecha_emision = NULL;
                    }

                    $tra_fac_serie = $utility->validarLongitudString($tra_fac_serie, 0, 250);
                    $tra_fac_no_referencia = $utility->validarLongitudString($tra_fac_no_referencia, 0, 250);
                    $tra_fac_autorizacion = $utility->validarLongitudString($tra_fac_autorizacion, 0, 250);
                    $tra_fac_monto = $utility->validarLongitudString($tra_fac_monto, 0, 18);
                    //$data= $parameter['data'] ?? array();
                    
                    $tra_cm_etapa  = 1;
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';

                    //$montoAPagar = $utility->montoOrdenDeTrabajo($PDO, "tra_orden_trabajo", "otra_precio", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    //$montoPagado = $utility->montoPagoRealizado($PDO, "tra_formas_pago_ordenes_trabajo", "tra_fp_monto", $tra_fp_no_consulta, $tra_fp_no_orden, "");
                    
                    $tra_fac_correlativo = $utility->CorrelAutomatico($PDO, "tra_factura", "tra_fac_correlativo", "");
                    
                    $sql = 
                    "insert into tra_factura (
                                            tra_fac_correlativo, 
                                            tra_fac_no_consulta,
                                            tra_fac_no_orden_trabajo,
                                            tra_fac_monto,
                                            tra_fac_serie, 
                                            tra_fac_no_referencia,
                                            tra_fac_autorizacion,
                                            tra_fac_fecha_emision,
                                            tra_fac_aseguradora,
                                            tra_fac_estado,
                                            tra_fac_usuarioi,
                                            tra_fac_usuariom,
                                            tra_fac_fechai,
                                            tra_fac_fecham
                                            ) values(
                                            :tra_fac_correlativo, 
                                            :tra_fac_no_consulta,
                                            :tra_fac_no_orden_trabajo,
                                            :tra_fac_monto,
                                            :tra_fac_serie, 
                                            :tra_fac_no_referencia,
                                            :tra_fac_autorizacion,
                                            :tra_fac_fecha_emision,
                                            :tra_fac_aseguradora,
                                            'A',
                                            :id_usuario, 
                                            :id_usuario, 
                                            now(), 
                                            now()
                                            )";

                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'tra_fac_correlativo' => $tra_fac_correlativo,
                        'tra_fac_no_consulta' => $tra_fac_no_consulta,
                        'tra_fac_monto' => $tra_fac_monto, 
                        'tra_fac_no_orden_trabajo' => $tra_fac_no_orden_trabajo,
                        'tra_fac_serie' => $tra_fac_serie,
                        'tra_fac_no_referencia' => $tra_fac_no_referencia,
                        'tra_fac_autorizacion' => $tra_fac_autorizacion,
                        'tra_fac_fecha_emision' => $tra_fac_fecha_emision,
                        'id_usuario' => $id_usuario,
                        'tra_fac_aseguradora' => $tra_fac_aseguradora
                    ]);

                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Factura Registrada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'La Factura no pudo ser Registrada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                    
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function deleteItemServicioOrdenTrabajo($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'eliminar');
                if($userFuncionality == 'OK'){
                    $otra_correlativo = (int)$parameter['otra_correlativo'] ?? 0;
                    
                    $sql = "update tra_orden_trabajo set otra_estado = 'E',otra_fecham = now() where otra_correlativo = :otra_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'otra_correlativo' => $otra_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Dato eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Dato no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function deleteFacturaPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_fac_correlativo = (int)$parameter['tra_fac_correlativo'] ?? 0;
                    
                    $sql = "update tra_factura set tra_fac_estado = 'E',tra_fac_fecham = now() where tra_fac_correlativo = :tra_fac_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'tra_fac_correlativo' => $tra_fac_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Factura eliminada exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Factura no pudo ser eliminada', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

    public function deleteItemFormaPago($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'eliminar');
                if($userFuncionality == 'OK'){
                    $tra_fp_correlativo = (int)$parameter['tra_fp_correlativo'] ?? 0;
                    
                    $sql = "update tra_formas_pago_ordenes_trabajo set tra_fp_estado = 'E',tra_fp_fecham = now() where tra_fp_correlativo = :tra_fp_correlativo";
        
                    $stmt = $PDO->prepare($sql);
                    $result = $stmt->execute([
                        'tra_fp_correlativo' => $tra_fp_correlativo
                    ]);
                    if ($result == true) {
                        $data = array('estado'=>'OK', 'mensaje'=>'Dato eliminado exitosamente', 'status'=>200,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(200);
                    }else{
                        $data = array('estado'=>'ERROR', 'mensaje'=>'Dato no pudo ser eliminado', 'status'=>403,'token'=>$token);
                        $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                    }
                }else{
                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                    $response->getBody()->write($payload);
                    $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }
    public function insertDatoPaciente($request, $response, $args) {
        try{
            $dbConnection = new DBConnection();
            $conexion = $dbConnection->setConnection();
            if ($conexion == "OK") {
                $PDO = $dbConnection->getConnection();  
                $token = $request->getAttribute('new_token');
                $id_usuario = (int)$request->getAttribute('id');
                $emp_codigo = (int)$request->getAttribute('emp_codigo');
                $amb_codigo = (int)$request->getAttribute('amb_codigo');
                $parameter = $request->getParsedBody();
                $utility = new UtilityDB();
                $userFuncionality = $utility->userFuncionalityAccess($PDO, $id_usuario,$emp_codigo,$amb_codigo, 'Tra_Recepcion_Paciente', 'nuevo');

                if($userFuncionality == 'OK'){
                    $registrarCita = false;
                    
                    $tra_cm_lugar_atencion  = (int)$parameter['tra_cm_lugar_atencion'] ?? 0;
                    $tra_cm_correlativo=(int)$parameter['tra_cm_correlativo'] ?? 0;
                    $cli_correlativo=(int)$parameter['cli_correlativo'] ?? 0;
                    $cli_nombre=$parameter['cli_nombre'] ?? 'null';
                    $cli_dpi=$parameter['cli_dpi'] ?? 'null';
                    $cli_nit=$parameter['cli_nit'] ?? 'null';
                    $cli_telefono1=$parameter['cli_telefono1'] ?? 'null';
                    $tra_cm_usr_correl=(int)$parameter['tra_cm_usr_correl'] ?? 0;
                    
                    $tra_cm_fecha_inicio_consulta=$parameter['tra_cm_fecha_inicio_consulta'] ?? date("Y-m-d H:i");
                    $tra_cm_fecha_fin_consulta= "";
                    
                    $cli_fecha_nacimiento = $parameter['tra_cm_fecha_nacimiento'] ?? date("Y-m-d");
                    $fecha = "";
                    if($cli_fecha_nacimiento == ""){//|| $cli_fecha_nacimiento == "Invalid date"
                        $cli_fecha_nacimiento = NULL;
                    }else{
                        
                        $cli_fecha_nacimiento = explode("/",$cli_fecha_nacimiento);
                        $dia = $cli_fecha_nacimiento[0];
                        $mes = $cli_fecha_nacimiento[1];
                        $anio = $cli_fecha_nacimiento[2];
                        $cli_fecha_nacimiento = $anio."-".$mes."-".$dia;
                    }
                    $tra_cm_telefono= $parameter['tra_cm_telefono'] ?? 'null';
                    //$tra_cm_menor  = $parameter['tra_cm_menor'] ?? 0;
                    $tra_cm_responsable_menor=$parameter['tra_cm_responsable_menor'] ?? 'null';
                    $tra_cm_direccion=$parameter['tra_cm_direccion'] ?? 'null';
                    $tra_cm_etapa  = 1;
                    $tra_cm_duracion_consulta = 40;
                    $tra_cm_estado='A';//$parameter['tra_cm_estado'] ?? 'A';

                    $cli_nombre = $utility->validarLongitudString($cli_nombre, 0, 150);
                    $cli_dpi = $utility->validarLongitudString($cli_dpi, 0, 50);
                    $cli_nit = $utility->validarLongitudString($cli_nit, 0, 12);
                    $cli_telefono1 = $utility->validarLongitudString($cli_telefono1, 0, 15);
                    
                    if($tra_cm_fecha_inicio_consulta !=""){
                        //$tra_fecha_fin_consulta = $tra_cm_fecha_inicio_consulta->modify('+40 minute'); 
                        $tra_cm_fecha_fin_consulta = strtotime ( '+40 minute' , strtotime($tra_cm_fecha_inicio_consulta)) ;
                        $tra_cm_fecha_fin_consulta = date( 'Y-m-d H:i:s' , $tra_cm_fecha_fin_consulta);
                    }
                    

                    $horarioCentroValido = 1;//$utility->validarHorarioSucursal($PDO, "cfg_sucursal", "suc_correlativo","$tra_cm_fecha_inicio_consulta","$tra_cm_fecha_fin_consulta","$tra_cm_lugar_atencion"," and suc_empresa = $emp_codigo and suc_ambiente = $amb_codigo");
                    
                    $horarioMedicoDisponible = 1;//$utility->validarDisponibilidadHorarioMedico($PDO, "cfg_agenda", "age_correlativo","$age_usr_correl","$age_suc_correlativo","$age_pro_correl", "$tra_cm_fecha_inicio_consulta", "$tra_cm_fecha_fin_consulta", "order by age_correlativo desc");
                    
                    //$tra_cm_correlativo = $utility->CorrelAutomatico($PDO, "tra_consulta_medica", "tra_cm_correlativo", "");

                    /*$array_cliente = array(
                        'cli_nombre'=>$tra_cm_nombre_paciente,
                        'cli_email'=>$tra_cm_correo,
                        'cli_telefono1'=>$tra_cm_telefono,
                        'cli_telefono2'=>$tra_cm_telefono,
                        'cli_fecha_nacimiento'=>$tra_cm_fecha_nacimiento
                    );
                    //identificamos al cliente
                    $tra_cm_cli_correlativo = $utility->clientRegister($PDO,$array_cliente, $id_usuario,0);*/
                    //ACTUALIZACION DATOS USUARIO
                    $sqlUser = "update cfg_cliente set 
                    cli_nombre = :cli_nombre,
                    cli_dpi = :cli_dpi,
                    cli_nit = :cli_nit,
                    cli_telefono1 = :cli_telefono1,
                    cli_fecha_nacimiento = :cli_fecha_nacimiento,
                    cli_usuariom = :id_usuario,
                    cli_fecham = now() 
                    where cli_correlativo = :cli_correlativo";

                    $stmtUser = $PDO->prepare($sqlUser);
                    $resultUser = $stmtUser->execute([
                        'id_usuario' => $id_usuario,
                        'cli_correlativo' => $cli_correlativo,
                        'cli_nombre' => $cli_nombre,
                        'cli_dpi' => $cli_dpi,
                        'cli_telefono1' => $cli_telefono1,
                        'cli_nit' => $cli_nit,
                        'cli_fecha_nacimiento' => $cli_fecha_nacimiento
                    ]);
                    
                     $sql = " 
                     update tra_consulta_medica set 
                        tra_cm_usr_correl = :tra_cm_usr_correl,
                        tra_cm_usuariom = :id_usuario,
                        tra_cm_fecham = now() 
                        where tra_cm_correlativo = :tra_cm_correlativo";

                        if($horarioCentroValido > 0){
                            $registrarCita = true;
                            if($horarioMedicoDisponible > 0){
                                $registrarCita = true;
                            }else{
                                $registrarCita = false;
                                $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar la cita del paciente, el horario seleccionado ya está reservado, por favor revise el horario del médico', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }else{
                            $registrarCita = false;
                            $data = array('estado'=>'ERROR', 'mensaje'=>'No es posible registrar la cita del paciente, el horario seleccionado está fuera del horario del centro, por favor revise el horario del centro de atención', 'status'=>403,'token'=>$token);
                            $payload = json_encode($data);
                            $response->getBody()->write($payload);
                            $response = $response->withStatus(403);
                        }
                        
                        if($registrarCita == true){
                            $stmt = $PDO->prepare($sql);
                            $result = $stmt->execute([
                                'tra_cm_correlativo' => $tra_cm_correlativo, 
                                'tra_cm_usr_correl' => $tra_cm_usr_correl,
                                'id_usuario' => $id_usuario
                                ]);
                              
                                
                            if ($result == true) {
                                $data = array('estado'=>'OK', 'mensaje'=>'Registro actualizado exitosamente', 'status'=>200,'token'=>$token,'key'=>$tra_cm_correlativo);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(200);
                            }else{
                                $data = array('estado'=>'ERROR', 'mensaje'=>'Registro no pudo ser actualizado', 'status'=>403,'token'=>$token);
                                $payload = json_encode($data);
                                $response->getBody()->write($payload);
                                $response = $response->withStatus(403);
                            }
                        }
                    
                }else{

                    $data = array('estado'=>'ERROR', 'mensaje'=>$userFuncionality, 'status'=>403);
                    $payload = json_encode($data);
                        $response->getBody()->write($payload);
                        $response = $response->withStatus(403);
                }
            
                $PDO = null;
            }else{
                $data = array('estado'=>'ERROR', 'mensaje'=>(string)$conexion,'status'=>500);
                $payload = json_encode($data);
                $response->getBody()->write($payload);
                $response = $response->withStatus(200);
            }
        }catch(PDOException $e){
            $data = array('estado'=>'ERROR', 'mensaje'=>$e->getMessage(),'status'=>500,'token'=>$token);
            $payload = json_encode($data);
            $response->getBody()->write($payload);
            $response = $response->withStatus(500);
        }
        return $response;
    }

}