<?php
namespace App\Security;

use App\Controllers\BaseController;
use Exception;
use Firebase\JWT\ExpiredException;
use \Firebase\JWT\JWT;

class Token {
    public $newToken;
	public $id;
	public $login;
	public $emp_codigo;
    public $amb_codigo;

    public function createToken($id,$login,$emp_codigo,$amb_codigo){
        
        $data = array(
            "id"=>$id,
            "user"=>$login,
            "emp_codigo"=>$emp_codigo,
            "amb_codigo"=>$amb_codigo
        );
        $payload = array(
            "iss" => SITE,
            "aud" => SITE,
            "iat" => time(),
            "exp" => time()+EXPIRATION,
            "data" => $data);

            $jwt = JWT::encode($payload, SECRET_KEY);

            return $jwt;
    }

    public function validateToken($jwt){
        $respuesta = "NOK";
        try{
            if(!empty($jwt)){
                $decoded = JWT::decode($jwt, SECRET_KEY, array('HS256'));
                $decoded_array = (array) $decoded;
                $data = (array)$decoded_array['data'];

                $this->id = $data['id'];
                $this->login = $data['user'];
                $this->emp_codigo = $data['emp_codigo'];
                $this->amb_codigo = $data['amb_codigo'];
                
                if($this->emp_codigo != 0){
                    if($this->amb_codigo != 0){
                        
                        $data = array(
                            "id"=>$this->id,
                            "user"=>$this->login,
                            "emp_codigo"=>$this->emp_codigo,
                            "amb_codigo"=>$this->amb_codigo
                        );
                
                        $payload = array(
                            "iss" => SITE,
                            "aud" => SITE,
                            "iat" => time(),
                            "exp" => time()+EXPIRATION,
                            "data" => $data);
                
                        $this->newToken = JWT::encode($payload, SECRET_KEY);
                        $respuesta = "OK";
                    }else{
                        $respuesta = "Codigo de Ambiente no es Válido, favor Comunicarse con Admon. de Sistema...";
                    }    
                }else{
                    $respuesta = "Codigo de Empresa no es Válido, favor Comunicarse con Admon. de Sistema...";
                }
            }else{
                $respuesta = "Token no encontrado";
            }
        }catch(ExpiredException $e){
            $respuesta = "Sesión finalizada [".$e->getMessage()."] inicie sesión nuevamente";
        }
        return $respuesta;

    }
}
?>