<?php
namespace App\Utility;

use App\DB\DBConnection;
use PDO;
use PDOException;
use Psr\Http\Message\UploadedFileInterface;
use ZipArchive;

class UtilityDB{
        public function CorrelAutomatico($connection, $pNomTabla, $pNomColumna, $pFiltro) {
            $rst_correl_sig = 0;
    
            $sql = "select IFNULL(max($pNomColumna),0)+1 correlativo from $pNomTabla where 1=1 $pFiltro";
    
            $stmt = $connection->query($sql);
            $result = $stmt->fetchAll(PDO::FETCH_OBJ);
    
            if ($stmt->rowCount() > 0) {
                $rst_correl_sig = (($result[0]->correlativo) );
            } else {
                $rst_correl_sig = 0;
            }
            return $rst_correl_sig;
        }
        public function RegistrosTotal($connection, $pNomTabla, $pFiltroTabla, $array) {
            $rst_conteo_reg = 0;
    
            $sql = "select count(1) as conteo_reg from $pNomTabla where 1 = 1 $pFiltroTabla; ";
            
            $stmt = $connection->prepare($sql);
            $stmt->execute($array);
            
            $result = $stmt->fetchAll(PDO::FETCH_OBJ);
    
            if ($stmt->rowCount() > 0) {
                $rst_conteo_reg = $result[0]->conteo_reg;
            } else {
                $rst_conteo_reg = 0;
            }
            return $rst_conteo_reg;
        }
        public function userFuncionalityAccess($connection, $usr_correlativo,$emp_codigo,$amb_codigo, $objeto, $tipo) {
            $respuesta = 'NOK';
    
            $sql = "select 
            count(1) conteo
            from
            cfg_usuario,
            cfg_usuario_rol,
            cfg_rol,
            cfg_rol_funcionalidad,
            cfg_funcionalidad,
            cfg_funcionalidad_ambiente,
            cfg_empresa
            where
            usr_codigo =:usr_correlativo
            and usr_estado='A'
            and rol_empresa=:emp_codigo
            and uro_usuario = usr_codigo
            and rol_codigo = uro_rol
            and rol_estado = 'A'
            and fun_empresa = :emp_codigo
            and rof_rol = rol_codigo
            and rol_ambiente =:amb_codigo
            and fun_correlativo= rof_funcionalidad
            and fua_funcionalidad = fun_correlativo
            and fun_estado ='A'
            and rof_estado='A'
            and fua_ambiente = :amb_codigo
            and fun_objeto = :objeto
            and emp_codigo = rol_empresa
            and emp_estado ='A' ";
            if($tipo == "lectura"){$sql.=" and rof_lectura = 1";}
            if($tipo=="nuevo"){$sql.=" and rof_nuevo = 1";}
            if($tipo=="modificar"){$sql.=" and rof_modificar= 1";}
            if($tipo=="eliminar"){$sql.=" and rof_eliminar = 1";}
            
            $stmt = $connection->prepare($sql);
            $stmt->execute(["usr_correlativo"=>$usr_correlativo,"emp_codigo"=>$emp_codigo,"amb_codigo"=>$amb_codigo,"objeto"=>$objeto]);
            $result = $stmt->fetchAll(PDO::FETCH_OBJ);
            
            if ($stmt->rowCount() > 0) {
                
                $conteo = $result[0]->conteo;
                if($conteo > 0){
                    $respuesta = "OK";
                }else{
                    $respuesta = "El usuario no tiene los permisos adecuados para consultar la información solicitada: [$objeto],
                    Comuníquese con el Administrador del Sistema";
                }
            } else {
                $respuesta = "El usuario no tiene los permisos adecuados para consultar la información solicitada: [$objeto],
                Comuníquese con el Administrador del Sistema";
            }
            return $respuesta;
        }
        public function cmbCatalogo($connection,$cat_tipo, $emp_codigo, $amb_codigo){
                $response = [];
                
                $sql ="select
                cat_valor, 
                cat_nombre
                from cfg_catalogo
                where  
                upper(cat_tipo) = upper(:cat_tipo)
                and cat_estado = 'A' 
                and (cat_empresa=:emp_codigo or cat_empresa = -1)
                and (cat_ambiente=:amb_codigo or cat_ambiente=-1)
                order by cat_arbol";
        
                $stmt = $connection->prepare($sql);
                $stmt->execute(['cat_tipo' => $cat_tipo,'emp_codigo'=>$emp_codigo,'amb_codigo'=>$amb_codigo]);
    
                $result = $stmt->fetchAll($connection::FETCH_OBJ);
                $response = $result;
                $PDO = null;
                return $response;
        }
        public function moveUploadedFile($dir,UploadedFileInterface  $uploadedFile){
            $extension = pathinfo($uploadedFile->getClientFilename(), PATHINFO_EXTENSION);
            $basename = bin2hex(random_bytes(8)); // see http://php.net/manual/en/function.random-bytes.php
            $filename = sprintf('%s.%0.8s', $basename, $extension);
            $uploadedFile->moveTo($dir . DIRECTORY_SEPARATOR . $filename);
            return strval($filename);
        }
    
        public function ramdomChar(){
            $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            return substr(str_shuffle($permitted_chars), 0, 16);
        }
        public function traPlanAmenaza($connection,$pam_tipo, $pam_pde_correlativo){
            $response = [];
            
            $sql = " select 
            pam_correlativo,
            pam_pde_correlativo,
            pam_campo1,
            pam_campo2,
            pam_campo3,
            pam_campo4,
            pam_campo5,
            pam_campo6,
            pam_campo7,
            pam_campo8,
            pam_campo9,
            pam_campo10,
            pam_campo11,
            pam_tipo,
            pam_usuarioi,
            pam_usuariom,
            pam_fechai,
            pam_fecham
            from 
            tra_plan_amenaza
            where 
            1=1
            and pam_pde_correlativo=:pam_pde_correlativo
            and pam_tipo = :pam_tipo
            ";
    
            $stmt = $connection->prepare($sql);
            $stmt->execute(['pam_tipo' => $pam_tipo,'pam_pde_correlativo'=>$pam_pde_correlativo]);
            $result = $stmt->fetchAll($connection::FETCH_OBJ);
            $response = $result;
            $PDO = null;
            return $response;
    }
    public function insertTraPlanDetalle($connection,$pld_pla_correlativo,$emp_codigo, $amb_codigo, $id_usuario){
        $response = "nOk";
        $pld_correlativo = $this->CorrelAutomatico($connection, "tra_plan_detalle", "pld_correlativo", "");
        $sql = " insert into tra_plan_detalle ( 
            pld_correlativo,
            pld_pla_correlativo,
            pld_empresa,
            pld_ambiente,
            pld_campo18,
            pld_campo20,
            pld_campo23,
            pld_campo28,
            pld_seccion,
            pld_sub_seccion,
            pld_estado,
            pld_usuarioi,
            pld_usuariom,
            pld_fechai,
            pld_fecham)
            values(
                :pld_correlativo,
                :pld_pla_correlativo,
                :pld_empresa,
                :pld_ambiente,
                0,
                0,
                0,
                0,
                1.00,
                1.00,
                'A',
                :pld_usuarioi,
                :pld_usuarioi,
                now(),
                now()
            )
            ";
    
            $stmt = $connection->prepare($sql);
            $result = $stmt->execute([
                'pld_correlativo' => $pld_correlativo,
                'pld_pla_correlativo' => $pld_pla_correlativo,
                'pld_empresa' => $emp_codigo,
                'pld_ambiente' => $amb_codigo,
                'pld_usuarioi' => $id_usuario,
            ]);
            $response = "OK";
            return $response;
    }
    public function insertTraPlanAmenaza($connection,$pam_pde_correlativo,$pam_tipo, $id_usuario,$pam_campo12){
        $response = "nOk";
        $correlativo = $this->CorrelAutomatico($connection, "tra_plan_amenaza", "pam_correlativo", "");
        $sql = " insert into tra_plan_amenaza ( 
            pam_correlativo,
            pam_pde_correlativo,
            pam_tipo,
            pam_campo12,
            pam_usuarioi,
            pam_usuariom,
            pam_fechai,
            pam_fecham
            )
            values(
                :pam_correlativo,
                :pam_pde_correlativo,
                :pam_tipo,
                :pam_campo12,
                :pam_usuarioi,
                :pam_usuarioi,
                now(),
                now()
            )
            ";
    
            $stmt = $connection->prepare($sql);
            $result = $stmt->execute([
                'pam_correlativo' => $correlativo,
                'pam_pde_correlativo' => $pam_pde_correlativo,
                'pam_campo12' => $pam_campo12,
                'pam_tipo' => $pam_tipo,
                'pam_usuarioi' => $id_usuario,
            ]);
            $response = "OK";
            return $response;
    }
    public function insertUsuarioConfig($connection,$ucf_empresa,$ucf_objeto,$ucf_objeto_codigo,$ucf_objeto_default,$ucf_usuario,$ucf_usuarioi){
        $response = "nOk";
        $ucf_codigo = $this->CorrelAutomatico($connection, "cfg_usuario_config", "ucf_codigo", "");
        $sql = " insert into cfg_usuario_config ( 
            ucf_codigo,
            ucf_empresa,
            ucf_objeto,
            ucf_objeto_codigo,
            ucf_objeto_default,
            ucf_usuario,
            ucf_tipo_asignacion,
            ucf_estado,
            ucf_usuarioi,
            ucf_usuariom,
            ucf_fechai,
            ucf_fecham
            )
            values(
                :ucf_codigo,
                :ucf_empresa,
                :ucf_objeto,
                :ucf_objeto_codigo,
                :ucf_objeto_default,
                :ucf_usuario,
                0,
                'A',
                :ucf_usuarioi,
                :ucf_usuarioi,
                now(),
                now()
            )
            ";
    
            $stmt = $connection->prepare($sql);
            $result = $stmt->execute([
                'ucf_codigo'=>$ucf_codigo,
                'ucf_empresa'=>$ucf_empresa,
                'ucf_objeto'=>$ucf_objeto,
                'ucf_objeto_codigo'=>$ucf_objeto_codigo,
                'ucf_objeto_default'=>$ucf_objeto_default,
                'ucf_usuario'=>$ucf_usuario,
                'ucf_usuarioi'=>$ucf_usuarioi
            ]);
            $response = "OK";
            return $response;
    }
    public function ppreAvance($connection,$correlativo){
        $response = 0;
        $sql = "select  ifnull(round(sum(campo1)),0)avance from (
            select 
            (((case when (pld_campo1 = '' or isnull(pld_campo1)) then 0 else 1 end) +
            (case when (pld_campo2 = '' or isnull(pld_campo2)) then 0 else 1 end) )*20) /2 campo1
            from 
            tra_plan_detalle
            where 
            pld_pla_correlativo = :correlativo
            union all
            select 
            (((case when (pld_campo3 = ''  or isnull(pld_campo3))then 0 else 1 end) +
            (case when (pld_campo4 = '' or isnull(pld_campo4)) then 0 else 1 end)+
            (case when (pld_campo5 = '' or isnull(pld_campo5)) then 0 else 1 end)+
            (case when (pld_campo6 = '' or isnull(pld_campo6)) then 0 else 1 end)+
            (case when (pld_campo7 = '' or isnull(pld_campo7)) then 0 else 1 end)+
            (case when (pld_campo8 = '' or isnull(pld_campo8)) then 0 else 1 end)+
            (case when (pld_campo9 = '' or isnull(pld_campo9)) then 0 else 1 end)+
            (case when (pld_campo10 = '' or isnull(pld_campo10)) then 0 else 1 end)+
            (case when (pld_campo11 = '' or isnull(pld_campo11)) then 0 else 1 end)+
            (case when (pld_campo12 = '' or isnull(pld_campo12)) then 0 else 1 end)+
            (case when (pld_campo13 = '' or isnull(pld_campo13)) then 0 else 1 end)+
            (case when (pld_campo14 = '' or isnull(pld_campo14)) then 0 else 1 end)+
            (case when (pld_campo15 = '' or isnull(pld_campo15)) then 0 else 1 end)+
            (case when (pld_campo16 = '' or isnull(pld_campo16)) then 0 else 1 end)+
            (case when (pld_campo17 = '' or isnull(pld_campo17)) then 0 else 1 end)+
            (case when (pld_campo22 = '' or isnull(pld_campo18)) then 0 else 1 end)+
            (case when (pld_campo24 = '' or isnull(pld_campo19)) then 0 else 1 end)+
            (case when (pld_campo25 = '' or isnull(pld_campo20)) then 0 else 1 end)+
            (case when (pld_campo26 = '' or isnull(pld_campo21)) then 0 else 1 end)+
            (case when (pld_campo27 = '' or isnull(pld_campo22)) then 0 else 1 end)
            
            )*15) /20 campo1
            from 
            tra_plan_detalle
            where 
            pld_pla_correlativo = :correlativo
            union all 
            select 
            (((case when (pld_campo29 = '' or isnull(pld_campo29)) then 0 else 1 end) +
            (case when (pld_campo30 = '' or isnull(pld_campo30)) then 0 else 1 end)+
            (case when (pld_campo31 = '' or isnull(pld_campo31)) then 0 else 1 end)+
            (case when (pld_campo32 = '' or isnull(pld_campo32)) then 0 else 1 end)
            )*15) /4 campo1
            from 
            tra_plan_detalle
            where 
            pld_pla_correlativo = :correlativo
            union all
            select 
            max(
            (((case when (pam_campo1 = '' or isnull(pam_campo1)) then 0 else 1 end)+
            (case when (pam_campo2 = '' or isnull(pam_campo2)) then 0 else 1 end)+
            (case when (pam_campo3 = '' or isnull(pam_campo3)) then 0 else 1 end)+
            (case when (pam_campo4 = '' or isnull(pam_campo4)) then 0 else 1 end)+
            (case when (pam_campo5 = '' or isnull(pam_campo5)) then 0 else 1 end)+
            (case when (pam_campo6 = '' or isnull(pam_campo6)) then 0 else 1 end)+
            (case when (pam_campo7 = '' or isnull(pam_campo7)) then 0 else 1 end)+
            (case when (pam_campo8 = '' or isnull(pam_campo8)) then 0 else 1 end)+
            (case when (pam_campo12 = '' or isnull(pam_campo12)) then 0 else 1 end)
            )*15)/9) campo1
            from 
            tra_plan_amenaza
            where
            pam_pde_correlativo = :correlativo
            and pam_tipo = '2_2'
            union all
            select 
            max(
            (((case when (pam_campo1 = '' or isnull(pam_campo1)) then 0 else 1 end)+
            (case when (pam_campo2 = '' or isnull(pam_campo2)) then 0 else 1 end)+
            (case when (pam_campo3 = '' or isnull(pam_campo3)) then 0 else 1 end))*10)/3) campo1
            from 
            tra_plan_amenaza
            where
            pam_pde_correlativo = :correlativo
            and pam_tipo = '3_1'
            union all 
            select 
            max(
            (((case when (pam_campo1 = '' or isnull(pam_campo1)) then 0 else 1 end)+
            (case when (pam_campo2 = '' or isnull(pam_campo2)) then 0 else 1 end)+
            (case when (pam_campo3 = '' or isnull(pam_campo3)) then 0 else 1 end)+
            (case when (pam_campo4 = '' or isnull(pam_campo4)) then 0 else 1 end)+
            (case when (pam_campo5 = '' or isnull(pam_campo5)) then 0 else 1 end)+
            (case when (pam_campo6 = '' or isnull(pam_campo6)) then 0 else 1 end)
            )*5)/6) campo1
            from 
            tra_plan_amenaza
            where
            pam_pde_correlativo = :correlativo
            and pam_tipo = '4_1'
            union all
            select 
            max(
            (((case when (pam_campo1 = '' or isnull(pam_campo1)) then 0 else 1 end)+
            (case when (pam_campo2 = '' or isnull(pam_campo2)) then 0 else 1 end)+
            (case when (pam_campo3 = '' or isnull(pam_campo3)) then 0 else 1 end)+
            (case when (pam_campo4 = '' or isnull(pam_campo4)) then 0 else 1 end)
            )*10)/4) campo1
            from 
            tra_plan_amenaza
            where
            pam_pde_correlativo = :correlativo
            and pam_tipo = '6_1'
            union all
            select 
            max(
            (((case when (pam_campo1 = '' or isnull(pam_campo1)) then 0 else 1 end)+
            (case when (pam_campo2 = '' or isnull(pam_campo2)) then 0 else 1 end)+
            (case when (pam_campo3 = '' or isnull(pam_campo3)) then 0 else 1 end)+
            (case when (pam_campo4 = '' or isnull(pam_campo4)) then 0 else 1 end)+
            (case when (pam_campo5 = '' or isnull(pam_campo5)) then 0 else 1 end)
            )*5)/5) campo1
            from 
            tra_plan_amenaza
            where
            pam_pde_correlativo = :correlativo
            and pam_tipo = '6_2'
            union all
            select 
            max(
            (((case when (pam_campo1 = '' or isnull(pam_campo1)) then 0 else 1 end)+
            (case when (pam_campo2 = '' or isnull(pam_campo2)) then 0 else 1 end)+
            (case when (pam_campo3 = '' or isnull(pam_campo3)) then 0 else 1 end)+
            (case when (pam_campo4 = '' or isnull(pam_campo4)) then 0 else 1 end)+
            (case when (pam_campo5 = '' or isnull(pam_campo5)) then 0 else 1 end)
            )*5)/5) campo1
            from 
            tra_plan_amenaza
            where
            pam_pde_correlativo = :correlativo
            and pam_tipo = '6_3'
            ) a
            ";
    
            $stmt = $connection->prepare($sql);
            $result = $stmt->execute([
                'correlativo'=>$correlativo
            ]);
            $result = $stmt->fetchAll($connection::FETCH_OBJ);
            if ($stmt->rowCount() > 0) {
                $response = $result[0]->avance;
            }
            
            return $response;
    }
    public function updateAvancePPRE($connection,$avance,$correlativo){
        $response = "nOk";
        $sql = " update tra_plan set pla_avance = :avance where pla_correlativo = :correlativo";
    
            $stmt = $connection->prepare($sql);
            $result = $stmt->execute([
                'avance'=>$avance,
                'correlativo'=>$correlativo
            ]);
            $response = "OK";
            return $response;
    }
    public function getCorrelativo($connection, $pNomTabla, $pNomColumna, $pFiltro) {
        $rst_correl_sig = 0;
        $sql = "select IFNULL(max($pNomColumna),0) correlativo from $pNomTabla where 1=1 $pFiltro";
        $stmt = $connection->query($sql);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);
        if ($stmt->rowCount() > 0) {
            $rst_correl_sig = (($result[0]->correlativo) );
        } else {
            $rst_correl_sig = 0;
        }
        return $rst_correl_sig;
    }
    public function getProbabilidadCorrel($connection, $correlativo, $probabilidad){
        $rst_correl_sig = 0;
        $sql = "select pam_correlativo correlativo
        from tra_plan_amenaza 
        where 
        pam_pde_correlativo = $correlativo
        and pam_tipo = '2_1'
        and position('$probabilidad' in pam_campo1)>0";
        $stmt = $connection->query($sql);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);
        
        if ($stmt->rowCount() > 0) {
            $rst_correl_sig = (($result[0]->correlativo) );
        } else {
            $rst_correl_sig = 0;
        }
        return $rst_correl_sig;
    }
    public function updateMatrizRiesgo($connection,$campo,$correlativo, $valor,$pam_pde_correlativo){
        $response = "nOk";
        $sql = " update tra_plan_amenaza set $campo = concat(IFNULL($campo,''), (case when ($campo is null || $campo = '') then '' else ',' end),'$valor') where pam_correlativo = $correlativo";
        
            $stmt = $connection->prepare($sql);
            $result = $stmt->execute();

            $sql = "select $campo campo from tra_plan_amenaza where pam_correlativo = $correlativo";
            $stmt = $connection->prepare($sql);
                $stmt->execute();
                
                $result = $stmt->fetchAll($connection::FETCH_OBJ);
                if ($stmt->rowCount() > 0) {
                    $valor = $result[0]->campo;
                    $string = rtrim($valor, ',');
                    $string = ltrim($valor, ',');

                    $sql ="update tra_plan_amenaza set $campo = '$string' where pam_correlativo = $correlativo";
                    $stmt2 = $connection->prepare($sql);
                    $result2 = $stmt2->execute();

                }

                $sql = "update  tra_plan_amenaza
                    set  
                    pam_campo2 =replace(trim(trailing ',' from pam_campo2),',,',','),
                    pam_campo3 =replace(trim(trailing ',' from pam_campo3),',,',','),
                    pam_campo4 =replace(trim(trailing ',' from pam_campo4),',,',','),
                    pam_campo5 =replace(trim(trailing ',' from pam_campo5),',,',','),
                    pam_campo6 =replace(trim(trailing ',' from pam_campo6),',,',','),
                    pam_campo7 =replace(trim(trailing ',' from pam_campo7),',,',','),
                    pam_campo8 =replace(trim(trailing ',' from pam_campo8),',,',','),
                    pam_campo9 =replace(trim(trailing ',' from pam_campo9),',,',','),
                    pam_campo10 =replace(trim(trailing ',' from pam_campo10),',,',','),
                    pam_campo11 =replace(trim(trailing ',' from pam_campo11),',,',',')
                    where pam_tipo = '2_1'
                    
                    and pam_pde_correlativo = $pam_pde_correlativo";
                    $stmt = $connection->prepare($sql);
                    $result2 = $stmt->execute();


                    $sql = "update  tra_plan_amenaza
                    set  
                    pam_campo2 =trim(both ',' from pam_campo2),
                    pam_campo3 =trim(both ',' from pam_campo3),
                    pam_campo4 =trim(both ',' from pam_campo4),
                    pam_campo5 =trim(both ',' from pam_campo5),
                    pam_campo6 =trim(both ',' from pam_campo6),
                    pam_campo7 =trim(both ',' from pam_campo7),
                    pam_campo8 =trim(both ',' from pam_campo8),
                    pam_campo9 =trim(both ',' from pam_campo9),
                    pam_campo10 =trim(both ',' from pam_campo10),
                    pam_campo11 =trim(both ',' from pam_campo11)
                    where pam_tipo = '2_1'
                    
                    and pam_pde_correlativo = $pam_pde_correlativo";
                    $stmt = $connection->prepare($sql);
                    $result3 = $stmt->execute();

                
            //$stmt->debugDumpParams();
            $response = "OK";
            return $response;
            
    }
    public function updateCamposMatriz($connection,$campo,$correlativo,$valor_anterior){
        $response = "nOk";
        $sql = "update  tra_plan_amenaza
        set  
        pam_campo2 =replace(pam_campo2,'$valor_anterior',''),
        pam_campo3 =replace(pam_campo3,'$valor_anterior',''),
        pam_campo4 =replace(pam_campo4,'$valor_anterior',''),
        pam_campo5 =replace(pam_campo5,'$valor_anterior',''),
        pam_campo6 =replace(pam_campo6,'$valor_anterior',''),
        pam_campo7 =replace(pam_campo7,'$valor_anterior',''),
        pam_campo8 =replace(pam_campo8,'$valor_anterior',''),
        pam_campo9 =replace(pam_campo9,'$valor_anterior',''),
        pam_campo10 =replace(pam_campo10,'$valor_anterior',''),
        pam_campo11 =replace(pam_campo11,'$valor_anterior','')
        where pam_tipo = '2_1'
        and (
            pam_campo2 like '%$valor_anterior%' or
            pam_campo3 like '%$valor_anterior%' or
            pam_campo4 like '%$valor_anterior%' or
            pam_campo5 like '%$valor_anterior%' or
            pam_campo6 like '%$valor_anterior%' or
            pam_campo7 like '%$valor_anterior%' or
            pam_campo8 like '%$valor_anterior%' or
            pam_campo9 like '%$valor_anterior%' or
            pam_campo10 like '%$valor_anterior%' or
            pam_campo11 like '%$valor_anterior%' 
        )
        and pam_pde_correlativo = $correlativo";
        
            $stmt = $connection->prepare($sql);
            $result = $stmt->execute();
            //$stmt->debugDumpParams();
            //ejecucion de 2 query
            $sql = "update  tra_plan_amenaza
                    set  
                    pam_campo2 =replace(trim(trailing ',' from pam_campo2),',,',','),
                    pam_campo3 =replace(trim(trailing ',' from pam_campo3),',,',','),
                    pam_campo4 =replace(trim(trailing ',' from pam_campo4),',,',','),
                    pam_campo5 =replace(trim(trailing ',' from pam_campo5),',,',','),
                    pam_campo6 =replace(trim(trailing ',' from pam_campo6),',,',','),
                    pam_campo7 =replace(trim(trailing ',' from pam_campo7),',,',','),
                    pam_campo8 =replace(trim(trailing ',' from pam_campo8),',,',','),
                    pam_campo9 =replace(trim(trailing ',' from pam_campo9),',,',','),
                    pam_campo10 =replace(trim(trailing ',' from pam_campo10),',,',','),
                    pam_campo11 =replace(trim(trailing ',' from pam_campo11),',,',',')
                    where pam_tipo = '2_1'
                    
                    and pam_pde_correlativo = $correlativo";
                    $stmt = $connection->prepare($sql);
                    $result2 = $stmt->execute();


                    $sql = "update  tra_plan_amenaza
                    set  
                    pam_campo2 =trim(both ',' from pam_campo2),
                    pam_campo3 =trim(both ',' from pam_campo3),
                    pam_campo4 =trim(both ',' from pam_campo4),
                    pam_campo5 =trim(both ',' from pam_campo5),
                    pam_campo6 =trim(both ',' from pam_campo6),
                    pam_campo7 =trim(both ',' from pam_campo7),
                    pam_campo8 =trim(both ',' from pam_campo8),
                    pam_campo9 =trim(both ',' from pam_campo9),
                    pam_campo10 =trim(both ',' from pam_campo10),
                    pam_campo11 =trim(both ',' from pam_campo11)
                    where pam_tipo = '2_1'
                    
                    and pam_pde_correlativo = $correlativo";
                    $stmt = $connection->prepare($sql);
                    $result3 = $stmt->execute();
            $response = "OK";
            return $response;
            
    }
    public function getAttachment($connection,$codigo){
        $response = [];
        
        $sql = " select
        att_correl,
        att_codigo,
        att_empresa,
        att_objeto,
        att_objeto_codigo,
        att_tipo,
        att_etapa,
        att_direccion,
        att_archivo,
        att_visibilidad,
        att_estado,
        att_usuarioi,
        att_usuariom,
        att_fechai,
        att_fecham,
        att_version,
        att_seccion
        from 
        tra_attachment ta 
        where 
        att_objeto = 'PPRE' 
        and att_objeto_codigo = :codigo
        and att_estado = 'A'
        ";
        $stmt = $connection->prepare($sql);
        $stmt->execute(['codigo' => $codigo]);
        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        $response = $result;
        //$stmt->debugDumpParams();
        
        return $response;
}
public function insertTraPlanAmenazaMatriz($connection,$pam_pde_correlativo,$pam_tipo, $id_usuario,$pam_campo1){
    $response = "nOk";
    $correlativo = $this->CorrelAutomatico($connection, "tra_plan_amenaza", "pam_correlativo", "");
    
    $sql = " insert into tra_plan_amenaza ( 
        pam_correlativo,
        pam_pde_correlativo,
        pam_tipo,
        pam_campo1,
        pam_campo11,
        pam_usuarioi,
        pam_usuariom,
        pam_fechai,
        pam_fecham
        )
        values(
            :pam_correlativo,
            :pam_pde_correlativo,
            :pam_tipo,
            :pam_campo1,
            null,
            :pam_usuarioi,
            :pam_usuarioi,
            now(),
            now()
        )
        ";
        $stmt = $connection->prepare($sql);
        $result = $stmt->execute([
            'pam_correlativo' => $correlativo,
            'pam_pde_correlativo' => $pam_pde_correlativo,
            'pam_tipo' => $pam_tipo,
            'pam_campo1'=> $pam_campo1,
            'pam_usuarioi' => $id_usuario,
        ]);
        $response = "OK";
        return $response;
}
public function insertEdanDetalle($connection,
            $edt_edan_correlativo, 
            $edt_campo1, 
            $edt_campo2, 
            $edt_campo3, 
            $edt_campo4, 
            $edt_campo5, 
            $edt_campo6, 
            $edt_campo7, 
            $edt_campo8, 
            $edt_campo9, 
            $edt_campo10, 
            $edt_campo11, 
            $edt_campo12, 
            $edt_campo13, 
            $edt_campo14, 
            $edt_campo15, 
            $edt_campo16, 
            $edt_campo17, 
            $edt_campo18, 
            $edt_campo19, 
            $edt_campo20, 
            $edt_tipo, 
            $edt_usuarioi){
    $response = "nOk";
    $edt_correlativo = $this->CorrelAutomatico($connection, "tra_edan_detalle", "edt_correlativo", "");
    $sql = " insert 
    into
    tra_edan_detalle
    (
        edt_correlativo, 
        edt_edan_correlativo, 
        edt_campo1, 
        edt_campo2, 
        edt_campo3, 
        edt_campo4, 
        edt_campo5, 
        edt_campo6, 
        edt_campo7, 
        edt_campo8, 
        edt_campo9, 
        edt_campo10, 
        edt_campo11, 
        edt_campo12, 
        edt_campo13, 
        edt_campo14, 
        edt_campo15, 
        edt_campo16, 
        edt_campo17, 
        edt_campo18, 
        edt_campo19, 
        edt_campo20, 
        edt_tipo, 
        edt_estado,
        edt_usuarioi, 
        edt_usuariom, 
        edt_fechai, 
        edt_fecham
        )
        values
        (
            :edt_correlativo, 
            :edt_edan_correlativo, 
            :edt_campo1, 
            :edt_campo2, 
            :edt_campo3, 
            :edt_campo4, 
            :edt_campo5, 
            :edt_campo6, 
            :edt_campo7, 
            :edt_campo8, 
            :edt_campo9, 
            :edt_campo10, 
            :edt_campo11, 
            :edt_campo12, 
            :edt_campo13, 
            :edt_campo14, 
            :edt_campo15, 
            :edt_campo16, 
            :edt_campo17, 
            :edt_campo18, 
            :edt_campo19, 
            :edt_campo20, 
            :edt_tipo, 
            'A',
            :edt_usuarioi, 
            :edt_usuarioi, 
            now(), 
            now()
        )    
        ";
        $stmt = $connection->prepare($sql);
        $result = $stmt->execute([
            'edt_correlativo' => $edt_correlativo,
            'edt_edan_correlativo' => $edt_edan_correlativo,
            'edt_campo1' => $edt_campo1,
            'edt_campo2' => $edt_campo2,
            'edt_campo3' => $edt_campo3,
            'edt_campo4' => $edt_campo4,
            'edt_campo5' => $edt_campo5,
            'edt_campo6' => $edt_campo6,
            'edt_campo7' => $edt_campo7,
            'edt_campo8' => $edt_campo8,
            'edt_campo9' => $edt_campo9,
            'edt_campo10' => $edt_campo10,
            'edt_campo11' => $edt_campo11,
            'edt_campo12' => $edt_campo12,
            'edt_campo13' => $edt_campo13,
            'edt_campo14' => $edt_campo14,
            'edt_campo15' => $edt_campo15,
            'edt_campo16' => $edt_campo16,
            'edt_campo17' => $edt_campo17,
            'edt_campo18' => $edt_campo18,
            'edt_campo19' => $edt_campo19,
            'edt_campo20' => $edt_campo20,
            'edt_tipo' => $edt_tipo,
            'edt_usuarioi' => $edt_usuarioi
        ]);
        $response = "OK";
        return $response;
}
public function insertEdandanio($connection,
            $edd_edan_correlativo, 
            $edd_campo1, 
            $edd_campo2, 
            $edd_campo3,  
            $edd_tipo, 
            $edt_usuarioi){
    $response = "nOk";
    $edd_correlativo = $this->CorrelAutomatico($connection, "tra_edan_danio", "edd_correlativo", "");
    $sql = " insert 
    into
    tra_edan_danio
    (
        edd_correlativo, 
        edd_edan_correlativo, 
        edd_campo1, 
        edd_campo2, 
        edd_campo3,  
        edd_tipo, 
        edd_estado,
        edd_usuarioi, 
        edd_usuariom, 
        edd_fechai, 
        edd_fecham
        )
        values
        (
            :edd_correlativo, 
            :edd_edan_correlativo, 
            :edd_campo1, 
            :edd_campo2, 
            :edd_campo3,  
            :edd_tipo, 
            'A',
            :edd_usuarioi, 
            :edd_usuarioi, 
            now(), 
            now()
        )    
        ";
        $stmt = $connection->prepare($sql);
        $result = $stmt->execute([
            'edd_correlativo' => $edd_correlativo,
            'edd_edan_correlativo' => $edd_edan_correlativo,
            'edd_campo1' => $edd_campo1,
            'edd_campo2' => $edd_campo2,
            'edd_campo3' => $edd_campo3,
            'edd_tipo' => $edd_tipo,
            'edd_usuarioi' => $edt_usuarioi
        ]);
        $response = "OK";
        return $response;
}
public function traEdanDanio($connection,$edd_tipo, $edd_edan_correlativo){
    $response = [];
    
    $sql = " select 
    edd_correlativo,
    edd_edan_correlativo,
    edd_campo1,
    edd_campo2,
    edd_campo3,
    edd_tipo,
    edd_estado,
    edd_usuarioi,
    edd_usuariom,
    edd_fechai,
    edd_fecham
    from 
    tra_edan_danio
    where 
    1=1
    and edd_edan_correlativo = :edd_edan_correlativo
    and edd_tipo = :edd_tipo
    ";
    $stmt = $connection->prepare($sql);
    $stmt->execute(['edd_tipo' => $edd_tipo,'edd_edan_correlativo'=>$edd_edan_correlativo]);
    $result = $stmt->fetchAll($connection::FETCH_OBJ);
    $response = $result;
    $PDO = null;
    return $response;
}
    public function traEdanDetalle  ($connection,$edt_tipo, $edt_edan_correlativo){
        $response = [];
        
        $sql = " select
        edt_correlativo,
        edt_edan_correlativo,
        edt_campo1,
        edt_campo2,
        edt_campo3,
        edt_campo4,
        edt_campo5,
        edt_campo6,
        edt_campo7,
        edt_campo8,
        edt_campo9,
        edt_campo10,
        edt_campo11,
        edt_campo12,
        edt_campo13,
        edt_campo14,
        edt_campo15,
        edt_campo16,
        edt_campo17,
        edt_campo18,
        edt_campo19,
        edt_campo20,
        edt_estado,
        edt_tipo,
        edt_usuarioi,
        edt_usuariom,
        edt_fechai,
        edt_fecham
        from 
        tra_edan_detalle
        where 
        1=1
        and edt_edan_correlativo = :edt_edan_correlativo
        and edt_tipo = :edt_tipo
        ";
        $stmt = $connection->prepare($sql);
        $stmt->execute(['edt_tipo' => $edt_tipo,'edt_edan_correlativo'=>$edt_edan_correlativo]);
        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        $response = $result;
        $PDO = null;
        
        return $response;
    }

    public function getSubAmenaza($connection,$pam_correlativo,$pam_pde_correlativo){
        $response = [];
        
        $sql = " select 
        pam_correlativo,
        pam_pde_correlativo,
        dep.cat_nombre pam_campo1,
        mun.cat_nombre pam_campo2,
        pam_campo3,
        pam_campo4,
        pam_campo5,
        pam_campo6,
        pam_campo7,
        pam_campo8,
        pam_campo9,
        pam_campo10,
        pam_campo11,
        
        pam_campo12,
        pam_campo12 anterior_campo21,
        pam_tipo,
        pam_usuarioi,
        pam_usuariom,
        pam_fechai,
        pam_fecham
        from 
        tra_plan_amenaza
        left outer join cfg_catalogo dep on(dep.cat_tipo = 'GT_DEPTO' AND dep.cat_valor = pam_campo1)
        left outer join cfg_catalogo mun on(mun.cat_tipo = 'GT_MUNI' AND mun.cat_valor = pam_campo2)
        where 
        1=1
        and pam_pde_correlativo=:pam_pde_correlativo
        and pam_campo12 = :pam_correlativo
        ";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'pam_pde_correlativo' => $pam_pde_correlativo,
            'pam_correlativo' => $pam_correlativo
        ]);
        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        $response = $result;
        //$stmt->debugDumpParams();
        $PDO = null;
        
        return $response;
    }

    public function createZip($correlativo){
        if(ini_get('zlib.output_compression')){ini_set('zlib.output_compression', 'Off');}
        $zip = new ZipArchive();
        $userFolder = FILE_DIR.DIRECTORY_SEPARATOR;
        $file = $userFolder.$correlativo."_".FILE_NAME;
        $dbConnection = new DBConnection();
        $conexion = $dbConnection->setConnection();
        if ($conexion == "OK") {
            $PDO = $dbConnection->getConnection();
            $attachment = $this->getAttachment($PDO,$correlativo);
            $mask = $userFolder.'PPRE-'.$correlativo.'-*.*';
            array_map('unlink', glob($mask));

            $digits = 3;
            $randomNum = rand(pow(10, $digits-1), pow(10, $digits)-1);
            $zipFile = $userFolder.'PPRE-'.$correlativo.'-'.$randomNum.'.zip';
            if(file_exists($zipFile)){
                unlink($zipFile);
            }
            //creamos nuevo zip
            if ($zip->open($zipFile, ZipArchive::CREATE) === TRUE){
                //añadimos ppre
                $zip->addFile($file,FILE_NAME);
                //añadimos excel de soporte
                foreach($attachment as $idx =>$val){
                    $zip->addFile($val->att_direccion.DIRECTORY_SEPARATOR.$val->att_archivo,$val->att_archivo);
                }
                $zip->close();
            }
            $zipFile = DOWNLOAD_PPRE.DIRECTORY_SEPARATOR.'PPRE-'.$correlativo.'-'.$randomNum.'.zip';
        }else{
            echo $conexion;
        }
        return $zipFile;
    }

    public function validateUser($connection, $usr_email, $usr_password) {
        $conteo = 0;

        $sql = "select count(1)conteo from cfg_usuario where usr_email = :usr_email and usr_password = :usr_password and usr_estado = 'A'";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'usr_email' => $usr_email,
            'usr_password' => $usr_password
        ]);
        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        //$stmt->debugDumpParams();
        if ($stmt->rowCount() > 0) {
            $conteo = (($result[0]->conteo) );
        } else {
            $conteo = 0;
        }
        return $conteo;
    }

    public function search_img_array($array,$search){
        $valor = [];
        foreach($array as $idx =>$val){
            if($val->att_seccion == $search){
                $valor = $val;
            }
        }
        return $valor;
    }


    public function traPlanAmenazaCatalogo($connection,$pam_tipo, $pam_pde_correlativo){
        $response = [];
        
        $sql = " select 
        pam_correlativo,
        pam_pde_correlativo,
        pr.cat_nombre pam_campo1,
        im.cat_nombre pam_campo2,
        pam_campo3,
        pam_campo4,
        pam_campo5,
        pam_campo6,
        pam_campo7,
        pam_campo8,
        pam_campo9,
        pam_campo10,
        pam_campo11,
        pam_tipo,
        pam_usuarioi,
        pam_usuariom,
        pam_fechai,
        pam_fecham
        from 
        tra_plan_amenaza
        left outer join cfg_catalogo pr on (pr.cat_tipo = 'CMB_PROBABILIDAD' and pr.cat_valor = pam_campo1)
        left outer join cfg_catalogo im on (im.cat_tipo = 'CMB_IMPACTO' and im.cat_valor = pam_campo2)
        where 
        1=1
        and pam_pde_correlativo=:pam_pde_correlativo
        and pam_tipo = :pam_tipo
        ";

        $stmt = $connection->prepare($sql);
        $stmt->execute(['pam_tipo' => $pam_tipo,'pam_pde_correlativo'=>$pam_pde_correlativo]);
        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        $response = $result;
        $PDO = null;
        return $response;
}

public function traPlanAmenazaCatalogoDeptos($connection,$pam_tipo, $pam_pde_correlativo){
    $response = [];
    
    $sql = " select 
    pam_correlativo,
    pam_pde_correlativo,
    pr.cat_nombre pam_campo1,
    im.cat_nombre pam_campo2,
    pam_campo3,
    pam_campo4,
    pam_campo5,
    pam_campo6,
    pam_campo7,
    pam_campo8,
    pam_campo9,
    pam_campo10,
    pam_campo11,
    pam_tipo,
    pam_usuarioi,
    pam_usuariom,
    pam_fechai,
    pam_fecham
    from 
    tra_plan_amenaza
    left outer join cfg_catalogo pr on (pr.cat_tipo = 'GT_DEPTO' and pr.cat_valor = pam_campo1)
    left outer join cfg_catalogo im on (im.cat_tipo = 'GT_MUNI' and im.cat_valor = pam_campo2)
    where 
    1=1
    and pam_pde_correlativo=:pam_pde_correlativo
    and pam_tipo = :pam_tipo
    ";

    $stmt = $connection->prepare($sql);
    $stmt->execute(['pam_tipo' => $pam_tipo,'pam_pde_correlativo'=>$pam_pde_correlativo]);
    $result = $stmt->fetchAll($connection::FETCH_OBJ);
    $response = $result;
    $PDO = null;
    return $response;
}

public function insertFuncionalidadAmbiente($connection,$fua_funcionalidad,$amb_codigo, $fua_titulo, $id_usuario){
    $response = "nOk";
    $fua_codigo = $this->CorrelAutomatico($connection, "cfg_funcionalidad_ambiente", "fua_codigo", "");
    $sql = " insert into cfg_funcionalidad_ambiente ( 
        fua_codigo,
        fua_funcionalidad,
        fua_ambiente,
        fua_titulo,
        fua_estado,
        fua_usuarioi,
        fua_usuariom,
        fua_fechai,
        fua_fecham
        )values(
            :fua_codigo,
            :fua_funcionalidad,
            :fua_ambiente,
            :fua_titulo,
            'A',
            :id_usuario,
            :id_usuario,
            now(),
            now()
        )
        ";

        $stmt = $connection->prepare($sql);
        $result = $stmt->execute([
            'fua_codigo' => $fua_codigo,
            'fua_funcionalidad' => $fua_funcionalidad,
            'fua_ambiente' => $amb_codigo,
            'fua_titulo' => $fua_titulo,
            'id_usuario' => $id_usuario,
        ]);
        $response = "OK";
        return $response;
}

    public function buscarRegistro($connection, $pNomTabla, $pNomColumna, $pFiltro,$campo1) {//MOISES
        $rst_correl_sig = 0;
        $sql = "select 
                $pNomColumna  
                from $pNomTabla where 1=1 $pFiltro";

        $stmt = $connection->prepare($sql);
        $stmt->execute(['valorCampo1' => $campo1]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if (!empty($stmt)) {
            if(isset($result[0])){
                $rst_correl_sig = (($result[0]->dato));
            }else{
                $rst_correl_sig = 0;
            }
        }else{
            $rst_correl_sig = 0;
        }
        return $rst_correl_sig;
    }

    public function buscarRegistroObj($connection, $pNomTabla, $pNomColumna, $pFiltro,$campo1, $pOpcional) {
        $response = [];
        $sql = "select 
                $pNomColumna  
                from $pNomTabla where 1=1 $pFiltro $pOpcional";
        $stmt = $connection->prepare($sql);
            $stmt->execute(['valorCampo1' => $campo1]);
            $result = $stmt->fetchAll($connection::FETCH_OBJ);
            $response = $result;
            
        return $sql;
    }
    public function validarLongitudString($pValor,$inicio, $longitud) {
        $rst_valor = "";
        if(strlen($pValor) > $longitud){
            $rst_valor = substr($pValor, $inicio, $longitud);
        }else{
            $rst_valor = $pValor;
        }
        return $rst_valor;
    }
    public function validarLongitudNumero($pValor,$inicio, $longitud) {
        $rst_valor = 0;
        if(strlen($pValor) > $longitud){
            $rst_valor = substr($pValor, $inicio, $longitud);
        }else{
            $rst_valor = $pValor;
        }
        return $rst_valor;
    }

    public function ultimoRegistro($connection, $pNomTabla, $pNomColumna, $pFiltro) {
            $rst_correl_sig = 0;
    
            $sql = "select $pNomColumna correlativo from $pNomTabla where 1=1 $pFiltro";
    
            $stmt = $connection->query($sql);
            $result = $stmt->fetchAll(PDO::FETCH_OBJ);
    
            if ($stmt->rowCount() > 0) {
                $rst_correl_sig = (($result[0]->correlativo) );
            } else {
                $rst_correl_sig = 0;
            }
            return $rst_correl_sig;
    }

    public function validarHorarioSucursal($connection, $pNomTabla, $pNomColumnaCorrelativo, $tra_fecha_inicio_consulta, $tra_fecha_fin_consulta, $pSucursal, $pFiltro) {
        $result_horario = 0;
        $sql = "
        SELECT 
        CASE
        WHEN DAYOFWEEK(:fecha_inicio) >= 2 and DAYOFWEEK(:fecha_inicio) <=6 THEN (if(TIME(:fecha_inicio) >= TIME(suc_horario_lunes_a_viernes_inicio),1,0) and if(TIME(:fecha_fin) <= TIME(suc_horario_lunes_a_viernes_fin),1,0))
        WHEN DAYOFWEEK(:fecha_inicio) = 1 THEN (if(TIME(:fecha_inicio) >= TIME(suc_horario_domingo_inicio),1,0) and if(TIME(:fecha_fin) <= TIME(suc_horario_domingo_fin),1,0))
        WHEN DAYOFWEEK(:fecha_inicio) = 7 THEN (if(TIME(:fecha_inicio) >= TIME(suc_horario_sabado_inicio),1,0) and if(TIME(:fecha_fin) <= TIME(suc_horario_sabado_fin),1,0))
        ELSE ''
        END AS resultado FROM $pNomTabla WHERE suc_correlativo = :sucursal AND suc_estado !='E'";
        
        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'fecha_inicio' => $tra_fecha_inicio_consulta,
            'fecha_fin' => $tra_fecha_fin_consulta,
            'sucursal' => $pSucursal
        ]);
        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        if($stmt->rowCount() > 0) {
            $result_horario = (($result[0]->resultado));
        }else{
            $result_horario = 0;
        }

        return $result_horario;
    }
    public function validarHorarioServicioCentro($connection, $pNomTabla, $tra_fecha_inicio_consulta, $tra_fecha_fin_consulta, $pSucursal, $pServicio, $pFiltro) {
        $result_horario = 0;
        $sql = "
        SELECT 
        CASE
        WHEN DAYOFWEEK(:tra_fecha_inicio_consulta) >= 2 and DAYOFWEEK(:tra_fecha_inicio_consulta) <=6 THEN (if(TIME(:tra_fecha_inicio_consulta) >= ocf_hora_inicio_lav,1,0) and if(TIME(:tra_fecha_fin_consulta) <= ocf_hora_fin_lav,1,0))
        WHEN DAYOFWEEK(:tra_fecha_inicio_consulta) = 1 THEN (if(TIME(:tra_fecha_inicio_consulta) >= ocf_hora_inicio_domingo,1,0) and if(TIME(:tra_fecha_fin_consulta) <= ocf_hora_fin_domingo,1,0))
        WHEN DAYOFWEEK(:tra_fecha_inicio_consulta) = 7 THEN (if(TIME(:tra_fecha_inicio_consulta) >= ocf_hora_inicio_sabado,1,0) and if(TIME(:tra_fecha_fin_consulta) <= ocf_hora_fin_sabado,1,0))
        ELSE ''
        END AS resultado FROM $pNomTabla WHERE ocf_param_tipo = :servicio AND ocf_objeto_codigo = :sucursal AND ocf_estado ='A'";
        
        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'tra_fecha_inicio_consulta' => $tra_fecha_inicio_consulta,
            'tra_fecha_fin_consulta' => $tra_fecha_fin_consulta,
            'sucursal' => $pSucursal,
            'servicio' => $pServicio
        ]);
        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        if($stmt->rowCount() > 0) {
            $result_horario = (($result[0]->resultado));
        }else{
            $result_horario = 0;
        }

        return $result_horario;//$sql." ".$tra_fecha_inicio_consulta." ".$tra_fecha_fin_consulta;//rst_correl_sig
    }
    public function validarHorariosServicio($connection, $pNomTabla, $pNomColumnaCorrelativo, $pDiaInicio, $pDiaFin,$pHoraInicio,$pHoraFin, $pSucursal, $pFiltro) {
        $result_horario = 0;
        $sql = "
        SELECT 
        CASE
        WHEN (:dia_inicio) >= 2 and (:dia_fin) <=6 THEN (if(TIME(:pHoraInicio) >= suc_horario_lunes_a_viernes_inicio,1,0) and if(TIME(:pHoraFin) <= suc_horario_lunes_a_viernes_fin,1,0))
        WHEN (:dia_inicio) = 1 THEN (if(TIME(:pHoraInicio) >= suc_horario_domingo_inicio,1,0) and if(TIME(:pHoraFin) <= suc_horario_domingo_fin,1,0))
        WHEN (:dia_inicio) = 7 THEN (if(TIME(:pHoraInicio) >= suc_horario_sabado_inicio,1,0) and if(TIME(:pHoraFin) <= suc_horario_sabado_fin,1,0))
        ELSE ''
        END AS resultado FROM $pNomTabla WHERE suc_correlativo = :sucursal AND suc_estado !='E'";
        
        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'dia_inicio' => $pDiaInicio,
            'dia_fin' => $pDiaFin,
            'sucursal' => $pSucursal,
            'pHoraInicio' => $pHoraInicio,
            'pHoraFin' => $pHoraFin
        ]);
        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        if($stmt->rowCount() > 0) {
            $result_horario = (($result[0]->resultado));
        }else{
            $result_horario = 0;
        }

        return $result_horario;//$sql." ".$tra_fecha_inicio_consulta." ".$tra_fecha_fin_consulta;//rst_correl_sig
    }
    public function validarAgendaMedico($connection, $pNomTabla, $pNomColumna, $pUsuario,$pCentro, $pConsulta, $pFechaInicio, $pFechaFin, $pFiltro) {
            $rst_correl_sig = 0;
    
            $sql = "
            select  
            age_correlativo AS correlativo 
            from $pNomTabla 
            where 1=1 
            and age_usr_correl = :usuario 
            and age_fecha_inicio BETWEEN :fechainicio and :fechafin and age_fecha_fin BETWEEN :fechainicio and :fechafin
            and age_estado ='A' 
            order by age_correlativo desc";
            //and age_pro_correl = :consulta
            //and age_suc_correlativo = :centro
            $stmt = $connection->prepare($sql);
            $stmt->execute([
                'usuario' => $pUsuario,
                //'centro' => $pCentro,
                //'consulta' => $pConsulta,
                'fechainicio' => $pFechaInicio,
                'fechafin' => $pFechaFin,
            ]);
            $result = $stmt->fetchAll(PDO::FETCH_OBJ);
             
            if ($stmt->rowCount() > 0) {
                $rst_correl_sig = (($result[0]->correlativo) );
            } else {
                $rst_correl_sig = 0;
            }
            return $rst_correl_sig;
    }
    /*public function validarHorarioCitas($connection, $pNomTabla, $pNomColumna, $pServicio,$pCentro, $pFechaInicio, $pFechaFin, $pFiltro){
        //set @fechainicio = '2021-10-05 15:42';
        //set @fechafin = '2021-10-05 16:18';
       $sql = " 
        SELECT * FROM $pNomTabla
        WHERE 1=1 
        and tra_tipo_consulta = :tipo_consulta 
        and tra_lugar_atencion = :pCentro  
        and DATE(tra_fecha_inicio_consulta) = DATE(@fechainicio)
        and (TIME(tra_fecha_inicio_consulta) = TIME(@fechainicio) AND TIME(tra_fecha_fin_consulta) <= (TIME(@fechafin)))
        ";
    }*/
    public function validarHorarioCitas($connection, $pNomTabla, $pNomColumna, $pServicio,$pCentro, $pFechaInicio, $pFechaFin, $pFiltro) {
        $rst_correl_sig = 0;
        $sql = "
        select  
        tra_cm_correlativo AS correlativo 
        from $pNomTabla 
        where 1=1 
        and tra_cm_tipo_consulta = :tipo_consulta 
        and tra_cm_lugar_atencion = :centro 
        and DATE(tra_cm_fecha_fin_consulta) = DATE(:fechainicio)
        and (
        (TIME(:fechainicio)>=TIME(tra_cm_fecha_fin_consulta) AND TIME(:fechafin)<=TIME(tra_cm_fecha_fin_consulta))
        OR 
        (TIME(:fechainicio)<=TIME(tra_cm_fecha_fin_consulta) AND TIME(:fechafin)>TIME(tra_cm_fecha_fin_consulta) )
        OR
        (TIME(:fechafin)>TIME(tra_cm_fecha_fin_consulta) AND TIME(:fechainicio)<TIME(tra_cm_fecha_fin_consulta) )
        )
        and tra_cm_estado ='A' 
        and tra_cm_etapa = 1 
        order by tra_cm_correlativo desc";
        //and (TIME(:fechainicio) = TIME(tra_cm_fecha_fin_consulta) AND TIME(tra_cm_fecha_fin_consulta) != (TIME(:fechafin)))
        //and TIME(:fechainicio) BETWEEN TIME(tra_cm_fecha_fin_consulta) AND TIME(tra_cm_fecha_fin_consulta)

        //e_time_start between '08:00:00' and '06:00:00' and e_time_end between '08:00:00' and '06:00:00' AND e_date_event = '2018-03-16' OR (e_time_start< '08:00:00' and e_time_end > '06:00:00' )
        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'tipo_consulta' => $pServicio,
            'centro' => $pCentro,
            //'consulta' => $pConsulta,
            'fechainicio' => $pFechaInicio,
            'fechafin' => $pFechaFin,
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);
        //and age_pro_correl = :consulta 
        if ($stmt->rowCount() > 0) {
            $rst_correl_sig = (($result[0]->correlativo) );
        } else {
            $rst_correl_sig = 0;
        }
        return $rst_correl_sig;
    }
    public function clientRegister($connection,$array_cliente, $id_usuario, $busquedaEmail){
        $response = "nOk";
        
        //buscamos si cliente existe por medio de nombre y correo electronico
        $cli_correlativo = 0;
        if($busquedaEmail == 0){
            $sql = "select cli_correlativo correlativo from cfg_cliente where upper(cli_nombre) = upper(:cli_nombre) and upper(cli_email) = upper(:cli_email) and (upper(cli_telefono1) = upper(:cli_telefono1) || upper(cli_telefono2) = upper(:cli_telefono2))";
            $stmt = $connection->prepare($sql);
            $stmt->execute([
                'cli_nombre' => $array_cliente['cli_nombre'],
                'cli_email' => $array_cliente['cli_email'],
                'cli_telefono1' => $array_cliente['cli_telefono1'],
                'cli_telefono2' => $array_cliente['cli_telefono2']
            ]);
            $result = $stmt->fetchAll($connection::FETCH_OBJ);
            if (!empty($result)) {$cli_correlativo = (($result[0]->correlativo) );} 
        }else{
            $cli_correlativo = $array_cliente['cli_correlativo'];
        }
        //si encontramos coincidencia actualizamos el registro
        if($cli_correlativo > 0){
            $sql = " update cfg_cliente set 
                cli_nombre = :cli_nombre,
                cli_email = :cli_email,
                cli_telefono1 = :cli_telefono1,
                cli_fecha_nacimiento = :cli_fecha_nacimiento,
                cli_usuariom = :id_usuario,
                cli_fecham =  now() 
                WHERE cli_correlativo = :cli_cliente";

                $stmt = $connection->prepare($sql);
                $result = $stmt->execute([
                    'cli_cliente' =>$array_cliente['cli_correlativo'],
                    'cli_nombre' =>$array_cliente['cli_nombre'],
                    'cli_email' => $array_cliente['cli_email'],
                    'cli_telefono1' => $array_cliente['cli_telefono1'],
                    'id_usuario' => $id_usuario,
                    'cli_fecha_nacimiento' => $array_cliente['cli_fecha_nacimiento']
                ]);   
                
                if ($result == true) {
                    $response = "OK";
                }else{
                    $response = "Cliente no pudo ser creado";
                }
        }else{
            $cli_correlativo = $this->CorrelAutomatico($connection, "cfg_cliente", "cli_correlativo", "");
            $sql = " insert into cfg_cliente ( 
                cli_correlativo,
                cli_nombre,
                cli_email,
                cli_telefono1,
                cli_fecha_nacimiento,
                cli_estado,
                cli_usuarioi,
                cli_usuariom,
                cli_fechai,
                cli_fecham
                )values(
                    :cli_correlativo,
                    :cli_nombre,
                    :cli_email,
                    :cli_telefono1,
                    :cli_fecha_nacimiento,
                    'A',
                    :id_usuario,
                    :id_usuario,
                    now(),
                    now()
                )
                ";

                $stmt = $connection->prepare($sql);
                $result = $stmt->execute([
                    'cli_correlativo' => $cli_correlativo,
                    'cli_nombre' =>$array_cliente['cli_nombre'],
                    'cli_email' => $array_cliente['cli_email'],
                    'cli_telefono1' => $array_cliente['cli_telefono1'],
                    'id_usuario' => $id_usuario,
                    'cli_fecha_nacimiento' => $array_cliente['cli_fecha_nacimiento']
                ]);   
                
                if ($result == true) {
                    $response = "OK";
                }else{
                    $response = "Cliente no pudo ser creado";
                }
        }
        return $cli_correlativo;
    }
   
    public function horarioCentro($connection, $pNomTabla, $pNomColumna, $pUsuario,$pCentro, $pConsulta, $pFechaInicio, $pFechaFin, $pFiltro) {
            $rst_correl_sig = 0;
    
            /*$sql = "select $pNomColumna correlativo from $pNomTabla 
            where 1=1 
            and age_usr_correl = $pUsuario 
            and age_pro_correl = $pConsulta 
            and age_suc_correlativo = $pCentro 
            $pFiltro";*/
            /*set @pUsuario = 2;
            set @pConsulta = 32;
            set @pCentro = 1;
            set @fechainicio = '2021-09-01 13:15:00';
            set @fechafin = '2021-09-10 09:15:00';*/
            $sql = "
            select  
            tra_correlativo  AS correlativo 
            from $pNomTabla 
            where 1=1 
            and tra_lugar_atencion = :centro 
            
            and tra_etapa = 1  
            and tra_estado ='A' 
            and DATE(tra_fecha_inicio_consulta) = DATE(:fechainicio)
            and DATE(tra_fecha_fin_consulta) = DATE(:fechafin) 
            and TIME(tra_fecha_inicio_consulta) BETWEEN TIME(:fechainicio) and TIME(:fechafin)
            ";
    
            $stmt = $connection->prepare($sql);
            $stmt->execute([
                'centro' => $pCentro,
                //'consulta' => $pConsulta,
                'fechainicio' => $pFechaInicio,
                'fechafin' => $pFechaFin,
            ]);
            $result = $stmt->fetchAll(PDO::FETCH_OBJ);
            //and TIME(tra_fecha_inicio_consulta) BETWEEN TIME(:fechainicio) and TIME(:fechafin)
            //'usuario' => $pUsuario,
            //and age_usr_correl = :usuario 
            //and age_pro_correl = :consulta 

            if ($stmt->rowCount() > 0) {
                $rst_correl_sig = (($result[0]->correlativo) );
            } else {
                $rst_correl_sig = 0;
            }
            return $rst_correl_sig;
    }
    public function validarHorarioAtencionMedico($connection, $pNomTabla, $pNomColumnaCorrelativo, $tra_fecha_inicio_consulta, $tra_fecha_fin_consulta, $pSucursal, $pFiltro) {
        $result_horario = 0;
    
        $sql = "
        SELECT 
        CASE
        WHEN DAYOFWEEK(:tra_fecha_inicio_consulta) >= 2 and DAYOFWEEK(:tra_fecha_inicio_consulta) <=6 THEN (if(TIME(:tra_fecha_inicio_consulta) >= suc_horario_lunes_a_viernes_inicio,1,0) and if(TIME(:tra_fecha_fin_consulta) <= suc_horario_lunes_a_viernes_fin,1,0))
        WHEN DAYOFWEEK(:tra_fecha_inicio_consulta) = 1 THEN (if(TIME(:tra_fecha_inicio_consulta) >= suc_horario_domingo_inicio,1,0) and if(TIME(:tra_fecha_fin_consulta) <= suc_horario_domingo_fin,1,0))
        WHEN DAYOFWEEK(:tra_fecha_inicio_consulta) = 7 THEN (if(TIME(:tra_fecha_inicio_consulta) >= suc_horario_sabado_inicio,1,0) and if(TIME(:tra_fecha_fin_consulta) <= suc_horario_sabado_fin,1,0))
        ELSE ''
        END AS resultado FROM $pNomTabla WHERE suc_correlativo = $pSucursal";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'tra_fecha_inicio_consulta' => $tra_fecha_inicio_consulta,
            'tra_fecha_fin_consulta' => $tra_fecha_fin_consulta
        ]);
        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        if($stmt->rowCount() > 0) {
            $result_horario = (($result[0]->resultado));
        }else{
            $result_horario = 0;
        }

        return $result_horario;
    
    }

    public function validarDisponibilidadHorarioMedico($connection, $pNomTabla, $pNomColumna, $pUsuario,$pCentro, $pConsulta, $pFechaInicio, $pFechaFin, $pFiltro) {
        $rst_correl_sig = 0;
        $sql = "
        select  
        tra_correlativo  AS correlativo 
        from $pNomTabla 
        where 1=1 
        and tra_tipo_consulta = :consulta 
        and tra_lugar_atencion = :centro 
        and age_fecha_inicio BETWEEN :fechainicio and :fechafin
        and age_estado !='E' 
        order by age_correlativo desc";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'centro' => $pCentro,
            'consulta' => $pConsulta,
            'fechainicio' => $pFechaInicio,
            'fechafin' => $pFechaFin,
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if ($stmt->rowCount() > 0) {
            $rst_correl_sig = (($result[0]->correlativo) );
        } else {
            $rst_correl_sig = 0;
        }
        return $rst_correl_sig;
    }
    public function validarHorarioCosulta($connection, $pNomTabla, $pNomColumna, $pUsuario,$pCentro, $pConsulta, $pFechaInicio, $pFechaFin, $pFiltro) {
        $result_consulta = 0;
        $sql = "
        select  
        $pNomColumna  AS correlativo 
        from $pNomTabla 
        where 1=1 
        and tra_cm_tipo_consulta = :pConsulta 
        and tra_cm_lugar_atencion = :pCentro 
        and (tra_cm_fecha_inicio_consulta BETWEEN '$pFechaInicio' and '$pFechaFin' or tra_cm_fecha_fin_consulta BETWEEN '$pFechaInicio' and '$pFechaFin')  
        and tra_cm_estado !='E'";

        /*$query = "
        select  
        $pNomColumna  AS correlativo 
        from $pNomTabla 
        where 1=1 
        and tra_cm_tipo_consulta = $pConsulta and tra_cm_lugar_atencion = $pCentro and (tra_cm_fecha_inicio_consulta BETWEEN '$pFechaInicio' and '$pFechaFin' or tra_cm_fecha_fin_consulta BETWEEN '$pFechaInicio') and '$pFechaFin' 
        and tra_cm_estado !='E'";*/
        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'pCentro' => $pCentro,
            'pConsulta' => $pConsulta
            // 'pFechaInicio' => $pFechaInicio,
            // 'pFechaFin' => $pFechaFin
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if ($stmt->rowCount() > 0) {
            $result_consulta = 1;//(($result[0]->correlativo));
        }else{
            $result_consulta = 0;
        }
        return $result_consulta;//." ".$stmt->rowCount()." ".$sql
    }
    /*
    public function montoOrdenDeTrabajo($connection, $pNomTabla, $pCampos, $pConsulta, $pNoOrden, $pFiltro) {
        $rst_monto = 0;
        $sql = "
        select  
        sum($pCampos) as monto 
        from $pNomTabla 
        where 1=1 
        and otra_no_consulta = :pConsulta 
        and otra_no_orden = :pNoOrden 
        and otra_estado ='A'";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'pConsulta' => $pConsulta,
            'pNoOrden' => $pNoOrden
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_monto = ($result[0]->monto);
        }else{
            $rst_monto = 0;
        }
        
        return $rst_monto;
    }*/
    public function montoOrdenDeTrabajoPaciente($connection, $pNomTabla, $pCampos, $pConsulta, $pNoOrden, $pFiltro) {
        $rst_monto = 0;
        $sql = "
        select  
        sum($pCampos) as monto 
        from $pNomTabla 
        where 1=1 
        and otra_no_consulta = :pConsulta 
        and otra_no_orden = :pNoOrden 
        and otra_estado ='A'";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'pConsulta' => $pConsulta,
            'pNoOrden' => $pNoOrden
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_monto = ($result[0]->monto);
        }else{
            $rst_monto = 0;
        }
        
        return $rst_monto;
    }
    public function montoOrdenDeTrabajoCliente($connection, $pNomTabla, $pCampos, $pConsulta, $pNoOrden, $pFiltro) {
        $rst_monto = 0;
        $sql = "
        select  
        sum($pCampos) as monto 
        from $pNomTabla 
        where 1=1 
        and otra_no_consulta = :pConsulta 
        and otra_no_orden = :pNoOrden 
        and otra_estado ='A'";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'pConsulta' => $pConsulta,
            'pNoOrden' => $pNoOrden
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_monto = ($result[0]->monto);
        }else{
            $rst_monto = 0;
        }
        
        return $rst_monto;
    }
    /*public function montoPagoRealizado($connection, $pNomTabla, $pCampos, $pConsulta, $pNoOrden, $pFiltro) {
        $rst_monto = 0;
        $sql = "
        select  
        sum($pCampos) as monto 
        from $pNomTabla 
        where 1=1 
        and tra_fp_no_consulta = :pConsulta 
        and tra_fp_no_orden = :pNoOrden 
        and tra_fp_estado ='A'";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'pConsulta' => $pConsulta,
            'pNoOrden' => $pNoOrden
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_monto = ($result[0]->monto);
        }else{
            $rst_monto = 0;
        }
        
        return $rst_monto;
    }*/
    /*public function montoPagoPaciente($connection, $pNomTabla, $pCampos, $pConsulta, $pNoOrden, $pFiltro) {
        $rst_monto = 0;
        $sql = "
        select  
        sum($pCampos) as monto 
        from $pNomTabla 
        where 1=1 
        and tra_fp_no_consulta = :pConsulta 
        and tra_fp_no_orden = :pNoOrden 
        and tra_fp_estado ='A'
        and tra_fp_aseguradora = NULL";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'pConsulta' => $pConsulta,
            'pNoOrden' => $pNoOrden
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_monto = ($result[0]->monto);
        }else{
            $rst_monto = 0;
        }
        
        return $rst_monto;
    }*/
    /*public function montoPagoCliente($connection, $pNomTabla, $pCampos, $pConsulta, $pNoOrden, $pFiltro) {
        $rst_monto = 0;
        $sql = "
        select  
        sum($pCampos) as monto 
        from $pNomTabla 
        where 1=1 
        and tra_fp_no_consulta = :pConsulta 
        and tra_fp_no_orden = :pNoOrden 
        and tra_fp_estado ='A'
        and tra_fp_aseguradora >= 0";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'pConsulta' => $pConsulta,
            'pNoOrden' => $pNoOrden
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_monto = ($result[0]->monto);
        }else{
            $rst_monto = 0;
        }
        
        return $rst_monto;
    }*/
    public function verificarPlanAseguradora($connection, $pNomTabla, $pCampos, $pConsulta, $pNoOrden, $pFiltro) {
        $rst_plan = 0;
        $sql = "
        select  
        $pCampos as campo 
        from $pNomTabla 
        where 1=1 
        and otra_no_consulta = :pConsulta 
        and otra_no_orden = :pNoOrden 
        and otra_estado !='E' ORDER BY otra_correlativo ASC LIMIT 1";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'pConsulta' => $pConsulta,
            'pNoOrden' => $pNoOrden
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_plan = ($result[0]->campo);
        }else{
            $rst_plan = 0;
        }
        
        return $rst_plan;
    }
    public function actualizarOtrosCobros($connection, $pNomTabla, $otra_total_otros, $otra_descripcion_total_otros, $pConsulta, $pNoOrden, $pFiltro) {
        $rst_actualizado = 0;
       
        $response = "nOk";
        $sql = " update 
        $pNomTabla set 
        otra_total_otros = :otra_total_otros,
        otra_descripcion_total_otros = :otra_descripcion_total_otros 
        where 
        otra_no_consulta = :pConsulta 
        and otra_no_orden = :pNoOrden 
        and otra_estado !='E'";

        $stmt = $connection->prepare($sql);
        $result = $stmt->execute([
            'pConsulta' => $pConsulta,
            'pNoOrden' => $pNoOrden,
            'otra_total_otros'=>$otra_total_otros,
            'otra_descripcion_total_otros'=>$otra_descripcion_total_otros
        ]);
        $response = "OK";
        return $response;
    }
    public function nombrePlan($connection, $pNomTabla, $pCampos, $ocf_correlativo, $pFiltro) {
        $rst_nombre_plan = "";
        $sql = "
        select  
        $pCampos as campo 
        from $pNomTabla 
        where 1=1 
        and ocf_correlativo = :ocf_correlativo 
        and ocf_objeto = 'Cfg_aseguradora_plan'
        and ocf_estado !='E'";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'ocf_correlativo' => $ocf_correlativo
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_nombre_plan = ($result[0]->campo);
        }else{
            $rst_nombre_plan = "";
        }
        
        return $rst_nombre_plan;
    }
    public function verificarNoCupon($connection, $pNomTabla, $tra_fp_tipo_cupon, $tra_fp_serie, $tra_fp_no_referencia, $tra_fp_monto, $pFiltro) {
        $rst_cupon = 0;
        $sql = "
        select  
        cup_correlativo  
        from $pNomTabla 
        where 1=1 
        and cup_tipo = :tra_fp_tipo_cupon 
        and cup_serie = UPPER(:tra_fp_serie) 
        and cup_monto = :tra_fp_monto 
        and ($tra_fp_no_referencia >= cup_numero_inicio and $tra_fp_no_referencia <= cup_numero_fin) 
        and cup_estado !='E'";
        
        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'tra_fp_tipo_cupon' => $tra_fp_tipo_cupon,
            'tra_fp_serie' => $tra_fp_serie,
            //'tra_fp_no_referencia' => $tra_fp_no_referencia,
            'tra_fp_monto' => $tra_fp_monto
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_cupon = ($result[0]->cup_correlativo);
        }else{
            $rst_cupon = 0;
        }
        
        return $rst_cupon;
    }

    public function validarCuponUsado($connection, $pNomTabla, $tra_fp_tipo_cupon, $tra_fp_serie, $tra_fp_no_referencia, $tra_fp_monto, $pFiltro) {
        $rst_cupon = 0;
        $sql = "
        select  
        tra_fp_correlativo  
        from $pNomTabla 
        where 1=1 
        and tra_fp_tipo_cupon = :tra_fp_tipo_cupon 
        and tra_fp_serie = UPPER(:tra_fp_serie) 
        and tra_fp_monto = :tra_fp_monto 
        and tra_fp_no_referencia = :tra_fp_no_referencia 
        and tra_fp_estado !='E'";
        
        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'tra_fp_tipo_cupon' => $tra_fp_tipo_cupon,
            'tra_fp_serie' => $tra_fp_serie,
            'tra_fp_no_referencia' => $tra_fp_no_referencia,
            'tra_fp_monto' => $tra_fp_monto
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_cupon = ($result[0]->tra_fp_correlativo);
        }else{
            $rst_cupon = 0;
        }
        
        return $rst_cupon;
    }
    public function existeFacturaOrdenTrabajo($connection, $pNomTabla, $tra_fac_no_consulta, $tra_fac_no_orden_trabajo, $pFiltro) {
        $response = [];
        
        $sql ="
        select  
        tra_fac_correlativo,
        tra_fac_serie,
        tra_fac_monto   
        from $pNomTabla 
        where 1=1 
        and tra_fac_no_consulta = :tra_fac_no_consulta  
        and tra_fac_no_orden_trabajo = :tra_fac_no_orden_trabajo  
        and tra_fac_estado !='E'";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'tra_fac_no_consulta' => $tra_fac_no_consulta,
            'tra_fac_no_orden_trabajo' => $tra_fac_no_orden_trabajo
        ]);

        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        $response = $result;
        $PDO = null;
        return $response;
    }

    public function existePagoOrdenTrabajo($connection, $pNomTabla, $noConsulta, $noOrdenTrabajo, $pFiltro) {
        $response = [];
        
        $sql ="
        select  
        ROUND(sum(tra_fp_monto),2) as importePagado 
        from $pNomTabla 
        where 1=1 
        and tra_fp_no_consulta = :noConsulta  
        and tra_fp_no_orden = :noOrdenTrabajo  
        and tra_fp_estado !='E'";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'noConsulta' => $noConsulta,
            'noOrdenTrabajo' => $noOrdenTrabajo
        ]);

        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        $response = $result;
        $PDO = null;
        return $response;
    }

    public function informacionOrdenTrabajo($connection, $pNomTabla, $otra_no_consulta, $otra_no_orden, $pFiltro) {
        $response = [];
        
        $sql ="
        select  
        sum(otra_precio) as monto,
        otra_total_otros 
        from $pNomTabla 
        where 1=1 
        and otra_no_consulta = :otra_no_consulta  
        and otra_no_orden = :otra_no_orden  
        and otra_estado !='E'";

        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'otra_no_consulta' => $otra_no_consulta,
            'otra_no_orden' => $otra_no_orden
        ]);

        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        $response = $result;
        $PDO = null;
        return $response;
    }
    public function obtenerUltimaConsultaPaciente($connection, $pNomTabla, $tra_fichamn_cli_correlativo, $pFiltro) {
        $rst_correlativo = 0;
        $sql = "select tra_cm_correlativo as correlativo from 
        $pNomTabla 
        where tra_cm_cli_correlativo = :tra_fichamn_cli_correlativo 
        and tra_cm_estado = 'A' and tra_cm_etapa >= 4 order by tra_cm_correlativo desc limit 1";
        
        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'tra_fichamn_cli_correlativo' => $tra_fichamn_cli_correlativo
        ]);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        if($stmt->rowCount() > 0) {
            $rst_correlativo = ($result[0]->correlativo);
        }else{
            $rst_correlativo = 0;
        }
        
        return $rst_correlativo;
    }
    public function obtenerCodigoConsulta($connection, $pNomTabla, $tra_cm_correlativo, $pFiltro) {
        $response = [];
        $sql = "select tra_cm_cli_correlativo,tra_cm_fecha_inicio_consulta,tra_cm_fecha_fin_consulta from 
        $pNomTabla 
        where tra_cm_correlativo = :tra_cm_correlativo 
        and tra_cm_estado != 'E'";
        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'tra_cm_correlativo' => $tra_cm_correlativo
        ]);

        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        $response = $result;
        $connection = null;
        return $response;
    }

    public function calcularMontoOrdenTra($connection, $pNomTabla, $noConsulta, $noOrden, $pFiltro) {
        $response = [];
        
        $sql = " 
            select 
            ROUND(otra_cliente_porcentaje,2) as otra_cliente_porcentaje,
            ROUND(otra_paciente_porcentaje,2) as otra_paciente_porcentaje,
            ROUND(sum(otra_precio),2) as importeTotal,
            ROUND(IFNULL(otra_total_otros,0),2) as otra_total_otros,
            ROUND(((sum(otra_precio)*(otra_paciente_porcentaje/100))+otra_total_otros),2) as importePaciente,
            ROUND((sum(otra_precio)-ROUND(((sum(otra_precio)*(otra_paciente_porcentaje/100))+otra_total_otros),2)),2) as importeCliente,
            
            ROUND(IFNULL((select sum(tra_fp_monto) from tra_formas_pago_ordenes_trabajo where tra_fp_no_consulta = :noConsulta 
            and tra_fp_no_orden = :noOrden and tra_fp_aseguradora > 0 and tra_fp_estado ='A'),0),2) as montoPagadoCliente,
            
            ROUND(IFNULL((select sum(tra_fp_monto) from tra_formas_pago_ordenes_trabajo where tra_fp_no_consulta = :noConsulta 
            and tra_fp_no_orden = :noOrden and tra_fp_estado ='A' and tra_fp_aseguradora IS NULL),0),2) as montoPagadoPaciente 
            from
            tra_orden_trabajo
            where
            1=1
            and otra_estado ='A'
            and otra_no_consulta = :noConsulta 
            and otra_no_orden = :noOrden";
        $stmt = $connection->prepare($sql);
        $stmt->execute([
            'noConsulta' => $noConsulta,
            'noOrden' => $noOrden
        ]);

        $result = $stmt->fetchAll($connection::FETCH_OBJ);
        $response = $result;
        //$connection = null;
        return $response;
    }
        
}
?>