<?php
namespace App\Utility;
use App\Controllers\BaseController;
use DOMDocument;
use Exception;
use PhpOffice\PhpWord\IOFactory;
use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\Settings;
use PhpOffice\PhpWord\Shared\Html;
use PhpOffice\PhpWord\TemplateProcessor;

class Word{
    
    public function create($data,$id,$connection){
        try{
            \PhpOffice\PhpWord\Settings::setOutputEscapingEnabled(true);
            $utility = new UtilityDB();
            $attachment = $utility->getAttachment($connection,$data[0]->pld_pla_correlativo);
            
            //variables globales
            $fancyTableStyleName = 'Fancy Table';
            $fancyTableStyle = array('borderSize' => 2, 'borderColor' => '000000', 'alignment' => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER);
            $fancyTableFirstRowStyle = array('borderBottomSize' => 0, 'borderBottomColor' => '0000FF', 'bgColor' => 'cccccc');
            
            $fancyTableCellBtlrStyle = array('valign' => 'center', 'textDirection' => \PhpOffice\PhpWord\Style\Cell::TEXT_DIR_BTLR);
            $fancyTableFontStyle = array('bold' => false,'color'=>'000000');
            $matrixTableStyleName = 'Matrix Table';
            $matrixTableStyle = array('borderSize' => 2, 'borderColor' => '000000', 'alignment' => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER);
            $matrixTableFirstRowStyle = array('borderBottomSize' => 18, 'borderBottomColor' => '0000FF', 'bgColor' => '95c5ed');
            $matrixTableCellStyle = array('valign' => 'center');
            $matrixTableCellBtlrStyle = array('valign' => 'center', 'textDirection' => \PhpOffice\PhpWord\Style\Cell::TEXT_DIR_BTLR);
            $matrixTableFontStyle = array('bold' => false,'color'=>'ffffff');
            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $respuesta = 'nOk';
            
            $userFolder = FILE_DIR.DIRECTORY_SEPARATOR;
            if (!file_exists($userFolder)) {
                mkdir($userFolder, 0777, true);
            }
            $phpWord = new \PhpOffice\PhpWord\PhpWord();
            $section = $phpWord->addSection();
            /*$header = $section->addHeader();
            $header->addImage(IMG_DIR.DIRECTORY_SEPARATOR.'header.png',array(
                'width'         => 141.732,
                'height'        => 20.12598,
                'align'         => 'right'
            ));*/
            //caratula
            $fechai = $data[0]->pld_fechai;
            $section->addText("Ultima actualización($fechai)", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $section->addText('Version(1)', array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $section->addTextBreak(2, null, null);
            $section->addText('PPRE', array(
                'name'=>'calibri',
                'size'=>36,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));
            $section->addText('Plan de Preparación y Respuesta a Emergencia', array(
                'name'=>'calibri',
                'size'=>24,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));

            $section->addImage(IMG_DIR.DIRECTORY_SEPARATOR.'blank.png',array(
                'width'         => 400.54,
                'height'        => 240.00,
                'align'         => 'center'
            ));

            $section->addTextBreak(1);
           /* $section->addTextBreak(2);
            $section->addText('Guatemala', array(
                'name'=>'calibri',
                'size'=>20,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));
            $section->addText('JOTAY', array(
                'name'=>'calibri',
                'size'=>20,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));
            $section->addText('Miembro de ACT Alliance', array(
                'name'=>'calibri',
                'size'=>28,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));*/
            
            $section->addImage(IMG_DIR.DIRECTORY_SEPARATOR.'ppre.png',array(
                'width'         => 300.54,
                'height'        => 110.00,
                'align'         => 'center'
            ));
            $section->addTextBreak(2);
            
            $usuario_aprobacion = $data[0]->pla_usuarioi;
            $section->addText("Aprobado por: $usuario_aprobacion", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), array(
                'alignment'=>'left'
            ));
            $section->addPageBreak();
            $fontStyle = array('spaceAfter' => 10, 'size' => 16,'name'=>'calibri','bold'=>true);
            $section->addText('Historial de Actualizaciones',array('bold'=>true,'size'=>16,'align'=> 'left','name'=>'calibri'));
            $section->addText('(Esta sección se completa una vez descargado el plan de la plataforma, servirá para llevar registro y actualización del mismo)',
            array('color'=>'1500ba','bold'=>false,'size'=>10,'align'=> 'left','name'=>'calibri'));

            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Fecha de Modificación',array('size'=>12,'bold'=>true,'calibri'=>12),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Responsable   ',array('size'=>12,'bold'=>true,'calibri'=>12),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Número de Páginas',array('size'=>12,'bold'=>true,'calibri'=>12),array('align' => 'center'));

            $table->addRow();
            $table->addCell();
            $table->addCell();
            $table->addCell();

            $section->addTextBreak(1);

            $section->addText('Responsable de Socialización con el personal',array('bold'=>true,'size'=>16,'align'=> 'left','name'=>'calibri'));
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Responsable',array('size'=>12,'bold'=>true,'calibri'=>12),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Método   ',array('size'=>12,'bold'=>true,'calibri'=>12),array('align' => 'center'));
            
            $table->addRow();
            $table->addCell();
            $table->addCell();

            $section->addTextBreak(1);

            $section->addText('Fecha de próxima Actualización:',array('bold'=>true,'size'=>12,'align'=> 'left','name'=>'calibri'));
            $section->addText('Actualización semestral o si hay cambios significativos en el contexto.',
            array('color'=>'1500ba','italic'=>true,'size'=>10,'align'=> 'center','name'=>'calibri'));

            $section->addTextBreak(4);
            $lineStyle = array('weight' => 1, 'width' => 450, 'height' => 0, 'color' => '38c172');
            $section->addLine($lineStyle);

            $section->addText('Con el apoyo de:',array('bold'=>true,'size'=>14,'name'=>'calibri'),array('align'=>'center'));
            $section->addImage(IMG_DIR.DIRECTORY_SEPARATOR.'logo_jotay.jpg',array(
                'width'         => 280.54,
                'height'        => 80.00,
                'align'         => 'center'
            ));

            $section->addPageBreak();
            $fontStyle = array('spaceAfter' => 10, 'size' => 12,'name'=>'calibri','bold'=>false);
            $section->addText('CONTENIDO',array('bold'=>true,'size'=>16,'align'=> 'center','color'=>'72c2ff'));
            $section->addTextBreak(2);
            // Add TOC #1
            $toc = $section->addTOC($fontStyle);
            $section->addPageBreak();
            
            $phpWord->addTitleStyle(1, array('size' => 16,'name'=>'calibri','color' => '021b7f', 'bold' => true));
            $phpWord->addTitleStyle(2, array('size' => 14,'name'=>'calibri', 'color' => '021b7f','bold' => true));
            
            $section->addTitle('1. ANÁLISIS DE CONTEXTO', 1);
            $section->addTitle('1.1 Resumen de Analisis de Contexto', 2);
            $pld_campo1 = $data[0]->pld_campo1;
            $pld_campo1 = str_replace('<br>','',$pld_campo1);
            \PhpOffice\PhpWord\Shared\Html::addHtml($section, $pld_campo1);
            $section->addTextBreak(2);
            $section->addTitle('1.2 Resumen de Análisis de Contexto', 2);
            $pld_campo2 = $data[0]->pld_campo2;
            $pld_campo2 = str_replace('<br>','',$pld_campo2);
            \PhpOffice\PhpWord\Shared\Html::addHtml($section, $pld_campo2);
            $section->addTextBreak(2);
            $section->addTitle('1.3 Mapa Área / País', 2);
            $mapa1_3 = $utility->search_img_array($attachment,'1_3');

            if(!empty($mapa1_3)){
            
                $section->addImage($mapa1_3->att_direccion.DIRECTORY_SEPARATOR.$mapa1_3->att_archivo,array(
                    'width'         => 353.54,
                    'height'        => 203.82677,
                    'align'         => 'center'
                ));
            }

            $peligro1_3 = $utility->traPlanAmenazaCatalogoDeptos($connection,'1_3',$data[0]->pld_pla_correlativo);
            
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Departamento',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Municipio',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Comunidad',array('size'=>8,'bold'=>true),array('align' => 'center'));

            foreach($peligro1_3 as $idx =>$val){
                $table->addRow();
                $table->addCell(1750)->addText($val->pam_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->pam_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->pam_campo3,array('size'=>8,'bold'=>true));
            }
            $section->addTextBreak(2);
            $section->addTitle('2. ANÁLISIS DE RIESGOS', 1);
            //$section->addTextBreak(2);
            $section->addTitle('2.1 Análisis detallado de riesgos', 2);
            /*$section->addText('Provea un analisis detallado de los riesgos usando las tablas',array('color'=>'ff0000','size'=>'10'));
            $section->addTextBreak(0);
            $section->addText('Información clave',array('color'=>'ff0000','size'=>'10','underline'=>'single'));
            $section->addTextBreak(0);
            $section->addListItem('Identificar todas las amenazas que podrian afectar al pais o comunidades.',0,array('color'=>'ff0000','size'=>'6'));
            $section->addListItem('Priorizar las amenazas identificada en el analisis de riesgos de acuerdo a su impacto y frecuencia usando la consecuencia cualitativa y los sistemas de medición de probabilidad (ver notas de orientacion)',0,array('color'=>'ff0000','size'=>'6'));
            $section->addListItem('Utilizar la matriz de riesgo (abajo) para facilitar la comparación entre los diferentes riesgos identificados',0,array('color'=>'ff0000','size'=>'6'));
            $section->addListItem('Identificar todas las amenazas que podrian afectar al pais o comunidades.',0,array('color'=>'ff0000','size'=>'6'));
            $section->addListItem('Realizar un analisis mas detallado de las 3 amenazas priorizadas y documentarlas en la tabla de análisis de riegos.',0,array('color'=>'ff0000','size'=>'6'));*/
            
            
            
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $matriz_riesgo = $utility->traPlanAmenaza($connection,'2_1',$data[0]->pld_pla_correlativo);
            
            
            foreach($matriz_riesgo as $idx =>$valor){
                
                if(strpos($valor->pam_campo1,'5')!== false){
                    $row = $table->addRow();
                    $row->addCell(800, array('vMerge' => 'restart','bgColor' => '9cc2e5','valign' => 'center','textDirection'=>\PhpOffice\PhpWord\Style\Cell::TEXT_DIR_BTLR))->addText('Probabilidad');
                    $row->addCell(2000, array('vMerge' => 'restart','bgColor' => '9cc2e5'))->addText($valor->pam_campo1,array('size'=>8,'bold'=>true));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor' => '92d050'))->addText($valor->pam_campo2,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor' => 'ffff00'))->addText($valor->pam_campo3,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ffbf00'))->addText($valor->pam_campo4,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ff0000'))->addText($valor->pam_campo5,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ff0000'))->addText($valor->pam_campo6,array('size'=>6));        
                }
                if(strpos($valor->pam_campo1,'4')!== false){
                    $row = $table->addRow();
                    $row->addCell(null,array('vMerge'=>'continue'));
                    $row->addCell(2000, array('vMerge' => 'restart','bgColor' => '9cc2e5'))->addText($valor->pam_campo1,array('size'=>8,'bold'=>true));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor' => '92d050'))->addText($valor->pam_campo2,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor' => 'ffff00'))->addText($valor->pam_campo3,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ffbf00'))->addText($valor->pam_campo4,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ffbf00'))->addText($valor->pam_campo5,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ff0000'))->addText($valor->pam_campo6,array('size'=>6));
                }
                if(strpos($valor->pam_campo1,'3')!== false){
                    $row = $table->addRow();
                    $row->addCell(null,array('vMerge'=>'continue'));
                    $row->addCell(2000, array('vMerge' => 'restart','bgColor' => '9cc2e5'))->addText($valor->pam_campo1,array('size'=>8,'bold'=>true));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor' => 'ffffff'))->addText($valor->pam_campo2,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor' => '92d050'))->addText($valor->pam_campo3,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ffff00'))->addText($valor->pam_campo4,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ffbf00'))->addText($valor->pam_campo5,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ffbf00'))->addText($valor->pam_campo6,array('size'=>6));
                }
                if(strpos($valor->pam_campo1,'2')!== false){
                    $row = $table->addRow();
                    $row->addCell(null,array('vMerge'=>'continue'));
                    $row->addCell(2000, array('vMerge' => 'restart','bgColor' => '9cc2e5'))->addText($valor->pam_campo1,array('size'=>8,'bold'=>true));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor' => 'ffffff'))->addText($valor->pam_campo2,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor' => '92d050'))->addText($valor->pam_campo3,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'92d050'))->addText($valor->pam_campo4,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ffff00'))->addText($valor->pam_campo5,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ffff00'))->addText($valor->pam_campo6,array('size'=>6));
                }
                if(strpos($valor->pam_campo1,'1')!== false){
                    $row = $table->addRow();
                    $row->addCell(null,array('vMerge'=>'continue'));
                    $row->addCell(2000, array('vMerge' => 'restart','bgColor' => '9cc2e5'))->addText($valor->pam_campo1,array('size'=>8,'bold'=>true));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor' => 'ffffff'))->addText($valor->pam_campo2,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor' => 'ffffff'))->addText($valor->pam_campo3,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'ffffff'))->addText($valor->pam_campo4,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'92d050'))->addText($valor->pam_campo5,array('size'=>6));
                    $row->addCell(1500, array('vMerge' => 'restart','bgColor'=>'92d050'))->addText($valor->pam_campo6,array('size'=>6));
                }
            }
            
            
            
            
            
            
            $row = $table->addRow();
            $row->addCell(null,array('vMerge'=>'restart'));
            $row->addCell(null,array('vMerge'=>'restart'));
            $row->addCell(2000, array('vMerge' => 'restart','bgColor' => 'c6d9f1'))->addText('1 insignificante',array('size'=>8,'bold'=>true));
            $row->addCell(2000, array('vMerge' => 'restart','bgColor' => 'c6d9f1'))->addText('2 menor',array('size'=>8,'bold'=>true));
            $row->addCell(2000, array('vMerge' => 'restart','bgColor' => 'c6d9f1'))->addText('3 moderado',array('size'=>8,'bold'=>true));
            $row->addCell(2000, array('vMerge' => 'restart','bgColor' => 'c6d9f1'))->addText('4 mayor',array('size'=>8,'bold'=>true));
            $row->addCell(2000, array('vMerge' => 'restart','bgColor' => 'c6d9f1'))->addText('5 catastrofico',array('size'=>8,'bold'=>true));
            $row = $table->addRow();
            $row->addCell(null,array('vMerge'=>'restart'));
            $row->addCell(null,array('vMerge'=>'restart'));
            $row->addCell(1000, array('gridSpan' => 5, 'vMerge' => 'restart','bgColor' => 'c6d9f1'))->addText('Impacto',null,array('alignment' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER));
            
            $section->addTextBreak(1);
            $table = $section->addTable('Colspan Rowspan');
            $row = $table->addRow();
            $row->addCell(500,array('bgColor' => 'ff0000'));
            $row->addCell(10000)->addText('alto riesgo, alta prioridad para prevención, mitigación y planes de contingencia (acción inmendiata)',array('size'=>8,'color'=>'#999999'),null);
            $row = $table->addRow();
            $row->addCell(500,array('bgColor' => 'ffbf00'));
            $row->addCell(10000)->addText('alto riesgo, alta prioridad para prevención, mitigación y planes de contingencia (acción inmendiata)',array('size'=>8,'color'=>'#999999'),null);
            
            $row = $table->addRow();
            $row->addCell(500,array('bgColor' => 'ffff00'));
            $row->addCell(10000)->addText('condición de riesto suficientemente alta para considerar futuras acciones de prevención, mitigación y planes de contingencia. (acciones de planificación)',array('size'=>8,'color'=>'#999999'),null);
            $row = $table->addRow();
            $row->addCell(500,array('bgColor' => '92d050'));
            $row->addCell(10000)->addText('bajo riesgo, se require de acciones de prevención, mitigación y planes de contingencia',array('size'=>8,'color'=>'#999999'),null);
            
           
            
            $section->addTextBreak(1);

            $section->addTitle('2.2 ANÁLISIS DE RIESGO DETALLADO - ANEXO', 2);

            
            
            $peligro1 = $utility->traPlanAmenazaCatalogoDeptos($connection,'2_2_1',$data[0]->pld_pla_correlativo);
            $section->addText("Amenaza 1", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);


            $mapa2_2_1 = $utility->search_img_array($attachment,'2_2_1');

            if(!empty($mapa2_2_1)){
            
                $section->addImage($mapa2_2_1->att_direccion.DIRECTORY_SEPARATOR.$mapa2_2_1->att_archivo,array(
                    'width'         => 353.54,
                    'height'        => 203.82677,
                    'align'         => 'center'
                ));
            }
            
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Departamento',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Municipio',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Comunidad',array('size'=>8,'bold'=>true),array('align' => 'center'));

            foreach($peligro1 as $idx =>$val){
                $table->addRow();
                $table->addCell(1750)->addText($val->pam_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->pam_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->pam_campo3,array('size'=>8,'bold'=>true));
            }

            $peligro2 = $utility->traPlanAmenazaCatalogoDeptos($connection,'2_2_2',$data[0]->pld_pla_correlativo);
            $section->addText("Amenaza 2", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);

            $mapa2_2_2 = $utility->search_img_array($attachment,'2_2_2');

            if(!empty($mapa2_2_2)){
            
                $section->addImage($mapa2_2_2->att_direccion.DIRECTORY_SEPARATOR.$mapa2_2_2->att_archivo,array(
                    'width'         => 353.54,
                    'height'        => 203.82677,
                    'align'         => 'center'
                ));
            }

            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Departamento',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Municipio',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Comunidad',array('size'=>8,'bold'=>true),array('align' => 'center'));

            foreach($peligro2 as $idx =>$val){
                $table->addRow();
                $table->addCell(1750)->addText($val->pam_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->pam_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->pam_campo3,array('size'=>8,'bold'=>true));
            }

            $peligro3 = $utility->traPlanAmenazaCatalogoDeptos($connection,'2_2_3',$data[0]->pld_pla_correlativo);
            $section->addText("Amenaza 3", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);

            $mapa2_2_3 = $utility->search_img_array($attachment,'2_2_3');

            if(!empty($mapa2_2_3)){
            
                $section->addImage($mapa2_2_3->att_direccion.DIRECTORY_SEPARATOR.$mapa2_2_3->att_archivo,array(
                    'width'         => 353.54,
                    'height'        => 203.82677,
                    'align'         => 'center'
                ));
            }
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Departamento',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Municipio',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Comunidad',array('size'=>8,'bold'=>true),array('align' => 'center'));

            foreach($peligro3 as $idx =>$val){
                $table->addRow();
                $table->addCell(1750)->addText($val->pam_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->pam_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->pam_campo3,array('size'=>8,'bold'=>true));
            }

            $riesgo_detallado = $utility->traPlanAmenazaCatalogo($connection,'2_2',$data[0]->pld_pla_correlativo);
            $section->addTextBreak(2);
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Amenazas',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Amenaza 1',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Amenaza 2',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Amenaza 3',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $amenazas = Array(
                //'área geografica',
                'Probabilidad',
                'Impacto',
                'Detonantes',
                'Estacionalidad (tiempos)',
                'Riesgos secundarios/peligros',
                'Población expuesta/activos en riesgos (como y porque)',
                'Mecanismos de afrontamiento individuales y colectivos',
                'Consecuencias humanitarias',
                'Factores limitantes'
            );
            foreach($amenazas as $idx =>$val){
                $table->addRow();
                $table->addCell(1750)->addText($val,array('size'=>8,'bold'=>true));
                $idx++;
                foreach ($riesgo_detallado as $clave => $valor) {
                    
                    $campo ='pam_campo'.$idx;
                    $table->addCell(1750)->addText($valor->$campo);
    
                }
            }

            $section->addTextBreak(2);
            $section->addTitle('3. ALERTAS E INDICADORES', 1);
            $section->addTitle('3.1 Sistemas de Alerta Temprana e Indicadores', 2);
            $ews_indicadores = $utility->traPlanAmenaza($connection,'3_1',$data[0]->pld_pla_correlativo);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Peligro',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('EWS',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Fuente',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Indicadores',array('size'=>8,'bold'=>true),array('align' => 'center'));
            foreach ($ews_indicadores as $clave => $valor) {
                $table->addRow();
                $table->addCell(3000)->addText($clave+1,array('size'=>8,'bold'=>true));
                $table->addCell(3000)->addText($valor->pam_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(3000)->addText($valor->pam_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(3000)->addText($valor->pam_campo3,array('size'=>8,'bold'=>true));
            }
            
            $section->addTextBreak(2);
            $section->addTitle('4 CAPACIDAD DE RESPUESTA ', 1);
            $section->addTitle('4.1 Historial humanitario', 2);
            
            $emergencia_respuesta = $utility->traPlanAmenaza($connection,'4_1',$data[0]->pld_pla_correlativo);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Año',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Emergencia',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Área geografica',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Sectores',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('# beneficiarios',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Valor de la respuesta (Q)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            foreach ($emergencia_respuesta as $clave => $valor) {
                $table->addRow();
                $table->addCell(3000)->addText($valor->pam_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(3000)->addText($valor->pam_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(3000)->addText($valor->pam_campo3,array('size'=>8,'bold'=>true));
                $table->addCell(3000)->addText($valor->pam_campo4,array('size'=>8,'bold'=>true));
                $table->addCell(3000)->addText($valor->pam_campo5,array('size'=>8,'bold'=>true));
                $table->addCell(3000)->addText($valor->pam_campo6,array('size'=>8,'bold'=>true));
            }
            $section->addTextBreak(2);
            $section->addTitle('4.2 Área de Operación', 2);
           
            $mapa4_1_2 = $utility->search_img_array($attachment,'4_2');
            if(!empty($mapa4_1_2)){
                $section->addImage($mapa4_1_2->att_direccion.DIRECTORY_SEPARATOR.$mapa4_1_2->att_archivo,array(
                    'width'         => 353.54,
                    'height'        => 203.82677,
                    'align'         => 'center'
                ));
            }

            $peligro4 = $utility->traPlanAmenazaCatalogoDeptos($connection,'4_1_2',$data[0]->pld_pla_correlativo);
            
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Departamento',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Municipio',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Comunidad',array('size'=>8,'bold'=>true),array('align' => 'center'));

            foreach($peligro4 as $idx =>$val){
                $table->addRow();
                $table->addCell(1750)->addText($val->pam_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->pam_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->pam_campo3,array('size'=>8,'bold'=>true));
            }
            
            $section->addTextBreak(2);
            $section->addTitle('4.3 Evaluación rápida de necesidades', 2);
            
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Nombre de la persona o cargo',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Capacitado en evaluaciones',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Sector de especializacion',array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            $table->addRow();
            $table->addCell(3000)->addText($data[0]->pld_campo3,array('size'=>8,'bold'=>true));
            $table->addCell(3000)->addText($data[0]->pld_campo4,array('size'=>8,'bold'=>true));
            $table->addCell(3000)->addText($data[0]->pld_campo5,array('size'=>8,'bold'=>true));
            $table->addRow();
            $table->addCell(3000)->addText($data[0]->pld_campo6,array('size'=>8,'bold'=>true));
            $table->addCell(3000)->addText($data[0]->pld_campo7,array('size'=>8,'bold'=>true));
            $table->addCell(3000)->addText($data[0]->pld_campo8,array('size'=>8,'bold'=>true));
            $table->addRow();
            $table->addCell(3000)->addText($data[0]->pld_campo9,array('size'=>8,'bold'=>true));
            $table->addCell(3000)->addText($data[0]->pld_campo10,array('size'=>8,'bold'=>true));
            $table->addCell(3000)->addText($data[0]->pld_campo11,array('size'=>8,'bold'=>true));
            $table->addRow();
            $table->addCell(3000)->addText($data[0]->pld_campo12,array('size'=>8,'bold'=>true));
            $table->addCell(3000)->addText($data[0]->pld_campo13,array('size'=>8,'bold'=>true));
            $table->addCell(3000)->addText($data[0]->pld_campo14,array('size'=>8,'bold'=>true));
            $table->addRow();
            $table->addCell(3000)->addText($data[0]->pld_campo15,array('size'=>8,'bold'=>true));
            $table->addCell(3000)->addText($data[0]->pld_campo16,array('size'=>8,'bold'=>true));
            $table->addCell(3000)->addText($data[0]->pld_campo17,array('size'=>8,'bold'=>true));
            $section->addTextBreak(2);
            $herramientas_digitales = "";
            ($data[0]->pld_campo18 == 1) ? $herramientas_digitales ='Si': $herramientas_digitales = 'No';
            $section->addText("Su organización tiene herramientas digitales (teléfonos moviles, tabletas, etc.) disponibles para evaluaciones?: $herramientas_digitales", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $herramientas_cuantas = $data[0]->pld_campo19;
            $section->addText("Cuantos?: $herramientas_cuantas", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $section->addTextBreak(2);
            $section->addTitle('4.4 Programación de transferencia de efectivo', 2);
            $campo20 = "";
            ($data[0]->pld_campo20 == 1) ? $campo20 ='Si': $campo20 = 'No';
            $campo20 = $data[0]->pld_campo20;
            $section->addText("Su organización tiene experiencia con la programacion de EFECTIVO? : $campo20", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $experiencia_efectivo_anios = $data[0]->pld_campo21;
            $section->addText("Cuantos años? : $experiencia_efectivo_anios", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $experiencia_efectivo_expl = $data[0]->pld_campo22;
            $section->addText("Breve explicación de la programación anterior de EFECTIVO : $experiencia_efectivo_expl", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $campo23 = $data[0]->pld_campo23;
            $section->addText("Se ha realizado un análisis de mercado para la futura programación de EFECTIVO? : $campo23", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $section->addTextBreak(2);
            $section->addTitle('5. RECURSOS SOCIOS', 1);
            $section->addTitle('5.1 Recursos en el país del socio', 2);
            
            $section->addText("Recursos humanos humanitarios actualmente disponibles", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $section->addText($data[0]->pld_campo29, array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>false
            ), null);

            $section->addText("Recuros materiales", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $section->addText($data[0]->pld_campo30, array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>false
            ), null);

            $section->addText("Fondos", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $section->addText($data[0]->pld_campo31, array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>false
            ), null);

            $section->addText("Acuerdos", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $section->addText($data[0]->pld_campo32, array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>false
            ), null);

            
            $section->addTextBreak(2);
            $section->addTitle('6. COMUNICACIONES', 1);
            $section->addTitle('6.1 Comunicaciones internas', 2);
            
            $contacto_interno = $utility->traPlanAmenaza($connection,'6_1',$data[0]->pld_pla_correlativo);
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Papel',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Nombre',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Telefono',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Correo Electrónico',array('size'=>8,'bold'=>true),array('align' => 'center'));
            foreach ($contacto_interno as $clave => $valor) {
                $table->addRow();
                $campo ='pam_campo'.$idx;
                    $table->addCell(1750)->addText($valor->pam_campo2);
                    $table->addCell(1750)->addText($valor->pam_campo1);
                    $table->addCell(1750)->addText($valor->pam_campo3);
                    $table->addCell(1750)->addText($valor->pam_campo4);
    
            }
            $section->addTitle('6.2 Comunicaciones externas', 2);
            
            $contacto_externo = $utility->traPlanAmenaza($connection,'6_2',$data[0]->pld_pla_correlativo);
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Papel',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Organización',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Nombre',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Telefono',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Correo Electrónico',array('size'=>8,'bold'=>true),array('align' => 'center'));
            foreach ($contacto_externo as $clave => $valor) {
                $table->addRow();
                    $table->addCell(1750)->addText($valor->pam_campo2);
                    $table->addCell(1750)->addText($valor->pam_campo3);
                    $table->addCell(1750)->addText($valor->pam_campo1);
                    $table->addCell(1750)->addText($valor->pam_campo4);
                    $table->addCell(1750)->addText($valor->pam_campo5);
    
            }
            $section->addTitle('6.3 Coordinación externa', 2);
            
            $coord_externa = $utility->traPlanAmenaza($connection,'6_3',$data[0]->pld_pla_correlativo);
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Nombre del grupo / plataforma de coordinación',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Lider (ONG, ONU, gobierno, donante, etc.)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Cobertura (local, nacional o internacional)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Dominio / Comentarios (tema discutido, por ejemplo, vivienda, tierra y propiedad',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Quién asiste a la reunión',array('size'=>8,'bold'=>true),array('align' => 'center'));
            foreach ($coord_externa as $clave => $valor) {
                $table->addRow();
                    $table->addCell(1750)->addText($valor->pam_campo1);
                    $table->addCell(1750)->addText($valor->pam_campo2);
                    $table->addCell(1750)->addText($valor->pam_campo3);
                    $table->addCell(1750)->addText($valor->pam_campo4);
                    $table->addCell(1750)->addText($valor->pam_campo5);
    
            }
            $phpWord->getSettings()->setUpdateFields(true);
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $objWriter->save($userFolder.$id."_".FILE_NAME);
            

            $respuesta = 'OK';
        }catch(Exception $e){
            $respuesta = $e->getMessage();
        }
        return $respuesta;
    }
	
	public function createEdan($data,$connection,$correlativo){
        try{
            \PhpOffice\PhpWord\Settings::setOutputEscapingEnabled(true);
            $utility = new UtilityDB();
            //variables globales
            $fancyTableStyleName = 'Fancy Table';
            $fancyTableStyle = array('borderSize' => 2, 'borderColor' => '000000', 'alignment' => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER);
            $fancyTableFirstRowStyle = array('borderBottomSize' => 0, 'borderBottomColor' => '0000FF', 'bgColor' => 'cccccc');
            
            $fancyTableCellBtlrStyle = array('valign' => 'center', 'textDirection' => \PhpOffice\PhpWord\Style\Cell::TEXT_DIR_BTLR);
            $fancyTableFontStyle = array('bold' => false,'color'=>'000000');
            $matrixTableStyleName = 'Matrix Table';
            $matrixTableStyle = array('borderSize' => 2, 'borderColor' => '000000', 'alignment' => \PhpOffice\PhpWord\SimpleType\JcTable::CENTER);
            $matrixTableFirstRowStyle = array('borderBottomSize' => 18, 'borderBottomColor' => '0000FF', 'bgColor' => '95c5ed');
            $matrixTableCellStyle = array('valign' => 'center');
            $matrixTableCellBtlrStyle = array('valign' => 'center', 'textDirection' => \PhpOffice\PhpWord\Style\Cell::TEXT_DIR_BTLR);
            $matrixTableFontStyle = array('bold' => false,'color'=>'ffffff');
            
            $respuesta = 'nOk';
            
            $userFolder = FILE_DIR_EDAN.DIRECTORY_SEPARATOR;
            if (!file_exists($userFolder)) {
                mkdir($userFolder, 0777, true);
            }
            $phpWord = new \PhpOffice\PhpWord\PhpWord();
            $section = $phpWord->addSection();
           /* $header = $section->addHeader();
            $header->addImage(IMG_DIR.DIRECTORY_SEPARATOR.'header.png',array(
                'width'         => 141.732,
                'height'        => 20.12598,
                'align'         => 'right'
            ));*/
            //caratula
            $fechai = $data[0]->eda_fecham;
            $section->addText("Ultima actualizacion($fechai)", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $section->addText('Version(1)', array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), null);
            $section->addTextBreak(2, null, null);
            $titulo = $data[0]->eda_titulo;
            $section->addText('EVALUACIÓN DE DAÑOS Y ANÁLISIS DE NECESIDADES', array(
                'name'=>'calibri',
                'size'=>24,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));
            $section->addText('EDAN', array(
                'name'=>'calibri',
                'size'=>36,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));
            $section->addText($titulo, array(
                'name'=>'calibri',
                'size'=>24,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));

            $section->addImage(IMG_DIR.DIRECTORY_SEPARATOR.'blank.png',array(
                'width'         => 400.54,
                'height'        => 240.00,
                'align'         => 'center'
            ));
            /*$section->addTextBreak(4);
            $section->addText('Guatemala', array(
                'name'=>'calibri',
                'size'=>20,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));
            $section->addText('JOTAY', array(
                'name'=>'calibri',
                'size'=>20,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));
            $section->addText('Miembro de ACT Alliance', array(
                'name'=>'calibri',
                'size'=>28,
                'bold'=>true
            ), array(
                'alignment'=>'center'
            ));
            
            /*$section->addImage(IMG_DIR.DIRECTORY_SEPARATOR.'ppre.png',array(
                'width'         => 453.54,
                'height'        => 150.00,
                'align'         => 'right'
            ));*/
            $section->addTextBreak(4);
            
            $usuario_aprobacion = $data[0]->eda_usuarioi;
            $section->addText("Aprobado por:$usuario_aprobacion", array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), array(
                'alignment'=>'left'
            ));
            $section->addPageBreak();
            $fontStyle = array('spaceAfter' => 10, 'size' => 12,'name'=>'calibri','bold'=>false);
            $section->addText('CONTENIDO',array('bold'=>true,'size'=>16,'align'=> 'center','color'=>'72c2ff'));
            $section->addTextBreak(2);
            // Add TOC #1
            $toc = $section->addTOC($fontStyle);
            $section->addPageBreak();
            
            $phpWord->addTitleStyle(1, array('size' => 12,'name'=>'cambria','color' => '277ab2', 'bold' => true));
            $phpWord->addTitleStyle(2, array('size' => 10,'name'=>'cambria', 'color' => '277ab2','bold' => true));
            
            $section->addTitle('1. EVENTO', 1);
            $evento = $utility->traEdanDetalle($connection,'EVT',$data[0]->eda_correlativo);
            foreach($evento as $idx =>$val){
                
                $textrun = $section->addTextRun();
                if($val->edt_campo2 == '0'){
                    $textrun->addFormField('checkbox')->setValue(false);
                }else{
                    $textrun->addFormField('checkbox')->setValue(true);
                }
                $textrun->addText($val->edt_campo1);
            }
            $eventoDanio = $utility->traEdanDanio($connection,'EVT',$data[0]->eda_correlativo);
            
            $section->addText("Especifique:", array(
                'name'=>'calibri',
                'size'=>11,
                'bold'=>true
            ), null); 
            $section->addText($eventoDanio[0]->edd_campo1, array(
                'name'=>'calibri',
                'size'=>11,
                'bold'=>false
            ), null); 
            $section->addText("Causa del evento:", array(
                'name'=>'calibri',
                'size'=>11,
                'bold'=>true
            ), null); 
            $section->addText($eventoDanio[0]->edd_campo2, array(
                'name'=>'calibri',
                'size'=>11,
                'bold'=>false
            ), null); 
            
            $section->addTitle('2. PERSONAS', 1);
            $persona = $utility->traEdanDanio($connection,'PER',$data[0]->eda_correlativo);
            $section->addText("Afectación a:", array(
                'name'=>'calibri',
                'size'=>11,
                'bold'=>true
            ), null); 
            $section->addText($persona[0]->edd_campo1, array(
                'name'=>'calibri',
                'size'=>11,
                'bold'=>false
            ), null); 
            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Afectados',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Evacuados',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Damnificados',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Desaparecidos',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Heridos',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Muertos',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc'))->addText('Albergados',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $personaDetail = $utility->traEdanDetalle($connection,'PER',$data[0]->eda_correlativo);
            foreach($personaDetail as $idx =>$val){
                if($val->edt_campo20 == 'P'){
                    $table->addRow();
                    $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo4,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo5,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo6,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo7,array('size'=>8,'bold'=>true));
                }
            }
            //nueva tabla agregada
            $section->addTextBreak(1);
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Comunidad/Municipio/Departamento',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc', 'gridspan'=>10))->addText('Personas afectadas por Edades (años) y Género',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan'=>2,'vMerge' => 'restart'))->addText('Total',array('size'=>8,'bold'=>true),array('align' => 'center'));

            $table->addRow();
            
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 2))->addText('menor que 1',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 2))->addText('1-4',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 2))->addText('5-14',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 2))->addText('15-49',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 2))->addText('mayor a 50',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue','gridspan'=>2))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue','gridspan'=>2))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue','gridspan'=>2))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue','gridspan'=>2))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('C',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));

            foreach($personaDetail as $idx =>$val){
                if($val->edt_campo20 == 'D'){
                    $table->addRow();
                    $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo4,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo5,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo6,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo7,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo8,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo9,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo10,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo11,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo12,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo13,array('size'=>8,'bold'=>true));
                }
            }


            $section->addTitle('3. EDIFICACIONES', 1);
            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('DA',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('DE',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Total',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc', 'gridspan'=>2))->addText('Funciona',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc', 'gridspan'=>2))->addText('Solución',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Observaciones',array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            $table->addRow();
            $table->addCell(3000, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('Si',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('No',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('Si',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('No',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(3000, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            $personaDetail = $utility->traEdanDetalle($connection,'EDI',$data[0]->eda_correlativo);
            foreach($personaDetail as $idx =>$val){
                $table->addRow();
                $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo4,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo5,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo6,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo7,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo8,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo9,array('size'=>8,'bold'=>true));
                
            }
            $otrosEdif = $utility->traEdanDanio($connection,'PER',$data[0]->eda_correlativo);
            $section->addText("Especifique otros edificios:", array(
                'name'=>'calibri',
                'size'=>11,
                'bold'=>true
            ), null); 
            $section->addText($otrosEdif[0]->edd_campo1, array(
                'name'=>'calibri',
                'size'=>11,
                'bold'=>false
            ), null); 
            $section->addTitle('4. PERSONAS ALBERGADAS', 1);
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Nombre Albergue',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan'=>2, 'vMerge'=>'restart'))->addText('Tipo Albergue',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc', 'gridspan'=>10))->addText('Albergados por edades (años) y genero',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan'=>2,'vMerge' => 'restart'))->addText('Total',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan'=>2,'vMerge' => 'restart'))->addText('Atendidos',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan'=>2,'vMerge' => 'restart'))->addText('Cond. Sanitarias',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Ubicación',array('size'=>8,'bold'=>true),array('align' => 'center'));
            //17
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue','gridspan'=>2))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 2))->addText('menor que 1',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 2))->addText('1-4',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 2))->addText('5-14',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 2))->addText('15-49',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 2))->addText('mayor a 50',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue','gridspan'=>2))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue','gridspan'=>2))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue','gridspan'=>2))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue','gridspan'=>2))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('C',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('F',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('M',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('S',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('N',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('S',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('N',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $personas_albergadas = $utility->traEdanDetalle($connection,'PER',$data[0]->eda_correlativo);
            foreach($personas_albergadas as $idx =>$val){
                $table->addRow();
                $table->addCell(null)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo4,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo5,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo6,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo7,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo8,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo9,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo10,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo11,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo12,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo13,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo14,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo15,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo16,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo17,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo18,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo19,array('size'=>8,'bold'=>true));
                $table->addCell(null)->addText($val->edt_campo20,array('size'=>8,'bold'=>true));
                
            }
            $section->addTitle('5. RED VIAL', 1);
            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('DA',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('DE',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc', 'gridspan'=>2))->addText('Funciona',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Longitud (km)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Especifique el daño',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Ubicación',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Lugares incomunicados',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Rutas Alternas',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Rehabilitacion temporal (s/n)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('S',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('N',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            
            
            $red_vial = $utility->traEdanDetalle($connection,'RED',$data[0]->eda_correlativo);
            foreach($red_vial as $idx =>$val){
                $table->addRow();
                $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo4,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo5,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo6,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo7,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo8,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo9,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo10,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo11,array('size'=>8,'bold'=>true));
                
            }
            $section->addTitle('6. LINEAS VITALES', 1);
            
            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('DA',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('DE',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc', 'gridspan'=>2))->addText('Funciona',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan'=>2))->addText('Población afectada',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan'=>2))->addText('Solución local',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Descripción del daño',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Observaciones',array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('S',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('N',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('Cantidad',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('% de total',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('S',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridSpan' => 1))->addText('N',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            
            
            
            $lineas_vitales = $utility->traEdanDetalle($connection,'LIN',$data[0]->eda_correlativo);
            foreach($lineas_vitales as $idx =>$val){
                $table->addRow();
                $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo4,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo5,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo6,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo7,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo8,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo9,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo10,array('size'=>8,'bold'=>true));
                $table->addCell(1750)->addText($val->edt_campo11,array('size'=>8,'bold'=>true));
                
            }
            $section->addTitle('7. INFRAESTRUCTURA PROD.', 1);
            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Maíz',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Frijol',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Arroz',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Yuca',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Platano',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Palma Africana',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Sorgo',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Café',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Banano',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $infra = $utility->traEdanDetalle($connection,'INF',$data[0]->eda_correlativo);
            foreach($infra as $idx =>$val){
                if(strpos($val->edt_campo1,"5.1") !== false){
                    $table->addRow();
                    $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo4,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo5,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo6,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo7,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo8,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo9,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo10,array('size'=>8,'bold'=>true));
                }
                
            }
            $section->addTextBreak(2, null, null);
            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Equino (Caballos)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Porcino (Cerdos)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Avícola (Aves)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Caprino (Cabros)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Apicultura (Abejas)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Bovino (Vacas, Toros)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Otros',array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            
            foreach($infra as $idx =>$val){
                if(strpos($val->edt_campo1,"5.2") !== false){
                    $table->addRow();
                    $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo4,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo5,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo6,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo7,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo8,array('size'=>8,'bold'=>true));
                }
                
            }
            $section->addTitle('8. INGRESO Y ACCESO A ALIMENTOS.', 1);
            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Producto',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Número de familias que tienen reserva de alimentos',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan' => 2))->addText('Disponibilidad en el mercado',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan' => 2))->addText('Precio de mercado (lempiras/libra)',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan' => 2))->addText('puede el comercio local traerlo de otra zona',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc'))->addText('S',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc'))->addText('N',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc'))->addText('Ante crisis',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc'))->addText('Ahora',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc'))->addText('S',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc'))->addText('N',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $disp_alimentos = $utility->traEdanDetalle($connection,'ING',$data[0]->eda_correlativo);
            foreach($disp_alimentos as $idx =>$val){
                if($val->edt_campo20 == "D"){
                    $table->addRow();
                    $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo4,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo5,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo6,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo7,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo8,array('size'=>8,'bold'=>true));
                }
                
            }
            $section->addTextBreak(2, null, null);
            
            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Principales fuentes de ingresos / acceso alimentario',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('No. De familias que viven de esta actividad',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan' => 2))->addText('Esta fuente esta afectada',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('% afectacion',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','gridspan' => 2))->addText('Tiene capacidad de compra de alimentos',array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc'))->addText('S',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc'))->addText('N',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'continue'))->addText(null,array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc'))->addText('S',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc'))->addText('N',array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            foreach($disp_alimentos as $idx =>$val){
                if($val->edt_campo20 == "I"){
                    $table->addRow();
                    $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo4,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo5,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo6,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo7,array('size'=>8,'bold'=>true));
                }
                
            }
            $section->addTitle('9. NECESIDADES EN RECURSOS BASICOS.', 1);
            $section->addText('Necesidades Identificadas', array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), array(
                'alignment'=>'left'
            ));

            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Descripción',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Cantidad',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Observaciones',array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            $infra = $utility->traEdanDetalle($connection,'NEC',$data[0]->eda_correlativo);
            foreach($infra as $idx =>$val){
                if($val->edt_campo20 == 'I'){
                    $table->addRow();
                    $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                }
                
            }
            $section->addTextBreak(1);
            $section->addText('Recursos Disponibles', array(
                'name'=>'calibri',
                'size'=>12,
                'bold'=>true
            ), array(
                'alignment'=>'left'
            ));

            $styleTable = array('borderSize' => 6, 'borderColor' => '000000');
            $phpWord->addTableStyle('Colspan Rowspan', $styleTable);
            $table = $section->addTable('Colspan Rowspan');
            $table->addRow();
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Descripción',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Cantidad',array('size'=>8,'bold'=>true),array('align' => 'center'));
            $table->addCell(null, array('bgColor' => 'cccccc','vMerge' => 'restart'))->addText('Observaciones',array('size'=>8,'bold'=>true),array('align' => 'center'));
            
            
            foreach($infra as $idx =>$val){

                if($val->edt_campo20 == 'D'){
                    $table->addRow();
                    $table->addCell(1750)->addText($val->edt_campo1,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo2,array('size'=>8,'bold'=>true));
                    $table->addCell(1750)->addText($val->edt_campo3,array('size'=>8,'bold'=>true));
                }
                
            }

            $mask = $userFolder.'EDAN-'.$data[0]->eda_correlativo.'-*.*';
            array_map('unlink', glob($mask));

            $phpWord->getSettings()->setUpdateFields(true);
            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $objWriter->save($userFolder.'EDAN-'.$data[0]->eda_correlativo."-".$correlativo.$data[0]->eda_titulo.'.docx');
            $respuesta = 'OK';
        }catch(Exception $e){
            $respuesta = $e->getMessage();
        }
        return $respuesta;
        
    }

    function clonePlan($id){
        $phpWord = new \PhpOffice\PhpWord\PhpWord();

        $userFolder = FILE_DIR.DIRECTORY_SEPARATOR;
        if (!file_exists($userFolder)) {
            mkdir($userFolder, 0777, true);
        }
        $mask = $userFolder.'PPRE-'.$id.'-*.*';

        array_map('unlink', glob($mask));
        $digits = 3;
        $randomNum = rand(pow(10, $digits-1), pow(10, $digits)-1);
        $NewFile = $userFolder.'PPRE-'.$id.'-'.$randomNum.'.docx';
        $downloadFile = DOWNLOAD_PPRE.DIRECTORY_SEPARATOR.'PPRE-'.$id.'-'.$randomNum.'.docx';
        if(file_exists($NewFile)){
            unlink($NewFile);
        }


        $document = $phpWord->loadTemplate($userFolder.$id."_".FILE_NAME);
        $document->saveAs($NewFile);

        return $downloadFile;
    }

    
    
}
